#ifndef _IPXFILT_H_

#define _IPXFILT_H_

enum IPX_FILTER_TYPE
{
   IPX_INVALID_FILTER = 0,
   IPX_FILTER_ON_SOURCE_ADDRESS,
   IPX_FORWARD_ON_SOURCE_ADDRESS,
   IPX_FILTER_ON_DESTINATION_ADDRESS,
   IPX_FORWARD_ON_DESTINATION_ADDRESS
} ;

enum IPX_FILTER_DEFAULT_ACTION
{
   IPX_FILTER_DEFAULT_ACTION_FORWARD,
   IPX_FILTER_DEFAULT_ACTION_FILTER
} ;



typedef struct
{
   ULONG network_number ;
   ULONG node_number_ulong ;
   USHORT node_number_ushort ;
   USHORT socket_number ;
} FULL_IPX_ADDRESS ;

struct struct_ipx_filter
{
   struct struct_ipx_filter *forward_link ;
   struct struct_ipx_filter *backward_link ;
   FULL_IPX_ADDRESS ipx_address ;
   FULL_IPX_ADDRESS mask ;
   USHORT port ;
   enum IPX_FILTER_TYPE type ;
} ;
typedef struct struct_ipx_filter IPX_FILTERING_ENTRY ;

typedef struct str_ipx_filter_class
{
   IPX_FILTERING_ENTRY *ipx_filtering_table, *ipx_src_filter_chain, *ipx_dest_filter_chain ;
   USHORT ipx_filter_table_size, ipx_number_of_src_filter_entries, ipx_number_of_dest_filter_entries ;
   enum BOOLEAN ipx_filtering_inited ;
   enum IPX_FILTER_DEFAULT_ACTION ipx_filter_default_action, ipx_filter_default_tx_action, ipx_filter_default_rx_action ;
} str_ipx_filter_class ;

extern enum BOOLEAN ipx_rx_filter (USHORT port_number, ETHERNET_BUFFER *sptr_rx_packet, USHORT size_of_packet) ;
extern enum BOOLEAN ipx_tx_filter (USHORT port_number, ETHERNET_BUFFER *sptr_tx_packet, USHORT size_of_packet) ;

#endif
