#include	"defs.h"
/*	$Modname: ipxlearn.c$  $version: 1.2$      $date: 10/20/95$   */
/*
* 	$lgb$
1.0 01/26/95 ross checking in for release.
1.1 01/26/95 ross adding copyright.
1.2 10/20/95 nishit Changed copyright
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1989 - 1995 RouterWare, Inc.								   */
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Suite 212 Newport Beach, CA  92660  */
/************************************************************************/
#include	"ipx.h"
/****************************************************************************/
void learn_ipx_network_address (USHORT port_number)
{
	if (++ipx_class.port[port_number].number_of_learning_clock_ticks >= ipx_class.port[port_number].learning_holding_time)
		{
		if ((ipx_class.port[port_number].current_number_of_learning_retries + 1) <
			(ipx_class.port[port_number].maximum_number_of_learning_retries))
			{
			++ipx_class.port[port_number].current_number_of_learning_retries;

			ipx_class.port[port_number].number_of_learning_clock_ticks = 0x0000;

			issue_router_info_request (port_number); /* get all router info */
			send_SAP_query (GENERAL_SERVICE_QUERY,port_number); /* get all SAP info */
			}
			else { /* BYME ASSUME THE network number */
				ipx_class.port[port_number].network_address_learned = TRUE;
				IPX_control (OPEN_VIRTUAL_PORT,(ULONG) port_number,(ULONG) NULL);
			}
		}
}
/****************************************************************************/
void check_to_see_if_network_address_is_learned (USHORT port_number,IPX_PACKET *sptr_rx_packet)
{
	if (ipx_class.port[port_number].network_address_learned == FALSE)
		{
		if (sptr_rx_packet->ipx_header.transport_control_hop_count == 0x00)
			{
			switch (((IPX_PACKET *)sptr_rx_packet)->ipx_header.packet_type)
				{
				case UNKNOWN_PACKET_TYPE:
				case ROUTER_PACKET_TYPE:
				case NETWARE_CORE_PROTOCOL_TYPE:
				case PACKET_EXCHANGE_PACKET:
				case SEQUENCED_PACKET_PROTOCOL:
					if (((ROUTE_INFORMATION *)sptr_rx_packet)->ipx_header.destination.socket == ROUTING_SOCKET)
						{
							if(sptr_rx_packet->ipx_header.source.network != 0){
								ipx_class.port[port_number].network_address_learned = TRUE;
								/* Srikar, Mar 17, 1997. If network number is to be different from configured value */
								/* we should inform snmp */
								if (ipx_class.port[port_number].network != sptr_rx_packet->ipx_header.source.network)
									ipx_class.port[port_number].ipx_mib.circuit_status = CHANGED_CIRCUIT_STATUS;
								ipx_class.port[port_number].network = sptr_rx_packet->ipx_header.source.network;
								IPX_control (OPEN_VIRTUAL_PORT,(ULONG) port_number,(ULONG)NULL);
							}	
						}
					else if (((ROUTE_INFORMATION *)sptr_rx_packet)->ipx_header.destination.socket == SAP_SOCKET)
						{
							if(sptr_rx_packet->ipx_header.source.network  != 0){
								ipx_class.port[port_number].network_address_learned = TRUE;

								ipx_class.port[port_number].network = sptr_rx_packet->ipx_header.source.network;
								IPX_control(OPEN_VIRTUAL_PORT,(ULONG) port_number,(ULONG) NULL);
							}
						}
				}
			}
		}
}
