#include	"defs.h"
/*	$Modname: ipxnlsp.c$  $version: 1.5$      $date: 10/25/95$   */
/*
* 	$lgb$
1.0 05/02/95 ross checking in.
1.1 05/02/95 ross adding copyright.
1.2 10/20/95 ross changes for NLSP RIP-SAP compatibility
1.3 10/20/95 nishit Changed copyright
1.4 10/20/95 nishit Cleanup debug printfs; ready for release
1.5 10/25/95 nishit Next entry by network in delete_nlsp_route_entry
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1989 - 1995 RouterWare, Inc.								   */
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Suite 212 Newport Beach, CA  92660  */
/************************************************************************/
#include	<stdlib.h>
#include	<string.h>
#include	"ipx.h"
/*************************************************************************/
enum TEST add_nlsp_route_entry (USHORT port_number,ROUTE_ENTRY *sptr_route_entry,ETHERNET_ADDRESS *sptr_ethernet_address,
	enum BOOLEAN new_primary_route,enum BOOLEAN static_entry,void *vptr_lsp)
{
	ROUTE_LIST_ENTRY *sptr_primary_route_entry;
	enum LIST_ENTRY_TYPE route_list_return_type;
	enum BOOLEAN new_primary_route_added;
	USHORT port_number_of_primary_route;

	PARAMETER_NOT_USED (new_primary_route);
	PARAMETER_NOT_USED (static_entry);

	new_primary_route_added = FALSE;

	if (sptr_route_entry->hops < SERVER_OR_ROUTER_DOWN_HOP_COUNT)
		{
		sptr_route_entry->hops = swap ((USHORT) (swap (sptr_route_entry->hops) + 1));

		if (sptr_route_entry->hops == SERVER_OR_ROUTER_DOWN_HOP_COUNT)
			{
			return (FAIL);
			}
		}

	if (sptr_route_entry->hops > SERVER_OR_ROUTER_DOWN_HOP_COUNT)
		{
		return (FAIL);
		}

	if (sptr_route_entry->network == 0x00000000) /* SPECIAL case (I'm not sure this ever happens) */
		{
		++ipx_class.port[port_number].statistics.number_of_RIP_packets_with_no_network_address_rxed;

		sptr_route_entry->network = ipx_class.port[port_number].network;
		}

	route_list_return_type = MATCHING_ENTRY_NOT_FOUND;

	for (sptr_primary_route_entry = get_route_list_entry_using_network (sptr_route_entry->network,
		ipx_class.router_list.sptr_forward_link) ; sptr_primary_route_entry != NULL;
		sptr_primary_route_entry = get_route_list_entry_using_network (sptr_route_entry->network,sptr_primary_route_entry))
		{
		port_number_of_primary_route = sptr_primary_route_entry->port_number;

		route_list_return_type = check_if_in_primary_route_list (sptr_primary_route_entry,sptr_route_entry,
			sptr_ethernet_address,port_number,NLSP_IPX_ROUTE,vptr_lsp);

		if (route_list_return_type != MATCHING_ENTRY_NOT_FOUND)
			{
			break;
			}

		sptr_primary_route_entry =  sptr_primary_route_entry->links.sptr_forward_link;
		}


	if (route_list_return_type == MATCHING_ENTRY_FOUND_NO_UPDATE)
		{
		return (PASS);
		}

	if (route_list_return_type == MATCHING_ENTRY_FOUND_UPDATE)
		{
		if (port_number_of_primary_route != sptr_primary_route_entry->port_number)
			{
			if (ipx_class.nlsp.fptr_nlsp_send_pseudonode_lsps != NULL)
				{
				(*ipx_class.nlsp.fptr_nlsp_send_pseudonode_lsps) (port_number_of_primary_route);
				}
			}

		new_primary_route_added = TRUE;
		}

	if (sptr_primary_route_entry == NULL)
		{
		if (sptr_route_entry->hops >= SERVER_OR_ROUTER_DOWN_HOP_COUNT)
			{
			return (FAIL);
			}

		if (add_route_entry (port_number,sptr_route_entry,sptr_ethernet_address,TRUE,FALSE,NLSP_IPX_ROUTE,vptr_lsp) == PASS)
			{
			new_primary_route_added = TRUE;
			}
		}

	if (new_primary_route_added == TRUE)
		{
		if (ipx_class.nlsp.fptr_nlsp_send_pseudonode_lsps != NULL)
			{
			(*ipx_class.nlsp.fptr_nlsp_send_pseudonode_lsps) (port_number);
			}
			
		update_routes_for_all_ports ();

		return (PASS);
		}
	else
		{
		return (FAIL);
		}
}
/*************************************************************************/
void delete_nlsp_route_entry (void *vptr_lsp,ULONG network_number)
{
	ROUTE_LIST_ENTRY *sptr_primary_route_entry;
	ROUTE_LIST_ENTRY *sptr_next_primary_route_entry;
	enum BOOLEAN route_deleted;

	route_deleted = FALSE;

	for (sptr_primary_route_entry = get_route_list_entry_using_network (network_number,
		ipx_class.router_list.sptr_forward_link);
		sptr_primary_route_entry != NULL;
		sptr_primary_route_entry = sptr_next_primary_route_entry)
		{
		sptr_next_primary_route_entry = get_route_list_entry_using_network (network_number,
			sptr_primary_route_entry->links.sptr_forward_link);

		if (sptr_primary_route_entry->vptr_lsp == (void *) vptr_lsp)
			{
			route_deleted = TRUE;

			sptr_primary_route_entry->route_entry.hops = SERVER_OR_ROUTER_DOWN_HOP_COUNT;
			sptr_primary_route_entry->new_primary_route = TRUE;
			}
		}

	if (route_deleted == TRUE)
		{
		update_routes_for_all_ports ();
		}
}
/*************************************************************************/
enum TEST add_nlsp_SAP_entry (USHORT port_number,SAP_ID *sptr_SAP_entry,ETHERNET_ADDRESS *sptr_ethernet_address,void *vptr_lsp)
{
	SAP_LIST_ENTRY *sptr_primary_SAP_entry;
	enum LIST_ENTRY_TYPE SAP_list_return_type;
	enum BOOLEAN new_primary_SAP_added;

	new_primary_SAP_added = FALSE;

	if (sptr_SAP_entry->intervening_networks >= SERVER_OR_ROUTER_DOWN_HOP_COUNT)
		{
		return (FAIL);
		}

	SAP_list_return_type = MATCHING_ENTRY_NOT_FOUND;

	for (sptr_primary_SAP_entry = get_SAP_list_entry_using_type (sptr_SAP_entry->SAP_type,
		ipx_class.SAP_list.sptr_forward_link) ; sptr_primary_SAP_entry != NULL;
		sptr_primary_SAP_entry = get_SAP_list_entry_using_type (sptr_SAP_entry->SAP_type,sptr_primary_SAP_entry))
		{
		SAP_list_return_type = check_if_in_primary_SAP_list (sptr_primary_SAP_entry,sptr_SAP_entry,
			sptr_ethernet_address,port_number,NLSP_SAP,vptr_lsp);

		if (SAP_list_return_type != MATCHING_ENTRY_NOT_FOUND)
			{
			break;
			}

		sptr_primary_SAP_entry = sptr_primary_SAP_entry->links.sptr_forward_link;
		}

	if (SAP_list_return_type == MATCHING_ENTRY_FOUND_UPDATE)
		{
		new_primary_SAP_added = TRUE;
		}

	if (sptr_primary_SAP_entry == NULL)
		{
		if (sptr_SAP_entry->intervening_networks >= SERVER_OR_ROUTER_DOWN_HOP_COUNT)
			{
			return (FAIL);
			}

		if (add_SAP_entry (port_number,sptr_SAP_entry,sptr_ethernet_address,TRUE,FALSE,NLSP_SAP,vptr_lsp) == PASS)
			{
			new_primary_SAP_added = TRUE;
			}
		}

	if (new_primary_SAP_added == TRUE)
		{
		update_SAPs_for_all_ports ();

		return (GENERAL_SAP_RXED_UPATE);
		}
	else
		{
		return (GENERAL_SAP_RXED);
		}
}
/*************************************************************************/
void delete_nlsp_SAP_entry (void *vptr_lsp,enum SAP_PACKET_TYPE SAP_type,BYTE length_of_name_of_service,char const *cptr_SAP_name)
{
	SAP_LIST_ENTRY *sptr_primary_SAP_entry;
	SAP_LIST_ENTRY *sptr_next_primary_SAP_entry;
	enum BOOLEAN SAP_deleted;
	BYTE length_of_service_in_this_entry;

	SAP_deleted = FALSE;

	for (sptr_primary_SAP_entry = get_SAP_list_entry_using_type (SAP_type,ipx_class.SAP_list.sptr_forward_link);
		sptr_primary_SAP_entry != NULL;sptr_primary_SAP_entry = sptr_next_primary_SAP_entry)
		{
		sptr_next_primary_SAP_entry = sptr_primary_SAP_entry->links.sptr_forward_link;

		length_of_service_in_this_entry = (BYTE) (strlen (sptr_primary_SAP_entry->SAP_ID.SAP_name));

		if (length_of_service_in_this_entry != length_of_name_of_service)
			{
			continue;
			}
			
		if (memcmp (sptr_primary_SAP_entry->SAP_ID.SAP_name, cptr_SAP_name, length_of_name_of_service) != STRINGS_MATCH)
			{
			continue;
			}
			
		if (sptr_primary_SAP_entry->vptr_lsp == (void *) vptr_lsp)
			{
			SAP_deleted = TRUE;

			sptr_primary_SAP_entry->SAP_ID.intervening_networks = SERVER_OR_ROUTER_DOWN_HOP_COUNT;
			sptr_primary_SAP_entry->new_primary_SAP = TRUE;
			}
		}

	if (SAP_deleted == TRUE)
		{
		update_SAPs_for_all_ports ();
		}
}
/*************************************************************************/
void add_standby_routes_to_ipx_route_list (ROUTE_LIST_ENTRY *sptr_standby_route_list_entry)
{
	USHORT port_number;
	ROUTE_ENTRY *sptr_route_entry;
	enum BOOLEAN new_primary_route_added;
	enum LIST_ENTRY_TYPE route_list_return_type;
	ROUTE_LIST_ENTRY *sptr_primary_route_entry;

	while (sptr_standby_route_list_entry != NULL)
		{
		sptr_route_entry = &sptr_standby_route_list_entry->route_entry;

		port_number = sptr_standby_route_list_entry->port_number;

		route_list_return_type = MATCHING_ENTRY_NOT_FOUND;

		for (sptr_primary_route_entry = get_route_list_entry_using_network (sptr_route_entry->network,
			ipx_class.router_list.sptr_forward_link) ; sptr_primary_route_entry != NULL;
			sptr_primary_route_entry = get_route_list_entry_using_network (sptr_route_entry->network,	sptr_primary_route_entry))
			{
			route_list_return_type = check_if_in_primary_route_list (sptr_primary_route_entry, sptr_route_entry, 
				&sptr_standby_route_list_entry->router_address, port_number,RIP_IPX_ROUTE,NULL);

			if (route_list_return_type != MATCHING_ENTRY_NOT_FOUND)
				{
				break;
				}
			}

		if (route_list_return_type == MATCHING_ENTRY_FOUND_UPDATE)
			{
			new_primary_route_added = TRUE;
			}

		if (sptr_primary_route_entry == NULL)
			{
			if (sptr_route_entry->hops >= SERVER_OR_ROUTER_DOWN_HOP_COUNT)
				{
				continue;
				}

			add_entry_to_list ((LINK *) &ipx_class.router_list,(LINK *) &sptr_standby_route_list_entry->links);

			new_primary_route_added = TRUE;
			}

		sptr_standby_route_list_entry = sptr_standby_route_list_entry->links.sptr_forward_link;
		}

	if (new_primary_route_added == TRUE)
		{
		update_routes_for_all_ports ();
		}
}
/*************************************************************************/
void add_standby_SAPs_to_ipx_SAP_list (SAP_LIST_ENTRY *sptr_standby_SAP_list_entry)
{
	USHORT port_number;
	SAP_ID *sptr_SAP_ID;
	enum BOOLEAN new_primary_SAP;
	enum LIST_ENTRY_TYPE SAP_list_return_type;
	SAP_LIST_ENTRY *sptr_primary_SAP_entry;

	while (sptr_standby_SAP_list_entry != NULL)
		{
		sptr_SAP_ID = &sptr_standby_SAP_list_entry->SAP_ID;

		port_number = sptr_standby_SAP_list_entry->port_number;

		SAP_list_return_type = MATCHING_ENTRY_NOT_FOUND;

		for (sptr_primary_SAP_entry = ipx_class.SAP_list.sptr_forward_link; sptr_primary_SAP_entry != NULL;
			sptr_primary_SAP_entry = sptr_primary_SAP_entry->links.sptr_forward_link)
			{
			SAP_list_return_type = check_if_in_primary_SAP_list (sptr_primary_SAP_entry, sptr_SAP_ID, 
				&sptr_standby_SAP_list_entry->router_address, port_number,RIP_IPX_ROUTE,NULL);

			if (SAP_list_return_type != MATCHING_ENTRY_NOT_FOUND)
				{
				break;
				}
			}

		if (SAP_list_return_type == MATCHING_ENTRY_FOUND_UPDATE)
			{
			new_primary_SAP = TRUE;
			}

		if (sptr_primary_SAP_entry == NULL)
			{
			if (sptr_SAP_ID->intervening_networks >= SERVER_OR_ROUTER_DOWN_HOP_COUNT)
				{
				continue;
				}

			add_entry_to_list ((LINK *) &ipx_class.SAP_list,(LINK *) &sptr_standby_SAP_list_entry->links);

			new_primary_SAP = TRUE;
			}

		sptr_standby_SAP_list_entry = sptr_standby_SAP_list_entry->links.sptr_forward_link;
		}

	if (new_primary_SAP == TRUE)
		{
		update_SAPs_for_all_ports ();
		}
}
