#include	"defs.h"
/************************************************************************/
/*	Copyright (C) 1993 - 1995 RouterWare, Inc.   								*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Suite 212 Newport Beach, CA 92660	*/
/************************************************************************/
#include 	<stdlib.h>
#include 	<string.h>
#include 	<stddef.h>
#include	"ipx.h"
#include	"vpingstr.h"
/****************************************************************************/ /* 2.12.3 */
static enum IPX_PACKET_STATE  send_ping_response_packet (USHORT port_number, IPX_PING_PACKET *sptr_ping_rx_packet,
	USHORT size_of_frame, enum BOOLEAN data_present_in_rx_packet);
static void initialize_ipx_ping_packet (USHORT port_number, IPX_PING_PACKET *sptr_ping_rx_packet,
	IPX_PING_PACKET *sptr_ping_tx_packet, USHORT size_of_frame, enum BOOLEAN data_present_in_rx_packet);
/****************************************************************************/ /* 2.12.3 */
enum IPX_PACKET_STATE ipx_ping_packet_received (USHORT port_number, IPX_PING_PACKET *sptr_ping_rx_packet, USHORT size_of_frame)
{
	USHORT size_of_ipx_packet;
	enum BOOLEAN data_present_in_rx_packet;
	enum IPX_PACKET_STATE return_code;

	size_of_ipx_packet = (USHORT) (size_of_frame - sizeof (UNION_MAC_HEADER));

	if (size_of_ipx_packet < MINIMUM_SIZE_OF_IPX_PING_PACKET)
		{
 		ipx_printf (ALARM_PRINTF,"IPX: IPX Ping packet received too small on port 0x04x\r\n", port_number);

		return(ILLEGAL_PACKET_SIZE);																			  /* 2.12.3.a, 2.12.3.d */
		}

	if (sptr_ping_rx_packet->ping_header.signature != IPX_PING_SIGNATURE)
		{
 		ipx_printf (ALARM_PRINTF,"IPX: IPX Ping packet has illegal signature on port 0x04x\r\n", port_number);

		return (INCORRECT_IPX_PING_SIGNATURE);                                              /* 2.12.3.b, 2.12.3.e */
		}

	if (sptr_ping_rx_packet->ping_header.type == PING_RESPONSE)
		{
		if ((sptr_ping_rx_packet->ipx_header.destination.node_address._ulong ==				/* packet is for us, but we do not */
			ipx_class.port[port_number].ethernet_address._ulong) &&                         /* requests as yet, so we dump this */
			(sptr_ping_rx_packet->ipx_header.destination.node_address._ushort ==
			ipx_class.port[port_number].ethernet_address._ushort))                             
			{
	 		ipx_printf (ALARM_PRINTF,"IPX: IPX Ping response received for us; we do not send requests; port 0x04x\r\n",
	 			port_number);
		
			return (PING_RESPONSE_RECEIVED_FOR_US);
			}

		if ((sptr_ping_rx_packet->ping_header.result != PING_DATA_NOT_PRESENT) && 
			(sptr_ping_rx_packet->ping_header.result != PING_DATA_PRESENT))
			{
	 		ipx_printf (ALARM_PRINTF,"IPX: IPX Ping packet has illegal result field on port 0x04x\r\n", port_number);

			return (INCORRECT_IPX_PING_RESULT_TYPE);                                        /* 2.12.3.f */
			}

		return_code = ipx_data_to_route (port_number,(IPX_PACKET *) sptr_ping_rx_packet,size_of_frame,FALSE);
		}
		
	else
		{
		if (size_of_ipx_packet == MINIMUM_SIZE_OF_IPX_PING_PACKET)
			{
			data_present_in_rx_packet = FALSE;
			}
		else
			{
			data_present_in_rx_packet = TRUE;
			}


		return_code = send_ping_response_packet (port_number, sptr_ping_rx_packet, size_of_frame, data_present_in_rx_packet);
		}
}
/****************************************************************************/ /* 2.12.3 */
static enum IPX_PACKET_STATE  send_ping_response_packet (USHORT port_number, IPX_PING_PACKET *sptr_ping_rx_packet,
	USHORT size_of_frame, enum BOOLEAN data_present_in_rx_packet)
{
	IPX_PING_PACKET *sptr_ping_tx_packet;
	enum IPX_PACKET_STATE return_code;

	sptr_ping_tx_packet = buffer_malloc (size_of_frame);

	initialize_ipx_ping_packet (port_number, sptr_ping_rx_packet, sptr_ping_tx_packet, size_of_frame, data_present_in_rx_packet);

	return_code = ipx_data_to_route (port_number,(IPX_PACKET *) sptr_ping_rx_packet,size_of_frame,FALSE);

	return (return_code);
}
/****************************************************************************/ /* 2.12.3.c */
static void initialize_ipx_ping_packet (USHORT port_number, IPX_PING_PACKET *sptr_ping_rx_packet,
	IPX_PING_PACKET *sptr_ping_tx_packet, USHORT size_of_frame, enum BOOLEAN data_present_in_rx_packet)
{
	USHORT size_of_data;

	sptr_ping_tx_packet->ipx_header.checksum = 0xffff;
	sptr_ping_tx_packet->ipx_header.transport_control_hop_count = 0x00;
	sptr_ping_tx_packet->ipx_header.packet_type = IPX_PING_PACKET_TYPE;

	sptr_ping_tx_packet->ipx_header.destination.network = sptr_ping_rx_packet->ipx_header.source.network;
	sptr_ping_tx_packet->ipx_header.destination.node_address = sptr_ping_rx_packet->ipx_header.source.node_address;
	sptr_ping_tx_packet->ipx_header.destination.socket = sptr_ping_rx_packet->ipx_header.source.socket;

	sptr_ping_tx_packet->ipx_header.source.network = ipx_class.port[port_number].network;
	sptr_ping_tx_packet->ipx_header.source.node_address = ipx_class.port[port_number].ethernet_address;
	sptr_ping_tx_packet->ipx_header.source.socket = IPX_PING_SOCKET_NUMBER;

	sptr_ping_tx_packet->ping_header.signature = IPX_PING_SIGNATURE;
	sptr_ping_tx_packet->ping_header.version = 0x01;                                     /* ignored on receipt */
	sptr_ping_tx_packet->ping_header.type = PING_RESPONSE;
	sptr_ping_tx_packet->ping_header.id = sptr_ping_rx_packet->ping_header.id;
	sptr_ping_tx_packet->ping_header.result = (BYTE) data_present_in_rx_packet;
	sptr_ping_tx_packet->ping_header.reserved = 0x00;                                    /* ignored on receipt */

	if (data_present_in_rx_packet == TRUE)
		{
		size_of_data = (USHORT) (size_of_frame - offsetof (IPX_PING_PACKET, data));

		memcpy (&sptr_ping_tx_packet->data, &sptr_ping_rx_packet->data, size_of_data);
		}
}
