#include	"defs.h"
/*	$Modname: ipxrout.c$  $version: 3.44$      $date: 10/20/95$   */
/*
* 	$lgb$
1.0 12/26/92 ross
1.1 12/26/92 ross
1.2 01/12/93 ross Added checks for too large hop counts in ipxrout and ipxnetbs and statistics, LLC proper SAPs, netbios broadcast fix soon
1.3 01/17/93 ross fixed SNAP addition bug.
1.4 01/21/93 ross ipxrip timer routine was moved to ipxtimer.c
3.0 01/21/93 ross files ipxrip.c and ipxsap.c split into *ls.c
3.1 01/30/93 ross added ifdef ENABLE_IPX_FRAME_CONVERSION, temporary, will be deleted.
3.2 01/30/93 ross delete references to ipx dlci
3.3 01/31/93 ross added support for netware lite routing
3.4 02/08/93 ross added tunnel support.
3.5 02/20/93 ross changed hop count test from to <.
3.6 03/15/93 ross x86 version now works in real mode -just enough memory
3.7 03/22/93 ross changed name of IPX_MANAGEMENT_PARAMETERS to IPX_PORT_CLASS
3.8 03/30/93 ross added netbios name caching.
3.9 04/06/93 ross moved LSL code into ipxsnap.c, no dependencies in LSL
3.10 04/12/93 ross added ipx wan functions
3.11 04/13/93 ross added stats etc. for Novell's ipx mib v0.9
3.12 05/13/93 ross added stack parameter for tunnel software
3.13 05/21/93 ross made some more tunnel changes, corrected some printf bugs
3.14 05/24/93 ross fixed some problems will loops going down.
3.15 06/15/93 ross fixed diagnostic call return.  Courtesy of Bill.
3.16 07/18/93 ross added IPX_PACKET_STATE to send_ipx_packet for disabled ports.  Courtesy of Yoram.
3.17 07/19/93 ross removed the sizeof (CRC) line.
3.18 07/19/93 ross delete line with CRC... it was commented out.
3.19 07/28/93 ross added statistic path not found.
3.20 10/09/93 ross Added changes for ipxwan
3.21 11/09/93 ross Fixed swap function in ipxrip.c ipxsap.c
3.22 01/25/94 ross adding is_this_an_ipx_packet for people who have the ipxsnap functions available elsewhere.
3.23 01/26/94 ross took out check for wan port in watchdog detection for ipx_data_to_route.
3.24 02/02/94 ross added protocol discrimination function,MTU check.
3.25 03/09/94 ross fixed NLSP conditional compile.
3.26 03/11/94 ross changed NULL to FALSE in call to ipx_data_to_route.
3.27 03/11/94 ross added port_number to is_this... call.  Courtesy of Lori.
3.28 03/11/94 ross another cast.
3.29 03/14/94 ross cleaned up braces and white spaces for release.
3.30 03/19/94 ross more cosmetic cleanup.
3.31 05/20/94 ross changed DLSX to DLSW.
3.32 06/08/94 ross first version support for ipx and rip sap mibs. Ugh.
3.33 07/23/94 ross adding spx support.
3.34 08/08/94 ross finishing end station support.
3.35 11/21/94 ross changed to compile under C++, added big sap and rip support.
3.36 11/23/94 ross changed watchdog to use outgoing port.
3.37 11/23/94 ross Added remote access. Added auto-configuration.
3.38 01/26/95 ross changes for rwutils, spx spoofing, nlsp registration.
3.39 03/26/95 ross nlsp changes.
3.40 05/26/95 ross making change for nlsp exit route.
3.41 07/31/95 ross fixed issue related to the newer LSL and checking ipx packets.  Courtesy of Hung.
3.42 09/25/95 ross added changes for dynamic loading
3.43 10/20/95 ross changes for NLSP RIP-SAP compatibility
3.44 10/20/95 nishit Changed copyright
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1989 - 1995 RouterWare, Inc.								   */
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Suite 212 Newport Beach, CA  92660  */
/************************************************************************/
#include "ipx.h"	  
#include "\rtrware\lsl\vbufstr.h"
#ifdef IPX_FILTERING
#include "ipxfilt.h"
#endif
/****************************************************************************/
enum RX_PACKET_STATE IPX_router_rx_packet (USHORT port_number,ETHERNET_BUFFER *sptr_rx_packet,USHORT size_of_packet)
{
	enum IPX_PACKET_STATE return_code;

	return_code = NON_IPX_PACKET;

#ifdef IPX_HEADER_TRANSLATION
	if ((sptr_rx_packet = convert_ipx_header_in_rx_frame (&port_number,(FRAME *) sptr_rx_packet,&size_of_packet)) == NULL)
		{
		++ipx_class.number_of_non_ipx_packets_received;
		return (PACKET_NOT_RECOGNIZED);
		}

	if (port_number == ILLEGAL_VIRTUAL_PORT_NUMBER)
		{
		++ipx_class.number_of_non_ipx_packets_received;
		return (PACKET_NOT_RECOGNIZED);
		}
#else
	#ifndef __LSL__
		if (is_this_an_ipx_packet (port_number,(IPX_PACKET *) sptr_rx_packet) == FALSE)
			{
			++ipx_class.number_of_non_ipx_packets_received;
			return (PACKET_NOT_RECOGNIZED);
			}
   #else
		if (is_this_a_converted_ipx_packet (port_number, (IPX_PACKET *) sptr_rx_packet) == FALSE)
			{
			++ipx_class.number_of_non_ipx_packets_received;
			return (PACKET_NOT_RECOGNIZED);
			}
	if (ipx_class.port[port_number].port_enabled == FALSE)
		{
		++ipx_class.port[port_number].statistics.number_of_non_ipx_packets_received;

		return (PACKET_RECOGNIZED_BUT_NOT_FORWARDED);
		}

	#endif
#endif

/* Sanjays code */
	ipx_class.ipxBasicSysEntry[0].ipxBasicSysInReceives++;
/* Sanjays code */

	if (ipx_class.port[port_number].port_enabled == FALSE)
		{
		++ipx_class.port[port_number].statistics.number_of_non_ipx_packets_received;

/* Sanjays code */
		ipx_class.ipxBasicSysEntry[0].ipxBasicSysInDiscards++;
/* Sanjays code */
		return (PACKET_RECOGNIZED_BUT_NOT_FORWARDED);
		}

	if (ipx_class.port[port_number].learn_network_address == TRUE)
		{
		check_to_see_if_network_address_is_learned (port_number,(IPX_PACKET *) sptr_rx_packet);
			if (ipx_class.port[port_number].network_address_learned == FALSE)
				{
/* Sanjays code */
				ipx_class.ipxBasicSysEntry[0].ipxBasicSysInDiscards++;
/* Sanjays code */
				return (PACKET_RECOGNIZED_BUT_NOT_FORWARDED);
				}
		}

#ifdef IPX_WAN_ENABLED
	if (ipx_class.port[port_number].remote_access == TRUE)
		{
		add_remote_access_station (&port_number,(IPX_PACKET *) sptr_rx_packet);
		}
#endif

	if (size_of_packet > ipx_class.port[port_number].maximum_packet_size_including_header)
		{
		++ipx_class.port[port_number].statistics.number_of_packets_too_large_received;
/* Sanjays code */
		ipx_class.ipxBasicSysEntry[0].ipxBasicSysInDiscards++;
/* Sanjays code */
																	 
		return (PACKET_RECOGNIZED_BUT_NOT_FORWARDED);
		}

#ifdef IPX_FILTERING
	if (ipx_rx_filter (port_number,sptr_rx_packet,size_of_packet) == TRUE)
		{
		++ipx_class.port[port_number].statistics.number_of_rx_packets_filtered;
/* Sanjays code */
		++ipx_class.ipxAdvSysEntry[0].ipxAdvSysInFiltered;
/* Sanjays code */
		return (PACKET_RECOGNIZED_BUT_NOT_FORWARDED);
		}
#endif

#ifdef DEBUG
	display_ipx_packet (port_number,(IPX_PACKET *) sptr_rx_packet,size_of_packet,TRUE);
#endif

	switch (((IPX_PACKET *)sptr_rx_packet)->ipx_header.packet_type)
		{
		case ECHO_PACKET_TYPE:
			return_code = ipx_echo_packet_received (port_number,(ECHO_PACKET *) sptr_rx_packet,size_of_packet);
			break;

		case ERROR_PACKET_TYPE:
			++ipx_class.port[port_number].statistics.number_of_error_type_packets_received;
			return_code = DATA_PACKET_WAS_RXED_AND_WAS_NOT_FORWARDED;
			break;

		case UNKNOWN_PACKET_TYPE:
		case ROUTER_PACKET_TYPE:
		case NETWARE_CORE_PROTOCOL_TYPE:
		case PACKET_EXCHANGE_PACKET:
		case SEQUENCED_PACKET_PROTOCOL:
		case NLSP_EXPERIMENTAL_PACKET:
			if (((ROUTE_INFORMATION *)sptr_rx_packet)->ipx_header.destination.socket == ROUTING_SOCKET)
				{
/* Sanjays code */
				ipx_class.ipxBasicSysEntry[0].ipxBasicSysInDelivers++;
/* Sanjays code */
				return_code = ipx_router_packet_received ((ROUTE_INFORMATION *)sptr_rx_packet,port_number);
				}
			else if (((ROUTE_INFORMATION *)sptr_rx_packet)->ipx_header.destination.socket == SAP_SOCKET)
				{
/* Sanjays code */
				ipx_class.ipxBasicSysEntry[0].ipxBasicSysInDelivers++;
/* Sanjays code */
				return_code = ipx_SAP_packet_received ((SAP_RECEIVE_PACKET *)sptr_rx_packet,port_number);
				}
#ifdef IPX_WAN_ENABLED
			else if (((ROUTE_INFORMATION *)sptr_rx_packet)->ipx_header.destination.socket == IPX_WAN_SOCKET)
				{
/* Sanjays code */
				ipx_class.ipxBasicSysEntry[0].ipxBasicSysInDelivers++;
/* Sanjays code */
				return_code = ipx_wan_packet_received (port_number,(UNION_IPX_WAN_PACKET *)sptr_rx_packet,size_of_packet);
				}
#endif
			else if (((ROUTE_INFORMATION *)sptr_rx_packet)->ipx_header.destination.socket == NETWARE_SERIALIZATION_SOCKET)
				{
				return_code = serialization_packet_received (port_number,(SERIALIZATION_PACKET *)sptr_rx_packet,size_of_packet);
				}
			else if (((ROUTE_INFORMATION *)sptr_rx_packet)->ipx_header.destination.socket == NLSP_IPX_SOCKET ||
				((ROUTE_INFORMATION *)sptr_rx_packet)->ipx_header.source.socket == NLSP_IPX_SOCKET)
				{
				if (ipx_class.nlsp.fptr_nlsp_rx_routine != NULL)
					{
					return_code = (*ipx_class.nlsp.fptr_nlsp_rx_routine) (port_number,sptr_rx_packet,size_of_packet);
					}
				}
			else
				{
				if (((ROUTE_INFORMATION *)sptr_rx_packet)->ipx_header.destination.socket == NETBIOS_SOCKET ||
					((ROUTE_INFORMATION *)sptr_rx_packet)->ipx_header.source.socket == NETBIOS_SOCKET)
					{
					return_code = netbios_packet_received (port_number,(NOVELL_NETBIOS_PACKET *) sptr_rx_packet,size_of_packet,FALSE);
					}
				else
					{
					return_code = ipx_data_to_route (port_number,(IPX_PACKET *) sptr_rx_packet,size_of_packet,FALSE);
					}
				}

			break;

		case NETBIOS_NAME_PACKET:
			return_code = netbios_packet_received (port_number,(NOVELL_NETBIOS_PACKET *) sptr_rx_packet,size_of_packet,FALSE);
			break;

		default:
			if (((ROUTE_INFORMATION *)sptr_rx_packet)->ipx_header.destination.socket == NETWARE_SERIALIZATION_SOCKET)
				{
				return_code = serialization_packet_received (port_number,(SERIALIZATION_PACKET *)sptr_rx_packet,size_of_packet);
				}
			else
				{
				return_code = ipx_data_to_route (port_number,(IPX_PACKET *) sptr_rx_packet,size_of_packet,FALSE);
				}
			break;
		}

	if ((return_code & IPX_PACKET_STATE_MASK) == NON_IPX_PACKET)
		{
		++ipx_class.port[port_number].statistics.number_of_non_ipx_packets_received;
/* Sanjays code */
		ipx_class.ipxBasicSysEntry[0].ipxBasicSysInDiscards++;
/* Sanjays code */
		return (PACKET_NOT_RECOGNIZED);
		}
	else if (return_code == DATA_PACKET_WAS_RXED_AND_WAS_FORWARDED)
		{
		++ipx_class.port[port_number].statistics.number_of_packets_received;
		/* Srikar, Mar 17, 1997. To update the equivalent ipx stack level variable */
		++ipx_class.ipxBasicSysEntry[0].ipxBasicSysInReceives;
		return (PACKET_RECOGNIZED_AND_FORWARDED);
		}
	else
		{
		++ipx_class.port[port_number].statistics.number_of_packets_received;
		/* Srikar, Mar 17, 1997. To update the equivalent ipx stack level variable */
		++ipx_class.ipxBasicSysEntry[0].ipxBasicSysInReceives;
		return (PACKET_RECOGNIZED_BUT_NOT_FORWARDED);
		}
}
#if defined (__LSL__)
/****************************************************************************/
enum BOOLEAN is_this_an_ipx_packet (USHORT port_number,IPX_PACKET *sptr_rx_packet)
{
	UNION_ETHERNET_LENGTH_OR_TYPE_FIELD length_or_type;
	UNION_SNAP_OR_LLC_HEADER *sptr_snap_or_llc_header;
	enum IPX_FRAME_TYPE tx_frame_type;

	tx_frame_type = ipx_class.port[port_number].tx_frame_type;

	if (sptr_rx_packet->ipx_header.checksum != 0xffff)
		{
		return (FALSE);
		}

	switch (tx_frame_type)
		{
		case ETHERNET_TYPE_II_IPX:

			length_or_type.type = *(USHORT *)((ULONG) sptr_rx_packet - sizeof (USHORT));

			if (length_or_type.type == NETWARE_BLUE_BOOK_ETHERNET_TYPE)
				{
				return (TRUE);
				}

			break;
		case RAW_8023_IPX:

			length_or_type.length = *(USHORT *)((ULONG) sptr_rx_packet - sizeof (USHORT));

			if (swap (length_or_type.length) <= MAXIMUM_8023_LENGTH)
				{
				return (TRUE);
				}

			break;
		case SNAP_IPX:
			sptr_snap_or_llc_header = (UNION_SNAP_OR_LLC_HEADER *) ((ULONG) sptr_rx_packet - sizeof (SNAP_HEADER));

			if (sptr_snap_or_llc_header->snap.llc_frame_type == UNNUMBERED_INFORMATION)
				{
				if (sptr_snap_or_llc_header->snap.destination_address_DSAP == LSAP_SNAP_LLC &&
					sptr_snap_or_llc_header->snap.source_address_SSAP == LSAP_SNAP_LLC &&
					sptr_snap_or_llc_header->snap.protocol_id == SNAP_IPX_PROTOCOL_ID)
					{
					return (TRUE);
					}
				}
			break;
		case LLC_IPX:
			sptr_snap_or_llc_header = (UNION_SNAP_OR_LLC_HEADER *) ((ULONG) sptr_rx_packet - sizeof (LLC_HEADER));

			if (sptr_snap_or_llc_header->llc.llc_frame_type == UNNUMBERED_INFORMATION)
				{
				if (sptr_snap_or_llc_header->llc.destination_address_DSAP != LSAP_SNAP_LLC &&
					sptr_snap_or_llc_header->llc.source_address_SSAP != LSAP_SNAP_LLC &&
					sptr_snap_or_llc_header->llc.destination_address_DSAP == NOVELL_SAP_FOR_IPX &&
					sptr_snap_or_llc_header->llc.source_address_SSAP == NOVELL_SAP_FOR_IPX)
					{
					return (TRUE);
					}
				}
			break;
		default:
			break;
		}

	return (FALSE);
}
#else
/****************************************************************************/
enum BOOLEAN is_this_an_ipx_packet (USHORT port_number,IPX_PACKET *sptr_rx_packet)
{
	UNION_SNAP_OR_LLC_HEADER *sptr_snap_or_llc_header;
	enum IPX_FRAME_TYPE tx_frame_type;
	IPX_HEADER *sptr_ipx_header;

	tx_frame_type = ipx_class.port[port_number].tx_frame_type;

	sptr_snap_or_llc_header = (UNION_SNAP_OR_LLC_HEADER *) &sptr_rx_packet->ipx_header;

	switch (tx_frame_type)
		{
		case ETHERNET_TYPE_II_IPX:
			if ((sptr_rx_packet->ipx_header.checksum == 0xffff) &&
				(sptr_rx_packet->ethernet_header.length == NETWARE_BLUE_BOOK_ETHERNET_TYPE))
				{
				return (TRUE);
				}
			break;
		case RAW_8023_IPX:
			if ((sptr_rx_packet->ipx_header.checksum == 0xffff) &&
				(swap (sptr_rx_packet->ethernet_header.length) <= MAXIMUM_8023_LENGTH))
				{
				return (TRUE);
				}
			break;
		case SNAP_IPX:
			if (sptr_snap_or_llc_header->snap.llc_frame_type == UNNUMBERED_INFORMATION)
				{
				if (sptr_snap_or_llc_header->snap.destination_address_DSAP == LSAP_SNAP_LLC &&
					sptr_snap_or_llc_header->snap.source_address_SSAP == LSAP_SNAP_LLC &&
					sptr_snap_or_llc_header->snap.protocol_id == SNAP_IPX_PROTOCOL_ID)
					{
					sptr_ipx_header = (IPX_HEADER *) &((IPX_8022_SNAP_PACKET *)sptr_rx_packet)->ipx_header;

					if (sptr_ipx_header->checksum == 0xffff)	/* novell SNAP packet */
						{
						return (TRUE);
						}
					}
				}
			break;
		case LLC_IPX:
			if (sptr_snap_or_llc_header->snap.llc_frame_type == UNNUMBERED_INFORMATION)
				{
				if (sptr_snap_or_llc_header->llc.destination_address_DSAP != LSAP_SNAP_LLC &&
					sptr_snap_or_llc_header->llc.source_address_SSAP != LSAP_SNAP_LLC &&
					sptr_snap_or_llc_header->llc.destination_address_DSAP == NOVELL_SAP_FOR_IPX &&
					sptr_snap_or_llc_header->llc.source_address_SSAP == NOVELL_SAP_FOR_IPX)
					{
					sptr_ipx_header = (IPX_HEADER *) &((IPX_8022_PACKET *)sptr_rx_packet)->ipx_header;

					if (sptr_ipx_header->checksum == 0xffff)	/* novell LLC packet */
						{
						return (TRUE);
						}
					}
				}
			break;
		default:
			break;
		}

	return (FALSE);
}
#endif
/****************************************************************************/
enum IPX_PACKET_STATE ipx_data_to_route (USHORT port_number,IPX_PACKET *sptr_rx_packet,USHORT size_of_packet,
	enum BOOLEAN stack_packet)
{
	ETHERNET_ADDRESS	*sptr_hop_routers_ethernet_address;
	USHORT	outgoing_port_number;
	enum IPX_PACKET_STATE return_code;

	++ipx_class.port[port_number].statistics.number_of_packets_to_route;

	if ((sptr_rx_packet->ipx_header.destination.node_address._ushort == 0xffff) &&
		(sptr_rx_packet->ipx_header.destination.node_address._ulong == 0xffffffffL)) /* broadcast firewall */
		{
		if (ipx_class.port[port_number].network == sptr_rx_packet->ipx_header.destination.network)
			{
			return (BROADCAST_PACKET_WAS_RXED);						/* local send packet */
			}
		}

	if (sptr_rx_packet->ipx_header.source.network == 0x00000000) /* ws does this normally upon boot up */
		{
		sptr_rx_packet->ipx_header.source.network = ipx_class.port[port_number].network; 
		}

	if ((ipx_class.port[port_number].enable_diagnostic_packets == TRUE) &&
		(sptr_rx_packet->ipx_header.destination.socket == DIAGNOSTICS_SOCKET))
		{
		return_code = diagnostic_packet_received (port_number,(DIAGNOSTIC_REQUEST_PACKET *) sptr_rx_packet,size_of_packet);

		return (return_code);
		}

/*	if ((ipx_class.port[port_number].enable_watchdog_connection_spoofing == TRUE) &&
		sptr_rx_packet->ipx_header.packet_type == NETWARE_CORE_PROTOCOL_TYPE)
		{
		ipx_ncp_packet_received (port_number,(NETWARE_CORE_PROTOCOL_PACKET *) sptr_rx_packet); 
		}
CURRENTLY TESTING */

	sptr_hop_routers_ethernet_address = get_next_hop_router_address (sptr_rx_packet->ipx_header.destination.network,
		&outgoing_port_number);

	if (sptr_hop_routers_ethernet_address != CANT_FIND_NETWORK)
		{
		sptr_rx_packet->ipx_header.transport_control_hop_count =
			(BYTE) (sptr_rx_packet->ipx_header.transport_control_hop_count + 1);

		if (sptr_rx_packet->ipx_header.transport_control_hop_count > ipx_class.port[port_number].maximum_number_of_hops)
			{
			++ipx_class.port[port_number].statistics.number_of_hop_counts_too_large;
/* Sanjays code */
			++ipx_class.ipxAdvSysEntry[0].ipxAdvSysInTooManyHops;
/* Sanjays code */

			return (DATA_PACKET_WAS_RXED_AND_WAS_NOT_FORWARDED);
			}

		if (sptr_hop_routers_ethernet_address == ON_OTHER_PORTS_NETWORK)
			{
			sptr_rx_packet->ethernet_header.destination_address = sptr_rx_packet->ipx_header.destination.node_address;
			}
		else
			{
			sptr_rx_packet->ethernet_header.destination_address = *sptr_hop_routers_ethernet_address;
			}

		sptr_rx_packet->ethernet_header.source_address = ipx_class.port[outgoing_port_number].ethernet_address;

		if (ipx_class.port[outgoing_port_number].enable_watchdog_spoofing == TRUE)
			{
			if ((swap(sptr_rx_packet->ipx_header.length) == sizeof(IPX_WATCHDOG_PACKET)) &&
					(*(BYTE *)((&sptr_rx_packet->data[0]) + 1) == 'Y' ||
					*(BYTE *)((&sptr_rx_packet->data[0]) + 1) == '?'))
#if 0
			if ((sptr_rx_packet->ipx_header.packet_type == UNKNOWN_PACKET_TYPE ||
					sptr_rx_packet->ipx_header.packet_type == NW4_IPX_WATCHDOG_PACKET ||
					sptr_rx_packet->ipx_header.packet_type == NETWARE_CORE_PROTOCOL_TYPE) &&
				swap (sptr_rx_packet->ipx_header.length) == sizeof (IPX_WATCHDOG_PACKET))
#endif
				{
				return_code = watchdog_packet_received (outgoing_port_number,(WATCHDOG_PACKET *) sptr_rx_packet,size_of_packet);

				if (return_code != WATCHDOG_PACKET_NOT_RECOGNIZED)
					{
					return (return_code);						
					}
				}
			}

		if (ipx_class.port[outgoing_port_number].enable_spx_watchdog_spoofing == TRUE)
			{
			if (sptr_rx_packet->ipx_header.packet_type == SEQUENCED_PACKET_PROTOCOL)
				{
				return_code = spx_packet_received (port_number,outgoing_port_number,(SPX_PACKET *) sptr_rx_packet,size_of_packet);

				return (return_code);						
				}
			}

		if (stack_packet == FALSE)
			return_code = send_ipx_packet (outgoing_port_number,sptr_rx_packet,size_of_packet,TRUE,NULL);
		else 
			return_code = send_ipx_packet (outgoing_port_number,sptr_rx_packet,size_of_packet,FALSE,send_completion_ipx_packet);
/* Sanjays code */
		ipx_class.ipxAdvSysEntry[0].ipxAdvSysForwPackets++;
/* Sanjays code */
	
		return (return_code);
		}
	else
		{
		++ipx_class.port[port_number].statistics.number_of_path_not_found_packets;
/* Sanjays code */
		ipx_class.ipxBasicSysEntry[0].ipxBasicSysNoRoutes++;
/* Sanjays code */

		return (DATA_PACKET_WAS_RXED_AND_WAS_NOT_FORWARDED);
		}
}
/****************************************************************************/
ETHERNET_ADDRESS *get_next_hop_router_address (ULONG destination_network,USHORT *usptr_return_local_router_port_number)
{
	ROUTE_LIST_ENTRY *sptr_primary_route_entry;
	USHORT	local_port_number;
	ETHERNET_ADDRESS *sptr_return_router_address;

	if (ipx_class.nlsp.fptr_nlsp_find_valid_route != NULL)
		{
		sptr_return_router_address = (*ipx_class.nlsp.fptr_nlsp_find_valid_route)
			(destination_network,usptr_return_local_router_port_number);

		return (sptr_return_router_address);
		}

	/* first check for a locally attached route */

	for (local_port_number = ipx_class.starting_port_number; local_port_number < ipx_class.number_of_ports; ++local_port_number)
		{
		if (destination_network == ipx_class.port[local_port_number].network)
			{
			*usptr_return_local_router_port_number = local_port_number;
			return (ON_OTHER_PORTS_NETWORK);
			}
		}

	/* now check other routers for route to destination network */

	for (sptr_primary_route_entry = ipx_class.router_list.sptr_forward_link; sptr_primary_route_entry != NULL;
		sptr_primary_route_entry = sptr_primary_route_entry->links.sptr_forward_link)
		{
		if (sptr_primary_route_entry->route_entry.network == destination_network)
			{
			*usptr_return_local_router_port_number = sptr_primary_route_entry->port_number;
			return (&sptr_primary_route_entry->router_address); /* we found the route, now return this fact */
			}
		}

/*	if (ipx_class.nlsp.fptr_nlsp_find_exit_route != NULL)
		{
		sptr_return_router_address = (*ipx_class.nlsp.fptr_nlsp_find_exit_route)
			(destination_network,usptr_return_local_router_port_number);

		if (sptr_return_router_address != CANT_FIND_NETWORK)
			{
			return (sptr_return_router_address);
			}
		}
*/

	return (CANT_FIND_NETWORK);
}
#ifdef __LSL__
/*
** Multi-Tech added code below to check a LSL translated packet to 
** determine if the current packet is an IPX packet.
** Returns FALSE if packet is NOT an IPX packet, else returns TRUE.
*/
enum BOOLEAN is_this_a_converted_ipx_packet (USHORT port_number,IPX_PACKET *sptr_rx_packet)
{
	enum LSL_PACKET_TYPE lsl_packet_type;
   CONVERTED_8022_PACKET *sptr_converted_llc_header;
   CONVERTED_8022_SNAP_PACKET *sptr_converted_snap_header;


	/* 
	** For a LSL converted frame, the length field in the MAC header is
   ** actually a LSL specific type
   */
   lsl_packet_type = (enum LSL_PACKET_TYPE) sptr_rx_packet->ethernet_header.length;

	switch (lsl_packet_type)
		{
		case ETHERNET_TYPE_II:
		case RAW_8023:
			if (sptr_rx_packet->ipx_header.checksum == 0xFFFF)
				return (TRUE);
			break;

		case SNAP_PACKET:
			sptr_converted_snap_header = (CONVERTED_8022_SNAP_PACKET *)
									((ULONG)sptr_rx_packet - sizeof(SNAP_HEADER));
			if (sptr_converted_snap_header->snap_header.llc_frame_type == UNNUMBERED_INFORMATION &&
				sptr_converted_snap_header->snap_header.protocol_id == SNAP_IPX_PROTOCOL_ID)
				return (TRUE);
			break;

		case LLC_PACKET:
			sptr_converted_llc_header = (CONVERTED_8022_PACKET *)
									((ULONG)sptr_rx_packet - sizeof(LLC_HEADER));
			if (sptr_converted_llc_header->llc_header.destination_address_DSAP == NOVELL_SAP_FOR_IPX &&
					sptr_converted_llc_header->llc_header.source_address_SSAP == NOVELL_SAP_FOR_IPX )
				return TRUE;
			break;

		default:
			break;
		}

	return (FALSE);
}
#endif /* __LSL__ */
