#include	"defs.h"
/*	$Modname: ipxsap.c$  $version: 3.24$      $date: 10/20/95$   */
/*
* 	$lgb$
2.3 01/05/92 ross
2.4 01/21/92 ross send_packet (....,FALSE,TRUE...) driver recalcs CRC (FALSE) and releases buffer
2.5 01/25/92 ross added SAP_deletion_detected, deleted update_SAP, integrated in using enum BOOLEAN to send_periodic_SAP_information.
2.6 01/25/92 ross added check for existence of secondary entry in SAP queue in SAP_deletion_detected, like in ipx.c in router_down_detected
2.7 02/28/92 ross moved secondary route entry code out of SAP down routine, it didn't belong there.
2.8 02/28/92 ross added function check_for_down_secondary_paths which was incorrectly moved back in the previous version.
2.9 04/22/92 ross
2.10 06/22/92 ross Needed instead of > for building big SAP and RIP messages (courtesy of DD).
2.11 10/20/92 ross
2.12 11/02/92 ross made ipx_printf take 1 parameter
2.13 11/02/92 ross made most lines 132 columns now.
2.14 11/24/92 ross
2.15 11/24/92 ross
2.16 12/05/92 ross general clean-up moved some globals in #ifdefs
2.17 12/06/92 ross implemented ipx class structure - no algorithm changes
2.18 12/06/92 ross adding functions to ipxsnmp.c, added static protos for ipx.c and ipxsap.c
2.19 12/26/92 ross
2.20 01/12/93 ross Added checks for too large hop counts in ipxrout and ipxnetbs and statistics, LLC proper SAPs, netbios broadcast fix soon
2.21 01/14/93 ross added update only to periodic timer /w enabled.
2.22 01/14/93 ross added wan BOOLEAN for better wan control, upcoming IPXWAN support
2.23 01/17/93 ross fixed SNAP addition bug.
2.24 01/21/93 ross service was changed to SAP in 2 static functions.
2.25 01/21/93 ross yanked out aging routine and put it in ipxtimer.c.
2.26 01/21/93 ross got rid of PACKET_EXCHANGE_PACKET since all functions set this anyways.
2.27 01/21/93 ross
2.28 01/21/93 ross changed printf in periodic send to differentiate updates from periodics and print different message.
2.29 01/21/93 ross saving before file splitting, added update function.
3.0 01/21/93 ross files ipxrip.c and ipxsap.c split into *ls.c
3.1 02/08/93 ross send_nearest_SAP, when there are no SAPs, the get a send packet was not freed.  It is now done.
3.2 03/08/93 ross added pacing logic to sap,sapls,rip,ripls, and ipxtimer
3.3 03/11/93 ross working with all novell certification tests
3.4 03/15/93 ross x86 version now works in real mode -just enough memory
3.5 03/22/93 ross changed name of IPX_MANAGEMENT_PARAMETERS to IPX_PORT_CLASS
3.6 04/12/93 ross made variable name change in vipxstr.h
3.7 05/13/93 ross added stack parameter for tunnel software
3.8 05/15/93 ross added several new functions for management and use them.
3.9 05/24/93 ross fixed some problems will loops going down.
3.10 05/26/93 ross fixed the loop code stuff
3.11 06/02/93 ross added router address to calls to check_primary... Courtesy of YR.
3.12 11/04/93 ross fixes for simultaneous rip downs and secondary sap/rip lists
3.13 11/08/93 ross fixed some secondary rip and sap problems.  Courtesy of Rick.
3.14 11/09/93 ross Fixed swap function in ipxrip.c ipxsap.c
3.15 11/18/93 ross added test case for get nearest server 1.10. Courtesy of Ken.
3.16 03/14/94 ross cleaned up braces and white spaces for release.
3.17 03/19/94 ross cosmetic cleanup, extraneous header files removed.
3.18 06/10/94 ross added ifdef around enable_SAP_broadcasts.
3.19 11/21/94 ross changed to compile under C++, added big sap and rip support.
3.20 11/23/94 ross Added remote access. Added auto-configuration.
3.21 03/26/95 ross nlsp changes.
3.22 09/25/95 ross added changes for dynamic loading
3.23 10/20/95 ross changes for NLSP RIP-SAP compatibility
3.24 10/20/95 nishit Changed copyright
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1989 - 1995 RouterWare, Inc.								   */
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Suite 212 Newport Beach, CA  92660  */
/************************************************************************/
#include	<stdlib.h>

#include	"ipx.h"
/****************************************************************************/
static enum IPX_PACKET_STATE send_general_SAP_response (SAP_RECEIVE_PACKET *sptr_ipx_SAP_rx_packet,USHORT port_number);
static enum IPX_PACKET_STATE send_nearest_SAP_response (SAP_RECEIVE_PACKET *sptr_ipx_SAP_rx_packet,USHORT port_number);
static enum IPX_PACKET_STATE store_general_SAP_information (SAP_RECEIVE_PACKET *sptr_ipx_SAP_rx_packet,USHORT port_number);
static enum IPX_PACKET_STATE store_nearest_SAP_information (SAP_RECEIVE_PACKET *sptr_ipx_SAP_rx_packet,USHORT port_number);
static GAP_TIME_SAP_RESPONSE_PACKET *store_SAP_ID_in_response_packet (USHORT port_number,
	SAP_RECEIVE_PACKET *sptr_ipx_SAP_rx_packet,SAP_LIST_ENTRY *sptr_primary_SAP_entry,
	GAP_TIME_SAP_RESPONSE_PACKET *sptr_SAP_response_packet,BYTE *bptr_number_of_SAP_IDs);
/*************************************************************************/
enum IPX_PACKET_STATE send_SAP_query (enum QUERY_TYPE query_type,USHORT port_number)
{
	SAP_SEND_QUERY_PACKET *sptr_SAP_send_query_packet;

	if (ipx_class.port[port_number].enable_SAP_broadcasts == TRUE)
		{
		sptr_SAP_send_query_packet = (SAP_SEND_QUERY_PACKET *) get_a_send_packet (port_number,sizeof (SAP_SEND_QUERY_PACKET));

		if (sptr_SAP_send_query_packet == NULL)
			{
			return (OUT_OF_TX_PACKET_MEMORY);
			}

		initialize_SAP_query (port_number,sptr_SAP_send_query_packet);

		sptr_SAP_send_query_packet->service_query_packet.query_type = (USHORT_ENUM (QUERY_TYPE)) query_type;

		++ipx_class.port[port_number].statistics.SAP_tx.number_of_general_queries;

/* Sanjays code */
		++ipx_class.ipxBasicSysEntry[0].ipxBasicSysOutRequests;
/* Sanjays code */
		send_ipx_packet (port_number,(IPX_PACKET *) sptr_SAP_send_query_packet,sizeof (SAP_SEND_QUERY_PACKET),
			FALSE,send_completion_ipx_packet);
		}
	else
		{
		return (SAP_BROADCASTS_DISABLED);
		}

	return (GENERAL_SAP_INFORMATION_QUERY);
}
/*************************************************************************/
enum IPX_PACKET_STATE ipx_SAP_packet_received (SAP_RECEIVE_PACKET *sptr_ipx_SAP_rx_packet,USHORT port_number)
{
	enum	IPX_PACKET_STATE	return_code;

	++ipx_class.port[port_number].statistics.SAP_rx.number_of_packets;

	if (sptr_ipx_SAP_rx_packet->ipx_header.source.network == 0x00000000)
		{
		sptr_ipx_SAP_rx_packet->ipx_header.source.network = ipx_class.port[port_number].network; /* ws does this normally upon boot up */
		}

	if (sptr_ipx_SAP_rx_packet->ipx_header.source.network != ipx_class.port[port_number].network)
		{
		++ipx_class.port[port_number].statistics.number_of_SAP_packets_with_wrong_network_address;
		++ipx_class.sapSysEntry[0].sapSysIncorrectPackets;

		ipx_management_alarm (SAP_PACKET_RXED_WITH_WRONG_NETWORK_ADDRESS_FOR_PORT,port_number);

		return (SAP_PACKET_RXED_WITH_WRONG_NETWORK_ADDRESS_FOR_PORT);
		}

	switch (sptr_ipx_SAP_rx_packet->rx_SAP.query_packet.query_type)
		{
		case GENERAL_SERVICE_QUERY:
			++ipx_class.port[port_number].statistics.SAP_rx.number_of_general_queries;

			if (swap (sptr_ipx_SAP_rx_packet->ipx_header.length) == sizeof (SAP_SEND_QUERY_PACKET) - sizeof (UNION_MAC_HEADER))
				{
				++ipx_class.port[port_number].statistics.SAP_tx.number_of_packets;

				return_code = send_general_SAP_response (sptr_ipx_SAP_rx_packet,port_number);
				}
			else
				{
				++ipx_class.port[port_number].statistics.rx_number_of_unknown_SAP_general_queries;
/* Sanjays code */
				++ipx_class.sapSysEntry[0].sapSysIncorrectPackets;
/* Sanjays code */

				return_code = UNKNOWN_GENERAL_SAP_QUERY_RXED;
				}

			break;
		case NEAREST_SERVICE_QUERY:
			++ipx_class.port[port_number].statistics.SAP_rx.number_of_nearest_queries;

			if (swap (sptr_ipx_SAP_rx_packet->ipx_header.length) == sizeof (SAP_SEND_QUERY_PACKET) - sizeof (UNION_MAC_HEADER))
				{
				++ipx_class.port[port_number].statistics.SAP_tx.number_of_packets;

				return_code = send_nearest_SAP_response (sptr_ipx_SAP_rx_packet,port_number);
				}
			else
				{
				++ipx_class.port[port_number].statistics.rx_number_of_unknown_SAP_nearest_queries;
/* Sanjays code */
				++ipx_class.sapSysEntry[0].sapSysIncorrectPackets;
/* Sanjays code */

				return_code = UNKNOWN_NEAREST_SAP_QUERY_RXED;
				}

			break;
		case GENERAL_SERVICE_RESPONSE:
			if (swap (sptr_ipx_SAP_rx_packet->ipx_header.length) <= ipx_class.port[port_number].maximum_size_of_SAP_packet - sizeof (UNION_MAC_HEADER))
				{
				++ipx_class.port[port_number].statistics.SAP_rx.number_of_general_responses;

				return_code = store_general_SAP_information (sptr_ipx_SAP_rx_packet,port_number);
				}
			else
				{
				++ipx_class.port[port_number].statistics.number_of_unknown_rx_SAP_general_responses;
/* Sanjays code */
				++ipx_class.sapSysEntry[0].sapSysIncorrectPackets;
/* Sanjays code */

				return_code = UNKNOWN_SAP_GENERAL_RESPONSE_RXED;
				}

			break;
		case NEAREST_SERVICE_RESPONSE:
			if (swap (sptr_ipx_SAP_rx_packet->ipx_header.length) ==
				sizeof (SAP_NEAREST_RESPONSE_PACKET) - sizeof (UNION_MAC_HEADER))
				{
				++ipx_class.port[port_number].statistics.SAP_rx.number_of_nearest_responses;

				return_code = store_nearest_SAP_information (sptr_ipx_SAP_rx_packet,port_number);
				}
			else
				{
				++ipx_class.port[port_number].statistics.number_of_unknown_rx_SAP_nearest_responses;
/* Sanjays code */
				++ipx_class.sapSysEntry[0].sapSysIncorrectPackets;
/* Sanjays code */

				return_code = UNKNOWN_SAP_NEAREST_RESPONSE_RXED;
				}
			break;
		default:
			return (NON_IPX_PACKET_SAP);
		}

	return (return_code);
}
/*************************************************************************/
static enum IPX_PACKET_STATE send_general_SAP_response (SAP_RECEIVE_PACKET *sptr_ipx_SAP_rx_packet,USHORT port_number)
{
	SAP_LIST_ENTRY *sptr_primary_SAP_entry;
	BYTE	number_of_SAP_IDs;
	GAP_TIME_SAP_RESPONSE_PACKET *sptr_SAP_response_packet;
	enum IPX_PACKET_STATE return_ipx_state;

#ifdef DISABLE_ALL_SAP_BROADCASTS
	if (ipx_class.port[port_number].enable_SAP_broadcasts == FALSE)
		{
		return (SAP_BROADCASTS_DISABLED);
		}
#endif

	sptr_SAP_response_packet =	(GAP_TIME_SAP_RESPONSE_PACKET *) get_a_send_packet (port_number,
		ipx_class.port[port_number].maximum_size_of_SAP_packet + sizeof (LINK));

	if (sptr_SAP_response_packet == NULL)
		{
		return (OUT_OF_TX_PACKET_MEMORY);
		}

	number_of_SAP_IDs = 0x00;

	if (sptr_ipx_SAP_rx_packet->rx_SAP.query_packet.SAP_type == (enum SAP_PACKET_TYPE) ALL_SERVER_TYPES)
		{
		for (sptr_primary_SAP_entry = ipx_class.SAP_list.sptr_forward_link; sptr_primary_SAP_entry != NULL;
			sptr_primary_SAP_entry = sptr_primary_SAP_entry->links.sptr_forward_link)
			{
			sptr_SAP_response_packet = store_SAP_ID_in_response_packet (port_number,sptr_ipx_SAP_rx_packet,sptr_primary_SAP_entry,
				sptr_SAP_response_packet,&number_of_SAP_IDs);

			if (sptr_SAP_response_packet == NULL)
				{
				return (OUT_OF_TX_PACKET_MEMORY);
				}
			}
		}
	else 
		{
		for (sptr_primary_SAP_entry = get_SAP_list_entry_using_type (sptr_ipx_SAP_rx_packet->rx_SAP.query_packet.SAP_type,
			ipx_class.SAP_list.sptr_forward_link);
			sptr_primary_SAP_entry != NULL;
			sptr_primary_SAP_entry = get_SAP_list_entry_using_type (sptr_ipx_SAP_rx_packet->rx_SAP.query_packet.SAP_type,
				sptr_primary_SAP_entry))
			{
			sptr_SAP_response_packet = store_SAP_ID_in_response_packet (port_number,sptr_ipx_SAP_rx_packet,sptr_primary_SAP_entry,
				sptr_SAP_response_packet,&number_of_SAP_IDs);

			if (sptr_SAP_response_packet == NULL)
				{
				return (OUT_OF_TX_PACKET_MEMORY);
				}

			sptr_primary_SAP_entry = sptr_primary_SAP_entry->links.sptr_forward_link;
			}
		}

	if (number_of_SAP_IDs > 0x00)
		{
		initialize_SAP_response (port_number,(SAP_RESPONSE_PACKET *) &sptr_SAP_response_packet->ethernet_header,
			&sptr_ipx_SAP_rx_packet->ethernet_header.source_address,
			swap ((USHORT) (ipx_class.port[port_number].maximum_size_of_SAP_packet -
			((ipx_class.port[port_number].maximum_number_of_SAP_entries - number_of_SAP_IDs) * sizeof (SAP_ID))
			- sizeof (UNION_MAC_HEADER))),
			&sptr_ipx_SAP_rx_packet->ipx_header.source,
			GENERAL_SERVICE_RESPONSE);

		add_entry_to_list ((LINK *) &ipx_class.port[port_number].response_SAP_list,&sptr_SAP_response_packet->links);

/* Sanjays code */
		++ipx_class.port[port_number].statistics.SAP_tx.number_of_packets;
/* Sanjays code */
		return_ipx_state = GENERAL_SAP_REQUEST_RXED;
		}
	else
		{
		sptr_SAP_response_packet = (GAP_TIME_SAP_RESPONSE_PACKET *)
			normalize_send_packet_header (port_number,(IPX_PACKET *) sptr_SAP_response_packet);

		free_a_send_packet ((IPX_PACKET *)sptr_SAP_response_packet);

		return_ipx_state = GENERAL_SAP_REQUEST_RXED_NO_KNOWN_SAPS;
		}

	if (return_ipx_state == GENERAL_SAP_REQUEST_RXED)
		{
		return (GENERAL_SAP_REQUEST_RXED);
		}
	else
		{
		return (GENERAL_SAP_REQUEST_RXED_NO_KNOWN_SAPS);
		}
}
/*************************************************************************/
static GAP_TIME_SAP_RESPONSE_PACKET *store_SAP_ID_in_response_packet (USHORT port_number,
	SAP_RECEIVE_PACKET *sptr_ipx_SAP_rx_packet,SAP_LIST_ENTRY *sptr_primary_SAP_entry,
	GAP_TIME_SAP_RESPONSE_PACKET *sptr_SAP_response_packet,BYTE *bptr_number_of_SAP_IDs)
{
	if (is_SAP_the_best_information (sptr_primary_SAP_entry,port_number) == TRUE)
		{
		if ((ipx_class.nlsp.fptr_nlsp_check_for_valid_SAP_id == NULL) ||
			((ipx_class.nlsp.fptr_nlsp_check_for_valid_SAP_id != NULL) &&
			((*ipx_class.nlsp.fptr_nlsp_check_for_valid_SAP_id) (sptr_primary_SAP_entry, TRUE) == PASS)))
			{
			sptr_SAP_response_packet->SAP_ID[*bptr_number_of_SAP_IDs] = sptr_primary_SAP_entry->SAP_ID;

			*bptr_number_of_SAP_IDs = (BYTE) (*bptr_number_of_SAP_IDs + 1);

			if (*bptr_number_of_SAP_IDs == ipx_class.port[port_number].maximum_number_of_SAP_entries)
				{
				initialize_SAP_response (port_number,(SAP_RESPONSE_PACKET *) &sptr_SAP_response_packet->ethernet_header,
					&sptr_ipx_SAP_rx_packet->ethernet_header.source_address,
					swap ((USHORT) (ipx_class.port[port_number].maximum_size_of_SAP_packet - sizeof (UNION_MAC_HEADER))),
					&sptr_ipx_SAP_rx_packet->ipx_header.source,
					GENERAL_SERVICE_RESPONSE);

				add_entry_to_list ((LINK *) &ipx_class.port[port_number].response_SAP_list,&sptr_SAP_response_packet->links);

				sptr_SAP_response_packet =	(GAP_TIME_SAP_RESPONSE_PACKET *) get_a_send_packet (port_number,
					ipx_class.port[port_number].maximum_size_of_SAP_packet + sizeof (LINK));

				*bptr_number_of_SAP_IDs	= 0x00;
				}
			}
		}

	return (sptr_SAP_response_packet);
}
/*************************************************************************/
static enum IPX_PACKET_STATE send_nearest_SAP_response (SAP_RECEIVE_PACKET *sptr_ipx_SAP_rx_packet,USHORT port_number)
{
	SAP_LIST_ENTRY *sptr_primary_SAP_entry;
	BYTE	number_of_SAP_IDs;
	SAP_RESPONSE_PACKET	*sptr_SAP_response_packet;
	ROUTE_ENTRY *sptr_route_entry_for_SAP;
	USHORT swapped_transport_time;

#ifdef DISABLE_ALL_SAP_BROADCASTS
	if (ipx_class.port[port_number].enable_SAP_broadcasts == FALSE)
		{
		return (SAP_BROADCASTS_DISABLED);
		}
#endif

	sptr_SAP_response_packet = (SAP_RESPONSE_PACKET *) get_a_send_packet (port_number,
		ipx_class.port[port_number].maximum_size_of_SAP_packet);

	if (sptr_SAP_response_packet == NULL)
		{
		return (OUT_OF_TX_PACKET_MEMORY);
		}

	number_of_SAP_IDs = 0x00;
	swapped_transport_time = 0xffff;

	for (sptr_primary_SAP_entry = get_SAP_list_entry_using_type (sptr_ipx_SAP_rx_packet->rx_SAP.query_packet.SAP_type,
		ipx_class.SAP_list.sptr_forward_link);
		sptr_primary_SAP_entry != NULL;
		sptr_primary_SAP_entry = get_SAP_list_entry_using_type (sptr_ipx_SAP_rx_packet->rx_SAP.query_packet.SAP_type,
		sptr_primary_SAP_entry))
		{
		if (is_SAP_the_best_information (sptr_primary_SAP_entry,port_number) == TRUE)
			{
			sptr_route_entry_for_SAP =
				get_route_entry_from_network_address (sptr_primary_SAP_entry->SAP_ID.ipx_address.network);

			if (sptr_route_entry_for_SAP != NULL)
				{
				if (swap (sptr_route_entry_for_SAP->transport_time) < swapped_transport_time)
					{
					swapped_transport_time = swap (sptr_route_entry_for_SAP->transport_time);

					number_of_SAP_IDs = (BYTE) (number_of_SAP_IDs + 1);

					sptr_SAP_response_packet->SAP_ID[0] = sptr_primary_SAP_entry->SAP_ID;
					}
				else if (swap (sptr_route_entry_for_SAP->transport_time) == swapped_transport_time)
					{
					if (swap (sptr_primary_SAP_entry->SAP_ID.intervening_networks) <
						swap (sptr_SAP_response_packet->SAP_ID[0].intervening_networks))
						{
						number_of_SAP_IDs = (BYTE) (number_of_SAP_IDs + 1);

						sptr_SAP_response_packet->SAP_ID[0] = sptr_primary_SAP_entry->SAP_ID;
						}
					}

				}
			}
		else /* this case is a test case */
			{
			number_of_SAP_IDs = 0x00;
			break;
			}

		sptr_primary_SAP_entry = sptr_primary_SAP_entry->links.sptr_forward_link;
		}

	if (number_of_SAP_IDs > 0x00)
		{
		initialize_SAP_response (port_number,(SAP_RESPONSE_PACKET *) &sptr_SAP_response_packet->ethernet_header,
			&sptr_ipx_SAP_rx_packet->ethernet_header.source_address,
			swap (sizeof (SAP_NEAREST_RESPONSE_PACKET) - sizeof (UNION_MAC_HEADER)),&sptr_ipx_SAP_rx_packet->ipx_header.source,
			NEAREST_SERVICE_RESPONSE);

		++ipx_class.port[port_number].statistics.SAP_tx.number_of_nearest_responses;
/* Sanjays code */
		++ipx_class.port[port_number].statistics.SAP_tx.number_of_packets;
/* Sanjays code */


/* Sanjays code */
		++ipx_class.ipxBasicSysEntry[0].ipxBasicSysOutRequests;
/* Sanjays code */
		send_ipx_packet (port_number,(IPX_PACKET *) sptr_SAP_response_packet,(USHORT) (sizeof (UNION_MAC_HEADER) +
			swap (sptr_SAP_response_packet->ipx_header.length)),FALSE,send_completion_ipx_packet);

		return (NEAREST_SAP_REQUEST_RXED);
		}
	else
		{
		sptr_SAP_response_packet = (SAP_RESPONSE_PACKET *)
			normalize_send_packet_header (port_number,(IPX_PACKET *) sptr_SAP_response_packet);

		free_a_send_packet ((IPX_PACKET *)sptr_SAP_response_packet);

		return (NEAREST_SAP_REQUEST_RXED_NO_KNOWN_SAPS);
		}
}
/*************************************************************************/
static enum IPX_PACKET_STATE store_general_SAP_information (SAP_RECEIVE_PACKET *sptr_ipx_SAP_rx_packet,USHORT port_number)
{
	SAP_ID *sptr_SAP_ID;
	SAP_LIST_ENTRY *sptr_primary_SAP_entry;
	SAP_LIST_ENTRY *sptr_SAP_list_entry;
	USHORT	current_SAP_ID_number;
	USHORT	number_of_SAP_IDs;
	enum BOOLEAN new_primary_SAP;
	enum LIST_ENTRY_TYPE SAP_list_return_type;

	sptr_SAP_ID = &sptr_ipx_SAP_rx_packet->rx_SAP.ID_packet.SAP_ID[0];

	number_of_SAP_IDs = (USHORT) ((swap (sptr_ipx_SAP_rx_packet->ipx_header.length) - sizeof (IPX_HEADER) - sizeof (USHORT)) / 
		sizeof (SAP_ID));

	new_primary_SAP = FALSE;

	for (current_SAP_ID_number = 0x0000 ; current_SAP_ID_number < number_of_SAP_IDs ;++current_SAP_ID_number,++sptr_SAP_ID)
		{
		if (ipx_class.nlsp.fptr_nlsp_check_for_valid_SAP_id != NULL)
			{
			if ((sptr_SAP_list_entry = (SAP_LIST_ENTRY *) table_malloc (sizeof (SAP_LIST_ENTRY),1)) != NULL)
				{
				sptr_SAP_list_entry->SAP_ID = *sptr_SAP_ID;
				sptr_SAP_list_entry->router_address = sptr_ipx_SAP_rx_packet->ethernet_header.source_address;
				sptr_SAP_list_entry->port_number = port_number;
				sptr_SAP_list_entry->type = IPX_SAP;

				if ((*ipx_class.nlsp.fptr_nlsp_check_for_valid_SAP_id) (sptr_SAP_list_entry, TRUE) == FAIL)
					{
					table_free (sptr_SAP_list_entry);

					continue;
					}

				table_free (sptr_SAP_list_entry);
				}
			}
			
		if (sptr_SAP_ID->intervening_networks < SERVER_OR_ROUTER_DOWN_HOP_COUNT)
			{
			sptr_SAP_ID->intervening_networks = swap ((USHORT) (swap (sptr_SAP_ID->intervening_networks) + 1));
			}
		else if (sptr_SAP_ID->intervening_networks > SERVER_OR_ROUTER_DOWN_HOP_COUNT)
			{
			continue;
			}

		if (sptr_SAP_ID->ipx_address.network == 0x00000000L)
			{
			sptr_SAP_ID->ipx_address.network = ipx_class.port[port_number].network;
			}

		if (get_route_entry_from_network_address (sptr_SAP_ID->ipx_address.network) == NULL)
			{
			continue;
			}

		SAP_list_return_type = MATCHING_ENTRY_NOT_FOUND;

		for (sptr_primary_SAP_entry = ipx_class.SAP_list.sptr_forward_link; sptr_primary_SAP_entry != NULL;
			sptr_primary_SAP_entry = sptr_primary_SAP_entry->links.sptr_forward_link)
			{
			SAP_list_return_type	= check_if_in_primary_SAP_list (sptr_primary_SAP_entry,sptr_SAP_ID,
				&sptr_ipx_SAP_rx_packet->ethernet_header.source_address,port_number,IPX_SAP,NULL);

			if (SAP_list_return_type != MATCHING_ENTRY_NOT_FOUND)
				{
				break;
				}
			}

		if (SAP_list_return_type == MATCHING_ENTRY_FOUND_UPDATE)
			{
			new_primary_SAP = TRUE;
			}

		if (sptr_primary_SAP_entry == NULL)
			{
			if (sptr_SAP_ID->intervening_networks >= SERVER_OR_ROUTER_DOWN_HOP_COUNT)
				{
				continue;
				}

			if (add_SAP_entry (port_number,sptr_SAP_ID,&sptr_ipx_SAP_rx_packet->ethernet_header.source_address,TRUE,
				FALSE,IPX_SAP,NULL) == PASS)
				{
				new_primary_SAP = TRUE;
				}
			}
		}

	if (new_primary_SAP == TRUE)
		{
		update_SAPs_for_all_ports ();

		return (GENERAL_SAP_RXED_UPATE);
		}
	else
		{
		return (GENERAL_SAP_RXED);
		}
}
/*************************************************************************/
static enum IPX_PACKET_STATE store_nearest_SAP_information (SAP_RECEIVE_PACKET *sptr_ipx_SAP_rx_packet,USHORT port_number)
{
	SAP_ID *sptr_SAP_ID;
	SAP_LIST_ENTRY *sptr_primary_SAP_entry;
	SAP_LIST_ENTRY *sptr_next_SAP_list_entry;
	enum LIST_ENTRY_TYPE SAP_list_return_type;
	enum BOOLEAN new_primary_SAP;

	sptr_SAP_ID = &sptr_ipx_SAP_rx_packet->rx_SAP.ID_packet.SAP_ID[0];

	if (sptr_SAP_ID->intervening_networks < SERVER_OR_ROUTER_DOWN_HOP_COUNT)
		{
		sptr_SAP_ID->intervening_networks = swap ((USHORT) (swap (sptr_SAP_ID->intervening_networks) + 1));
		}

	new_primary_SAP = FALSE;

	SAP_list_return_type = MATCHING_ENTRY_NOT_FOUND;

	for (sptr_primary_SAP_entry = ipx_class.SAP_list.sptr_forward_link; sptr_primary_SAP_entry != NULL;)
		{
		sptr_next_SAP_list_entry = sptr_primary_SAP_entry->links.sptr_forward_link;

		SAP_list_return_type = check_if_in_primary_SAP_list (sptr_primary_SAP_entry,sptr_SAP_ID,
			&sptr_ipx_SAP_rx_packet->ethernet_header.source_address,port_number,IPX_SAP,NULL);

		if (SAP_list_return_type != MATCHING_ENTRY_NOT_FOUND)
			{
			break;
			}

		sptr_primary_SAP_entry = sptr_next_SAP_list_entry;
		}

	if (SAP_list_return_type == MATCHING_ENTRY_FOUND_UPDATE)
		{
		new_primary_SAP = TRUE;
		}

	if (sptr_primary_SAP_entry == NULL)
		{
		if (add_SAP_entry (port_number,sptr_SAP_ID,&sptr_ipx_SAP_rx_packet->ethernet_header.source_address,TRUE,FALSE,IPX_SAP,NULL) 
			== PASS)
			{
			new_primary_SAP = TRUE;
			}
		}

	if (new_primary_SAP == TRUE)
		{
		update_SAPs_for_all_ports ();

		return (NEAREST_SAP_RXED_UPATE);
		}
	else
		{
		return (NEAREST_SAP_RXED);
		}
}
