#include	"defs.h"
/*	$Modname: ipxsnap.c$  $version: 3.15$      $date: 10/25/95$   */
/*
* 	$lgb$
1.0 12/05/92 ross
1.1 12/05/92 ross
1.2 12/06/92 ross implemented ipx class structure - no algorithm changes
1.3 12/22/92 ross changed default, break to return (NULL);
1.4 12/26/92 ross
1.5 01/12/93 ross Added checks for too large hop counts in ipxrout and ipxnetbs and statistics, LLC proper SAPs, netbios broadcast fix soon
1.6 01/13/93 ross added proper values for SAPs courtesy of yr.
1.7 01/14/93 ross added wan BOOLEAN for better wan control, upcoming IPXWAN support
1.8 01/16/93 ross snap problem with snap rx to 8023 size.
1.9 01/17/93 ross fixed SNAP addition bug.
3.0 01/19/93 ross changed ipx_header_for_tx  token_ring_enabled test is not necessary - courtesy of Art B.
3.1 01/31/93 ross renamed RAW_..TYPE_II to ..TYPE_II
3.2 01/31/93 ross added support for netware lite routing
3.3 02/09/93 ross delete extra count for non-ipx packets received. Courtesy of HS.
3.4 03/15/93 ross x86 version now works in real mode -just enough memory
3.5 03/22/93 ross changed name of IPX_MANAGEMENT_PARAMETERS to IPX_PORT_CLASS
3.6 04/06/93 ross moved LSL code into ipxsnap.c, no dependencies in LSL
3.7 04/12/93 ross made variable name change in vipxstr.h
3.8 05/13/93 ross added stack parameter for tunnel software
3.9 05/21/93 ross made some more tunnel changes, corrected some printf bugs
3.10 03/09/94 ross added SNAP to token ring header addition.  Courtesy of Arcadi.
3.11 03/14/94 ross cleaned up braces and white spaces for release.
3.12 03/19/94 ross cosmetic cleanup, extraneous header files removed.
3.13 11/21/94 ross changed to compile under C++, added big sap and rip support.
3.14 10/20/95 nishit Changed copyright
3.15 10/25/95 nishit Minor NLSP related changes
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1989 - 1995 RouterWare, Inc.								   */
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Suite 212 Newport Beach, CA  92660  */
/************************************************************************/
#include	"ipx.h"
/****************************************************************************/
static USHORT convert_real_to_ipx_virtual_port_number (USHORT real_port_number,enum IPX_FRAME_TYPE ipx_frame_type);
static USHORT convert_ipx_virtual_to_real_port_number (USHORT virtual_port_number);
/****************************************************************************/
ETHERNET_BUFFER *convert_ipx_header_for_tx (USHORT *usptr_port_number,FRAME *sptr_tx_frame,USHORT *usptr_size_of_tx_packet)
{
	IPX_HEADER *sptr_ipx_header;
	MAC_ADDRESS source;
	MAC_ADDRESS destination;
	FRAME *sptr_modified_tx_frame;
	enum IPX_FRAME_TYPE tx_frame_type;
	UNION_ETHERNET_LENGTH_OR_TYPE_FIELD length_or_type;

	tx_frame_type = ipx_class.port[*usptr_port_number].tx_frame_type;
	sptr_ipx_header = (IPX_HEADER *) &sptr_tx_frame->snap_or_llc_header;

	if (ipx_class.port[*usptr_port_number].token_ring_enabled == TRUE)
		{
		source = sptr_tx_frame->mac_header.ethernet.source_address;
		destination = sptr_tx_frame->mac_header.ethernet.destination_address;
		}
	else
		{
		if (tx_frame_type != ETHERNET_TYPE_II_IPX)
			{
			if (tx_frame_type == RAW_8023_IPX)
				{
				length_or_type.length =	swap ((USHORT) ((swap (((IPX_PACKET *)sptr_tx_frame)->ipx_header.length) + 1) & 0xfffe));

				*usptr_size_of_tx_packet = (USHORT) ((*usptr_size_of_tx_packet + 1) & 0xfffe);
				}
			else
				length_or_type.length =	((IPX_PACKET *)sptr_tx_frame)->ipx_header.length;
			}
		else
			length_or_type.type = NETWARE_BLUE_BOOK_ETHERNET_TYPE;

		source = sptr_tx_frame->mac_header.ethernet.source_address;
		destination = sptr_tx_frame->mac_header.ethernet.destination_address;
		}

	switch (tx_frame_type)
		{
		case ETHERNET_TYPE_II_IPX:
		case RAW_8023_IPX:
			sptr_modified_tx_frame = (FRAME *) ((ULONG) sptr_ipx_header - sizeof (UNION_MAC_HEADER));
			break;
		case LLC_IPX:
			sptr_modified_tx_frame = (FRAME *) ((ULONG) sptr_ipx_header - sizeof (UNION_MAC_HEADER) - sizeof (LLC_HEADER));

			sptr_modified_tx_frame->snap_or_llc_header.llc.destination_address_DSAP = NOVELL_SAP_FOR_IPX;
			sptr_modified_tx_frame->snap_or_llc_header.llc.source_address_SSAP = NOVELL_SAP_FOR_IPX;
			sptr_modified_tx_frame->snap_or_llc_header.llc.llc_frame_type = UNNUMBERED_INFORMATION;

			break;
		case SNAP_IPX:
			sptr_modified_tx_frame = (FRAME *) ((ULONG) sptr_ipx_header - sizeof (UNION_MAC_HEADER) - sizeof (SNAP_HEADER));

			sptr_modified_tx_frame->snap_or_llc_header.snap.destination_address_DSAP = LSAP_SNAP_LLC;
			sptr_modified_tx_frame->snap_or_llc_header.snap.source_address_SSAP = LSAP_SNAP_LLC;
			sptr_modified_tx_frame->snap_or_llc_header.snap.llc_frame_type = UNNUMBERED_INFORMATION;

			sptr_modified_tx_frame->snap_or_llc_header.snap.protocol_id_filler[0] = 0x00;
			sptr_modified_tx_frame->snap_or_llc_header.snap.protocol_id_filler[1] = 0x00;
			sptr_modified_tx_frame->snap_or_llc_header.snap.protocol_id_filler[2] = 0x00;
			sptr_modified_tx_frame->snap_or_llc_header.snap.protocol_id = SNAP_IPX_PROTOCOL_ID;

			break;
		default:
			ipx_printf (SNAP_PRINTF,"IPX: Illegal IPX_FRAME_TYPE %04x",usptr_port_number);
			return (NULL);
		}

	if (ipx_class.port[*usptr_port_number].token_ring_enabled == TRUE)
		{
		sptr_modified_tx_frame->mac_header.token_ring.source_address = source;
		sptr_modified_tx_frame->mac_header.token_ring.destination_address = destination;
		sptr_modified_tx_frame->mac_header.token_ring.access_control = 0x00;
		sptr_modified_tx_frame->mac_header.token_ring.frame_control = TOKEN_RING_LLC_FRAME;
		}
	else
		{
		length_or_type.length = swap ((USHORT) (swap (length_or_type.length) + get_size_of_frame_type_header (*usptr_port_number)));

		sptr_modified_tx_frame->mac_header.ethernet.source_address = source;
		sptr_modified_tx_frame->mac_header.ethernet.destination_address = destination;
		sptr_modified_tx_frame->mac_header.ethernet.length_or_type = length_or_type;
		}

	*usptr_port_number = convert_ipx_virtual_to_real_port_number (*usptr_port_number);

	return ((ETHERNET_BUFFER *) sptr_modified_tx_frame);
}
/****************************************************************************/
ETHERNET_BUFFER *convert_ipx_header_in_rx_frame (USHORT *usptr_port_number,FRAME *sptr_rx_frame,USHORT *usptr_size_of_rx_packet)
{
	UNION_SNAP_OR_LLC_HEADER *sptr_snap_or_llc_header;
	IPX_HEADER *sptr_ipx_header;
	MAC_ADDRESS source;
	MAC_ADDRESS destination;

	sptr_ipx_header = &((IPX_PACKET *)sptr_rx_frame)->ipx_header;
	sptr_snap_or_llc_header = (UNION_SNAP_OR_LLC_HEADER *) sptr_ipx_header;

	if (sptr_ipx_header->checksum == 0xffff)	/* novell raw packet (default) */
		{
		if (sptr_rx_frame->mac_header.ethernet.length_or_type.type != NETWARE_BLUE_BOOK_ETHERNET_TYPE)
			sptr_rx_frame->mac_header.ethernet.length_or_type.length = (USHORT) RAW_8023_IPX;
		else
			sptr_rx_frame->mac_header.ethernet.length_or_type.length = (USHORT) ETHERNET_TYPE_II_IPX;

		*usptr_port_number =
			convert_real_to_ipx_virtual_port_number (*usptr_port_number,(enum IPX_FRAME_TYPE ) sptr_rx_frame->mac_header.ethernet.length_or_type.length);

		return ((ETHERNET_BUFFER *) sptr_rx_frame);
		}
	else if (sptr_snap_or_llc_header->snap.llc_frame_type == UNNUMBERED_INFORMATION)
		{
		if (sptr_snap_or_llc_header->snap.destination_address_DSAP == LSAP_SNAP_LLC &&
			sptr_snap_or_llc_header->snap.source_address_SSAP == LSAP_SNAP_LLC &&
			sptr_snap_or_llc_header->snap.protocol_id == SNAP_IPX_PROTOCOL_ID)
			{
			sptr_ipx_header = (IPX_HEADER *) &((IPX_8022_SNAP_PACKET *)sptr_rx_frame)->ipx_header;

			if (sptr_ipx_header->checksum == 0xffff)	/* novell SNAP packet */
				{
				if (ipx_class.virtual_port_number_array.token_ring_or_ethernet[*usptr_port_number] == TRUE)
					{
					source = sptr_rx_frame->mac_header.token_ring.source_address;
					destination = sptr_rx_frame->mac_header.token_ring.destination_address;
					}
				else
					{
					source = sptr_rx_frame->mac_header.ethernet.source_address;
					destination = sptr_rx_frame->mac_header.ethernet.destination_address;
					}

				((CONVERTED_IPX_8022_SNAP_PACKET *)sptr_rx_frame)->snap_header = sptr_snap_or_llc_header->snap;

				sptr_rx_frame = (FRAME *) ((ULONG) sptr_ipx_header - sizeof (ETHERNET_HEADER));

				sptr_rx_frame->mac_header.ethernet.source_address = source;
				sptr_rx_frame->mac_header.ethernet.destination_address = destination;
				sptr_rx_frame->mac_header.ethernet.length_or_type.length = (USHORT) SNAP_IPX;

				*usptr_size_of_rx_packet = (USHORT) (*usptr_size_of_rx_packet - sizeof (SNAP_HEADER));

				*usptr_port_number =
					convert_real_to_ipx_virtual_port_number (*usptr_port_number,
						(enum IPX_FRAME_TYPE ) sptr_rx_frame->mac_header.ethernet.length_or_type.length);

				return ((ETHERNET_BUFFER *) sptr_rx_frame);
				}
			else
				return (NULL);
			}
		else if (sptr_snap_or_llc_header->llc.destination_address_DSAP != LSAP_SNAP_LLC &&
			sptr_snap_or_llc_header->llc.source_address_SSAP != LSAP_SNAP_LLC &&
			sptr_snap_or_llc_header->llc.destination_address_DSAP == NOVELL_SAP_FOR_IPX &&
			sptr_snap_or_llc_header->llc.source_address_SSAP == NOVELL_SAP_FOR_IPX)
			{
			sptr_ipx_header = (IPX_HEADER *) &((IPX_8022_PACKET *)sptr_rx_frame)->ipx_header;

			if (sptr_ipx_header->checksum == 0xffff)	/* novell LLC packet */
				{
				if (ipx_class.virtual_port_number_array.token_ring_or_ethernet[*usptr_port_number] == TRUE)
					{
					source = sptr_rx_frame->mac_header.token_ring.source_address;
					destination = sptr_rx_frame->mac_header.token_ring.destination_address;
					}
				else
					{
					source = sptr_rx_frame->mac_header.ethernet.source_address;
					destination = sptr_rx_frame->mac_header.ethernet.destination_address;
					}

				((CONVERTED_IPX_8022_PACKET *)sptr_rx_frame)->llc_header = sptr_snap_or_llc_header->llc;

				sptr_rx_frame = (FRAME *) ((ULONG) sptr_ipx_header - sizeof (ETHERNET_HEADER));

				sptr_rx_frame->mac_header.ethernet.source_address = source;
				sptr_rx_frame->mac_header.ethernet.destination_address = destination;

				sptr_rx_frame->mac_header.ethernet.length_or_type.length = (USHORT) LLC_IPX;

				*usptr_size_of_rx_packet = (USHORT) (*usptr_size_of_rx_packet - sizeof (LLC_HEADER));

				*usptr_port_number =
					convert_real_to_ipx_virtual_port_number (*usptr_port_number,
						(enum IPX_FRAME_TYPE) sptr_rx_frame->mac_header.ethernet.length_or_type.length);

				return ((ETHERNET_BUFFER *) sptr_rx_frame);
				}
			else
				return (NULL);
			}
		}

	return (NULL);
}
/****************************************************************************/
USHORT get_size_of_frame_type_header (USHORT port_number)
{
	USHORT size_of_extra_header;

	size_of_extra_header = 0x0000;

	if (ipx_class.port[port_number].token_ring_enabled == TRUE)
		{
		switch (ipx_class.port[port_number].tx_frame_type)
			{
			case LLC_IPX:
				size_of_extra_header = sizeof (LLC_HEADER);
				break;
			case SNAP_IPX:
				size_of_extra_header = sizeof (SNAP_HEADER);
				break;
			}
		}
	else
		{
		switch (ipx_class.port[port_number].tx_frame_type)
			{
			case ETHERNET_TYPE_II_IPX:
			case RAW_8023_IPX:
				break;
			case LLC_IPX:
				size_of_extra_header = sizeof (LLC_HEADER);
				break;
			case SNAP_IPX:
				size_of_extra_header = sizeof (SNAP_HEADER);
				break;
			default:
				break;
			}
		}

	return (size_of_extra_header);
}
/*************************************************************************/
static USHORT convert_real_to_ipx_virtual_port_number (USHORT real_port_number,enum IPX_FRAME_TYPE ipx_frame_type)
{
	USHORT virtual_port_number;

	virtual_port_number = ipx_class.virtual_port_number_array.virtual_port_number[real_port_number];

	while (real_port_number == ipx_class.port[virtual_port_number].real_port_number)
		{
		if (ipx_frame_type == ipx_class.port[virtual_port_number].tx_frame_type)
			{
			return (virtual_port_number);
			}

		++virtual_port_number;
		}

	return (ILLEGAL_VIRTUAL_PORT_NUMBER);
}
/*************************************************************************/
static USHORT convert_ipx_virtual_to_real_port_number (USHORT virtual_port_number)
{
	return (ipx_class.port[virtual_port_number].real_port_number);
}
