#include	"defs.h"
/*	$Modname: ipxutil.c$  $version: 3.37$      $date: 10/20/95$   */
/*
* 	$lgb$
2.3 01/05/92 ross
2.4 01/21/92 ross changed send_packet parameters to handle FALSE-a bridge packet, and FALSE p
2.5 01/25/92 ross added logic to lock out receives when taking router down
2.6 01/25/92 ross changed send_periodics to reflect new BOOLEAN parameter to cause updates.
2.7 03/10/92 ross changed UNKNOWN_PACKET_TYPE to ROUTER type for periodic router information.
2.8 03/10/92 ross changed SAP info and router info messages to use PACKET_EXCHANGE_PACKET and ROUTER_PACKET packet types.
2.9 03/10/92 ross missed one the packet types, now all should be complete
2.10 06/22/92 ross move port_enabled = FALSE in shut down routine. Courtesy of DD.
2.11 08/05/92 ross
2.12 08/05/92 ross
2.13 08/09/92 ross added FRAME_RELAY_HEADER in header file and support for get_a_send_packet.
2.14 10/20/92 ross
2.15 11/02/92 ross made ipx_printf take 1 parameter
2.16 11/02/92 ross made most lines 132 columns now.
2.17 11/03/92 ross the amazing malloc bug catching version.
2.18 11/03/92 ross backed out bug catching version.
2.19 11/24/92 ross added token_ring_enabled parameter and modified send_ipx_packet
2.20 11/24/92 ross deleted token_ring_enabled parameter and unmodified send_ipx_packet.
2.21 11/24/92 ross
2.22 11/24/92 ross
2.23 12/05/92 ross general clean-up moved some globals in #ifdefs
2.24 12/06/92 ross implemented ipx class structure - no algorithm changes
2.25 12/06/92 ross adding functions to ipxsnmp.c, added static protos for ipx.c and ipxsap.c
2.26 12/26/92 ross
2.27 01/12/93 ross Added checks for too large hop counts in ipxrout and ipxnetbs and statistics, LLC proper SAPs, netbios broadcast fix soon
2.28 01/16/93 ross added SNAP_HEADER sizeof to get_a_send_packet.
2.29 01/17/93 ross fixed SNAP addition bug.
2.30 01/21/93 ross
3.0 01/21/93 ross files ipxrip.c and ipxsap.c split into *ls.c
3.1 01/22/93 ross renaming to ipxutil.c
3.2 01/23/93 ross added port_number to store_dlci
3.3 01/30/93 ross added ifdef ENABLE_IPX_FRAME_CONVERSION.  Temporary will be deleted.
3.4 01/30/93 ross delete references to ipx dlci
3.5 01/31/93 ross added support for netware lite routing
3.6 02/02/93 ross changed not_forwarded to forwarded in send_ipx_packet.
3.7 03/15/93 ross x86 version now works in real mode -just enough memory
3.8 03/22/93 ross changed name of IPX_MANAGEMENT_PARAMETERS to IPX_PORT_CLASS
3.9 04/06/93 ross moved LSL code into ipxsnap.c, no dependencies in LSL
3.10 04/12/93 ross made variable name change in vipxstr.h
3.11 04/13/93 ross added stats etc. for Novell's ipx mib v0.9
3.12 05/13/93 ross added stack parameter for tunnel software
3.13 05/19/93 ross added number_of_packets_forwarded variable, since number_of_packets_ot_route did not compensate for filtering.
3.14 05/21/93 ross made some more tunnel changes, corrected some printf bugs
3.15 05/24/93 ross fixed some problems will loops going down.
3.16 06/23/93 ross fixed a secondary SAP function
3.17 07/18/93 ross added IPX_PACKET_STATE to send_ipx_packet for disabled ports.  Courtesy of Yoram.
3.18 10/09/93 ross Added changes for ipxwan
3.19 10/30/93 ross moved STAND_ALONG to include queueing routines.
3.20 11/29/93 ross version 3.0 beta release
3.21 01/08/94 ross More lsl version 3 changes
3.22 01/31/94 ross added fptr_tx_completion call inside send ipx packet when a wan link is not up.  Courtesy of Rodney.
3.23 02/02/94 ross combined printfs in allocation error.
3.24 02/07/94 ross When a port is disabled, the fptr packet pointer is set correctly for llc and snap.
3.25 05/09/94 ross added field to wan class enable_ipx_wan_packets.
3.26 05/20/94 ross changed DLSX to DLSW.
3.27 06/15/94 ross had any funny byte at the end of the file.
3.28 08/08/94 ross finishing end station support.
3.29 08/25/94 ross added support for BYTE_ENUM and USHORT_ENUM
3.30 11/21/94 ross changed to compile under C++, added big sap and rip support.
3.31 11/23/94 ross Added remote access. Added auto-configuration.
3.32 01/13/95 ross remove list and swap functions.  Now in rwutils directory.
3.33 01/26/95 ross changes for rwutils
3.34 03/26/95 ross nlsp changes.
3.35 05/26/95 ross ipx wan printf renamed.
3.36 09/25/95 ross added changes for dynamic loading
3.37 10/20/95 nishit Changed copyright
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1989 - 1995 RouterWare, Inc.								   */
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Suite 212 Newport Beach, CA  92660  */
/************************************************************************/
#include	<string.h>
#include	<stdlib.h>
#include	<stdio.h>
#include	<stdarg.h>
#include	"ipx.h"
#ifdef IPX_FILTERING
#include "ipxfilt.h"
#endif
/****************************************************************************/
static void packet_allocation_error (USHORT port_number,ULONG size_of_packet);
static enum BOOLEAN send_packet_to_internal_network (USHORT *usptr_port_number,IPX_PACKET *sptr_tx_packet,
	USHORT number_of_bytes,void (*fptr_tx_completion) (USHORT port_number,IPX_PACKET *sptr_tx_packet));
/*************************************************************************/
IPX_PACKET *get_a_send_packet (USHORT port_number,ULONG size_of_packet)
{
	IPX_PACKET *sptr_return;
	USHORT size_of_extra_header;

	size_of_extra_header = get_size_of_frame_type_header (port_number);

	sptr_return = (IPX_PACKET *) buffer_malloc (size_of_packet + size_of_extra_header);

#ifdef DEBUG
	ipx_printf (MEMORY_PRINTF,"IPX: Pointer to send packet for port %04x, %p\r\n",port_number,sptr_return);
#endif

	if (sptr_return == NULL)
		{
		packet_allocation_error (port_number,size_of_packet);
		}
	else
		sptr_return = (IPX_PACKET *) ((ULONG) sptr_return + (ULONG) size_of_extra_header);

	return (sptr_return);
}
/*************************************************************************/
void free_a_send_packet (IPX_PACKET *sptr_tx_packet)
{
#ifdef DEBUG
	ipx_printf (MEMORY_PRINTF,"IPX: Free of %08lx\r\n",(ULONG) sptr_tx_packet);
#endif

#ifdef __BORLANDC__
	if (((ULONG) sptr_tx_packet) & 0x00000001)
		printf ("Free Error of %p\r\n",sptr_tx_packet);
#endif
	buffer_free (sptr_tx_packet);
}
/*************************************************************************/
static void packet_allocation_error (USHORT port_number,ULONG size_of_packet)
{
	++ipx_class.port[port_number].statistics.number_of_out_of_memory_send_calls;

	ipx_printf (ALARM_PRINTF,"IPX: Error Allocating Packet port number %04x size of %08lx\r\n",port_number,size_of_packet);

/*	This is a somewhat unusual case, since only small amounts of packets are ever transmitted.
   For our implementation we stuck a while (TRUE) which freezes the IPX router and allows us to do a post mortem analysis.
	#ifdef __LSL__
		printf (ALARM_PRINTF,"Error Allocating Packet size of %08x\r\n",size_of_packet);

		while (TRUE);
	#endif
*/
}
/*************************************************************************/
enum IPX_PACKET_STATE send_ipx_packet (USHORT port_number,IPX_PACKET *sptr_tx_packet,USHORT number_of_bytes,
	enum BOOLEAN forwarded_packet,void (*fptr_tx_completion) (USHORT port_number,IPX_PACKET *sptr_tx_packet))
{
	enum BOOLEAN internal_network_packet_forwarded;

	++ipx_class.port[port_number].statistics.number_of_packets_sent;

	if (port_number > ipx_class.number_of_ports)
		{
		ipx_printf (ALARM_PRINTF,"IPX: Illegal Port Number %04x\r\n",port_number);
/* Sanjays code */
#ifdef DEBUG
		ipx_class.ipxBasicSysEntry[0].ipxBasicSysOutDicards++;
#endif
/* Sanjays code */

		return (DATA_PACKET_WAS_RXED_AND_WAS_NOT_FORWARDED);
		}

#ifdef DEBUG
	display_ipx_packet (port_number,sptr_tx_packet,number_of_bytes,FALSE);
#endif

	if (port_number == (USHORT) (ipx_class.number_of_ports - ipx_class.remote_access_enabled))
		{
		internal_network_packet_forwarded = send_packet_to_internal_network (&port_number,sptr_tx_packet,number_of_bytes,
			fptr_tx_completion);

		if (internal_network_packet_forwarded == FALSE)
			{
/* Sanjays code */
			++ipx_class.ipxBasicSysEntry[0].ipxBasicSysOutDiscards;
/* Sanjays code */
			return (DATA_PACKET_WAS_RXED_AND_WAS_NOT_FORWARDED);
			}
		}

	number_of_bytes = (USHORT) (swap (sptr_tx_packet->ipx_header.length) + sizeof (UNION_MAC_HEADER));

#ifdef IPX_HEADER_TRANSLATION
	number_of_bytes += get_size_of_frame_type_header (port_number);
#endif

	if (ipx_class.port[port_number].port_enabled == TRUE)
		{
#ifdef IPX_WAN_ENABLED
		if (ipx_class.port[port_number].wan.enable_ipx_wan_packets == TRUE) 
			{
			if (ipx_class.port[port_number].wan.connection_state != LINK_UP &&
				(is_ipx_wan_packet ((UNION_IPX_WAN_PACKET *) sptr_tx_packet) == FALSE))
				{
				++ipx_class.port[port_number].wan.statistics.number_of_packets_to_send_discarded;

				if (fptr_tx_completion != NULL)
					{
					sptr_tx_packet = normalize_send_packet_header (port_number,sptr_tx_packet);

					(*fptr_tx_completion) (port_number,sptr_tx_packet);
					}

				return (DATA_PACKET_WAS_RXED_AND_WAS_NOT_FORWARDED);
				}
			}
#endif

#ifdef IPX_FILTERING
		if (ipx_tx_filter (port_number,sptr_tx_packet,number_of_bytes) == TRUE)
			{
			++ipx_class.port[port_number].statistics.number_of_tx_packets_filtered;
/* Sanjays code */
			++ipx_class.ipxAdvSysEntry[0].ipxAdvSysOutFiltered;
/* Sanjays code */
			return (DATA_PACKET_WAS_RXED_AND_WAS_NOT_FORWARDED);
			}
		else
			{

			}
#endif

#ifdef IPX_HEADER_TRANSLATION
		sptr_tx_packet = (IPX_PACKET *) convert_ipx_header_for_tx (&port_number,(FRAME *) sptr_tx_packet,&number_of_bytes);
#endif

		if (forwarded_packet == TRUE)
			{
			++ipx_class.port[port_number].statistics.number_packets_forwarded;
			/* Srikar, Mar 17, 1997. To update the equivalent ipx stack level variable */
			++ipx_class.ipxAdvSysEntry[0].ipxAdvSysForwPackets;
			}

		send_packet (ipx_class.stack_id,port_number,sptr_tx_packet,number_of_bytes,FALSE,
			forwarded_packet,(void (*) (USHORT port_number,void *)) fptr_tx_completion);

/* Sanjays code */
		ipx_class.ipxBasicSysEntry[0].ipxBasicSysOutPackets++;
/* Sanjays code */
		return (DATA_PACKET_WAS_RXED_AND_WAS_FORWARDED);
		}
	else
		{
		if (fptr_tx_completion != NULL)
			{
			sptr_tx_packet = normalize_send_packet_header (port_number,sptr_tx_packet);

			(*fptr_tx_completion) (port_number,sptr_tx_packet);
			}

		++ipx_class.port[port_number].statistics.number_of_packets_to_send_discarded;
/* Sanjays code */
		++ipx_class.ipxBasicSysEntry[0].ipxBasicSysOutDiscards;
/* Sanjays code */

		return (DATA_PACKET_WAS_RXED_AND_WAS_NOT_FORWARDED);
		}
}
/*************************************************************************/
static enum BOOLEAN send_packet_to_internal_network (USHORT *usptr_port_number,IPX_PACKET *sptr_tx_packet,
	USHORT number_of_bytes,void (*fptr_tx_completion) (USHORT port_number,IPX_PACKET *sptr_tx_packet))
{
	enum BOOLEAN remote_access_packet;

	remote_access_packet = FALSE;

	if (ipx_class.internal_SAP_id.ipx_address.network != 0x00000000L)
		{
#ifdef IPX_WAN_ENABLED
		remote_access_packet = get_remote_access_destination_port_number (usptr_port_number,sptr_tx_packet);

		if (remote_access_packet == FALSE)
			{
#endif
			if ((((ROUTE_INFORMATION *)sptr_tx_packet)->ipx_header.packet_type == SEQUENCED_PACKET_PROTOCOL) &&
				(ipx_class.transport.fptr_rx_routine != NULL))
				{
				(*ipx_class.transport.fptr_rx_routine) (sptr_tx_packet,number_of_bytes);
				}
			else if ((((ROUTE_INFORMATION *)sptr_tx_packet)->ipx_header.packet_type == NETWARE_CORE_PROTOCOL_TYPE) &&
				(ipx_class.transport.fptr_rx_routine != NULL))
				{
				(*ipx_class.ncp.fptr_rx_routine) (sptr_tx_packet,number_of_bytes);
				}
			else if (ipx_class.end_station.fptr_rx_routine != NULL)
				{
				(*ipx_class.end_station.fptr_rx_routine) (sptr_tx_packet,number_of_bytes);
				}


			if (fptr_tx_completion != NULL)
				{
				sptr_tx_packet = normalize_send_packet_header (*usptr_port_number,sptr_tx_packet);

				(*fptr_tx_completion) (*usptr_port_number,sptr_tx_packet);
				}

#ifdef IPX_WAN_ENABLED
			}
#endif
		++ipx_class.port[*usptr_port_number].statistics.ipx_mib.number_of_local_rx_packets;
		/* Srikar, Mar 17, 1997. To update the equivalent ipx stack level variable */
		++ipx_class.ipxBasicSysEntry[0].ipxBasicSysInDelivers;
		}
	else
		{
		ipx_printf (ALARM_PRINTF,"IPX: Illegal Port Number %04x\r\n",*usptr_port_number);
		}

	return (remote_access_packet);
}
/*************************************************************************/
IPX_PACKET *normalize_send_packet_header (USHORT port_number,IPX_PACKET *sptr_ipx_packet)
{
	sptr_ipx_packet =	(IPX_PACKET *) ((ULONG) sptr_ipx_packet - (ULONG) get_size_of_frame_type_header (port_number));

	return (sptr_ipx_packet);
}
/*************************************************************************/
void send_completion_ipx_packet (USHORT port_number,IPX_PACKET *sptr_tx_packet)
{
	++ipx_class.port[port_number].statistics.number_of_send_completions;

	free_a_send_packet (sptr_tx_packet);
}
/*************************************************************************/
void clear_all_counters (void)
{
	USHORT port_number_index;

	for (port_number_index = 0x0000; port_number_index < ipx_class.number_of_ports; ++port_number_index)
		{
		memset (&ipx_class.port[port_number_index].statistics,(int) NULL,sizeof (IPX_STATISTICS));
		}
}
/*************************************************************************/
void set_ipx_gap_time_counter (BYTE gap_time_counter)
{
	ipx_class.gap_time_limit =	gap_time_counter;
}
/*************************************************************************/
void set_ipx_internal_SAP_id (SAP_ID *sptr_SAP_id)
{
	ipx_class.internal_SAP_id = *sptr_SAP_id;
}
/*************************************************************************/
SAP_ID *get_ipx_internal_SAP_id (void)
{
	return (&ipx_class.internal_SAP_id);
}
/*************************************************************************/
void enable_or_disable_ipx_printing (enum BOOLEAN enable_or_disable)
{
	ipx_class.ipx_printing_enabled = (BYTE_ENUM (BOOLEAN)) enable_or_disable;
}
/*************************************************************************/
void enable_or_disable_ipx_group_printing (enum BOOLEAN enable_or_disable,enum PRINTF_GROUPS printf_group)
{
	switch (printf_group)
		{
		case SAP_PRINTF:
			ipx_class.SAP_printing_enabled = (BYTE_ENUM (BOOLEAN)) enable_or_disable;
			break;
		case RIP_PRINTF:
			ipx_class.RIP_printing_enabled = (BYTE_ENUM (BOOLEAN)) enable_or_disable;
			break;
		case MEMORY_PRINTF:
			ipx_class.memory_printing_enabled = (BYTE_ENUM (BOOLEAN)) enable_or_disable;
			break;
		case ALARM_PRINTF:
			ipx_class.alarm_printing_enabled = (BYTE_ENUM (BOOLEAN)) enable_or_disable;
			break;
		case SNAP_PRINTF:
			ipx_class.snap_printing_enabled = (BYTE_ENUM (BOOLEAN)) enable_or_disable;
			break;
		case SNMP_PRINTF:
			ipx_class.snmp_printing_enabled = (BYTE_ENUM (BOOLEAN)) enable_or_disable;
			break;
		case DATA_PRINTF:
			ipx_class.data_printing_enabled = (BYTE_ENUM (BOOLEAN)) enable_or_disable;
			break;
		case IPX_WAN_TIMER_PRINTF:
			ipx_class.ipx_wan_timer_printing_enabled = (BYTE_ENUM (BOOLEAN)) enable_or_disable;
			break;
		case IPX_WAN_INFORMATION_PRINTF:
			ipx_class.ipx_wan_rip_sap_printing_enabled = (BYTE_ENUM (BOOLEAN)) enable_or_disable;
			break;
		case ECHO_PRINTF:
			ipx_class.echo_printing_enabled = (BYTE_ENUM (BOOLEAN)) enable_or_disable;
			break;
		case NETBIOS_PRINTF:
			ipx_class.netbios_printing_enabled = (BYTE_ENUM (BOOLEAN)) enable_or_disable;
			break;
		case NETWARE_LITE_PRINTF:
			ipx_class.netware_lite_printing_enabled = (BYTE_ENUM (BOOLEAN)) enable_or_disable;
			break;
		case WATCHDOG_PRINTF:
			ipx_class.watchdog_printing_enabled = (BYTE_ENUM (BOOLEAN)) enable_or_disable;
			break;
		case DIAGNOSTIC_PRINTF:
			ipx_class.diagnostic_printing_enabled = (BYTE_ENUM (BOOLEAN)) enable_or_disable;
			break;
		case SERIALIZATION_PRINTF:
			ipx_class.serialization_printing_enabled = (BYTE_ENUM (BOOLEAN)) enable_or_disable;
			break;
		}
}
/*************************************************************************/
void ipx_printf (enum PRINTF_GROUPS printf_group,const char *cptr_format, ...)
{
	enum BOOLEAN print_string;

	va_list argptr;

	va_start (argptr,cptr_format);

	if (ipx_class.ipx_printing_enabled == FALSE)
		{
		va_end (argptr);

		return;
		}

	print_string = FALSE;

	switch (printf_group)
		{
		case SAP_PRINTF:
			print_string = ipx_class.SAP_printing_enabled;
			break;
		case RIP_PRINTF:
			print_string = ipx_class.RIP_printing_enabled;
			break;
		case MEMORY_PRINTF:
			print_string = ipx_class.memory_printing_enabled;
			break;
		case ALARM_PRINTF:
			print_string = ipx_class.alarm_printing_enabled;
			break;
		case SNAP_PRINTF:
			print_string = ipx_class.snap_printing_enabled;
			break;
		case SNMP_PRINTF:
			print_string = ipx_class.snmp_printing_enabled;
			break;
		case DATA_PRINTF:
			print_string = ipx_class.data_printing_enabled;
			break;
		case IPX_WAN_TIMER_PRINTF:
			print_string = ipx_class.ipx_wan_timer_printing_enabled;
			break;
		case IPX_WAN_INFORMATION_PRINTF:
			print_string = ipx_class.ipx_wan_rip_sap_printing_enabled;
			break;
		case ECHO_PRINTF:
			print_string = ipx_class.echo_printing_enabled;
			break;
		case NETBIOS_PRINTF:
			print_string = ipx_class.netbios_printing_enabled;
			break;
		case NETWARE_LITE_PRINTF:
			print_string = ipx_class.netware_lite_printing_enabled;
			break;
		case WATCHDOG_PRINTF:
			print_string = ipx_class.watchdog_printing_enabled;
			break;
		case DIAGNOSTIC_PRINTF:
			print_string = ipx_class.diagnostic_printing_enabled;
			break;
		case SERIALIZATION_PRINTF:
			print_string = ipx_class.serialization_printing_enabled;
			break;
#ifdef IPX_FILTERING
      case IPX_FILTER_PRINTF:
         print_string = ipx_class.ipx_filter_printing_enabled ;
         break ;
#endif
		}

	if (print_string == TRUE)
		{
		vprintf (cptr_format,argptr);
		}

	va_end (argptr);
}
