#include	"defs.h"
/*	$Modname: ipxwatch.c$  $version: 1.13$      $date: 10/20/95$   */
/*
* 	$lgb$
1.0 05/01/93 ross
1.1 05/07/93 ross fix courtesy of KM.
1.2 05/13/93 ross added stack parameter for tunnel software
1.3 05/13/93 ross changed port_number to outgoing_port_number.
1.4 05/14/93 ross added ethernet dest/source address.
1.5 07/18/93 ross added IPX_PACKET_STATE to send_ipx_packet for disabled ports.  Courtesy of Yoram.
1.6 03/14/94 ross cleaned up braces and white spaces for release.
1.7 11/21/94 ross changed to compile under C++, added big sap and rip support.
1.8 11/23/94 ross Added remote access. Added auto-configuration.
1.10 12/12/94 ross check for outgoing port being enabled in ras case.  Courtesy of Danny.
1.11 01/26/95 ross changes in check for packet.  Courtesy of Danny.
1.12 09/25/95 ross added changes for dynamic loading
1.13 10/20/95 nishit Changed copyright
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1989 - 1995 RouterWare, Inc.								   */
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Suite 212 Newport Beach, CA  92660  */
/************************************************************************/
#include	<stdlib.h>
#include	"ipx.h"
/****************************************************************************/
static WATCHDOG_CONNECTION *find_packet_in_watchdog_connection_list (USHORT port_number,
	NETWARE_CORE_PROTOCOL_PACKET *sptr_ncp_rx_packet);
/****************************************************************************/
enum IPX_PACKET_STATE watchdog_packet_received (USHORT port_number,WATCHDOG_PACKET *sptr_watchdog_rx_packet,
	USHORT size_of_packet)
{
	enum IPX_PACKET_STATE return_code;
	IPX_ADDRESS ipx_address;
	USHORT	outgoing_port_number;
	ETHERNET_ADDRESS	*sptr_hop_routers_ethernet_address;

	if ((ipx_class.port[port_number].enable_watchdog_spoofing == FALSE) ||
		(ipx_class.port[port_number].port_enabled == FALSE))
		{
		return (WATCHDOG_DISABLED);
		}

	if (sptr_watchdog_rx_packet->request_or_response == WATCHDOG_REQUEST)
		{
		sptr_watchdog_rx_packet->request_or_response = WATCHDOG_REPLY;

		++ipx_class.port[port_number].statistics.number_of_watchdog_request_packets_received;

		ipx_address = sptr_watchdog_rx_packet->ipx_header.destination;

		sptr_watchdog_rx_packet->ipx_header.destination = sptr_watchdog_rx_packet->ipx_header.source;

		sptr_watchdog_rx_packet->ipx_header.source = ipx_address;

		sptr_hop_routers_ethernet_address = get_next_hop_router_address (sptr_watchdog_rx_packet->ipx_header.destination.network,
			&outgoing_port_number);

		if (sptr_hop_routers_ethernet_address == ON_OTHER_PORTS_NETWORK)
			{
			sptr_watchdog_rx_packet->ethernet_header.destination_address =
				sptr_watchdog_rx_packet->ipx_header.destination.node_address;
			}
		else
			{
			sptr_watchdog_rx_packet->ethernet_header.destination_address = *sptr_hop_routers_ethernet_address;
			}

		sptr_watchdog_rx_packet->ethernet_header.source_address = ipx_class.port[outgoing_port_number].ethernet_address;

		if (sptr_hop_routers_ethernet_address != CANT_FIND_NETWORK)
			{
			return_code = send_ipx_packet (outgoing_port_number,(IPX_PACKET *) sptr_watchdog_rx_packet,size_of_packet,TRUE,NULL);

			return (return_code);
			}
		else
			{
			return (DATA_PACKET_WAS_RXED_AND_WAS_NOT_FORWARDED);
			}
		}
	else if (sptr_watchdog_rx_packet->request_or_response == WATCHDOG_REPLY)
		{
		++ipx_class.port[port_number].statistics.number_of_watchdog_response_packets_received;

		return_code = DATA_PACKET_WAS_RXED_AND_WAS_NOT_FORWARDED;
		}
	else
		{
		return_code = WATCHDOG_PACKET_NOT_RECOGNIZED;
		}

	return (return_code);
}
/****************************************************************************/
void issue_periodic_client_watchdog (USHORT port_number)
{
	WATCHDOG_CONNECTION *sptr_connection;

	for (sptr_connection = (WATCHDOG_CONNECTION *)
		get_pointer_to_first_entry_in_list ((LINK *) &ipx_class.port[port_number].watchdog_connection_list);
		sptr_connection != NULL; sptr_connection = get_pointer_to_next_entry_in_list ((LINK *) &sptr_connection->links))
		{
		if (++sptr_connection->current_watchdog_time > ipx_class.port[port_number].watchdog_holding_time)
			{
			if (sptr_connection->server_side == FALSE)
				{
				sptr_connection->current_watchdog_time = 0x00000000L;

			  /* 	send_watchdog_request_to_client (port_number); */
				}
			else
				{
				/* send_watchdog_reply_to_router_with_server (port_number); */
				}
			}
		}
}
/****************************************************************************/
void add_packet_to_watchdog_connection_list (USHORT port_number,NETWARE_CORE_PROTOCOL_PACKET *sptr_ncp_rx_packet,
	enum BOOLEAN server)
{
	WATCHDOG_CONNECTION *sptr_connection;

	sptr_connection = find_packet_in_watchdog_connection_list (port_number,sptr_ncp_rx_packet);

	if (sptr_connection == NULL)
		{
		sptr_connection = table_malloc (sizeof (WATCHDOG_CONNECTION),1);

		if (sptr_connection == NULL)
			{
			sptr_connection->current_watchdog_time = 0x00000000L;

			if (server == TRUE)
				{
				sptr_connection->server_mac_address = *((MAC_ADDRESS *) &sptr_ncp_rx_packet->ethernet_header.source_address);
				sptr_connection->client_mac_address = *((MAC_ADDRESS *) &sptr_ncp_rx_packet->ethernet_header.destination_address);
				}
			else
				{
				sptr_connection->server_mac_address = *((MAC_ADDRESS *) &sptr_ncp_rx_packet->ethernet_header.destination_address);
				sptr_connection->client_mac_address = *((MAC_ADDRESS *) &sptr_ncp_rx_packet->ethernet_header.source_address);
				}

			sptr_connection->connection_number = sptr_ncp_rx_packet->connection_number;
			sptr_connection->server_side = (BYTE_ENUM (BOOLEAN)) server;
			}
		}
	else
		{
		sptr_connection->current_watchdog_time = 0x00000000L;
		}
}
/****************************************************************************/
void delete_packet_to_watchdog_connection_list (USHORT port_number,WATCHDOG_PACKET *sptr_watchdog_rx_packet)
{
	PARAMETER_NOT_USED (port_number);
	PARAMETER_NOT_USED (sptr_watchdog_rx_packet);

}
/****************************************************************************/
static WATCHDOG_CONNECTION *find_packet_in_watchdog_connection_list (USHORT port_number,
	NETWARE_CORE_PROTOCOL_PACKET *sptr_ncp_rx_packet)
{
	PARAMETER_NOT_USED (port_number);
	PARAMETER_NOT_USED (sptr_ncp_rx_packet);

	return (NULL);
}
/****************************************************************************/
void ipx_ncp_packet_received (USHORT port_number,NETWARE_CORE_PROTOCOL_PACKET *sptr_ncp_rx_packet)
{
	switch (sptr_ncp_rx_packet->request_type)
		{
		case NCP_CREATE_SERVICE_CONNECTION:
			break;
		case NCP_SERVICE_REQUEST:
			add_packet_to_watchdog_connection_list (port_number,sptr_ncp_rx_packet,FALSE);
			break;
		case NCP_DESTROY_SERVICE_CONNECTION:
			add_packet_to_watchdog_connection_list (port_number,sptr_ncp_rx_packet,FALSE);
			break;
		case NCP_BURST_MODE_TRANSFER:
			add_packet_to_watchdog_connection_list (port_number,sptr_ncp_rx_packet,FALSE);
			break;
		}
}
