/*	$Modname: kipx.h$  $version: 3.37$      $date: 10/25/95$   */
/*
* 	$lgb$
2.3 01/05/92 ross
2.4 01/21/92 ross new version control
2.5 01/25/92 ross added PACKET_RX_STATE for better compatibility with Router Engines WAN code.
2.6 01/26/92 ross
2.7 08/05/92 ross
2.8 08/09/92 ross added PROTOCOL_PORT_NUMBER_MASKS.
2.9 08/13/92 ross changed PROTOCOL_PORT_NUMBER_MASKS moved ip ->>&bssvc.tmp
2.10 10/20/92 ross
2.11 11/24/92 ross
2.12 11/24/92 ross
2.13 12/05/92 ross general clean-up moved some globals in #ifdefs
2.14 12/06/92 ross adding functions to ipxsnmp.c, added static protos for ipx.c and ipxsap.c
2.15 12/26/92 ross
2.16 01/12/93 ross Added checks for too large hop counts in ipxrout and ipxnetbs and statistics, LLC proper SAPs, netbios broadcast fix soon
2.17 01/14/93 ross added wan BOOLEAN for better wan control, upcoming IPXWAN support
3.0 01/17/93 ross fixed SNAP addition bug.
3.1 01/22/93 ross changed ECHO_TYPES to proper size.
3.2 01/22/93 ross took out a , in the enum ECHO_TYPES.
3.3 01/25/93 ross added __GNU__ check for GNU 2.0.1 compiler bug.
3.4 01/29/93 ross changed GNU to GNUC.
3.5 01/31/93 ross renamed RAW_ETHERNET_TYPE to ETHERNET_TYPE
3.6 01/31/93 ross added support for netware lite routing
3.7 02/02/93 ross changed encapsulation packet type
3.8 02/03/93 ross added more ipx states.
3.9 02/12/93 ross added USER_DEFINED_NUMBER_OF_IPX_PORTS.
3.10 03/08/93 ross added pacing logic to sap,sapls,rip,ripls, and ipxtimer
3.11 03/15/93 ross x86 version now works in real mode -just enough memory
3.12 03/30/93 ross added netbios name caching.
3.13 04/06/93 ross moved LSL code into ipxsnap.c, no dependencies in LSL
3.14 04/12/93 ross ipxwan addition/deletions.
3.15 05/13/93 ross added stack parameter for tunnel software
3.16 05/14/93 ross took out the __GNUC__ ifdef - v2.2 of gnu fixes their bug.
3.17 05/15/93 ross added more printf booleans.
3.18 07/18/93 ross changed constants to return PACKET_RECOGNIZED_BUT_NOT_FORWARDED instead of PACKET_NOT_RECOGNIZED.
3.19 12/10/93 ross big endian prototype problem.  Courtesy of Rick.
3.20 12/14/93 ross another big endian sizing problem.  Courtesy of Rick.
3.21 01/08/94 ross More lsl version 3 changes
3.22 01/25/94 ross renamed TUNNEL to DLSX.
3.23 02/02/94 ross added parenthesis around swap functions.  Courtesy of Rodney.
3.24 03/09/94 ross removing the wan_port dependency on rip and sap aging.
3.25 03/11/94 ross changed router ids to route entries
3.26 03/14/94 ross cleaned up braces and white spaces for release.
3.27 05/20/94 ross renamed dlsx to dlsw.
3.28 05/20/94 ross added better support for disabled port, and added add rip/sap function pointers.  Courtest of Fred and Don.
3.29 06/08/94 ross first version support for ipx and rip sap mibs. Ugh.
3.30 11/23/94 ross Added remote access. Added auto-configuration.
3.31 01/26/95 ross added watchdog return code.  Courtesy of Danny.
3.32 03/26/95 ross nlsp changes.
3.33 04/18/95 ross changed NSLP to NLSP.
3.34 05/26/95 ross ipxwan constant renamed.
3.35 10/20/95 ross changes for NLSP RIP-SAP compatibility
3.36 10/20/95 nishit Changed copyright
3.37 10/25/95 nishit Modified #define DEFAULT_ROUTE_NETWORK_NUMBER
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1989 - 1995 RouterWare, Inc.								   */
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Suite 212 Newport Beach, CA  92660  */
/************************************************************************/
/************************************************************************/
#ifndef _KIPX_H_
#define _KIPX_H_

#define	SIZE_OF_TOKEN_RING_AC_FC_FIELDS 2
#define MAXIMUM_8023_LENGTH 1500

#ifdef BIG_ENDIAN
	#define	BIG_ENDIAN_CONSTANT(ushort) ushort
	#define	swap(a) (a)
	#define	swap_long(a) (a)
#else
	#define	BIG_ENDIAN_CONSTANT(ushort) (((0x00ff & ushort) << 8) | (ushort >> 8))
#endif

#ifndef RX_PACKET_STATE_DEFINED

	#define RX_PACKET_STATE_DEFINED

	enum	RX_PACKET_STATE
	{
		PACKET_NOT_RECOGNIZED,
		PACKET_RECOGNIZED_BUT_NOT_FORWARDED,
		PACKET_RECOGNIZED_AND_FORWARDED
	};

#endif

#define	MAXIMUM_NUMBER_OF_NETBIOS_LANS	8
#ifndef __BORLANDC__
	#define	MAXIMUM_NUMBER_OF_NETWARE_LANS	2100
	/* #define	MAXIMUM_NUMBER_OF_NETWARE_LANS	256 */
#else
	#define	MAXIMUM_NUMBER_OF_NETWARE_LANS	256
#endif
#define	MAXIMUM_NUMBER_OF_ROUTE_ENTRIES_PER_PACKET	50
#define	MAXIMUM_NUMBER_OF_SAP_IDS_PER_PACKET	7

#define	NETWARE_BLUE_BOOK_ETHERNET_TYPE	BIG_ENDIAN_CONSTANT (0x8137)

#define	PERIODIC_BROADCAST_TIME 60 /* in seconds */
#define	LIST_ENTRY_AGEING_TIME 180 /* in seconds */
#define	SERVER_OR_ROUTER_DOWN_HOP_COUNT	BIG_ENDIAN_CONSTANT (0x0010)
#define 	DEFAULT_ROUTE_NETWORK_NUMBER 0xfffffffeL

#define	MAXIMUM_HOP_COUNT	0x10

/* sockets */

enum NETWARE_SOCKETS
{
	NETWARE_CORE_PROTOCOL_SOCKET = BIG_ENDIAN_CONSTANT (0x0451),
	SAP_SOCKET = BIG_ENDIAN_CONSTANT (0x0452),
	ROUTING_SOCKET = BIG_ENDIAN_CONSTANT (0x0453),
	NETBIOS_SOCKET = BIG_ENDIAN_CONSTANT (0x0455),
	DIAGNOSTICS_SOCKET = BIG_ENDIAN_CONSTANT (0x0456),
	NETWARE_SERIALIZATION_SOCKET = BIG_ENDIAN_CONSTANT (0x0457),
	FILE_SERVER_COMMUNICATION_3_SOCKET = BIG_ENDIAN_CONSTANT (0x4003),
	FILE_SERVER_COMMUNICATION_4_SOCKET = BIG_ENDIAN_CONSTANT (0x4004),
	FILE_SERVER_COMMUNICATION_5_SOCKET = BIG_ENDIAN_CONSTANT (0x4005),
	FILE_SERVER_COMMUNICATION_6_SOCKET = BIG_ENDIAN_CONSTANT (0x4006),
	FILE_SERVER_COMMUNICATION_7_SOCKET = BIG_ENDIAN_CONSTANT (0x4007),
	NLSP_IPX_SOCKET = BIG_ENDIAN_CONSTANT (0x9001),
	IPX_WAN_SOCKET = BIG_ENDIAN_CONSTANT (0x9004),
	IPX_DLSW_SOCKET = BIG_ENDIAN_CONSTANT (0xa004),
	IPX_DLSW_BROADCAST_SOCKET = BIG_ENDIAN_CONSTANT (0xa005)
};

/* various constants */

#define	AUTO_ID_BROADCAST	   BIG_ENDIAN_CONSTANT (0x0002)
#define	SERVER_SHUTDOWN	   16
#define	IPX_REQUEST_ROUTER_SOCKET		BIG_ENDIAN_CONSTANT (0x8000)

enum	QUERY_TYPE
{
	GENERAL_SERVICE_QUERY =	BIG_ENDIAN_CONSTANT (0x0001),
	NEAREST_SERVICE_QUERY = BIG_ENDIAN_CONSTANT (0x0003),

	_IPX_ENUM_USHORT_FILLER_ = 0x1000
}; 

enum RESPONSE_TYPE
{
	GENERAL_SERVICE_RESPONSE = BIG_ENDIAN_CONSTANT (0x0002),
	NEAREST_SERVICE_RESPONSE = BIG_ENDIAN_CONSTANT (0x0004),

	_IPX_ENUM_USHORT_FILLER__ = 0x1000
}; 

enum ECHO_TYPES
{
	ECHO_REQUEST = BIG_ENDIAN_CONSTANT (0x0001),
	ECHO_REPLY = BIG_ENDIAN_CONSTANT (0x0002),

	_IPX_ENUM_USHORT_FILLER___ = 0x1000
};

/* router lan addresses */

#define	ALL_ROUTERS	0xffffffffL

enum	LIST_ENTRY_TYPE
{
	MATCHING_ENTRY_FOUND_NO_UPDATE, 
	MATCHING_ENTRY_FOUND_UPDATE, 
	MATCHING_ENTRY_NOT_FOUND
};

enum	NLSP_VALID_ENTRY_RETURN_TYPE
{
	FROM_NLSP_ROUTER, 
	VALID_ENTRY_ON_NON_DESIGNATED_ROUTER,
	NLSP_ROUTE_EXISTS_TO_THIS_NETWORK,
	VALID_ENTRY_ON_DESIGNATED_ROUTER
};

enum ROUTE_PACKET_TYPE
{
	ROUTE_REQUEST_INFORMATION = BIG_ENDIAN_CONSTANT (0x0001),
	ROUTE_INFO = BIG_ENDIAN_CONSTANT (0x0002),

	__ENUM_USHORT_FILLER____ = 0x1000
};

enum IPX_PACKET_TYPES
{
	UNKNOWN_PACKET_TYPE			= 0x00,
	ROUTER_PACKET_TYPE			= 0x01,
	ECHO_PACKET_TYPE				= 0x02,
	ERROR_PACKET_TYPE				= 0x03,
	PACKET_EXCHANGE_PACKET		= 0x04,
	SEQUENCED_PACKET_PROTOCOL	= 0x05,
	NETWARE_CORE_PROTOCOL_TYPE	= 0x11,
	NETBIOS_NAME_PACKET			= 0x14,
	NETWARE_LITE_PACKET			= 0x19,
	NETWARE_LITE_ACK_PACKET		= 0x1a,
	NLSP_EXPERIMENTAL_PACKET	= 0x37
}; 

enum	SPX_CONNECTION_CONTROL_MASK
{
	SYSTEM_PACKET = 0x8000,SEND_ACKNOWLEDGEMENT = 0x4000, ATTENTION = 0x2000, END_OF_MESSAGE = 0x1000
};

enum SAP_PACKET_TYPE
{
	USER = BIG_ENDIAN_CONSTANT (0x0001),
	USER_GROUP = BIG_ENDIAN_CONSTANT (0x0002),
	PRINT_LIST = BIG_ENDIAN_CONSTANT (0x0003),
	NOVELL_FILE_SERVER = BIG_ENDIAN_CONSTANT (0x0004),
	JOB_SERVER = BIG_ENDIAN_CONSTANT (0x0005),
	GATEWAY_1 = BIG_ENDIAN_CONSTANT (0x0006),
	PRINT_SERVER = BIG_ENDIAN_CONSTANT (0x0007),
	ARCHIVE_LIST = BIG_ENDIAN_CONSTANT (0x0008),
	ARCHIVE_SERVER = BIG_ENDIAN_CONSTANT (0x0009),
	JOB_LIST = BIG_ENDIAN_CONSTANT (0x000a),
	ADMINISTRATION = BIG_ENDIAN_CONSTANT (0x000b),

	NAS_SNA_GATEWAY = BIG_ENDIAN_CONSTANT (0x0021),
	NACS = BIG_ENDIAN_CONSTANT (0x0023),
	REMOTE_BRIDGE_SERVER = BIG_ENDIAN_CONSTANT (0x0024),
	BRIDGE_SERVER = BIG_ENDIAN_CONSTANT (0x0026),
	TCP_IP_GATEWAY = BIG_ENDIAN_CONSTANT (0x0027),
	GATEWAY_2 = BIG_ENDIAN_CONSTANT (0x0029),
	TIME_SYNCHRONIZATION_SERVER = BIG_ENDIAN_CONSTANT (0x002d),
	ARCHIVE_SERVER_SAP= BIG_ENDIAN_CONSTANT (0x002e),

	ADVERTISING_PRINT_SERVER = BIG_ENDIAN_CONSTANT (0x0047),
	BTRIEVE_VAP_50 = BIG_ENDIAN_CONSTANT (0x004b),
	SQL_VAP = BIG_ENDIAN_CONSTANT (0x004c),
	XTREE_NETWORK_VERSION = BIG_ENDIAN_CONSTANT (0x004d),

	BTRIEVE_VAP_411 = BIG_ENDIAN_CONSTANT (0x0050),
	PRINT_LIST_USER = BIG_ENDIAN_CONSTANT (0x0053),

	WANCOPY_UTILITY = BIG_ENDIAN_CONSTANT (0x0072),
	TES_NETWARE_FOR_VMS = BIG_ENDIAN_CONSTANT (0x007a),

	NETWARE_ACCESS_SERVER = BIG_ENDIAN_CONSTANT (0x0098),
	PORLIST_NETWARE = BIG_ENDIAN_CONSTANT (0x009e),

	NETWARE_386 = BIG_ENDIAN_CONSTANT (0x0107),

	COMMUNICATION_EXECUTIVE = BIG_ENDIAN_CONSTANT (0x0130),
	NSS_DOMAIN = BIG_ENDIAN_CONSTANT (0x0133),
	NETWARE_386_PRINT_LIST = BIG_ENDIAN_CONSTANT (0x0137)
};

#define ALL_SERVER_TYPES  BIG_ENDIAN_CONSTANT (0xffff)

enum	SPX_DATASTREAM_TYPE
{
	END_OF_CONNECTION = 0xfe, END_OF_CONNECTION_ACKNOWLEDGEMENT = 0xff
};

#define	ON_OTHER_PORTS_NETWORK (ETHERNET_ADDRESS *)1
#define	CANT_FIND_NETWORK (ETHERNET_ADDRESS *)0


enum IPX_PACKET_STATE
{
	/* non or unknown ipx packet rx states */

	NON_IPX_PACKET = 0x0000,
	NON_IPX_PACKET_SAP = 0x0001,
	NON_IPX_PACKET_RIP = 0x0002,

	UNKNOWN_GENERAL_ROUTE_QUERY_RXED = 0x1003,
	UNKNOWN_NEAREST_ROUTE_QUERY_RXED = 0x1004,
	UNKNOWN_GENERAL_ROUTE_RESPONSE_RXED = 0x1005,
	UNKNOWN_NEAREST_ROUTE_RESPONSE_RXED = 0x1006,

	UNKNOWN_GENERAL_SAP_QUERY_RXED = 0x1007,
	UNKNOWN_NEAREST_SAP_QUERY_RXED = 0x1008,
	UNKNOWN_SAP_GENERAL_RESPONSE_RXED = 0x1009,
	UNKNOWN_SAP_NEAREST_RESPONSE_RXED = 0x100a,

	DATA_PACKET_WAS_RXED_AND_WAS_NOT_FORWARDED = 0x100b,

	UNKNOWN_NETBIOS_PACKET_RECEIVED = 0x100c,
	ILLEGAL_PACKET_SIZE = 0x100d,

	/* ipx packet rx states */

	DATA_PACKET_WAS_RXED_AND_WAS_FORWARDED = 0x2000,
	SAP_PACKET_WAS_RXED = 0x2001,
	RIP_PACKET_WAS_RXED = 0x2002,
	BROADCAST_PACKET_WAS_RXED = 0x2003,

	GENERAL_ROUTE_REQUEST_RXED_NO_KNOWN_ROUTES = 0x3000,
	GENERAL_ROUTE_REQUEST_RXED = 0x3001,
	NEAREST_ROUTE_REQUEST_RXED_NO_KNOWN_ROUTES = 0x3002,
	NEAREST_ROUTE_REQUEST_RXED = 0x3003,
	GENERAL_ROUTE_INFORMATION = 0x3004,
	GENERAL_ROUTE_INFORMATION_QUERY = 0x3005,
	GENERAL_ROUTE_REQUEST_RXED_WITH_RIP_COMPATIBILITY_OFF = 0x3006,
	
	GENERAL_RIP_RXED_UPATE = 0x4000,
	GENERAL_RIP_RXED = 0x4001,
	NEAREST_RIP_RXED_UPATE = 0x4002,
	NEAREST_RIP_RXED = 0x4003,
	GENERL_RIP_RXED_FROM_NLSP_ROUTER = 0x4004,
	GENERAL_RIP_RXED_WITH_RIP_COMPATIBILITY_OFF = 0x4005,

	GENERAL_SAP_REQUEST_RXED_NO_KNOWN_SAPS = 0x5000,
	GENERAL_SAP_REQUEST_RXED = 0x5001,
	NEAREST_SAP_REQUEST_RXED_NO_KNOWN_SAPS = 0x5002,
	NEAREST_SAP_REQUEST_RXED = 0x5003,
	GENERAL_SAP_INFORMATION = 0x5004,
	GENERAL_SAP_INFORMATION_QUERY = 0x5005,
	
	GENERAL_SAP_RXED_UPATE = 0x6000,
	GENERAL_SAP_RXED = 0x6001,
	NEAREST_SAP_RXED_UPATE = 0x6002,
	NEAREST_SAP_RXED = 0x6003,

	NETBIOS_PACKET_RXED_MAX_LANS = 0x7000,
	NETBIOS_UNKNOWN_PACKET_RXED = 0x7001,
	NETBIOS_PACKET_RXED = 0x7002,
	NETBIOS_PACKET_RXED_LOCAL = 0x7003,

	PORT_DISABLED = 0x8000,
	NETBIOS_DISABLED = 0x8001,
	RIP_BROADCASTS_DISABLED = 0x8002,
	RIP_PERIODIC_BROADCASTS_DISABLED = 0x8003,
	SAP_BROADCASTS_DISABLED = 0x8004,
	SAP_PERIODIC_BROADCASTS_DISABLED = 0x8005,

	RIP_PACKET_RXED_WITH_WRONG_NETWORK_ADDRESS_FOR_PORT = 0x9000,
	SAP_PACKET_RXED_WITH_WRONG_NETWORK_ADDRESS_FOR_PORT = 0x9001,
	WS_PACKET_RXED_WITH_WRONG_NETWORK_ADDRESS_FOR_PORT = 0x9002,
	LOCAL_PACKET_RXED_WITH_WRONG_NETWORK_ADDRESS_FOR_PORT = 0x9003,
	OUT_OF_ROUTE_LIST_ENTRIES = 0x9004,
	OUT_OF_SAP_LIST_ENTRIES = 0x9005,
	OUT_OF_TX_PACKET_MEMORY = 0x9006,
	TRYING_TO_ADD_DUPLICATE_ROUTE = 0x9007,

	NETWARE_LITE_DISABLED = 0xa000,
	NETWARE_LITE_PACKET_RXED = 0xa001,
	ILLEGAL_NETWARE_LITE_PACKET_RXED = 0xa002,

	DLSW_PACKETS_DISABLED = 0xb000,
	DLSW_PACKET_RXED = 0xb001,
	ILLEGAL_DLSW_PACKET_RXED = 0xb002,

	IPX_WAN_DISABLED = 0xc000,
	IPX_WAN_PACKET_RECEIVED = 0xc001,
	IPX_WAN_TIMER_REQUEST = 0xc002,
	WAN_PACKET_RXED_WITH_ILLEGAL_ID_STRING = 0xc003,
	WAN_PACKET_RXED_WITH_SAME_NETWORK_ADDRESS_FOR_PORT = 0xc004,
	IPX_WAN_TIMER_RESPONSE = 0xc005,
	IPX_WAN_TIMER_RESPONSE_RECEIVED = 0xc006,
	IPX_WAN_INFORMATION_REQUEST = 0xc007,
	IPX_WAN_INFORMATION_RESPONSE = 0xc008,
	IPX_WAN_THROUGHPUT_REQUEST = 0xc009,
	IPX_WAN_THROUGHPUT_RESPONSE = 0xc00a,
	IPX_WAN_DELAY_REQUEST = 0xc00b,
	IPX_WAN_DELAY_RESPONSE = 0xc00c,

	ILLEGAL_IPX_WAN_PACKET_RECEIVED = 0xc00f,

	WATCHDOG_DISABLED = 0xd000,

	SERIALIZATION_SPOOFING_DISABLED = 0xe000,

	WATCHDOG_PACKET_NOT_RECOGNIZED = 0xe001,

	DIAGNOSTIC_PACKET_RECEIVED = 0xf000
};

enum NLSP_RIP_COMPATIBILITY
{
	RIP_OFF,
	RIP_ON,
	RIP_AUTO
};

enum NLSP_SAP_COMPATIBILITY
{
	SAP_OFF,
	SAP_ON,
	SAP_AUTO
};

/* constant for aging either RIPs or SAPs */

#define DO_NOT_AGE					0x0000
#define NO_PERIODIC_BROADCASTS	0x0000

/* mask for IPX_PACKET_STATE */

#define	IPX_PACKET_STATE_MASK	0xff00

#define TOKEN_RING_LLC_FRAME 0x40

enum IPX_FRAME_TYPE
{
	RAW_8023_IPX,
	ETHERNET_TYPE_II_IPX,
	LLC_IPX,
	SNAP_IPX,
	SAME_TYPE_AS_RX_FRAME, /* for future use, DO NOT ALLOW AS A CONFIGURATION OPTION */

	_IPX__ENUM_USHORT_FILLER = 0x1000
};

enum PRINTF_GROUPS
{
	SAP_PRINTF,
	RIP_PRINTF,
	MEMORY_PRINTF,
	ALARM_PRINTF,
	SNAP_PRINTF,
	SNMP_PRINTF,
	DATA_PRINTF,
	IPX_WAN_TIMER_PRINTF,
	IPX_WAN_INFORMATION_PRINTF,
	ECHO_PRINTF,
	NETBIOS_PRINTF,
	NETWARE_LITE_PRINTF,
	DLSW_PRINTF,
	WATCHDOG_PRINTF,
	DIAGNOSTIC_PRINTF,
	SERIALIZATION_PRINTF,
	IPX_WAN_THROUGHPUT_PRINTF,
#ifdef IPX_FILTERING
   IPX_FILTER_PRINTF,
#endif
	IPX_WAN_DELAY_PRINTF
};

/* for ipxnetbs.c */

enum DATASTREAM_TYPE
{
	ADD_NETBIOS_NAME = 3,
	DEREGISTER_NETBIOS_NAME = 5
};

/* for ipxsnap.c */

#define MAXIMUM_NUMBER_OF_IPX_VIRTUAL_PORTS 256
#define ILLEGAL_VIRTUAL_PORT_NUMBER 0xffff

/* for ipxwatch.c */

enum WATCHDOG_SIGNATURE
{
	WATCHDOG_REQUEST = '?',
	WATCHDOG_REPLY = 'Y'
};

/* for ipxdiag.c */

enum SIMPLE_COMPONENT_TYPE
{
	IPX_SPX_COMPONENT,
	ROUTER_DRIVER_COMPONENT,
	LAN_DRIVER_COMPONENT,
	SHELL_COMPONENT,
	VAP_COMPONENT
};

enum EXTENDED_COMPONENT_TYPE
{
	ROUTER_COMPONENT,
	FILE_SERVER_ROUTER_COMPONENT,
	NON_DEDICATED_IPX_SPX_COMPONENT
};

enum LOCAL_NETWORK_TYPE
{
	LAN_BOARD,
	NON_DEDICATED_FILE_SERVER,
	REDIRECTED_REMOTE_LINE
};

#define SPX_DIAGNOSTIC_SOCKET BIG_ENDIAN_CONSTANT (0x4000)

/* for IPX SNMP MIB */

enum IPX_CIRCUIT_STATUS
{
	UNKNOWN_CIRCUIT_STATUS = 0x0001,
	CURRENT_CIRCUIT_STATUS = 0x0002,
	CHANGED_CIRCUIT_STATUS = 0x0003,
	READ_CIRCUIT_STATUS = 0x0004,
	READING_CIRCUIT_STATUS = 0x0005,
	WRITE_CIRCUIT_STATUS = 0x0006,
	WRITING_CIRCUIT_STATUS = 0x0007
};

enum IPX_CIRCUIT_TYPE
{
	OTHER_CIRCUIT_TYPE = 1,
	BROADCAST_CIRCUIT_TYPE,
	POINT_TO_POINT_CIRCUIT_TYPE,
	WAN_RIP_CIRCUIT_TYPE,
	UNNUMBERED_RIP_CIRCUIT_TYPE,
	DYNAMIC_CIRCUIT_TYPE,
	WAN_WS_CIRCUIT_TYPE
};

enum IPX_ROUTING_PROTOCOL_TYPE
{
	OTHER_IPX_ROUTE = 1,
	LOCAL_IPX_ROUTE,
	RIP_IPX_ROUTE,
	NLSP_IPX_ROUTE,
	STATIC_IPX_ROUTE
};

/* Srikar, Mar 15, 1997. Added the values which should be used for the protocol type */
/* according to the ipx mib */
enum IPX_SAP_PROTOCOL_TYPE
{
	OTHER_IPX_SAP = 1,
	LOCAL_IPX_SAP = 2,
	NLSP_SAP = 4,
	STATIC_SAP = 5,
	IPX_SAP = 6
};

enum RIP_CIRCUIT_STATE_TYPE
{
	RIP_CIRCUIT_STATE_OFF = 1,
	RIP_CIRCUIT_STATE_ON,
	RIP_CIRCUIT_STATE_AUTO_ON,
	RIP_CIRCUIT_STATE_AUTO_OFF
};

enum SAP_CIRCUIT_STATE_TYPE
{
	SAP_CIRCUIT_STATE_OFF = 1,
	SAP_CIRCUIT_STATE_ON,
	SAP_CIRCUIT_STATE_AUTO_ON,
	SAP_CIRCUIT_STATE_AUTO_OFF
};

enum NCP_REQUEST_TYPE
{
	NCP_CREATE_SERVICE_CONNECTION = 0x1111,
	NCP_SERVICE_REQUEST = 0x2222,
	NCP_DESTROY_SERVICE_CONNECTION = 0x5555,
	NCP_BURST_MODE_TRANSFER = 0x7777
};

#endif /* _KIPX_H_ */
