/*	$Modname: vnvipx.h$  $version: 1.9$      $date: 10/20/95$   */
/*
* 	$lgb$
1.0 05/20/94 ross changed DLSX to DLSW.
1.1 05/20/94 ross cosmetic.
1.2 08/08/94 ross finishing end station support.
1.3 11/21/94 ross changed to compile under C++, added big sap and rip support.
1.4 11/23/94 ross Added remote access. Added auto-configuration.
1.5 01/26/95 ross changes for spx spoofing.
1.6 03/26/95 ross nlsp changes.
1.7 04/20/95 ross added configurability for internal socket.  Courtesy of Craig.
1.8 05/02/95 ross adding ipxwan version 2 configuration items.
1.9 10/20/95 nishit Changed copyright
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1989 - 1995 RouterWare, Inc.								   */
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Suite 212 Newport Beach, CA  92660  */
/************************************************************************/
	/* IPX parameters */

void map_ipx_network_numbers (char *cptr_port_number_ipx_network_address_string);
void map_ipx_wan_network_numbers (char *cptr_port_number_ipx_network_address_string);
void set_ipx_tx_frame_type (char *cptr_port_number_and_tx_frame_type_string);
void set_router_internal_network (char *cptr_start_of_configuration_string);
void set_ipx_gap_time (char *cptr_start_of_configuration_string);
void set_ipx_real_port_numbers (char *cptr_port_number_and_tx_frame_type_string);
void turn_ipx_printing_on (char *cptr_start_of_configuration_string);
void turn_ipx_subgroup_printing_on (char *cptr_start_of_configuration_string,ULONG printf_type);
#ifdef IPX_FILTERING
extern void ipx_set_filtering_table_size (char *cfg_string) ;
extern void ipx_set_filtering_default_action (char *cfg_string) ;
extern void ipx_filter_source_address (char *cfg_string) ;
extern void ipx_filter_destination_address (char *cfg_string) ;
extern void ipx_forward_source_address (char *cfg_string) ;
extern void ipx_forward_destination_address (char *cfg_string) ;
#endif


CONFIGURATION_TABLE ipx_configuration_table =
{
	{TRUE},
	{
/* _____________________________________________________________________________________________ */
	{
		NULL,
		(enum BOOLEAN *) TRUE,
	"IPX =",
		(ULONG) offsetof (IPX_CLASS,enabled),
		(ULONG) &ipx_class,
		(ULONG) NULL
	},

/* _____________________________________________________________________________________________ */
	{
		(void 	(*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_variable_port_and_enable,
		NULL,
	"IPX Port =",
		(ULONG) offsetof (IPX_CLASS,port[0].port_enabled),
		(ULONG) &ipx_class,
		sizeof (IPX_PORT_CLASS)
	},

/* _____________________________________________________________________________________________ */
	{
		(void 	(*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_ushort_decimal_value,
		NULL,
	"IPX Number of Ports =",
		(ULONG) offsetof (IPX_CLASS,number_of_ports),
		(ULONG) &ipx_class,
		(ULONG) NULL
	},

/* _____________________________________________________________________________________________ */
	{
		(void 	(*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		map_ipx_network_numbers,
		NULL,
	"IPX Port Network =",
		(ULONG) offsetof (IPX_CLASS,port[0].network),
		(ULONG) &ipx_class,
		sizeof (IPX_PORT_CLASS)
	},

/* _____________________________________________________________________________________________ */
	{
		(void 	(*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_ipx_real_port_numbers,
		NULL,
	"IPX Virtual To Real Port ="
	},

/* _____________________________________________________________________________________________ */
	{
		set_variable_port_and_enable,
		NULL,
	"IPX Port Netbios =",
		(ULONG) offsetof (IPX_CLASS,port[0].netbios_enabled),
		(ULONG) &ipx_class,
		sizeof (IPX_PORT_CLASS)
	},

/* _____________________________________________________________________________________________ */
	{
		set_variable_port_and_enable,
		NULL,
	"IPX Port Cache Netbios Names =",
		(ULONG) offsetof (IPX_CLASS,port[0].netbios_name_caching_enabled),
		(ULONG) &ipx_class,
		sizeof (IPX_PORT_CLASS)
	},

/* _____________________________________________________________________________________________ */
	{
		set_variable_port_and_ushort_decimal_value,
		NULL,
	"IPX Port Netbios Hops =",
		(ULONG) offsetof (IPX_CLASS,port[0].maximum_number_of_netbios_hops),
		(ULONG) &ipx_class,
		sizeof (IPX_PORT_CLASS)
	},

/* _____________________________________________________________________________________________ */
	{
		set_variable_port_and_ushort_decimal_value,
		NULL,
	"IPX Port Maximum Number Of Hops =",
		(ULONG) offsetof (IPX_CLASS,port[0].maximum_number_of_hops),
		(ULONG) &ipx_class,
		sizeof (IPX_PORT_CLASS)
	},

/* _____________________________________________________________________________________________ */
	{
		set_variable_port_and_enable,
		NULL,
	"IPX Port Netware Lite =",
		(ULONG) offsetof (IPX_CLASS,port[0].netware_lite_enabled),
		(ULONG) &ipx_class,
		sizeof (IPX_PORT_CLASS)
	},

/* _____________________________________________________________________________________________ */
	{
		(void 	(*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_ipx_tx_frame_type,
		NULL,
	"IPX Port Frame Type =",
		(ULONG) NULL,
		(ULONG) NULL
		},

/* _____________________________________________________________________________________________ */
	{
		set_variable_port_and_ushort_decimal_value,
		NULL,
	"IPX Port Transport Time =",(ULONG) offsetof (IPX_CLASS,port[0].transport_time),
		(ULONG) &ipx_class,
		sizeof (IPX_PORT_CLASS)
	},

/* _____________________________________________________________________________________________ */
	{
		set_variable_port_and_ulong_decimal_value,
		NULL,
	"IPX Port Periodic RIP Tx Timer =",
		(ULONG) offsetof (IPX_CLASS,port[0].periodic_RIP_tx_timer),
		(ULONG) &ipx_class,
		sizeof (IPX_PORT_CLASS)
	},

/* _____________________________________________________________________________________________ */
	{
		set_variable_port_and_ulong_decimal_value,
		NULL,
	"IPX Port RIP Age Timer =",(ULONG) offsetof (IPX_CLASS,port[0].RIP_age_timer),
		(ULONG) &ipx_class,
		sizeof (IPX_PORT_CLASS)
	},

/* _____________________________________________________________________________________________ */
	{
		set_variable_port_and_ulong_decimal_value,
		NULL,
	"IPX Port Periodic SAP Tx Timer =",
		(ULONG) offsetof (IPX_CLASS,port[0].periodic_SAP_tx_timer),
		(ULONG) &ipx_class,
		sizeof (IPX_PORT_CLASS)
	},

/* _____________________________________________________________________________________________ */
	{
		set_variable_port_and_ulong_decimal_value,
		NULL,
	"IPX Port SAP Age Timer =",(ULONG) offsetof (IPX_CLASS,port[0].SAP_age_timer),
		(ULONG) &ipx_class,
		sizeof (IPX_PORT_CLASS)
	},

#ifdef IPX_FILTERING


/* _____________________________________________________________________________________________ */

	{(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		ipx_set_filtering_table_size,
		NULL,
	"IPX Number of Filtering Database Entries =",
		(ULONG)NULL,
		(ULONG)NULL
	},

/* _____________________________________________________________________________________________ */

	{(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		ipx_set_filtering_default_action,
		NULL,
	"IPX Filtering Default Action =",
		(ULONG)NULL,
		(ULONG)NULL
	},

/* _____________________________________________________________________________________________ */

	{(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		ipx_filter_source_address,
		NULL,
	"IPX Filter Source Address =",
		(ULONG)NULL,
		(ULONG)NULL
	},

/* _____________________________________________________________________________________________ */

	{(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		ipx_filter_destination_address,
		NULL,
	"IPX Filter Destination Address =",
		(ULONG)NULL,
		(ULONG)NULL
	},

/* _____________________________________________________________________________________________ */

	{(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		ipx_forward_source_address,
		NULL,
	"IPX Forward Source Address =",
		(ULONG)NULL,
		(ULONG)NULL
	},

/* _____________________________________________________________________________________________ */

	{(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		ipx_forward_destination_address,
		NULL,
	"IPX Forward Destination Address =",
		(ULONG)NULL,
		(ULONG)NULL
	},

/* _____________________________________________________________________________________________ */

   {
		NULL,
		(enum BOOLEAN *) TRUE,
	"IPX Printf Filtering =",
		(ULONG) offsetof (IPX_CLASS,ipx_filter_printing_enabled),
		(ULONG ) &ipx_class,
		(ULONG) NULL
	},

#endif

/* _____________________________________________________________________________________________ */
	{
		(void 	(*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		turn_ipx_printing_on,
		NULL,
	"IPX Printf =",
		(ULONG) NULL,
		(ULONG) NULL
	},

/* _____________________________________________________________________________________________ */
	{
		(void 	(*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		turn_ipx_subgroup_printing_on,
		NULL,
	"IPX Printf SAP =",(ULONG) SAP_PRINTF,
		(ULONG) NULL
	},

/* _____________________________________________________________________________________________ */
	{
		(void 	(*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		turn_ipx_subgroup_printing_on,
		NULL,
	"IPX Printf RIP =",(ULONG) RIP_PRINTF,
		(ULONG) NULL
	},

/* _____________________________________________________________________________________________ */
	{
		(void 	(*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		turn_ipx_subgroup_printing_on,
		NULL,
	"IPX Printf Memory =",(ULONG) MEMORY_PRINTF,
		(ULONG) NULL
	},

/* _____________________________________________________________________________________________ */
	{
		(void 	(*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		turn_ipx_subgroup_printing_on,
		NULL,
	"IPX Printf SNAP =",(ULONG) SNAP_PRINTF,
		(ULONG) NULL
	},

/* _____________________________________________________________________________________________ */
	{
		(void 	(*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		turn_ipx_subgroup_printing_on,
		NULL,
	"IPX Printf SNMP =",(ULONG) SNMP_PRINTF,
		(ULONG) NULL
	},

/* _____________________________________________________________________________________________ */
	{
		(void 	(*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		turn_ipx_subgroup_printing_on,
		NULL,
	"IPX Printf Data =",(ULONG) DATA_PRINTF,
		(ULONG) NULL
	},

/* _____________________________________________________________________________________________ */
	{
		(void 	(*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		turn_ipx_subgroup_printing_on,
		NULL,
	"IPX Printf Alarm =",(ULONG) ALARM_PRINTF,
		(ULONG) NULL
	},

/* _____________________________________________________________________________________________ */
	{
		(void 	(*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		turn_ipx_subgroup_printing_on,
		NULL,
	"IPX Printf Tunnel =",(ULONG) DLSW_PRINTF,
		(ULONG) NULL
	},

/* _____________________________________________________________________________________________ */
	{
		(void 	(*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_ipx_gap_time,
		NULL,
	"IPX Gap Time ="
	},

/* _____________________________________________________________________________________________ */
	{
		set_variable_port_and_enable,
		NULL,
	"IPX Port Serialization =",(ULONG) offsetof (IPX_CLASS,port[0].enable_serialization_spoofing),
		(ULONG) &ipx_class,
		sizeof (IPX_PORT_CLASS)
	},

/* _____________________________________________________________________________________________ */
	{
		set_variable_port_and_enable,
		NULL,
	"IPX Port Watchdog =",(ULONG) offsetof (IPX_CLASS,port[0].enable_watchdog_spoofing),
		(ULONG) &ipx_class,
		sizeof (IPX_PORT_CLASS)
	},

/* _____________________________________________________________________________________________ */
	{
		set_variable_port_and_enable,
		NULL,
	"IPX Port Diagnostics =",(ULONG) offsetof (IPX_CLASS,port[0].enable_diagnostic_packets),
		(ULONG) &ipx_class,
		sizeof (IPX_PORT_CLASS)
	},

/* _____________________________________________________________________________________________ */
	{
		set_variable_port_and_enable,
		NULL,
	"IPX Port Periodic SAP =",(ULONG) offsetof (IPX_CLASS,port[0].enable_periodic_SAP_broadcasts),
		(ULONG) &ipx_class,
		sizeof (IPX_PORT_CLASS)
	},

/* _____________________________________________________________________________________________ */
	{
		set_variable_port_and_enable,
		NULL,
	"IPX Port Periodic RIP =",(ULONG) offsetof (IPX_CLASS,port[0].enable_periodic_RIP_broadcasts),
		(ULONG) &ipx_class,
		sizeof (IPX_PORT_CLASS)
	},

/* _____________________________________________________________________________________________ */
	{
		set_variable_port_and_enable,
		NULL,
	"IPX Port SAP =",(ULONG) offsetof (IPX_CLASS,port[0].enable_SAP_broadcasts),
		(ULONG) &ipx_class,
		sizeof (IPX_PORT_CLASS)
	},

/* _____________________________________________________________________________________________ */
	{
		set_variable_port_and_enable,
		NULL,
	"IPX Port RIP =",(ULONG) offsetof (IPX_CLASS,port[0].enable_RIP_broadcasts),
		(ULONG) &ipx_class,
		sizeof (IPX_PORT_CLASS)},						

/* _____________________________________________________________________________________________ */
	{
		set_variable_port_and_enable,
		NULL,
	"IPX Port is WAN =",(ULONG) offsetof (IPX_CLASS,port[0].wan_port),
		(ULONG) &ipx_class,
		sizeof (IPX_PORT_CLASS)
	},

/* _____________________________________________________________________________________________ */
#ifdef IPX_WAN_ENABLED
	{
		set_variable_port_and_enable,
		NULL,
	"IPX Port is IPXWAN =",(ULONG) offsetof (IPX_CLASS,port[0].wan.enable_ipx_wan_packets),
		(ULONG) &ipx_class,
		sizeof (IPX_PORT_CLASS)
	},

/* _____________________________________________________________________________________________ */

	{
		(void 	(*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_variable_port_and_enable,
		NULL,
	"IPX Port Remote Access =",
		(ULONG) offsetof (IPX_CLASS,port[0].remote_access),
		(ULONG) &ipx_class,
		sizeof (IPX_PORT_CLASS)
	},

/* _____________________________________________________________________________________________ */

	{
		(void 	(*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_variable_port_and_enable,
		NULL,
	"IPX Port WAN Routing Type RIP SAP =",
		(ULONG) offsetof (IPX_CLASS,port[0].wan.routing_type_enabled[RIP_SAP_ROUTING]),
		(ULONG) &ipx_class,
		sizeof (IPX_PORT_CLASS)
	},

/* _____________________________________________________________________________________________ */

	{
		(void 	(*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_variable_port_and_enable,
		NULL,
	"IPX Port WAN Routing Type NLSP =",
		(ULONG) offsetof (IPX_CLASS,port[0].wan.routing_type_enabled[NLSP_ROUTING]),
		(ULONG) &ipx_class,
		sizeof (IPX_PORT_CLASS)
	},

/* _____________________________________________________________________________________________ */

	{
		(void 	(*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_variable_port_and_enable,
		NULL,
	"IPX Port WAN Routing Type Unnumbered RIP =",
		(ULONG) offsetof (IPX_CLASS,port[0].wan.routing_type_enabled[UNNUMBERED_RIP_ROUTING]),
		(ULONG) &ipx_class,
		sizeof (IPX_PORT_CLASS)
	},

/* _____________________________________________________________________________________________ */

	{
		(void 	(*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_variable_port_and_enable,
		NULL,
	"IPX Port WAN Routing Type On Demand Static =",
		(ULONG) offsetof (IPX_CLASS,port[0].wan.routing_type_enabled[ON_DEMAND_STATIC_ROUTING]),
		(ULONG) &ipx_class,
		sizeof (IPX_PORT_CLASS)
	},

/* _____________________________________________________________________________________________ */

	{
		(void 	(*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_variable_port_and_enable,
		NULL,
	"IPX Port WAN Routing Type Client Router =",
		(ULONG) offsetof (IPX_CLASS,port[0].wan.routing_type_enabled[CLIENT_ROUTER_CONNECTION]),
		(ULONG) &ipx_class,
		sizeof (IPX_PORT_CLASS)
	},

/* _____________________________________________________________________________________________ */
	{
		(void 	(*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_variable_port_and_ushort_decimal_value,
		NULL,
	"IPX Port WAN Request Retry Gap Time =",
		(ULONG) offsetof (IPX_CLASS,port[0].wan.request_retry_gap_time),
		(ULONG) &ipx_class,
		sizeof (IPX_PORT_CLASS)
	},

/* _____________________________________________________________________________________________ */
	{
		(void 	(*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_variable_port_and_ushort_decimal_value,
		NULL,
	"IPX Port WAN Request Limit =",
		(ULONG) offsetof (IPX_CLASS,port[0].wan.retry_limit),
		(ULONG) &ipx_class,
		sizeof (IPX_PORT_CLASS)
	},

/* _____________________________________________________________________________________________ */
	{
		(void 	(*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_variable_port_and_ushort_decimal_value,
		NULL,
	"IPX Port WAN Throughput Request Size =",
		(ULONG) offsetof (IPX_CLASS,port[0].wan.throughput_request_size),
		(ULONG) &ipx_class,
		sizeof (IPX_PORT_CLASS)
	},

#endif

/* _____________________________________________________________________________________________ */
	{
		(void 	(*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_variable_string,
		NULL,
	"IPX Router Name =",
		(ULONG) offsetof (IPX_CLASS,internal_SAP_id.SAP_name),
		(ULONG) &ipx_class,
		(ULONG) NULL
	},
/* _____________________________________________________________________________________________ */
	{
		(void 	(*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_ulong_swapped_hex_value,
		NULL,
	"IPX Router Network =",
		(ULONG) offsetof (IPX_CLASS,internal_SAP_id.ipx_address.network),
		(ULONG) &ipx_class,
		(ULONG) NULL
	},


/* _____________________________________________________________________________________________ */
	{
		(void 	(*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_ushort_decimal_value,
		NULL,
	"IPX Router Socket =",
		(ULONG) offsetof (IPX_CLASS,internal_SAP_id.ipx_address.socket),
		(ULONG) &ipx_class,
		(ULONG) NULL
	},

/* _____________________________________________________________________________________________ */
	{
		(void 	(*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_ushort_swapped_hex_value,
		NULL,
	"IPX Router SAP Type =",
		(ULONG) offsetof (IPX_CLASS,internal_SAP_id.SAP_type),
		(ULONG) &ipx_class,
		(ULONG) NULL
	},

/* _____________________________________________________________________________________________ */

	{
		set_variable_port_and_ulong_decimal_value,
		NULL,
	"IPX Port Maximum Frame Size =",
		(ULONG) offsetof (IPX_CLASS,port[0].maximum_packet_size_including_header),
		(ULONG) &ipx_class,
		sizeof (IPX_PORT_CLASS)
	},

/* _____________________________________________________________________________________________ */

	{
		set_variable_port_and_enable,
		NULL,
	"IPX Port Learn Network Address =",
		(ULONG) offsetof (IPX_CLASS,port[0].learn_network_address),
		(ULONG) &ipx_class,
		sizeof (IPX_PORT_CLASS)
	},

/* _____________________________________________________________________________________________ */

	{
		set_variable_port_and_ulong_decimal_value,
		NULL,
	"IPX Port Learning Periodic Time =",
		(ULONG) offsetof (IPX_CLASS,port[0].learning_holding_time),
		(ULONG) &ipx_class,
		sizeof (IPX_PORT_CLASS)
	},

/* _____________________________________________________________________________________________ */

	{
		set_variable_port_and_ulong_decimal_value,
		NULL,
	"IPX Port Learning Maximum Number of Retries =",
		(ULONG) offsetof (IPX_CLASS,port[0].maximum_number_of_learning_retries),
		(ULONG) &ipx_class,
		sizeof (IPX_PORT_CLASS)
	},

/* _____________________________________________________________________________________________ */

	{
		set_variable_port_and_ulong_decimal_value,
		NULL,
	"IPX Port Rip Maximum Size =",
		(ULONG) offsetof (IPX_CLASS,port[0].maximum_size_of_rip_packet),
		(ULONG) &ipx_class,
		sizeof (IPX_PORT_CLASS)
	},

/* _____________________________________________________________________________________________ */

	{
		set_variable_port_and_ulong_decimal_value,
		NULL,
	"IPX Port SAP Maximum Size =",
		(ULONG) offsetof (IPX_CLASS,port[0].maximum_size_of_SAP_packet),
		(ULONG) &ipx_class,
		sizeof (IPX_PORT_CLASS)
	},

/* _____________________________________________________________________________________________ */
	{
		NULL,
		(enum BOOLEAN *) TRUE,
	"IPX Remote Access Enabled =",
		(ULONG) offsetof (IPX_CLASS,remote_access_enabled),
		(ULONG) &ipx_class,
		(ULONG) NULL
	},

/* _____________________________________________________________________________________________ */

	{
		set_variable_port_and_ulong_decimal_value,
		NULL,
	"IPX Port SPX Connection Timeout =",
		(ULONG) offsetof (IPX_CLASS,port[0].spx_connection_timeout),
		(ULONG) &ipx_class,
		sizeof (IPX_PORT_CLASS)
	},

/* _____________________________________________________________________________________________ */
	{
		(void 	(*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_variable_port_and_enable,
		NULL,
	"IPX Port Spx Spoofing =",
		(ULONG) offsetof (IPX_CLASS,port[0].enable_spx_watchdog_spoofing),
		(ULONG) &ipx_class,
		sizeof (IPX_PORT_CLASS)
	},

/* _____________________________________________________________________________________________ */

	{
		NULL,
		(enum BOOLEAN *) TRUE,
	"IPX WAN Timer Printf =",
		(ULONG) offsetof (IPX_CLASS,ipx_wan_timer_printing_enabled),
		(ULONG ) &ipx_class,
		(ULONG) NULL
	},

/* _____________________________________________________________________________________________ */

	{
		NULL,
		(enum BOOLEAN *) TRUE,
	"IPX WAN RIP/SAP Printf =",
		(ULONG) offsetof (IPX_CLASS,ipx_wan_rip_sap_printing_enabled),
		(ULONG ) &ipx_class,
		(ULONG) NULL
	},

/* _____________________________________________________________________________________________ */
	{
		NULL,
		NULL,
	"",
		(ULONG) NULL,
		(ULONG) NULL,
		(ULONG) NULL
	}

	}	
};
