#include	"defs.h"
/*	$Modname: macbrdb.c$  $version: 1.22$      $date: 03/31/95$   */
/*
* 	$lgb$
1.0 01/05/92 ross
1.1 01/25/92 ross
1.2 04/22/92 ross
1.3 07/30/92 ross
1.4 08/05/92 ross
1.5 08/15/92 ross added dynamic hashing, fixed bug which installed bridge addresses in table.
1.6 08/21/92 ross
1.7 08/21/92 ross
1.8 08/22/92 ross Added support for multiple instances of stp_class
1.9 08/22/92 ross delete find_matching_source_e...
1.10 08/22/92 ross made as many functions as possible static
1.11 11/23/92 ross changed ETHERNET_ADDRESS to MAC_ADDRESS to appear more generic (cosmetic)
1.12 01/10/93 ross adding support for dlci number if FD table.
1.13 01/15/93 ross
1.14 01/20/93 ross
1.15 01/29/93 ross changed constants in macbrrx.c and macbrdb.c to better match snmp, fixed frame relay bug.
1.16 01/30/93 ross delete references to stp dlci
1.17 07/16/93 ross added some mib statistics
1.18 10/28/93 ross added some parenthesis for readability.
1.19 01/13/94 ross changed a 1 in static add to spanning tree port number.
1.20 03/07/94 ross removed external references to mac_address, function used instead.
1.21 06/15/94 ross cosmetic changes and snmp access routines.
1.22 03/31/95 ross Changes for new rwutils library.
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1989 - 1993 Router Engines, Inc.								*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	Router Engines, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
/************************************************************************/
#include	<string.h>
#include	<stdlib.h>
#include	<kstart.h>
#include "macbridg.h" 
#include "vmacbr.h"
#include	<lslproto.h>
/****************************************************************************/
void initialize_hashing_table (void)
{
	ULONG	entry_number;
	FILTERING_DATABASE_ENTRY *sptr_current_entry;

	stp_class.sptr_fd_table = (FILTERING_DATABASE_TABLE *) 
		table_malloc (stp_class.number_of_fd_entries,sizeof (FILTERING_DATABASE_ENTRY));

	stp_class.sptr_hash_table =
		(HASH_TABLE *) table_malloc (stp_class.number_of_hash_table_entries,
		sizeof (stp_class.sptr_first_entry_in_fd_table->links));

	stp_class.sptr_first_entry_in_fd_table = (FILTERING_DATABASE_ENTRY *) stp_class.sptr_fd_table;

	stp_class.free_fd_entries_queue.sptr_forward_link = NULL;
	stp_class.free_fd_entries_queue.sptr_backward_link = NULL;
	sptr_current_entry = stp_class.sptr_first_entry_in_fd_table;

	for (entry_number = 0 ; entry_number < stp_class.number_of_fd_entries; ++entry_number,++sptr_current_entry)
		{
		add_entry_to_queue (&stp_class.free_fd_entries_queue,&sptr_current_entry->links);
		}
}
/****************************************************************************/
extern	USHORT bridge_timer;
ULONG out_of_database_entries;
#if 0
/****************************************************************************/
enum FD_TABLE_ENTRY_TYPE add_entry_to_filtering_database (USHORT source_mac_address_ushort,
	ULONG source_mac_address_ulong,USHORT port_number,enum FD_TABLE_ENTRY_TYPE type)
{
	FILTERING_DATABASE_ENTRY	*sptr_matching_fd_entry;

	sptr_matching_fd_entry = (FILTERING_DATABASE_ENTRY *)
		stp_class.sptr_hash_table->entry[source_mac_address_ushort & stp_class.hash_mask].sptr_forward_link;

	while (sptr_matching_fd_entry != NULL)
		{
		if (sptr_matching_fd_entry->source_address._ushort == source_mac_address_ushort &&
			sptr_matching_fd_entry->source_address._ulong == source_mac_address_ulong)
			break;

		sptr_matching_fd_entry = (FILTERING_DATABASE_ENTRY *) sptr_matching_fd_entry->links.sptr_forward_link;
		}

	if (sptr_matching_fd_entry == NULL)
		{
 		sptr_matching_fd_entry =
			(FILTERING_DATABASE_ENTRY *) get_entry_from_queue (&stp_class.free_fd_entries_queue);

		if (sptr_matching_fd_entry == NULL)
			{
			++stp_class.port[port_number].number_of_frames_received_while_database_is_full;
			++stp_class.this_bridge.number_of_frames_received_while_database_is_full;
			return (OUT_OF_DATABASE_ENTRIES);
			}

		sptr_matching_fd_entry->source_address._ushort = source_mac_address_ushort;
		sptr_matching_fd_entry->source_address._ulong = source_mac_address_ulong;
		sptr_matching_fd_entry->timer_value = bridge_timer;
		sptr_matching_fd_entry->type = type;
		sptr_matching_fd_entry->port_number = port_number;

  		add_entry_to_queue ((LINK *) &stp_class.sptr_hash_table->entry[source_mac_address_ushort &
			stp_class.hash_mask],&sptr_matching_fd_entry->links);

		return (NOT_IN_DATABASE);
		}
	else
		{
		if (sptr_matching_fd_entry->type == DELETE_ENTRY_ON_TIMEOUT)
			{
			if (sptr_matching_fd_entry->port_number != port_number)
				{
				sptr_matching_fd_entry->source_address._ushort = source_mac_address_ushort;
				sptr_matching_fd_entry->source_address._ulong = source_mac_address_ulong;
				sptr_matching_fd_entry->timer_value = bridge_timer;
				sptr_matching_fd_entry->port_number = port_number;
													   
				return (IN_DATABASE_DIFFERENT_PORT);
				}
			else
				{
				sptr_matching_fd_entry->timer_value = bridge_timer;
				return (IN_DATABASE_SAME_PORT);
				}
			}
		else /* add custom filtering here */
			return (PERMANENT_TABLE_ENTRY);
		}
}
#endif

extern void display_span_tree () ;
enum FD_TABLE_ENTRY_TYPE add_entry_to_filtering_database (USHORT source_mac_address_ushort,
	ULONG source_mac_address_ulong,USHORT port_number,enum FD_TABLE_ENTRY_TYPE type)
{
	FILTERING_DATABASE_ENTRY *sptr_matching_fd_entry;

	sptr_matching_fd_entry = (FILTERING_DATABASE_ENTRY *)
		stp_class.sptr_hash_table->entry[source_mac_address_ushort & stp_class.hash_mask].sptr_forward_link;

	while (sptr_matching_fd_entry != NULL)
	{
		if (sptr_matching_fd_entry->source_address._ushort == source_mac_address_ushort &&
			sptr_matching_fd_entry->source_address._ulong == source_mac_address_ulong)
			break;

		sptr_matching_fd_entry = (FILTERING_DATABASE_ENTRY *) sptr_matching_fd_entry->links.sptr_forward_link;
	}

	if (sptr_matching_fd_entry == NULL)
	{
 		sptr_matching_fd_entry =
			(FILTERING_DATABASE_ENTRY *) get_entry_from_queue (&stp_class.free_fd_entries_queue);

		if (sptr_matching_fd_entry == NULL)
		{
			++stp_class.port[port_number].number_of_frames_received_while_database_is_full;
			++stp_class.this_bridge.number_of_frames_received_while_database_is_full;
			return (OUT_OF_DATABASE_ENTRIES);
		}

		sptr_matching_fd_entry->source_address._ushort = source_mac_address_ushort;
		sptr_matching_fd_entry->source_address._ulong = source_mac_address_ulong;
		sptr_matching_fd_entry->timer_value = bridge_timer;
		sptr_matching_fd_entry->type = type;
		sptr_matching_fd_entry->port_number = port_number;

  		add_entry_to_queue ((LINK *) &stp_class.sptr_hash_table->entry[source_mac_address_ushort &
			stp_class.hash_mask],&sptr_matching_fd_entry->links);
#if 0
		display_span_tree () ;
#endif
		return (NOT_IN_DATABASE);
	}
	else
	{
		if (sptr_matching_fd_entry->type == DELETE_ENTRY_ON_TIMEOUT)
		{
			if (sptr_matching_fd_entry->port_number != port_number)
			{
				sptr_matching_fd_entry->source_address._ushort = source_mac_address_ushort;
				sptr_matching_fd_entry->source_address._ulong = source_mac_address_ulong;
				sptr_matching_fd_entry->timer_value = bridge_timer;
				sptr_matching_fd_entry->port_number = port_number;
#if 0
				display_span_tree () ;
#endif
				return (IN_DATABASE_DIFFERENT_PORT);
			}
			else
			{
				sptr_matching_fd_entry->timer_value = bridge_timer;
				return (IN_DATABASE_SAME_PORT);
			}
		}
		else /* add custom filtering here */
		{
			switch (sptr_matching_fd_entry->type)
			{
				case (FILTER_ON_SOURCE_ADDRESS) :
					sptr_matching_fd_entry->timer_value = bridge_timer ;
					if (sptr_matching_fd_entry->port_number != port_number)
					{
						printf ("\nSTP configuration error : wrong port/address pair") ;
						sptr_matching_fd_entry->type = type ;
						sptr_matching_fd_entry->port_number = port_number ;
#if 0
						display_span_tree () ;
#endif
						return (NOT_IN_DATABASE) ;
					}
					return (FILTER_ON_SOURCE_ADDRESS) ;

				case (FORWARD_ON_SOURCE_ADDRESS) :
					sptr_matching_fd_entry->timer_value = bridge_timer ;
					if (sptr_matching_fd_entry->port_number != port_number)
					{
						printf ("\nSTP configuration error : wrong port/address pair") ;
						sptr_matching_fd_entry->type = type ;
						sptr_matching_fd_entry->port_number = port_number ;
#if 0
						display_span_tree () ;
#endif
						return (NOT_IN_DATABASE) ;
					}
					return (FORWARD_ON_SOURCE_ADDRESS) ;

				case (FILTER_ON_DESTINATION_ADDRESS) :
					sptr_matching_fd_entry->timer_value = bridge_timer ;
					if (sptr_matching_fd_entry->port_number != port_number)
					{
						printf ("\nSTP configuration error : wrong port/address pair") ;
						sptr_matching_fd_entry->type = type ;
						sptr_matching_fd_entry->port_number = port_number ;
#if 0
						display_span_tree () ;
#endif
						return (NOT_IN_DATABASE) ;
					}
					return (FILTER_ON_DESTINATION_ADDRESS) ;

				case (FORWARD_ON_DESTINATION_ADDRESS) :
					sptr_matching_fd_entry->timer_value = bridge_timer ;
					if (sptr_matching_fd_entry->port_number != port_number)
					{
						printf ("\nSTP configuration error : wrong port/address pair") ;
						sptr_matching_fd_entry->type = type ;
						sptr_matching_fd_entry->port_number = port_number ;
#if 0
						display_span_tree () ;
#endif
						return (NOT_IN_DATABASE) ;
					}
					return (FORWARD_ON_DESTINATION_ADDRESS) ;

				case (FILTER_ON_SOURCE_AND_DESTINATION_ADDRESS) :
					sptr_matching_fd_entry->timer_value = bridge_timer ;
					if (sptr_matching_fd_entry->port_number != port_number)
					{
						printf ("\nSTP configuration error : wrong port/address pair") ;
						sptr_matching_fd_entry->type = type ;
						sptr_matching_fd_entry->port_number = port_number ;
#if 0
						display_span_tree () ;
#endif
						return (NOT_IN_DATABASE) ;
					}
					return (FILTER_ON_SOURCE_AND_DESTINATION_ADDRESS) ;

				case (FORWARD_ON_SOURCE_AND_DESTINATION_ADDRESS) :
					sptr_matching_fd_entry->timer_value = bridge_timer ;
					if (sptr_matching_fd_entry->port_number != port_number)
					{
						printf ("\nSTP configuration error : wrong port/address pair") ;
						sptr_matching_fd_entry->type = type ;
						sptr_matching_fd_entry->port_number = port_number ;
#if 0
						display_span_tree () ;
#endif
						return (NOT_IN_DATABASE) ;
					}
					return (FORWARD_ON_SOURCE_AND_DESTINATION_ADDRESS) ;


				default :
					break ;
			}
			
			return (PERMANENT_TABLE_ENTRY);
		}
	}
}

/****************************************************************************/
FILTERING_DATABASE_ENTRY *get_destination_address_database_entry (USHORT destination_mac_address_ushort,
	ULONG destination_mac_address_ulong)
{
	FILTERING_DATABASE_ENTRY	*sptr_database_entry;

	sptr_database_entry = (FILTERING_DATABASE_ENTRY	*)
		stp_class.sptr_hash_table->entry[destination_mac_address_ushort &
			stp_class.hash_mask].sptr_forward_link;

	while (sptr_database_entry != NULL)
		{
		if (destination_mac_address_ushort == sptr_database_entry->source_address._ushort &&
			destination_mac_address_ulong == sptr_database_entry->source_address._ulong)
			{
			break; /* found entry in database */
			}

		sptr_database_entry = (FILTERING_DATABASE_ENTRY	*) sptr_database_entry->links.sptr_forward_link;
		}

	return (sptr_database_entry);
}
/****************************************************************************/
void database_entry_timer_check (void)
{
	FILTERING_DATABASE_ENTRY	*sptr_fd_entry;
	ULONG	entry_number;
	ULONG number_of_entries_per_timer_check;

	sptr_fd_entry = stp_class.sptr_first_entry_in_fd_table + stp_class.current_entry_to_check_age;

	number_of_entries_per_timer_check = stp_class.number_of_fd_entries / stp_class.clock_ticks_per_second;

	for (entry_number = 0x00000000L; entry_number < stp_class.number_of_fd_entries;
		++sptr_fd_entry,++entry_number,++stp_class.current_entry_to_check_age)
		{
	  	if (entry_number > number_of_entries_per_timer_check)
			{
	  		break;
			}

		if (stp_class.current_entry_to_check_age >= stp_class.number_of_fd_entries)
			{
			stp_class.current_entry_to_check_age = 0x00000000L;
			}

		if (sptr_fd_entry->port_number != 0 &&	sptr_fd_entry->type == DELETE_ENTRY_ON_TIMEOUT)
			{
			if ((sptr_fd_entry->timer_value + stp_class.this_bridge.aging_time_for_fd) < bridge_timer)
				{
				++stp_class.number_of_entries_timed_out;

 				delete_entry_from_queue ((LINK *)
					&stp_class.sptr_hash_table->entry[sptr_fd_entry->source_address._ushort &
						stp_class.hash_mask].sptr_forward_link,&sptr_fd_entry->links);
 
				memset (sptr_fd_entry, (int) NULL, sizeof (FILTERING_DATABASE_ENTRY));

 				add_entry_to_queue (&stp_class.free_fd_entries_queue,&sptr_fd_entry->links);
 				}
			}
		}
}
/****************************************************************************/
void add_bridge_addresses_to_static_forwarding_table (void)
{
	USHORT spanning_tree_port_number;
	MAC_ADDRESS mac_address;

	for (spanning_tree_port_number = 0x0000; spanning_tree_port_number < stp_class.number_of_spanning_tree_ports;
		++spanning_tree_port_number)
		{
		lsl_control (GET_MAC_ADDRESS,spanning_tree_port_number,stp_class.stack_id,&mac_address);

		add_entry_to_filtering_database (mac_address._ushort,mac_address._ulong,spanning_tree_port_number + 1 ,PERMANENT_TABLE_ENTRY);
		}
}
/****************************************************************************/
enum SORT_RETURN compare_node_addresses (FILTERING_DATABASE_ENTRY *sptr_fd_entry_1,FILTERING_DATABASE_ENTRY *sptr_fd_entry_2)
{
	BYTE	node_address_size;

	BYTE	*bptr_node_address_1 = (BYTE *) &sptr_fd_entry_1->source_address._ushort;
	BYTE	*bptr_node_address_2 = (BYTE *) &sptr_fd_entry_2->source_address._ushort;

	for (node_address_size = 0x00; node_address_size < sizeof (MAC_ADDRESS) ; node_address_size += (BYTE) 1)
		{
		if (*bptr_node_address_1 > *bptr_node_address_2)
			return (GREATER_THAN);
		if (*bptr_node_address_1 < *bptr_node_address_2)
			return (LESS_THAN);

		++bptr_node_address_1;
		++bptr_node_address_2;
		}

	return (EQUAL_TO);
}
#ifndef SMALL_ENTRY
/*************************************************************************/
void add_entry_to_queue (LINK *sptr_link,LINK *sptr_link_to_add)
{
	sptr_link_to_add->sptr_backward_link = sptr_link->sptr_backward_link;

	if (sptr_link->sptr_backward_link != NULL)
		sptr_link->sptr_backward_link->sptr_forward_link = sptr_link_to_add;
	else
		sptr_link->sptr_forward_link = sptr_link_to_add;
	
	sptr_link->sptr_backward_link = sptr_link_to_add;

	sptr_link_to_add->sptr_forward_link = NULL;
}
/*************************************************************************/
void  *get_entry_from_queue (LINK *sptr_link)
{
	LINK	*sptr_return_link;

	sptr_return_link = sptr_link->sptr_forward_link;

	if (sptr_return_link != NULL)
		{
		sptr_link->sptr_forward_link = sptr_link->sptr_forward_link->sptr_forward_link;

		if (sptr_link->sptr_forward_link != NULL)
			sptr_link->sptr_forward_link->sptr_backward_link = NULL;
		else 
			sptr_link->sptr_backward_link = NULL;

		if (sptr_return_link != NULL)
			{
			sptr_return_link->sptr_forward_link = NULL;
			sptr_return_link->sptr_backward_link = NULL;
			}
		}

	return (sptr_return_link);
}
/*************************************************************************/
void delete_entry_from_queue (LINK *sptr_queue_link,LINK *sptr_link_to_delete)
{
	if (sptr_link_to_delete->sptr_forward_link == NULL && sptr_link_to_delete->sptr_backward_link == NULL) /* 1 entry in queue */
		{
		sptr_queue_link->sptr_forward_link = NULL;
		sptr_queue_link->sptr_backward_link = NULL;
		return;
		}

	if (sptr_link_to_delete->sptr_backward_link == NULL) /* First entry in N (N >= 2) entry queue  */
		sptr_queue_link->sptr_forward_link = sptr_link_to_delete->sptr_forward_link; /* new first entry in queue have queue point to it */
	else 
		sptr_link_to_delete->sptr_backward_link->sptr_forward_link = sptr_link_to_delete->sptr_forward_link;

	if (sptr_link_to_delete->sptr_forward_link == NULL) /* Last entry in N (N >= 2) entry queue */
		sptr_queue_link->sptr_backward_link = sptr_link_to_delete->sptr_backward_link; /* new last entry in queue because we're deleting the end*/
	else 
		sptr_link_to_delete->sptr_forward_link->sptr_backward_link = sptr_link_to_delete->sptr_backward_link;

	sptr_link_to_delete->sptr_forward_link = NULL;
	sptr_link_to_delete->sptr_backward_link = NULL;
}
#else
USHORT convert_link_to_index (USHORT_LINK *sptr_link);
USHORT_LINK *convert_index_to_link (USHORT index);
/*************************************************************************/
void add_entry_to_queue (USHORT_LINK *sptr_link,USHORT_LINK *sptr_link_to_add)
{
	USHORT_LINK *sptr_previous_entry;

	sptr_link_to_add->previous_entry_index = sptr_link->previous_entry_index;

	if (sptr_link->previous_entry_index != NULL_USHORT_ENTRY)
		{
		sptr_previous_entry = convert_index_to_link (sptr_link->previous_entry_index);

		sptr_previous_entry->next_entry_index = convert_link_to_index (sptr_link_to_add);
		}
	else
		sptr_link->next_entry_index = convert_link_to_index (sptr_link_to_add);
	
	sptr_link->previous_entry_index = convert_link_to_index (sptr_link_to_add);

	sptr_link_to_add->next_entry_index = NULL_USHORT_ENTRY;
}
/*************************************************************************/
void *get_entry_from_queue (USHORT_LINK *sptr_link)
{
	USHORT_LINK	*sptr_return_link;
	USHORT_LINK	*sptr_next_link;

	sptr_return_link = convert_index_to_link (sptr_link->next_entry_index);

	if (sptr_return_link != NULL)
		{
		sptr_next_link = convert_index_to_link (sptr_link->next_entry_index);

		sptr_link->next_entry_index = sptr_next_link->next_entry_index;

		if (sptr_link->next_entry_index != NULL_USHORT_ENTRY)
			{
			sptr_next_link = convert_index_to_link (sptr_link->next_entry_index);
			sptr_next_link->previous_entry_index = NULL_USHORT_ENTRY;
			}
		else 
			sptr_link->previous_entry_index = NULL_USHORT_ENTRY;

		if (sptr_return_link != NULL)
			{
			sptr_return_link->next_entry_index = NULL_USHORT_ENTRY;
			sptr_return_link->previous_entry_index = NULL_USHORT_ENTRY;
			}
		}

	return (sptr_return_link);
}
/*************************************************************************/
void delete_entry_from_queue (USHORT_LINK *sptr_queue_link,USHORT_LINK *sptr_link_to_delete)
{
	USHORT_LINK	*sptr_previous_link;
	USHORT_LINK	*sptr_next_link;

	if (sptr_link_to_delete->next_entry_index == NULL_USHORT_ENTRY &&
		sptr_link_to_delete->previous_entry_index == NULL_USHORT_ENTRY) /* 1 entry in queue */
		{
		sptr_queue_link->next_entry_index = NULL_USHORT_ENTRY;
		sptr_queue_link->previous_entry_index = NULL_USHORT_ENTRY;
		return;
		}

	if (sptr_link_to_delete->previous_entry_index == NULL_USHORT_ENTRY) /* First entry in N (N >= 2) entry queue  */
		sptr_queue_link->next_entry_index = sptr_link_to_delete->next_entry_index; /* new first entry in queue have queue point to it */
	else
		{
		sptr_previous_link = convert_index_to_link (sptr_link_to_delete->previous_entry_index);
		sptr_previous_link->next_entry_index = sptr_link_to_delete->next_entry_index;
		}

	if (sptr_link_to_delete->next_entry_index == NULL_USHORT_ENTRY) /* Last entry in N (N >= 2) entry queue */
		sptr_queue_link->previous_entry_index = sptr_link_to_delete->previous_entry_index; /* new last entry in queue because we're deleting the end*/
	else
		{
		sptr_next_link = convert_index_to_link (sptr_link_to_delete->next_entry_index);

		sptr_next_link->previous_entry_index = sptr_link_to_delete->previous_entry_index;
		}

	sptr_link_to_delete->next_entry_index = NULL_USHORT_ENTRY;
	sptr_link_to_delete->previous_entry_index = NULL_USHORT_ENTRY;
}
/*************************************************************************/
USHORT_LINK *convert_index_to_link (USHORT index)
{
	return (&stp_class.sptr_fd_table->entry[index].links);
}
/*************************************************************************/
USHORT convert_link_to_index (USHORT_LINK *sptr_link)
{
	USHORT return_index;

	return_index = (USHORT) ((BYTE *) sptr_link - (BYTE *) &stp_class.sptr_fd_table->entry[0].links);
	return_index = return_index /sizeof (FILTERING_DATABASE_ENTRY);

	return (return_index);
}

#endif
