/****************************************************************************
 * File	: MACBRFLT.C
 *				Code to perform filtering of bridged packets. In theory filtering
 *				can be on the basis of learned addresses (DELETE_ON_TIMEOUT type
 *				of entries) or on addresses explicitly installed by management 
 *				software (PERMANENT_TABLE_ENTRY type of entries). 
 *
 *				Current code supports only filtering of learned addresses...
 *
 * Date	: 2, Aug, 1995
 * By		: Sanjay S
 * Rev.	: 2, Aug, 1995 - Started coding
 ***************************************************************************/

#include	"defs.h"

#include	<string.h>
#include	<stdlib.h>
#include	<kstart.h>
#include "macbridg.h" 
#include "vmacbr.h"
#include	<lslproto.h>

/*-------------------------------------------------------------------------*/
/* stp_filter()
 * 	Check if the passed packet needs to be filtered. Filtering is done
 *		by looking up the destination address in the hash table of filtering
 *		database entries and seeing if there is a matching entry of 
 *		DELETE_ON_TIMEOUT type or PERMANENT_TABLE_ENTRY type on the same
 *	   input port
 *
 * Params:
 *		Port number packet was received on
 *		Ptr to received buffer (including MAC header which only is used)
 * Returns:
 *		TRUE if the packet needs to be filtered out, FALSE otherwise.
 * NOTE: Currently even broadcast and multicast addresses are looked into.
 *		   maybe they need separate handling based on a separate set of info.
 */
enum BOOLEAN stp_filter (USHORT port_number,ETHERNET_BUFFER *sptr_rx_buffer)
{
	ULONG dest_mac_address_ulong;
	USHORT dest_mac_address_ushort;
	FILTERING_DATABASE_ENTRY	*sptr_matching_fd_entry;


	dest_mac_address_ushort = sptr_rx_buffer->mac_header.destination_address._ushort;
	dest_mac_address_ulong = sptr_rx_buffer->mac_header.destination_address._ulong;

	sptr_matching_fd_entry = (FILTERING_DATABASE_ENTRY *)
		stp_class.sptr_hash_table->entry[dest_mac_address_ushort & stp_class.hash_mask].sptr_forward_link;
	while (sptr_matching_fd_entry != NULL)
	{
		if (sptr_matching_fd_entry->source_address._ushort == dest_mac_address_ushort &&
				sptr_matching_fd_entry->source_address._ulong == dest_mac_address_ulong)
			break;

		sptr_matching_fd_entry = (FILTERING_DATABASE_ENTRY *) sptr_matching_fd_entry->links.sptr_forward_link;
	}

	/*-----------------------------------------------------------------------
	 * NOTE: For now we are not explicitly checking type as there is only
	 *       code to put in DELETE_ON_TIMEOUT or PERMANENT_TABLE_ENTRY types.
	 *---------------------------------------------------------------------*/

	if (sptr_matching_fd_entry != NULL)
	{
		/* filter if only received on same port */
		if (sptr_matching_fd_entry->port_number == port_number)
		{
			return TRUE;
		}
	}
	return FALSE;
}
