#include	"defs.h"
/*	$Modname: macbrmgt.c$  $version: 1.22$      $date: 03/31/95$   */
/*
* 	$lgb$
1.0 01/05/92 ross
1.1 01/25/92 ross
1.2 01/29/92 ross added port_number array stuff for line 88 and 89 read_forwarding_port_counters
1.3 04/22/92 ross
1.4 07/30/92 ross
1.5 07/30/92 ross
1.6 07/30/92 ross
1.7 08/05/92 ross
1.8 08/21/92 ross
1.9 08/22/92 ross Added support for multiple instances of stp_class
1.10 08/22/92 ross made as many functions as possible static
1.11 08/22/92 ross brought this module current.
1.12 11/23/92 ross changed ETHERNET_ADDRESS to MAC_ADDRESS to appear more generic - cosmetic
1.13 01/15/93 ross
1.14 01/18/93 ross changed aging_time to this_bridge.aging_time.
1.15 01/30/93 ross delete references to stp dlci
1.16 07/16/93 ross added some mib statistics
1.17 10/11/93 ross update for changes in LSL, bug in frame relay receive.
1.18 10/28/93 ross removed compile time printf functions.
1.19 01/10/94 ross added BIG_ENDIAN wrapper around addresses.  Thanks to Rick.
1.20 05/09/94 ross added changes for configuring forwarding state for SRT
1.21 06/15/94 ross cosmetic changes and snmp access routines.
1.22 03/31/95 ross Changes for new rwutils library.
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1989 - 1993 Router Engines, Inc.								*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	Router Engines, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
/************************************************************************/
#define	GLOBAL_FILE
#include	<string.h>
#include	<stdlib.h>
#include	<stdio.h>
#include	<stdarg.h>

#include	<kstart.h>

#include "macbridg.h"
#include	"kmgmt.h"
#include	"vmacmstr.h"
#include	"vmacbr.h"

/****************************************************************************/
static void read_bridge (READ_BRIDGE_STATUS *sptr_read_bridge_status);
/****************************************************************************/
enum TEST discover_bridge (READ_BRIDGE_STATUS *sptr_read_bridge_status,MAC_ADDRESS **sptr_low_address,
	MAC_ADDRESS **sptr_high_address,MAC_ADDRESS **sptr_address_exclusion_list)
{
	while (*sptr_low_address != NULL)
		{
		if (compare_addresses (*sptr_low_address,&stp_class.this_bridge.bridge_id.address) == GREATER_THAN)
			{
			if (compare_addresses (*sptr_high_address,&stp_class.this_bridge.bridge_id.address) == LESS_THAN)
				{
				while (compare_addresses (*sptr_address_exclusion_list,&stp_class.this_bridge.bridge_id.address) != EQUAL_TO)
					{
					++sptr_address_exclusion_list;
					}

				if (sptr_address_exclusion_list == NULL)
					{
					read_bridge (sptr_read_bridge_status);
					return (PASS);
					}
				}
			}

		++sptr_low_address;
		++sptr_high_address;
		}

	memset (&sptr_read_bridge_status->mac_address_from_bridge_id,(int) NULL,sizeof (MAC_ADDRESS));

	read_bridge (sptr_read_bridge_status);

	return (FAIL);
}
/****************************************************************************/
static void read_bridge (READ_BRIDGE_STATUS *sptr_read_bridge_status)
{
	memcpy (&sptr_read_bridge_status->mac_address_from_bridge_id,
		&stp_class.this_bridge.bridge_id.address,sizeof (MAC_ADDRESS));

	strcpy (sptr_read_bridge_status->name,(const char *) stp_class.this_bridge.name);

	sptr_read_bridge_status->number_of_ports = stp_class.number_of_spanning_tree_ports;

	sptr_read_bridge_status->uptime = (stp_class.this_bridge.time_up) + (stp_class.this_bridge.time_up / 5);
}
/****************************************************************************/
void set_bridge_name (const char *bptr_bridge_name)
{
	strcpy (stp_class.this_bridge.name,bptr_bridge_name);
}
/****************************************************************************/
void reset_bridge (void)
{
	table_free (stp_class.sptr_fd_table);
	table_free (stp_class.sptr_hash_table);

	initialize_bridge (stp_class.clock_ticks_per_second);
}
/****************************************************************************/
void read_port (USHORT port_number,char *bptr_port_name,enum PORT_TYPE *type_of_port)
{
	strcpy (bptr_port_name,(const char *) stp_class.port[port_number].name);
	*type_of_port = _8023;
}
/****************************************************************************/
void set_port_name (USHORT port_number,const char *bptr_port_name)
{
	strcpy (stp_class.port[port_number].name,bptr_port_name);
}
/****************************************************************************/
void read_forwarding_port_counters (USHORT port_number,PORT_COUNTERS *sptr_port_counters)
{
	sptr_port_counters->number_of_frames_discarded = stp_class.port[port_number].number_of_frames_discarded;
	sptr_port_counters->number_of_frames_forwarded = stp_class.port[port_number].number_of_frames_forwarded;
}
/****************************************************************************/
BYTE	read_transmissions_priority (USHORT port_number)
{
	return (stp_class.port[port_number].port_id.priority);
}
/****************************************************************************/
void set_transmission_priority (USHORT port_number,BYTE priority)
{
	stp_class.port[port_number].port_id.priority = priority;
}
/****************************************************************************/
void *read_filtering_database (void)
{
	return (stp_class.sptr_fd_table);
}
/****************************************************************************/
void set_filtering_database_aging_time (ULONG time)
{
	stp_class.this_bridge.aging_time_for_fd = time;
}
/****************************************************************************/
void read_permanent_database (PERMANENT_DATABASE_STATUS *sptr_permanent_database_status)
{
	USHORT	number_of_entries;
	USHORT	entry_number;
	FILTERING_DATABASE_ENTRY *sptr_current_entry;

	sptr_current_entry = stp_class.sptr_first_entry_in_fd_table;

	for (number_of_entries = 0x0000,entry_number = 0x0000 ; entry_number <= stp_class.number_of_fd_entries;
		++entry_number,++sptr_current_entry)
		{
		if (sptr_current_entry->port_number != 0x00)
			{
			++number_of_entries;
			}
		}

	sptr_permanent_database_status->maximum_number_of_entries = 256;
	sptr_permanent_database_status->current_number_of_entries = number_of_entries;
}
/****************************************************************************/
void create_filtering_entry (enum FILTERING_DATABASE_TYPE filtering_database_type,MAC_ADDRESS *sptr_mac_address_to_add,
	PORT_MAP *sptr_port_map)
{
	if (filtering_database_type == FILTERING_DATABASE)
		add_entry_to_filtering_database (sptr_mac_address_to_add->_ushort,sptr_mac_address_to_add->_ulong,
			sptr_port_map->inbound_port_number,DELETE_ENTRY_ON_TIMEOUT);
	else
		add_entry_to_filtering_database (sptr_mac_address_to_add->_ushort,sptr_mac_address_to_add->_ulong,
		sptr_port_map->inbound_port_number,PERMANENT_TABLE_ENTRY);
}
/****************************************************************************/
void delete_filtering_entry (enum FILTERING_DATABASE_TYPE filtering_database_type,
	MAC_ADDRESS *sptr_mac_address_to_delete)
{
	FILTERING_DATABASE_ENTRY	*sptr_matching_fde;

	sptr_matching_fde =
		find_source_address ((LINK *)
		&stp_class.sptr_hash_table->entry[sptr_mac_address_to_delete->_ushort],
		sptr_mac_address_to_delete->_ushort,sptr_mac_address_to_delete->_ulong);

	if (sptr_matching_fde != NULL)
		{
		if (filtering_database_type == FILTERING_DATABASE && sptr_matching_fde->type ==
			DELETE_ENTRY_ON_TIMEOUT || filtering_database_type == PERMANENT_DATABASE &&
			sptr_matching_fde->type == PERMANENT_TABLE_ENTRY)
			{
 			delete_entry_from_queue ((LINK *)
				&stp_class.sptr_hash_table->entry[sptr_matching_fde->source_address._ushort & stp_class.hash_mask].sptr_forward_link,
				&sptr_matching_fde->links);
			}
		}
}
/****************************************************************************/
FILTERING_DATABASE_ENTRY *find_source_address (LINK *sptr_queue_entry,USHORT source_mac_address_ushort,
	ULONG source_mac_address_ulong)
{
	while (sptr_queue_entry->sptr_forward_link != NULL)
		{
		if (((FILTERING_DATABASE_ENTRY *) sptr_queue_entry->sptr_forward_link)->source_address._ushort ==
			source_mac_address_ushort 
			&& ((FILTERING_DATABASE_ENTRY *) sptr_queue_entry->sptr_forward_link)->source_address._ulong == 
			source_mac_address_ulong)
			{
			break;
			}

		sptr_queue_entry = (LINK *) sptr_queue_entry->sptr_forward_link;
		}

	return ((FILTERING_DATABASE_ENTRY *) sptr_queue_entry->sptr_forward_link);
}
/****************************************************************************/
void read_filtering_entry (enum FILTERING_DATABASE_TYPE filtering_database_type,
	MAC_ADDRESS *sptr_mac_address_to_read,FILTERING_ENTRY_STATUS *sptr_filtering_entry_status)
{
	FILTERING_DATABASE_ENTRY	*sptr_matching_fde;

	sptr_matching_fde =
		find_source_address ((LINK *)
		&stp_class.sptr_hash_table->entry[sptr_mac_address_to_read->_ushort],
		sptr_mac_address_to_read->_ushort,sptr_mac_address_to_read->_ulong);

	if (sptr_matching_fde != NULL)
		{
		if (filtering_database_type == FILTERING_DATABASE && sptr_matching_fde->type ==
			DELETE_ENTRY_ON_TIMEOUT || filtering_database_type == PERMANENT_DATABASE &&
			sptr_matching_fde->type == PERMANENT_TABLE_ENTRY)
			{
			sptr_filtering_entry_status->filtering_mac_address = *sptr_mac_address_to_read;
			sptr_filtering_entry_status->union_filtering_port.dynamic_port_number = sptr_matching_fde->port_number;
			}
		}
}
/****************************************************************************/
void read_filtering_entry_range (enum FILTERING_DATABASE_TYPE filtering_database_type,
	USHORT database_start_index,USHORT database_stop_index,FILTERING_ENTRY_STATUS *sptr_filtering_entry_status)
{
	USHORT database_index;

	FILTERING_DATABASE_ENTRY	*sptr_matching_fde;

	for (database_index = database_start_index; database_index <= database_stop_index; ++database_index)
		{
		sptr_matching_fde = (FILTERING_DATABASE_ENTRY *) stp_class.sptr_hash_table->entry[database_index].sptr_forward_link;

		if (filtering_database_type == FILTERING_DATABASE && sptr_matching_fde->type ==
			DELETE_ENTRY_ON_TIMEOUT || filtering_database_type == PERMANENT_DATABASE &&
			sptr_matching_fde->type == PERMANENT_TABLE_ENTRY)
			{
			sptr_filtering_entry_status->filtering_mac_address = sptr_matching_fde->source_address;
			sptr_filtering_entry_status->union_filtering_port.dynamic_port_number = sptr_matching_fde->port_number;
			break;
			}
		}
}
/****************************************************************************/
BRIDGE_PARAMETERS	*read_bridge_parameters (void)
{
	return ((BRIDGE_PARAMETERS *)&stp_class.this_bridge);
}
/****************************************************************************/
void set_bridge_parameters (USHORT bridge_max_age,USHORT hello_time,USHORT forward_delay,USHORT bridge_priority)
{
	stp_class.this_bridge.bridge_id.priority = bridge_priority;
	stp_class.this_bridge.bridge_max_age = bridge_max_age;
	stp_class.this_bridge.bridge_hello_time = hello_time;
	stp_class.this_bridge.bridge_forward_delay = forward_delay;
}
/****************************************************************************/
UNION_FILTERING_STP_PORT_CLASS *read_port_parameters (USHORT port_number)
{
	return ((UNION_FILTERING_STP_PORT_CLASS *)&stp_class.port[port_number]);
}
/****************************************************************************/
void force_port_state (USHORT port_number,enum PORT_STATE state)
{
	stp_class.port[port_number].state = state;
}
/****************************************************************************/
void set_port_parameters (USHORT port_number,USHORT path_cost,BYTE port_priority)
{
	stp_class.port[port_number].path_cost = path_cost;
	stp_class.port[port_number].port_id.priority = port_priority;
}
/****************************************************************************/
enum BOOLEAN stp_forwarding_enabled (USHORT port_number)
{
	if (stp_class.port[port_number + 1].state == FORWARDING)
		return (TRUE);
	else
		return (FALSE);
}
/*************************************************************************/
void enable_or_disable_stp_printing (enum BOOLEAN enable_or_disable)
{
	stp_class.stp_printing_enabled = enable_or_disable;
}
/*************************************************************************/
void enable_or_disable_stp_group_printing (enum BOOLEAN enable_or_disable,enum STP_PRINTF_GROUPS printf_group)
{
	switch (printf_group)
		{
		case STP_MEMORY_PRINTF:
			stp_class.memory_printing_enabled = enable_or_disable;
			break;
		case STP_ALARM_PRINTF:
			stp_class.alarm_printing_enabled = enable_or_disable;
			break;
		case STP_SNMP_PRINTF:
			stp_class.snmp_printing_enabled = enable_or_disable;
			break;
		case STP_DATA_PRINTF:
			stp_class.data_printing_enabled = enable_or_disable;
			break;
		}
}
/*************************************************************************/
void stp_printf (enum STP_PRINTF_GROUPS printf_group,const char *cptr_format, ...)
{
	enum BOOLEAN print_string;

	va_list argptr;

	va_start (argptr,cptr_format);

	if (stp_class.stp_printing_enabled == FALSE)
		{
		va_end (argptr);

		return;
		}

	print_string = FALSE;

	switch (printf_group)
		{
		case STP_MEMORY_PRINTF:
			print_string = stp_class.memory_printing_enabled;
			break;
		case STP_ALARM_PRINTF:
			print_string = stp_class.alarm_printing_enabled;
			break;
		case STP_SNMP_PRINTF:
			print_string = stp_class.snmp_printing_enabled;
			break;
		case STP_DATA_PRINTF:
			print_string = stp_class.data_printing_enabled;
			break;
		}

	if (print_string == TRUE) 
		vprintf (cptr_format,argptr);

	va_end (argptr);
}
#ifdef DEBUG
/****************************************************************************/
ULONG counter_t;
/****************************************************************************/
void display_spanning_tree_packet (USHORT port_number,ETHERNET_BUFFER *sptr_rx_packet,USHORT size_of_packet)
{
	stp_printf (STP_DATA_PRINTF,"Port Number %04x ",port_number);

	if (stp_class.port[port_number].token_ring == TRUE)
		{
		sptr_rx_packet = (ETHERNET_BUFFER *) ((ULONG) sptr_rx_packet + 2);
		}

	stp_printf (STP_DATA_PRINTF,"Dest %08lx%04x ",swap_long (sptr_rx_packet->mac_header.destination_address._ulong),
		swap (sptr_rx_packet->mac_header.destination_address._ushort));
	stp_printf (STP_DATA_PRINTF,"Src %08lx%04x ",swap_long (sptr_rx_packet->mac_header.source_address._ulong),
		swap (sptr_rx_packet->mac_header.source_address._ushort));

	if (sptr_rx_packet->mac_header.destination_address._ushort == 0x0000)
		++counter_t;

	stp_printf (STP_DATA_PRINTF,"Size %04x\r\n",size_of_packet);
}
#endif
