#include "defs.h"
/*	$Modname: macbrspn.c$  $version: 1.30$      $date: 03/31/95$   */
/*
* 	$lgb$
1.0 01/05/92 ross
1.1 01/25/92 ross
1.2 04/22/92 ross
1.3 07/30/92 ross
1.4 07/30/92 ross
1.5 07/30/92 ross
1.6 07/31/92 ross
1.7 08/05/92 ross
1.8 08/21/92 ross
1.9 08/22/92 ross Added support for multiple instances of stp_class
1.10 08/22/92 ross made as many functions as possible static
1.11 11/23/92 ross changed ETHERNET_ADDRESS to MAC_ADDRESS to appear more generic (cosmetic)
1.12 01/15/93 ross changed 1992 to 1993.
1.13 01/29/93 ross changed get_nvram port parameters to use port_number - 1.
1.14 01/29/93 ross fixed nvram problem with port parameters.
1.15 02/28/93 ross deleted reference to vlibstr.h
1.16 07/16/93 ross added some mib statistics
1.17 07/18/93 ross added check for token ring boolean in the initialize data structures routine.
1.18 07/18/93 ross fixed another occurance of token ring bug.
1.19 07/23/93 ross small modification to sptr_mac_address.
1.20 10/28/93 ross delete nvram header
1.21 10/28/93 ross delete end-of-file symbol.
1.22 01/13/94 ross added setting the filtering database aging time when a topology change occurs.  Courtesy of Helen.
1.23 02/02/94 ross took out frame relay header and fixed big endian problems.  Courtesy of Rick.
1.24 03/07/94 ross removed external references to mac_address, function used instead.
1.25 05/09/94 ross added changes for configuring forwarding state for SRT
1.26 06/15/94 ross cosmetic changes and snmp access routines.
1.27 07/21/94 ross fixed bug with topology change.  Courtesy of sanjeev.
1.28 07/29/94 ross record_port_infor... add 1 to root path cost.  Courtesy of Sanjeev.
1.29 08/25/94 ross Added an enum cast for some compiler warnings.
1.30 03/31/95 ross Changes for new rwutils library.
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1989 - 1993 Router Engines, Inc.								*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	Router Engines, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
/************************************************************************/
#include	<kstart.h>
#include "macbridg.h"
#include "vmacbr.h"
#include	<lslproto.h>
/****************************************************************************/
static void setup_this_bridge_values (void);
static void initialize_mac_bridge_data_structures (USHORT port_number);
static void record_configuration_port_information (USHORT port_number,BRIDGE_CONFIGURATION_BPDU *sptr_bridge_configuration_BPDU);
static void record_hello_timeout_values (BRIDGE_CONFIGURATION_BPDU *sptr_bridge_configuration_BPDU);
static void reply (USHORT port_number);
static void root_selection (void);
static void designated_port_selection (void);
static void make_forwarding (USHORT port_number);
static void make_blocking (USHORT port_number);
static void topology_change_acknowledgement (void);
static void acknowledge_topology_change (USHORT port_number);
static enum BOOLEAN supercedes_port_info (USHORT port_number,BRIDGE_CONFIGURATION_BPDU *sptr_bridge_configuration_BPDU);
#ifdef NEW_FILTERING
extern add_other_filters_to_static_forwarding_table () ;
#endif
/****************************************************************************/
void initialize_bridge_spanning_tree (void)
{
	BYTE	port_number;

	stp_printf (STP_ALGORITHM_PRINTF,"initialize bridge \n\r");

	add_bridge_addresses_to_static_forwarding_table ();

#ifdef NEW_FILTERING
	add_other_filters_to_static_forwarding_table () ;
#endif
	setup_this_bridge_values ();

	set_timer (&stp_class.topology_change_notification_timer,STOP_TIMER);
	set_timer (&stp_class.topology_change_timer,STOP_TIMER);

	for (port_number = 0x01; port_number <= stp_class.number_of_spanning_tree_ports ; port_number += (BYTE) 1)
		{
		initialize_port (port_number);

		initialize_mac_bridge_data_structures (port_number);
		}

	port_state_selection ();

	configuration_BPDU_generation ();

	set_timer (&stp_class.hello_timer,START_TIMER);
}
/****************************************************************************/
static void setup_this_bridge_values (void)
{
/*	stp_class.stp_algorithm_enabled = TRUE; */

	stp_class.this_bridge.aging_time_for_fd = AGEING_TIME_FOR_FILTERING_DATABASE;

	lsl_control (GET_MAC_ADDRESS,0x0000,stp_class.stack_id,&stp_class.this_bridge.bridge_id.address);

	stp_class.this_bridge.bridge_id.priority = BRIDGE_PRIORITY;

	stp_class.this_bridge.bridge_max_age = MAXIMUM_AGE;
	stp_class.this_bridge.bridge_hello_time = HELLO_TIME;
	stp_class.this_bridge.bridge_forward_delay = FORWARD_DELAY_TIME;

	lsl_control (GET_MAC_ADDRESS,0x0000,stp_class.stack_id,&stp_class.this_bridge.root_id.address);

	stp_class.this_bridge.root_id.priority = BRIDGE_PRIORITY;

	stp_class.this_bridge.root_path_cost = 0x00000000L;

	stp_class.this_bridge.root_port_id.priority = PORT_PRIORITY;
	stp_class.this_bridge.root_port_id.number = 0x01;

	stp_class.this_bridge.max_age = stp_class.this_bridge.bridge_max_age; 
	stp_class.this_bridge.hello_time = stp_class.this_bridge.bridge_hello_time; 
	stp_class.this_bridge.forward_delay = stp_class.this_bridge.bridge_forward_delay; 

	stp_class.this_bridge.topology_change_detected = FALSE;
	stp_class.this_bridge.topology_change = FALSE;
	stp_class.this_bridge.topology_change_time = MAXIMUM_AGE + FORWARD_DELAY_TIME;

	stp_class.this_bridge.hold_time = HELLO_TIME;

/*	set_nvram_configuration (STP_THIS_BRIDGE_VALUES,&stp_class.this_bridge,NULL); */
}
/****************************************************************************/
void initialize_port (USHORT port_number)
{
/*	if (get_nvram_configuration (STP_PORT_VALUES,&stp_class.port[port_number],port_number - 1) == FALSE) */

	if (stp_class.port[port_number].path_cost == 0x0000)
		{
		stp_class.port[port_number].path_cost = ETHERNET_PATH_COST;
		}

	if (stp_class.port[port_number].message_age.value == 0x0000)
		{
		stp_class.port[port_number].message_age.value = MAXIMUM_AGE;
		}

	if (stp_class.port[port_number].hold_time.value == 0x0000)
		{
		stp_class.port[port_number].hold_time.value = HELLO_TIME;
		}

	if (stp_class.port[port_number].forward_delay.value == 0x0000)
		{
		stp_class.port[port_number].forward_delay.value = FORWARD_DELAY_TIME;
		}

	if (stp_class.port[port_number].port_id.priority == 0x0000)
		{
		stp_class.port[port_number].port_id.priority = PORT_PRIORITY;
		}

	if (stp_class.port[port_number].state != DISABLED)
	{
		if (stp_class.stp_algorithm_enabled)
			stp_class.port[port_number].state = BLOCKING;
		else
			stp_class.port[port_number].state = FORWARDING;
	}

	stp_class.port[port_number].dot1dStpPortEnable = TRUE;
	stp_class.port[port_number].topology_change_acknowledgement = FALSE;
	stp_class.port[port_number].configuration_pending = FALSE;
	stp_class.port[port_number].port_id.number = (BYTE) port_number;

/*	set_nvram_configuration (STP_PORT_VALUES,&stp_class.port[port_number],port_number - 1);
*/
	become_designated_port (port_number);

	set_timer (&stp_class.port[port_number].message_age,STOP_TIMER);
	set_timer (&stp_class.port[port_number].forward_delay,STOP_TIMER);
	set_timer (&stp_class.port[port_number].hold_time,STOP_TIMER);
}
/****************************************************************************/
static void initialize_mac_bridge_data_structures (USHORT port_number)
{
	if (stp_class.port[port_number].token_ring == TRUE)
		{
		stp_class.bridge_configuration_BPDU[port_number].mac_header.destination_address = token_ring_bridge_group_address;
		}
	else
		{
		stp_class.bridge_configuration_BPDU[port_number].mac_header.destination_address = bridge_group_address;
		}

	lsl_control (GET_MAC_ADDRESS,port_number - 1,stp_class.stack_id,&stp_class.port[port_number].mac_address);

	stp_class.bridge_configuration_BPDU[port_number].mac_header.source_address = stp_class.port[port_number].mac_address;

	stp_class.bridge_configuration_BPDU[port_number].mac_header.length =
		swap (sizeof (BRIDGE_CONFIGURATION_BPDU) - sizeof (ETHERNET_HEADER));

	stp_class.bridge_configuration_BPDU[port_number].LLC_header.destination_address_DSAP =
		(BYTE_ENUM (SAP_TYPES)) LSAP_BRIDGE_SPANNING_TREE_PROTOCOL;
	stp_class.bridge_configuration_BPDU[port_number].LLC_header.source_address_SSAP =
		(BYTE_ENUM (SAP_TYPES)) LSAP_BRIDGE_SPANNING_TREE_PROTOCOL;
	stp_class.bridge_configuration_BPDU[port_number].LLC_header.llc_frame_type = (BYTE_ENUM (LLC_FRAME_TYPE)) UNNUMBERED_INFORMATION;

	stp_class.bridge_configuration_BPDU[port_number].type = CONFIGURATION;
	stp_class.bridge_configuration_BPDU[port_number].protocol_version_ID = VERSION_ID;

	if (stp_class.port[port_number].token_ring == TRUE)
		convert_ethernet_header_to_token_ring ((ETHERNET_HEADER *) &stp_class.bridge_configuration_BPDU[port_number].mac_header);

	if (stp_class.port[port_number].token_ring == TRUE)
		{
		stp_class.bridge_topology_change_notification[port_number].mac_header.destination_address =
			token_ring_bridge_group_address;
		}
	else
		{
		stp_class.bridge_topology_change_notification[port_number].mac_header.destination_address =
			bridge_group_address;
		}

	lsl_control (GET_MAC_ADDRESS,port_number,stp_class.stack_id,
		&stp_class.bridge_topology_change_notification[port_number].mac_header.source_address);

	stp_class.bridge_topology_change_notification[port_number].mac_header.length =
		swap (sizeof (BRIDGE_TOPOLOGY_CHANGE_NOTIFICATION) - sizeof (ETHERNET_HEADER));

	stp_class.bridge_topology_change_notification[port_number].LLC_header.destination_address_DSAP =
		(BYTE_ENUM (SAP_TYPES)) LSAP_BRIDGE_SPANNING_TREE_PROTOCOL;

	stp_class.bridge_topology_change_notification[port_number].LLC_header.source_address_SSAP =
		(BYTE_ENUM (SAP_TYPES)) LSAP_BRIDGE_SPANNING_TREE_PROTOCOL;

	stp_class.bridge_topology_change_notification[port_number].LLC_header.llc_frame_type = (BYTE_ENUM (LLC_FRAME_TYPE)) UNNUMBERED_INFORMATION;
	stp_class.bridge_topology_change_notification[port_number].type = (BYTE_ENUM (BPDU_TYPE)) TOPOLOGY_CHANGE;
	stp_class.bridge_topology_change_notification[port_number].protocol_version_ID = VERSION_ID;

	if (stp_class.port[port_number].token_ring == TRUE)
		{
		convert_ethernet_header_to_token_ring ((ETHERNET_HEADER *) 
			&stp_class.bridge_topology_change_notification[port_number].mac_header);
		}
}
/****************************************************************************/
void transmit_configuration (USHORT port_number)
{
	if (stp_class.port[port_number].state == DISABLED)
		return;

	if (stp_class.port[port_number].hold_time.active == START_TIMER)
		{
		stp_class.port[port_number].configuration_pending = TRUE;
		}
	else
		{
		stp_class.bridge_configuration_BPDU[port_number].root_id = stp_class.this_bridge.root_id;
		stp_class.bridge_configuration_BPDU[port_number].root_path_cost = stp_class.this_bridge.root_path_cost;
		stp_class.bridge_configuration_BPDU[port_number].bridge_id = stp_class.this_bridge.bridge_id;
		stp_class.bridge_configuration_BPDU[port_number].port_id =
			stp_class.port[port_number].port_id;

		if (root_bridge () == TRUE)
			{
			stp_class.bridge_configuration_BPDU[port_number].message_age = 0x0000;
			}
		else
			{
			stp_class.bridge_configuration_BPDU[port_number].message_age = (USHORT) 
				(stp_class.port[stp_class.this_bridge.root_port_id.number].message_age.value + MESSAGE_AGE_INCREMENT);
			}

		stp_class.bridge_configuration_BPDU[port_number].max_age = stp_class.this_bridge.max_age;
		stp_class.bridge_configuration_BPDU[port_number].hello_time = stp_class.this_bridge.hello_time;
		stp_class.bridge_configuration_BPDU[port_number].forward_delay = stp_class.this_bridge.forward_delay;

		stp_class.bridge_configuration_BPDU[port_number].flags.topology_change_acknowledgement =
			stp_class.port[port_number].topology_change_acknowledgement;

		stp_class.port[port_number].topology_change_acknowledgement = FALSE;

		stp_class.bridge_configuration_BPDU[port_number].flags.topology_change = stp_class.this_bridge.topology_change;

		send_mac_bridge_PDU (port_number,&stp_class.bridge_configuration_BPDU[port_number],sizeof (BRIDGE_CONFIGURATION_BPDU));

		stp_class.port[port_number].configuration_pending = FALSE;

		stp_printf (STP_ALGORITHM_PRINTF,"start hold timer \n\r",port_number);

		set_timer (&stp_class.port[port_number].hold_time,START_TIMER);

		stp_printf (STP_ALGORITHM_PRINTF,"transmit configuration %04x\n\r",port_number);
		}
}
/****************************************************************************/   /** 4.6.2 */ 
enum BOOLEAN root_bridge (void)
{
	if (compare_identifiers (&stp_class.this_bridge.root_id,&stp_class.this_bridge.bridge_id) == EQUAL_TO)
		{
		return (TRUE);
		}
	else
		{
		return (FALSE);
		}
}
/****************************************************************************/    /** 4.6.2 */ 
static void record_configuration_port_information (USHORT port_number,BRIDGE_CONFIGURATION_BPDU *sptr_bridge_configuration_BPDU)
{
	stp_class.port[port_number].designated_root_id = sptr_bridge_configuration_BPDU->root_id;

	stp_class.port[port_number].designated_root_path_cost =
		sptr_bridge_configuration_BPDU->root_path_cost + 1;

	stp_class.port[port_number].designated_bridge_id = sptr_bridge_configuration_BPDU->bridge_id;
	stp_class.port[port_number].designated_port_id = sptr_bridge_configuration_BPDU->port_id;

	start_message_age_timer (&stp_class.port[port_number].message_age,START_TIMER,
		sptr_bridge_configuration_BPDU->message_age);
}
/****************************************************************************/   /** 4.6.3 */ 
static void record_hello_timeout_values (BRIDGE_CONFIGURATION_BPDU *sptr_bridge_configuration_BPDU)
{
	stp_class.this_bridge.max_age = sptr_bridge_configuration_BPDU->max_age;
	stp_class.this_bridge.hello_time = sptr_bridge_configuration_BPDU->hello_time;
	stp_class.this_bridge.forward_delay = sptr_bridge_configuration_BPDU->forward_delay;
	stp_class.this_bridge.topology_change = (enum BOOLEAN) sptr_bridge_configuration_BPDU->flags.topology_change;
}
/****************************************************************************/   /** 4.6.4 */ 
void configuration_BPDU_generation (void)
{
	USHORT port_number;

	stp_printf (STP_ALGORITHM_PRINTF,"configuration generation \n\r");

	for (port_number = 0x0001; port_number <= stp_class.number_of_spanning_tree_ports ; ++port_number)
		{
		if (designated_port (port_number) == TRUE && stp_class.port[port_number].state != DISABLED)
			{
			transmit_configuration (port_number);
			}
		}
}
/****************************************************************************/
enum BOOLEAN designated_port (USHORT port_number)
{
	if (compare_identifiers (&stp_class.this_bridge.bridge_id,
		&stp_class.port[port_number].designated_bridge_id) == EQUAL_TO)
		{
		if (stp_class.port[port_number].designated_port_id.number ==
			stp_class.port[port_number].port_id.number)
			{
			if (stp_class.port[port_number].state != DISABLED)
				{
				return (TRUE);
				}
			}
		}

	return (FALSE);
}
/****************************************************************************/
static void reply (USHORT port_number)
{
	stp_printf (STP_ALGORITHM_PRINTF,"reply %02x\n\r",port_number);

	transmit_configuration (port_number);
}
/****************************************************************************/
void transmit_topology_change_notification (void)
{
	stp_printf (STP_ALGORITHM_PRINTF,"transmit topology change notification  \n\r");

 	send_mac_bridge_PDU (stp_class.this_bridge.root_port_id.number,
		(BRIDGE_CONFIGURATION_BPDU *) &stp_class.bridge_topology_change_notification[stp_class.this_bridge.root_port_id.number],
			sizeof (BRIDGE_TOPOLOGY_CHANGE_NOTIFICATION));
}
/****************************************************************************/
void configuration_update (void)
{
	stp_printf (STP_ALGORITHM_PRINTF,"configuration update  \n\r");

	root_selection ();

	designated_port_selection ();
}
/****************************************************************************/
static void root_selection (void)
{
	USHORT port_number;
	BYTE root_port;

	root_port = NO_PORT;

	for (port_number = 0x0001; port_number <= stp_class.number_of_spanning_tree_ports ; ++port_number)
		{
		/* 4.6.8.3.1 */
		if ((designated_port (port_number) == FALSE) && 
			stp_class.port[port_number].state != DISABLED &&
			(compare_identifiers (&stp_class.port[port_number].designated_root_id,
			&stp_class.this_bridge.bridge_id) == LESS_THAN)) /* select a new root! */
			{
			/* 4.6.8.3.1 (1) */
			if (root_port == NO_PORT ||
				compare_identifiers (&stp_class.port[port_number].designated_root_id,
					&stp_class.port[root_port].designated_root_id) == LESS_THAN)
				{
				root_port = (BYTE) port_number;
				}
			/* 4.6.8.3.1 (2) */
			else if (compare_identifiers (&stp_class.port[port_number].designated_root_id,
				&stp_class.port[root_port].designated_root_id) == EQUAL_TO &&
				stp_class.port[port_number].path_cost +
				stp_class.port[port_number].designated_root_path_cost <
				stp_class.port[root_port].path_cost +
				stp_class.port[root_port].designated_root_path_cost)
				{
				root_port = (BYTE) port_number;
				}
			/* 4.6.8.3.1 (3) */
			else if (compare_identifiers (&stp_class.port[port_number].designated_root_id,
				&stp_class.port[root_port].designated_root_id) == EQUAL_TO &&
				stp_class.port[port_number].path_cost +
				stp_class.port[port_number].designated_root_path_cost ==
				stp_class.port[root_port].path_cost +
				stp_class.port[root_port].designated_root_path_cost &&
				compare_identifiers (&stp_class.port[port_number].designated_bridge_id,
				&stp_class.port[root_port].designated_bridge_id) == LESS_THAN)
				{
				root_port = (BYTE) port_number;
				}
			/* 4.6.8.3.1 (4) */
			else if (compare_identifiers (&stp_class.port[port_number].designated_root_id,
				&stp_class.port[root_port].designated_root_id) == EQUAL_TO &&
				stp_class.port[port_number].path_cost +
				stp_class.port[port_number].designated_root_path_cost ==
				stp_class.port[root_port].path_cost +
				stp_class.port[root_port].designated_root_path_cost &&
				compare_identifiers (&stp_class.port[port_number].designated_bridge_id,
				&stp_class.port[root_port].designated_bridge_id) == EQUAL_TO &&
				compare_port_identifiers (&stp_class.port[port_number].designated_port_id,
				&stp_class.port[root_port].designated_port_id) == LESS_THAN)
					{
					root_port = (BYTE) port_number;
					}
			/* 4.6.8.3.1 (5) */
			else if (compare_identifiers (&stp_class.port[port_number].designated_root_id,
				&stp_class.port[root_port].designated_root_id) == EQUAL_TO &&
				stp_class.port[port_number].path_cost +
				stp_class.port[port_number].designated_root_path_cost ==
				stp_class.port[root_port].path_cost +
				stp_class.port[root_port].designated_root_path_cost &&
				compare_identifiers (&stp_class.port[port_number].designated_bridge_id,
				&stp_class.port[root_port].designated_bridge_id) == EQUAL_TO &&
				compare_port_identifiers (&stp_class.port[port_number].designated_port_id,
				&stp_class.port[root_port].designated_port_id) == EQUAL_TO &&
				compare_port_identifiers (&stp_class.port[port_number].port_id,
				&stp_class.port[root_port].port_id) == LESS_THAN)
				{
				root_port = (BYTE) port_number;
				}
			}

		stp_class.this_bridge.root_port_id.number = root_port;

		if (root_port == NO_PORT) /* I am the root */
			{
			if (compare_identifiers (&stp_class.this_bridge.root_id,&stp_class.this_bridge.bridge_id) != EQUAL_TO)
				{
				if (stp_class.fptr_new_root != NULL)
					{
					(*stp_class.fptr_new_root) ();
					}
				}

			stp_class.this_bridge.root_id = stp_class.this_bridge.bridge_id;
			stp_class.this_bridge.root_path_cost = 0x00000000L;

			/* in record_hello_timeout_values we may overwritten these so reset them to bridge management initial values */

			stp_class.this_bridge.max_age = stp_class.this_bridge.bridge_max_age; 
			stp_class.this_bridge.hello_time = stp_class.this_bridge.bridge_hello_time; 
			stp_class.this_bridge.forward_delay = stp_class.this_bridge.bridge_forward_delay; 
			}
		else /* somebody else is the root */
			{
			if (compare_identifiers (&stp_class.this_bridge.root_id,
				&stp_class.port[root_port].designated_root_id) != EQUAL_TO)
				{
				if (stp_class.fptr_new_root != NULL)
					{
					(*stp_class.fptr_new_root) ();
					}
				}

			stp_class.this_bridge.root_id = stp_class.port[root_port].designated_root_id;
			stp_class.this_bridge.root_path_cost = (USHORT) (stp_class.port[root_port].designated_root_path_cost +
				stp_class.port[root_port].path_cost);
			}
		}
}
/****************************************************************************/
static void designated_port_selection (void)
{
	USHORT port_number;

	for (port_number = 0x0001; port_number <= stp_class.number_of_spanning_tree_ports ; ++port_number)
		{
		/* remember that the designated port can contain anybodys bridge address for the designated bridge including my own */

		if (stp_class.port[port_number].state != DISABLED)
			{
			if (designated_port (port_number) == TRUE || /* 4.6.9.3.1 */
				(compare_identifiers (&stp_class.port[port_number].designated_root_id,
				&stp_class.this_bridge.root_id) != EQUAL_TO) || /* 4.6.9.3.2 */
				(stp_class.this_bridge.root_path_cost < stp_class.port[port_number].designated_root_path_cost)) /* 4.6.9.3.3 */
				{
				become_designated_port (port_number);
				}
			else if (stp_class.this_bridge.root_path_cost ==
				stp_class.port[port_number].designated_root_path_cost &&	/* 4.6.9.3.4 */
				compare_identifiers (&stp_class.this_bridge.bridge_id,
				&stp_class.port[port_number].designated_bridge_id) == LESS_THAN)
				{
				become_designated_port (port_number);
				}
			else if (stp_class.this_bridge.root_path_cost ==
				stp_class.port[port_number].designated_root_path_cost && /* 4.6.9.3.5 */
				compare_identifiers (&stp_class.this_bridge.bridge_id,
				&stp_class.port[port_number].designated_bridge_id) == EQUAL_TO &&
				compare_port_identifiers (&stp_class.port[port_number].port_id,
				&stp_class.port[port_number].designated_port_id) != GREATER_THAN)
				{
				become_designated_port (port_number);
				}
			}
		}
}
/****************************************************************************/
void become_designated_port (USHORT port_number)
{
	stp_printf (STP_ALGORITHM_PRINTF,"become designated port %02x\n\r",port_number);

	stp_class.port[port_number].designated_root_id = stp_class.this_bridge.root_id;
	stp_class.port[port_number].designated_root_path_cost = stp_class.this_bridge.root_path_cost;
	stp_class.port[port_number].designated_bridge_id = stp_class.this_bridge.bridge_id;
	stp_class.port[port_number].designated_port_id = stp_class.port[port_number].port_id;
}
/****************************************************************************/  /** 4.6.11 */ 
void port_state_selection (void)
{
	BYTE	port_number;

	for (port_number = 0x0001; port_number <= stp_class.number_of_spanning_tree_ports ; port_number += (BYTE) 1)
		{
		if (port_number == stp_class.this_bridge.root_port_id.number)
			{
			stp_class.port[port_number].configuration_pending = FALSE;
			stp_class.port[port_number].topology_change_acknowledgement = FALSE;

			stp_printf (STP_ALGORITHM_PRINTF,"root port %02x\n\r",port_number);

			make_forwarding (port_number);
			}
		else if (designated_port (port_number) == TRUE)
			{
			stp_printf (STP_ALGORITHM_PRINTF,"designated port %02x\n\r",port_number);

			set_timer (&stp_class.port[port_number].message_age,STOP_TIMER);

			make_forwarding (port_number);
			}
		else
			{
			stp_printf (STP_ALGORITHM_PRINTF,"blocking port %02x\n\r",port_number);

			stp_class.port[port_number].configuration_pending = FALSE;
			stp_class.port[port_number].topology_change_acknowledgement = FALSE;

			make_blocking (port_number);
			}
		}
}
/****************************************************************************/
static void make_forwarding (USHORT port_number)
{
	if (stp_class.port[port_number].state == BLOCKING)
		{
		stp_class.port[port_number].state = LISTENING;

		stp_printf (STP_ALGORITHM_PRINTF,"listening started %02x\n\r",port_number);

		set_timer (&stp_class.port[port_number].forward_delay,START_TIMER);
		}
}
/****************************************************************************/
static void make_blocking (USHORT port_number)
{
	if (stp_class.port[port_number].state != DISABLED &&
		stp_class.port[port_number].state != BLOCKING)
		{
		if (stp_class.port[port_number].state == FORWARDING || stp_class.port[port_number].state == LEARNING)
			{
			topology_change_detection ();
			}

		stp_printf (STP_ALGORITHM_PRINTF,"blocking started %02x\n\r",port_number);

		stp_class.port[port_number].state = BLOCKING;

		set_timer  (&stp_class.port[port_number].forward_delay,STOP_TIMER);
		}
}
/****************************************************************************/
void topology_change_detection (void)
{
	stp_printf (STP_ALGORITHM_PRINTF,"topology change detection\n\r");

	if (stp_class.fptr_topology_change_detection != NULL)
		{
		(*stp_class.fptr_topology_change_detection) ();
		}

	stp_class.this_bridge.aging_time_for_fd = FORWARD_DELAY_TIME / TIMER_GRANULARITY;

	if (root_bridge () == TRUE)
		{
		stp_class.this_bridge.topology_change = TRUE;

		set_timer (&stp_class.topology_change_timer,START_TIMER);
		}
	else if (stp_class.this_bridge.topology_change_detected == FALSE)
		{
		transmit_topology_change_notification ();

		set_timer (&stp_class.topology_change_notification_timer,START_TIMER);
		}

	stp_class.this_bridge.topology_change_detected = TRUE;

	/* below are for snmp */

	++stp_class.this_bridge.number_of_topology_changes;

	stp_class.this_bridge.timer_topology_tick = timer_ulong;
}
/****************************************************************************/
static void topology_change_acknowledgement (void)
{
	stp_printf (STP_ALGORITHM_PRINTF,"topology change acknowledgement  \n\r");

	stp_class.this_bridge.topology_change_detected = FALSE;
	stp_class.this_bridge.topology_change = FALSE;

	set_timer (&stp_class.topology_change_notification_timer,STOP_TIMER);
}
/****************************************************************************/
static void acknowledge_topology_change (USHORT port_number)
{
	stp_printf (STP_ALGORITHM_PRINTF,"acknowledgement topology change %02x\n\r",port_number);

	stp_class.port[port_number].topology_change_acknowledgement = TRUE;
	
	transmit_configuration (port_number);
}
/****************************************************************************/
void bridge_protocol_message_received (USHORT port_number,BRIDGE_CONFIGURATION_BPDU *sptr_bridge_configuration_BPDU)
{
	enum	BOOLEAN	previous_bridge_state;

	previous_bridge_state = root_bridge ();

	if (sptr_bridge_configuration_BPDU->type == CONFIGURATION)
		{
		if (stp_class.port[port_number].state != DISABLED)
			{
			stp_printf (STP_ALGORITHM_PRINTF,"Hello message received %02x\n\r",port_number);

			if (supercedes_port_info (port_number,sptr_bridge_configuration_BPDU) == TRUE)
				{
				record_configuration_port_information (port_number,sptr_bridge_configuration_BPDU);

				configuration_update ();

				port_state_selection ();

				if ((root_bridge () == FALSE) && previous_bridge_state)
					{
					set_timer (&stp_class.hello_timer,STOP_TIMER);

					if (stp_class.this_bridge.topology_change_detected == TRUE)
						{
						set_timer (&stp_class.topology_change_timer,STOP_TIMER);

						transmit_topology_change_notification ();

						set_timer (&stp_class.topology_change_notification_timer,START_TIMER);
						}
					}

				if (port_number == stp_class.this_bridge.root_port_id.number)
					{
					record_hello_timeout_values (sptr_bridge_configuration_BPDU);

					configuration_BPDU_generation ();

					if (sptr_bridge_configuration_BPDU->flags.topology_change_acknowledgement == TRUE)
						topology_change_acknowledgement ();
					}
				}
			else if (designated_port (port_number) == TRUE)
				{
				reply (port_number);
				}
			}
		}
	else if (sptr_bridge_configuration_BPDU->type == (BYTE_ENUM (BPDU_TYPE)) TOPOLOGY_CHANGE)
		{
		stp_printf (STP_ALGORITHM_PRINTF,"topology change received %02x\n\r",port_number);

		if (stp_class.port[port_number].state != DISABLED)
			{
			if (designated_port (port_number) == TRUE)
				{
				topology_change_detection ();

				acknowledge_topology_change (port_number);
				}
			}
		}
}
/****************************************************************************/
static enum BOOLEAN supercedes_port_info (USHORT port_number,BRIDGE_CONFIGURATION_BPDU *sptr_bridge_configuration_BPDU)
{
	enum SORT_RETURN sort_return_value;

	/* all return (TRUE)s cause the configuration bpdu received to update the current root bridge information in
		stp_class.port[port_number] */

	/* check the designated root */

	sort_return_value = compare_identifiers (&sptr_bridge_configuration_BPDU->root_id,
		&stp_class.port[port_number].designated_root_id);

	if (sort_return_value == LESS_THAN)
		{
		return (TRUE); /* root value is better in new config bpdu */
		}
	else if (sort_return_value == GREATER_THAN)
		{
		return (FALSE); /* root value is worse in new config bpdu */
		}

	if (sptr_bridge_configuration_BPDU->root_path_cost < stp_class.port[port_number].designated_root_path_cost)
		{
		return (TRUE); /* root path cost is better in new config bpdu */
		}
	else if (sptr_bridge_configuration_BPDU->root_path_cost < stp_class.port[port_number].designated_root_path_cost)
		{
		return (FALSE); /* root path cost is worse in new config bpdu */
		}

	/* check the designated bridge for the port */

	sort_return_value = compare_identifiers (&sptr_bridge_configuration_BPDU->bridge_id,
		&stp_class.port[port_number].designated_bridge_id);

	if (sort_return_value == LESS_THAN)
		{
		return (TRUE); /* bridge value is better in new config bpdu */
		}
	else if (sort_return_value == GREATER_THAN)
		{
		return (FALSE); /* bridge value is worse in new config bpdu */
		}

	/* check to see if I am not the designated bridge for the port */

	if (compare_identifiers (&sptr_bridge_configuration_BPDU->bridge_id,&stp_class.this_bridge.bridge_id) != EQUAL_TO)
		{
		return (TRUE); /* bridge (myself) receiving the BPDU is not the designated bridge for the port */
		}

 	if (sptr_bridge_configuration_BPDU->port_id.number <= stp_class.port[port_number].designated_port_id.number)
		{
		return (TRUE); /* port id is the same or better in new config bpdu */
		}
	else
		{
	  	return (FALSE);
		}
}

