#include	"defs.h"
/*	$Modname: macbrtim.c$  $version: 1.18$      $date: 03/31/95$   */
/*
* 	$lgb$
1.0 01/05/92 ross
1.1 01/25/92 ross
1.2 04/22/92 ross
1.3 07/30/92 ross
1.4 07/30/92 ross
1.5 07/30/92 ross
1.6 08/05/92 ross
1.7 08/22/92 ross Added support for multiple instances of stp_class
1.8 08/22/92 ross made as many functions as possible static
1.9 11/23/92 ross changed ETHERNET_ADDRESS to MAC_ADDRESS to appear more generic (cosmetic)
1.10 01/15/93 ross
1.11 01/21/93 ross forgot to check in for TIMER_GRANULARITY addition.
1.12 07/16/93 ross added some mib statistics
1.13 01/13/94 ross added resetting of filtering database timer after a topology change.  Courtesy of Helen.
1.14 02/02/94 ross took out frame relay header and fixed big endian problems.  Courtesy of Rick.
1.15 03/07/94 ross timer granularity bug in did_timer_expire.  Courtesy of Rick.
1.16 06/15/94 ross cosmetic changes and snmp access routines.
1.17 08/25/94 ross Removed check for designated on some port.  Courtesy of Sanjeev.
1.18 03/31/95 ross Changes for new rwutils library.
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1989 - 1993 Router Engines, Inc.								*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	Router Engines, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
/************************************************************************/
#include	<kstart.h>
#include "macbridg.h"
#include "vmacbr.h"
/****************************************************************************/
/* There are 3 bridge timers and 3 timers per port */
/****************************************************************************/
static enum BOOLEAN did_timer_expire (TIMER *sptr_timer,USHORT timer_limit,void (*fptr_timer_expiration) (USHORT port_number),USHORT port_number);
static void hello_timer_expired (void);
static void forwarding_delay_timer_expired (USHORT port_number);
static void message_age_timer_expired (USHORT port_number);
static void topology_change_notice_timer_expired (void);
static void topology_change_timer_expired (void);
static void hold_timer_expired (USHORT port_number);
/****************************************************************************/
void mac_bridge_timer (void)
{
	BYTE	port_number;

	if (stp_class.timer_enabled == FALSE || stp_class.stp_algorithm_enabled == FALSE)
		{
		return;
		}

	database_entry_timer_check ();

	if (++stp_class.number_of_bridge_clock_ticks >= stp_class.clock_ticks_per_second)
		{
		stp_class.number_of_bridge_clock_ticks = 0x00000000L;

		++stp_class.this_bridge.time_up;

		did_timer_expire (&stp_class.hello_timer,stp_class.this_bridge.hello_time,
			(void (*)(USHORT port_number))hello_timer_expired,(ULONG) NULL);
		did_timer_expire (&stp_class.topology_change_timer,stp_class.this_bridge.topology_change_time,
			(void (*)(USHORT port_number))topology_change_timer_expired,(ULONG) NULL);
		did_timer_expire (&stp_class.topology_change_notification_timer,stp_class.this_bridge.hello_time,
			(void (*)(USHORT port_number))topology_change_notice_timer_expired,(ULONG) NULL);

		for (port_number = 0x01; port_number <= stp_class.number_of_spanning_tree_ports ; port_number += (BYTE) 1)
			{
			if (stp_class.port[port_number].state == DISABLED)
				continue;

			did_timer_expire (&stp_class.port[port_number].forward_delay,stp_class.this_bridge.forward_delay,
				forwarding_delay_timer_expired,port_number);

			did_timer_expire (&stp_class.port[port_number].message_age,stp_class.this_bridge.max_age,
				message_age_timer_expired,port_number);

			did_timer_expire (&stp_class.port[port_number].hold_time,stp_class.this_bridge.hold_time,
				hold_timer_expired,port_number); 
			}
		}
}
/****************************************************************************/
void set_timer (TIMER *sptr_timer,enum TIMER_COMMAND start_or_stop)
{
	sptr_timer->active = start_or_stop;

	if (sptr_timer->active == START_TIMER)
		{
		sptr_timer->value = 0x0000;
		}
}
/****************************************************************************/
void start_message_age_timer (TIMER *sptr_timer,enum TIMER_COMMAND start_or_stop,USHORT timer_value)
{
	sptr_timer->active = start_or_stop;

	if (sptr_timer->active == START_TIMER)
		{
		sptr_timer->value = timer_value;
		}
}
/****************************************************************************/
static enum BOOLEAN did_timer_expire (TIMER *sptr_timer,USHORT timer_limit,
	void (*fptr_timer_expiration) (USHORT port_number),USHORT port_number)
{
	if (sptr_timer->active == START_TIMER)
		{
		sptr_timer->value += (USHORT) TIMER_GRANULARITY; /* add 1 second, value is stored in 1/256ths of a second */

		if ((sptr_timer->value / TIMER_GRANULARITY) >= (timer_limit / TIMER_GRANULARITY)) /* compare using seconds */
			{
			sptr_timer->active = STOP_TIMER;

			(*fptr_timer_expiration) (port_number);

			return (TRUE);
			}
		}

	return (FALSE);
}
/****************************************************************************/
/* the hello timer essentially is a "wait" between config_BPDU updates should be 2 seconds */
/****************************************************************************/
static void hello_timer_expired (void)
{
	stp_printf (STP_ALGORITHM_PRINTF,"hello timer expired\n\r");

	configuration_BPDU_generation ();
	
	stp_printf (STP_ALGORITHM_PRINTF,"start hello timer\n\r");

	set_timer (&stp_class.hello_timer,START_TIMER);
}
/****************************************************************************/
/* the forward delay timer essentially is a "wait" between bridge states, should be 15 seconds */
/****************************************************************************/
static void forwarding_delay_timer_expired (USHORT port_number)
{
	stp_printf (STP_ALGORITHM_PRINTF,"forwarding timer expired %02x\n\r",port_number);

	if (stp_class.port[port_number].state == LISTENING)
		{
		stp_class.port[port_number].state = LEARNING;

		stp_printf (STP_ALGORITHM_PRINTF,"learning started %02x\n\r",port_number);

		set_timer (&stp_class.port[port_number].forward_delay,START_TIMER);
		}
	else if (stp_class.port[port_number].state == LEARNING)
		{
		stp_printf (STP_ALGORITHM_PRINTF,"forwarding started %02x\n\r",port_number);

		++stp_class.port[port_number].number_of_forward_transitions;

		stp_class.port[port_number].state = FORWARDING;
		}
}
/****************************************************************************/
static void message_age_timer_expired (USHORT port_number)
{
	enum	BOOLEAN	previous_root_state;

	stp_printf (STP_ALGORITHM_PRINTF,"message age timer expired %02x\n\r",port_number);

	previous_root_state = root_bridge ();

	become_designated_port (port_number);

	configuration_update ();

	port_state_selection ();

	if (root_bridge () == TRUE && previous_root_state == FALSE)
		{
		stp_class.this_bridge.max_age = stp_class.this_bridge.bridge_max_age;
		stp_class.this_bridge.hello_time = stp_class.this_bridge.bridge_hello_time;
		stp_class.this_bridge.forward_delay = stp_class.this_bridge.bridge_forward_delay;

		topology_change_detection ();

		set_timer (&stp_class.topology_change_notification_timer,STOP_TIMER);

		configuration_BPDU_generation ();

		set_timer (&stp_class.hello_timer,START_TIMER);
		}
}
/****************************************************************************/
static void topology_change_notice_timer_expired (void)
{
	stp_printf (STP_ALGORITHM_PRINTF,"topology change notification expired\n\r");

	transmit_topology_change_notification ();

	set_timer (&stp_class.topology_change_notification_timer,START_TIMER);
}
/****************************************************************************/
static void topology_change_timer_expired (void)
{
	stp_printf (STP_ALGORITHM_PRINTF,"topology change expired\n\r");

	stp_class.this_bridge.aging_time_for_fd = AGEING_TIME_FOR_FILTERING_DATABASE;

	stp_class.this_bridge.topology_change_detected = FALSE;
	stp_class.this_bridge.topology_change = FALSE;
}
/****************************************************************************/
static void hold_timer_expired (USHORT port_number)
{
	stp_printf (STP_ALGORITHM_PRINTF,"hold timer expired %04x\n\r",port_number);

	if (stp_class.port[port_number].configuration_pending == TRUE)
		{
		transmit_configuration (port_number);
		}
}
