/*
** VMACSNMP.H
*/

#if !defined(_VMACSNMP_H_)
#define _VMACSNMP_H_

/* General Notes:
** 1. enum is assumed to use 2 bytes.
**	2. The mib string dot1dTpFdbStatus uses an access function that is
**		tailor-made in the MACBSNMP.C SNMP code.
*/

/* Global function prototypes */
enum TEST snmp_get_or_set_mac_bridge_timed_ushort (USHORT port_number,enum MIB_OPERATION mib_operation,ULONG offset,ULONG _class,
	ULONG size,void *vptr_mib_value,USHORT *usptr_length_of_mib_obtained);
enum TEST snmp_get_or_set_mac_bridge_timed_ushort_max_age (USHORT port_number,enum MIB_OPERATION mib_operation,ULONG offset,ULONG _class,
	ULONG size,void *vptr_mib_value,USHORT *usptr_length_of_mib_obtained);
enum TEST snmp_get_or_set_mac_bridge_timed_ushort_hello_time (USHORT port_number,enum MIB_OPERATION mib_operation,ULONG offset,ULONG _class,
	ULONG size,void *vptr_mib_value,USHORT *usptr_length_of_mib_obtained);
enum TEST snmp_get_or_set_mac_bridge_timed_ushort_forward_delay (USHORT port_number,enum MIB_OPERATION mib_operation,ULONG offset,ULONG _class,
	ULONG size,void *vptr_mib_value,USHORT *usptr_length_of_mib_obtained);
enum TEST snmp_get_or_set_fdb_status(USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset, ULONG _class, ULONG size,
	void *vptr_mib_value_obtained, USHORT *usptr_length_of_mib_obtained);
enum TEST snmp_get_or_set_stp_port_state(USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset, ULONG _class, ULONG size,
	void *vptr_mib_value_obtained, USHORT *usptr_length_of_mib_obtained);
enum TEST snmp_get_or_set_stp_priority(USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset, ULONG _class, ULONG size,
	void *vptr_mib_value_obtained, USHORT *usptr_length_of_mib_obtained);
enum TEST snmp_get_or_set_stp_port_priority(USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset, ULONG _class, ULONG size,
	void *vptr_mib_value_obtained, USHORT *usptr_length_of_mib_obtained);
enum TEST snmp_get_or_set_stp_port_path_cost(USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset, ULONG _class, ULONG size,
	void *vptr_mib_value_obtained, USHORT *usptr_length_of_mib_obtained);
enum TEST snmp_get_or_set_tp_aging_time(USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset, ULONG _class, ULONG size,
	void *vptr_mib_value_obtained, USHORT *usptr_length_of_mib_obtained);

/* Srikar, Mar 23, 1997. The following function prototype added. */
enum TEST snmp_get_or_set_base_port_circuit(USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset, ULONG _class, ULONG size,
	void *vptr_mib_value_obtained, USHORT *usptr_length_of_mib_obtained);

/* Srikar, Mar 23, 1997. Removed the far qualifier in the definition since the table gets */
/* overwritten by the compiler startup code. */

#ifdef __MSDOS__
	SNMP_TABLE_ENTRY_PARAMETERS stp_snmp_table_parameters[] =
/*	SNMP_TABLE_ENTRY_PARAMETERS far stp_snmp_table_parameters[] = */
#else
	SNMP_TABLE_ENTRY_PARAMETERS stp_snmp_table_parameters[] =
/*	SNMP_TABLE_ENTRY_PARAMETERS far stp_snmp_table_parameters[] = */
#endif
{
	{ (ULONG) &stp_class, FALSE },
	{ (ULONG) NULL, TRUE, 0x01,
		{
			/* Srikar, Mar 18, 1997. Changed the size of index from ULONG to BYTE. */
			{	SNMP_SCALAR_TYPE, sizeof(BYTE),
				offsetof(STP_PORT_CLASS, port_id.number), FALSE
			}
		}
	},
	{ (ULONG) NULL, TRUE, 0x01,
		{
			/* Srikar, Mar 18, 1997. Changed the type from SNMP_SCALAR_TYPE to SNMP_STRING_TYPE. */
			{	SNMP_STRING_TYPE, sizeof(MAC_ADDRESS),
				offsetof(FILTERING_DATABASE_ENTRY, source_address), FALSE
			},
		}
	}
};

/* Srikar, Mar 23, 1997. Removed the far qualifier in the definition since the table gets */
/* overwritten by the compiler startup code. */

#ifdef __MSDOS__
	SNMP_TABLE_ENTRY stp_snmp_table[] = 
/*	SNMP_TABLE_ENTRY far stp_snmp_table[] = */
#else
	SNMP_TABLE_ENTRY stp_snmp_table[] = 
#endif
{
  {"dot1dBaseBridgeAddress",sizeof (MAC_ADDRESS),snmp_get_or_set_mac_address,
		FALSE, FALSE,
		(ULONG) offsetof (STP_CLASS,this_bridge.bridge_id.address),
		&stp_snmp_table_parameters[0]
	},
  {"dot1dBaseNumPorts",sizeof (ULONG),snmp_get_or_set_ushort,
		FALSE, FALSE,
		(ULONG) offsetof (STP_CLASS,number_of_spanning_tree_ports),
		&stp_snmp_table_parameters[0]
	},
  /* Srikar, Apr 11, 1997. Changed the access function from snmp_get_or_set_byte to snmp_get_or_set_ushort. */
  {"dot1dBaseType",sizeof (ULONG),snmp_get_or_set_ushort,
		FALSE, FALSE,
		(ULONG) offsetof (STP_CLASS,dot1dBaseType),
		&stp_snmp_table_parameters[0]
	},
  {"dot1dBasePort",sizeof (ULONG),snmp_get_or_set_byte,
		FALSE, FALSE,
		(ULONG) offsetof (STP_PORT_CLASS,port_id.number),
		&stp_snmp_table_parameters[1]
	},
  {"dot1dBasePortIfIndex",sizeof (ULONG),snmp_get_or_set_byte,
		FALSE, FALSE,
		(ULONG) offsetof (STP_PORT_CLASS,port_id.number),
		&stp_snmp_table_parameters[1]
	},
  /* Srikar, Mar 20, 1997. Changed the size_of_mib_variable from USHORT to 2 * sizeof(OBJECT_ID) */
  /* Srikar, Mar 23, 1997. Changed the access function from snmp_get_or_set_byte to snmp_get_or_set_base_port_circuit. */
  {"dot1dBasePortCircuit",2 * sizeof (OBJECT_ID),snmp_get_or_set_base_port_circuit,
		FALSE, FALSE,
		(ULONG) offsetof (STP_PORT_CLASS,port_id.number),
		&stp_snmp_table_parameters[1]
	},
  {"dot1dBasePortDelayExceededDiscards",sizeof (ULONG),snmp_get_or_set_ulong,
		FALSE, FALSE,
		(ULONG) offsetof (STP_PORT_CLASS,dot1dBasePortDelayExceededDiscards),
		&stp_snmp_table_parameters[1]
	},
  {"dot1dBasePortMtuExceededDiscards",sizeof (ULONG),snmp_get_or_set_ulong,
		FALSE, FALSE,
		(ULONG) offsetof (STP_PORT_CLASS,dot1dBasePortMtuExceededDiscards),
		&stp_snmp_table_parameters[1]
	},

	/*------------------ dot1dStp group ------------------------------------*/

  /* Srikar, Apr 11, 1997. Changed the access function from snmp_get_or_set_byte to snmp_get_or_set_ushort. */
  {"dot1dStpProtocolSpecification",sizeof (ULONG),snmp_get_or_set_ushort,
		FALSE, FALSE,
		(ULONG) offsetof (STP_CLASS,dot1dStpProtocolSpecification),
		&stp_snmp_table_parameters[0]
	},
  {"dot1dStpPriority",sizeof (ULONG),snmp_get_or_set_stp_priority,
		FALSE, FALSE,
		(ULONG) offsetof (STP_CLASS,this_bridge.bridge_id.priority),
		&stp_snmp_table_parameters[0]
	},
  {"dot1dStpTimeSinceTopologyChange",sizeof (ULONG),snmp_get_or_set_ulong,
		FALSE, FALSE,
		(ULONG) offsetof (STP_CLASS,this_bridge.timer_topology_tick),
		&stp_snmp_table_parameters[0]
	},
  {"dot1dStpTopChanges",sizeof (ULONG),snmp_get_or_set_ulong,
		FALSE, FALSE,
		(ULONG) offsetof (STP_CLASS,this_bridge.number_of_topology_changes),
		&stp_snmp_table_parameters[0]
	},
  {"dot1dStpDesignatedRoot",sizeof (BRIDGE_IDENTIFIER),snmp_get_or_set_8_byte_object,
		FALSE, FALSE,
		(ULONG) offsetof (STP_CLASS,this_bridge.root_id),
		&stp_snmp_table_parameters[0]
	},
  {"dot1dStpRootCost",sizeof (ULONG),snmp_get_or_set_ushort,
		FALSE, FALSE,
		(ULONG) offsetof (STP_CLASS,this_bridge.root_path_cost),
		&stp_snmp_table_parameters[0]
	},
  {"dot1dStpRootPort",sizeof (ULONG),snmp_get_or_set_byte,
		FALSE, FALSE,
		(ULONG) offsetof (STP_CLASS,this_bridge.root_port_id.number),
		&stp_snmp_table_parameters[0]
	},
  {"dot1dStpMaxAge",sizeof (ULONG),snmp_get_or_set_mac_bridge_timed_ushort,
		FALSE, FALSE,
		(ULONG) offsetof (STP_CLASS,this_bridge.max_age),
		&stp_snmp_table_parameters[0]
	},
  {"dot1dStpHelloTime",sizeof (ULONG),snmp_get_or_set_mac_bridge_timed_ushort,
		FALSE, FALSE,
		(ULONG) offsetof (STP_CLASS,this_bridge.hello_time),
		&stp_snmp_table_parameters[0]
	},
  {"dot1dStpHoldTime",sizeof (ULONG),snmp_get_or_set_mac_bridge_timed_ushort,
		FALSE, FALSE,
		(ULONG) offsetof (STP_CLASS,this_bridge.hold_time),
		&stp_snmp_table_parameters[0]
	},
  {"dot1dStpForwardDelay",sizeof (ULONG),snmp_get_or_set_mac_bridge_timed_ushort,
		FALSE, FALSE,
		(ULONG) offsetof (STP_CLASS,this_bridge.forward_delay),
		&stp_snmp_table_parameters[0]
	},
  {"dot1dStpBridgeMaxAge",sizeof (ULONG),snmp_get_or_set_mac_bridge_timed_ushort_max_age,
		FALSE, FALSE,
		(ULONG) offsetof (STP_CLASS,this_bridge.bridge_max_age),
		&stp_snmp_table_parameters[0]
	},
  {"dot1dStpBridgeHelloTime",sizeof (ULONG),snmp_get_or_set_mac_bridge_timed_ushort_hello_time,
		FALSE, FALSE,
		(ULONG) offsetof (STP_CLASS,this_bridge.bridge_hello_time),
		&stp_snmp_table_parameters[0]
	},
  {"dot1dStpBridgeForwardDelay",sizeof (ULONG),snmp_get_or_set_mac_bridge_timed_ushort_forward_delay,
		FALSE, FALSE,
		(ULONG) offsetof (STP_CLASS,this_bridge.bridge_forward_delay),
		&stp_snmp_table_parameters[0]
	},
  {"dot1dStpPort",sizeof (ULONG),snmp_get_or_set_byte,
		FALSE, FALSE,
		(ULONG) offsetof (STP_PORT_CLASS,port_id.number),
		&stp_snmp_table_parameters[1]
	},
  {"dot1dStpPortPriority",sizeof (ULONG),snmp_get_or_set_stp_port_priority,
		FALSE, FALSE,
		(ULONG) offsetof (STP_PORT_CLASS,port_id.priority),
		&stp_snmp_table_parameters[1]
	},
  /* Srikar, Mar 18, 1997. Changed the access function from snmp_get_or_set_ushort to snmp_get_or_set_byte */
  {"dot1dStpPortState",sizeof (ULONG),snmp_get_or_set_ushort,
		FALSE, FALSE,
		(ULONG) offsetof (STP_PORT_CLASS,state),
		&stp_snmp_table_parameters[1]
	},
  {"dot1dStpPortEnable",sizeof (ULONG),snmp_get_or_set_stp_port_state,
		TRUE, FALSE,
		(ULONG) offsetof (STP_PORT_CLASS,dot1dStpPortEnable),
		&stp_snmp_table_parameters[1]
	},
  {"dot1dStpPortPathCost",sizeof (ULONG),snmp_get_or_set_stp_port_path_cost,
		FALSE, FALSE,
		(ULONG) offsetof (STP_PORT_CLASS,path_cost),
		&stp_snmp_table_parameters[1]
	},
  {"dot1dStpPortDesignatedRoot",sizeof (BRIDGE_IDENTIFIER),snmp_get_or_set_8_byte_object,
		FALSE, FALSE,
		(ULONG) offsetof (STP_PORT_CLASS,designated_root_id),
		&stp_snmp_table_parameters[1]
	},
  {"dot1dStpPortDesignatedCost",sizeof (ULONG),snmp_get_or_set_ulong,
		FALSE, FALSE,
		(ULONG) offsetof (STP_PORT_CLASS,designated_root_path_cost),
		&stp_snmp_table_parameters[1]
	},
  {"dot1dStpPortDesignatedBridge",sizeof (BRIDGE_IDENTIFIER),snmp_get_or_set_8_byte_object,
		FALSE, FALSE,
		(ULONG) offsetof (STP_PORT_CLASS,designated_bridge_id),
		&stp_snmp_table_parameters[1]
	},
  /* Srikar, Mar 20, 1997. Changed the size_of_mib_variable from USHORT to 2 * sizeof(OBJECT_ID) */
  /* Srikar, Mar 23, 1997. Changed the access function from snmp_get_or_set_2_byte_object to */
  /* snmp_get_or_set_base_port_circuit. Changed the access field from 'designated_port_id' to 'designated_port_id.number'. */
  {"dot1dStpPortDesignatedPort",2 * sizeof (OBJECT_ID),snmp_get_or_set_base_port_circuit,
		FALSE, FALSE,
		(ULONG) offsetof (STP_PORT_CLASS,designated_port_id.number),
		&stp_snmp_table_parameters[1]
	},
  {"dot1dStpPortForwardTransitions",sizeof (ULONG),snmp_get_or_set_ulong,
		FALSE, FALSE,
		(ULONG) offsetof (STP_PORT_CLASS,number_of_forward_transitions),
		&stp_snmp_table_parameters[1]
	},

	/*------------------ dot1dTp group ------------------------------------*/

  {"dot1dTpLearnedEntryDiscards",sizeof (ULONG),snmp_get_or_set_ulong,
		FALSE, FALSE,
		(ULONG) offsetof (STP_CLASS,port[0].number_of_frames_discarded),
		&stp_snmp_table_parameters[0]
	},
  {"dot1dTpAgingTime",sizeof (ULONG),snmp_get_or_set_tp_aging_time,
		FALSE, FALSE,
		(ULONG) offsetof (STP_CLASS,this_bridge.aging_time_for_fd),
		&stp_snmp_table_parameters[0]
	},
  {"dot1dTpFdbAddress",sizeof (MAC_ADDRESS),snmp_get_or_set_mac_address,
		FALSE, FALSE,
		(ULONG) offsetof (FILTERING_DATABASE_ENTRY,source_address),
		&stp_snmp_table_parameters[2]
	},
  {"dot1dTpFdbPort",sizeof (ULONG),snmp_get_or_set_byte,
		FALSE, FALSE,
		(ULONG) offsetof (FILTERING_DATABASE_ENTRY,port_number),
		&stp_snmp_table_parameters[2]
	},
  {"dot1dTpFdbStatus",sizeof (ULONG),snmp_get_or_set_fdb_status,
		FALSE, FALSE,
		(ULONG) offsetof (FILTERING_DATABASE_ENTRY,type),
		&stp_snmp_table_parameters[2]
	},
  {"dot1dTpPort",sizeof (ULONG),snmp_get_or_set_byte,
		FALSE, FALSE,
		(ULONG) offsetof (STP_PORT_CLASS,port_id.number),
		&stp_snmp_table_parameters[1]
	},
  {"dot1dTpPortMaxInfo",sizeof (ULONG),snmp_get_or_set_ushort,
		FALSE, FALSE,
		(ULONG) offsetof (STP_PORT_CLASS,maximum_packet_size),
		&stp_snmp_table_parameters[1]
	},
  {"dot1dTpPortInFrames",sizeof (ULONG),snmp_get_or_set_ulong,
		FALSE, FALSE,
		(ULONG) offsetof (STP_PORT_CLASS,dot1dTpPortInFrames),
		&stp_snmp_table_parameters[1]
	},
  {"dot1dTpPortOutFrames",sizeof (ULONG),snmp_get_or_set_ulong,
		FALSE, FALSE,
		(ULONG) offsetof (STP_PORT_CLASS,number_of_frames_forwarded),
		&stp_snmp_table_parameters[1]
	},
  {"dot1dTpPortInDiscards",sizeof (ULONG),snmp_get_or_set_ulong,
		FALSE, FALSE,
		(ULONG) offsetof (STP_PORT_CLASS,number_of_frames_discarded),
		&stp_snmp_table_parameters[1]
	},
  	{
		"",0x0000,NULL,FALSE,FALSE,0L,NULL
	}
};

#endif /* _VMACSNMP_H_ */

