/*	$Modname: vnvstp.h$  $version: 1.2$      $date: 03/31/95$   */
/*
* 	$lgb$
1.0 04/05/94 ross initial release.
1.1 04/05/94 ross added port state parameters.
1.2 03/31/95 ross Changes for new rwutils library.
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1989 - 1992 Router Engines, Inc.								*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	Router Engines, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
/************************************************************************/
void turn_stp_printing_on (char *cptr_start_of_configuration_string);
void turn_stp_subgroup_printing_on (char *cptr_start_of_configuration_string,ULONG printf_type);
void set_spanning_tree_port_forwarding_state (char *cptr_port_number_and_port_state_type_string);
#ifdef NEW_FILTERING
void stp_default_action_cfg_string (char *cptr_port_number_and_port_state_type_string);
void stp_src_filter_cfg_string (char *cptr_port_number_and_port_state_type_string);
void stp_dest_filter_cfg_string (char *cptr_port_number_and_port_state_type_string);
void stp_src_forward_cfg_string (char *cptr_port_number_and_port_state_type_string);
void stp_dest_forward_cfg_string (char *cptr_port_number_and_port_state_type_string);
void stp_src_and_dest_forward_cfg_string (char *cptr_port_number_and_port_state_type_string);
void stp_src_and_dest_filter_cfg_string (char *cptr_port_number_and_port_state_type_string);
#endif

/* _____________________________________________________________________________________________ */

CONFIGURATION_TABLE stp_configuration_table =
{
	{TRUE},
	{
	/* Spanning Tree parameters */

	{
		NULL,
		(enum BOOLEAN *) TRUE,
		"Spanning Tree =",
		(ULONG) offsetof (STP_CLASS,enabled),
		(ULONG ) &stp_class,
		(ULONG) NULL
	},

/* _____________________________________________________________________________________________ */

	/* Spanning Tree parameters */

	{
		NULL,
		(enum BOOLEAN *) TRUE,
		"Spanning Tree Algorithm =",
		(ULONG) offsetof (STP_CLASS,stp_algorithm_enabled),
		(ULONG ) &stp_class,
		(ULONG) NULL
	},
/* _____________________________________________________________________________________________ */
	{
		(void 	(*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_ushort_decimal_value,
		NULL,
	"Spanning Tree Number of Ports =",
		(ULONG) offsetof (STP_CLASS,number_of_spanning_tree_ports),
		(ULONG ) &stp_class,
		(ULONG) NULL
	},
/* _____________________________________________________________________________________________ */
	{
		(void 	(*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_ushort_decimal_value,
		NULL,
	"Spanning Tree Number of Filtering Database Entries =",
		(ULONG) offsetof (STP_CLASS,number_of_fd_entries),
		(ULONG ) &stp_class,
		(ULONG) NULL
	},
/* _____________________________________________________________________________________________ */
	{(void 	(*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_variable_port_and_ulong_decimal_value,
		NULL,
	"Spanning Tree Port Path Cost =",
		(ULONG) offsetof (STP_CLASS,port[0].path_cost),
		(ULONG ) &stp_class,
		sizeof (STP_PORT_CLASS)
	},
/* _____________________________________________________________________________________________ */
	{
		(void 	(*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_ulong_decimal_value,
		NULL,
	"Spanning Tree Number of Hash Table Entries =",
		(ULONG) offsetof (STP_CLASS,number_of_hash_table_entries),
		(ULONG ) &stp_class,
		(ULONG) NULL
	},
/* _____________________________________________________________________________________________ */
	{
		(void 	(*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		turn_stp_printing_on,
		NULL,
	"Spanning Tree Printf =",
		(ULONG) offsetof (STP_CLASS,stp_printing_enabled),
		(ULONG) &stp_class,
		(ULONG) NULL
	},
/* _____________________________________________________________________________________________ */
	{
		(void 	(*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		turn_stp_subgroup_printing_on,
		NULL,
	"Spanning Tree Data Printf =",
		(ULONG) offsetof (STP_CLASS,data_printing_enabled),
		(ULONG) &stp_class,
		(ULONG) NULL
	},
/* _____________________________________________________________________________________________ */
	{
		set_variable_port_and_enable,
		NULL,
	"Spanning Tree Port Token Ring =",
		(ULONG) offsetof (STP_CLASS,port[0].token_ring),
		(ULONG ) &stp_class,
		sizeof (STP_PORT_CLASS)
	},
/* _____________________________________________________________________________________________ */
	{
		set_variable_port_and_enable,
		NULL,
	"Spanning Tree Port WAN =",
		(ULONG) offsetof (STP_CLASS,port[0].wan_port),
		(ULONG ) &stp_class,
		sizeof (STP_PORT_CLASS)
	},

/* _____________________________________________________________________________________________ */
	{(void 	(*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_variable_port_and_ushort_decimal_value,
		NULL,
	"Spanning Tree Port Message Age =",
		(ULONG) offsetof (STP_CLASS,port[0].message_age.value),
		(ULONG ) &stp_class,
		sizeof (STP_PORT_CLASS)
	},

/* _____________________________________________________________________________________________ */
	{(void 	(*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_variable_port_and_ushort_decimal_value,
		NULL,
	"Spanning Tree Port Hold Time =",
		(ULONG) offsetof (STP_CLASS,port[0].hold_time.value),
		(ULONG ) &stp_class,
		sizeof (STP_PORT_CLASS)
	},

/* _____________________________________________________________________________________________ */
	{(void 	(*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_variable_port_and_ushort_decimal_value,
		NULL,
	"Spanning Tree Port Forward Delay =",
		(ULONG) offsetof (STP_CLASS,port[0].forward_delay.value),
		(ULONG ) &stp_class,
		sizeof (STP_PORT_CLASS)
	},

/* _____________________________________________________________________________________________ */
	{(void 	(*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_variable_port_and_byte_decimal_value,
		NULL,
	"Spanning Tree Port ID Priority =",
		(ULONG) offsetof (STP_CLASS,port[0].port_id.priority),
		(ULONG ) &stp_class,
		sizeof (STP_PORT_CLASS)
	},

/* _____________________________________________________________________________________________ */
	{(void 	(*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_variable_port_and_ushort_decimal_value,
		NULL,
	"Spanning Tree Port Maximum Frame Size =",
		(ULONG) offsetof (STP_CLASS,port[0].maximum_packet_size),
		(ULONG ) &stp_class,
		sizeof (STP_PORT_CLASS)
	},

/* _____________________________________________________________________________________________ */
	{(void 	(*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_spanning_tree_port_forwarding_state,
		NULL,
	"Spanning Tree Port State =",
		(ULONG) NULL,
		(ULONG) NULL
	},

#ifdef NEW_FILTERING

/* _____________________________________________________________________________________________ */
	{(void 	(*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		stp_src_filter_cfg_string,
		NULL,
	"Spanning Tree Filter Source Address =",
		(ULONG) NULL,
		(ULONG) NULL
	},

/* _____________________________________________________________________________________________ */
	{(void 	(*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		stp_dest_filter_cfg_string,
		NULL,
	"Spanning Tree Filter Destination Address =",
		(ULONG) NULL,
		(ULONG) NULL
	},

/* _____________________________________________________________________________________________ */
	{(void 	(*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		stp_src_forward_cfg_string,
		NULL,
	"Spanning Tree Forward Source Address =",
		(ULONG) NULL,
		(ULONG) NULL
	},

/* _____________________________________________________________________________________________ */
	{(void 	(*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		stp_dest_forward_cfg_string,
		NULL,
	"Spanning Tree Forward Destination Address =",
		(ULONG) NULL,
		(ULONG) NULL
	},

/* _____________________________________________________________________________________________ */
	{(void 	(*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		stp_src_and_dest_forward_cfg_string,
		NULL,
	"Spanning Tree Forward Source or Destination Address =",
		(ULONG) NULL,
		(ULONG) NULL
	},

	{(void 	(*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		stp_src_and_dest_forward_cfg_string,
		NULL,
	"Spanning Tree Forward Destination or Source Address =",
		(ULONG) NULL,
		(ULONG) NULL
	},

/* _____________________________________________________________________________________________ */
	{(void 	(*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		stp_src_and_dest_filter_cfg_string,
		NULL,
	"Spanning Tree Filter Destination or Source Address =",
		(ULONG) NULL,
		(ULONG) NULL
	},

	{(void 	(*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		stp_src_and_dest_filter_cfg_string,
		NULL,
	"Spanning Tree Filter Source or Destination Address =",
		(ULONG) NULL,
		(ULONG) NULL
	},

/* _____________________________________________________________________________________________ */
	{(void 	(*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		stp_default_action_cfg_string,
		NULL,
	"Spanning Tree Default Action =",
		(ULONG) NULL,
		(ULONG) NULL
	},

#endif
/* _____________________________________________________________________________________________ */
	{
		NULL,
		NULL,
	"",
		(ULONG) NULL,
		(ULONG) NULL,
		(ULONG) NULL
	}

	}	
};
