/*	$Modname: kspx.h$  $version: 1.5$      $date: 08/02/95$   */
/*
* 	$lgb$
1.0 07/19/94 ross
1.1 07/21/94 ross
1.2 07/23/94 ross watchdog across router timed correctly.
1.3 08/08/94 ross Initial release
1.4 08/08/94 ross Added copyright
1.5 08/02/95 ross
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1994 RouterWare, Inc.												*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Blvd. Suite 212, Newport Beach Ca   */
/************************************************************************/
#define USER_DEFINED_DATASTREAM 										0x00

#define ILLEGAL_CONNECTION_ID 										0xffff

#ifndef  ALLOCATE_DYNAMIC_SOCKET
	#define ALLOCATE_DYNAMIC_SOCKET 									0x0000
	#define DYNAMIC_SOCKET_START 										BIG_ENDIAN_CONSTANT (0x4000)
#endif

#define UNREASONABLE_WINDOW_SIZE 									50

#define VARIABLE_NUMBER_OF_BYTES 									1

#define TRANSLATION_HEADER_SIZE 										0x10

#define SPX_ECB_SOCKET_BUFFER_SIZE 									1518

#define EXTRA_FRAME_HEADER_BYTES										64

#define MINIMAL_EXTRA_FRAME_HEADER_BYTES							(64 / 2)

#define EXTRA_FRAME_HEADER_MASK										0xffffffe0L



enum SPX_RETURN_CODE
{
	SPX_SUCCESSFUL,

	SPX_BAD_ADDRESS,
	SPX_OUT_OF_RESOURCES,
	SPX_ECB_IN_USE,

	SPX_CANCEL_FAILED,
	SPX_BAD_PARAMETER,
	SPX_ECB_NOT_FOUND,

	SPX_CONNECT_FAILED,
	SPX_CONNECT_NOT_FOUND,
	SPX_ECB_CANCELLED,
	SPX_BAD_PACKET,
	SPX_SOCKET_NOT_FOUND,

	SPX_CONNECTION_STARTED,
	SPX_CONNECTION_COMPLETED,
	SPX_CONNECT_TERMINATED,
	SPX_CONNECT_TIMEOUT,
	SPX_CONNECT_ABORTED,
	SPX_CONNECT_IN_USE,
	SPX_CONNECT_TABLE_FULL,
	SPX_SOCKET_CLOSED,
	SPX_PACKET_OVERFLOW,
	SPX_SOCKET_TABLE_FULL,
	SPX_SOCKET_IN_USE,

	SPX_NO_ACK_RECEIVED,
	SPX_IPX_SOCKET_IN_USE,
	SPX_BAD_CONNECT_STATUS,
	SPX_LISTEN_FAILED,

	SPX_INVALID_FRAGMENT,

	SPX_INVALID_ECB_ADDRESS,
	SPX_INVALID_FRAG_LIST,
	SPX_INVALID_SYS_SEM,
	SPX_INVALID_RAM_SEM		
};


enum SPX_PRINTF_GROUPS
{
	SPX_PRINTF,
	SPX_STATE_PRINTF,
	SPX_SNMP_PRINTF,
	SPX_MESSAGE_PRINTF,
	SPX_ALARM_PRINTF,
	SPX_MEMORY_PRINTF,
	SPX_DATA_PRINTF
};

enum SPX_ALARM_TYPE
{
	UNKNOWN_ERROR = 1,
	RX_PACKET_TOO_SHORT,
	RX_PACKET_TOO_LONG,
	NO_ERROR_SINCE_RESET	
};

enum SPX_CONNECTION_STATE
{
	SPX_DISCONNECTED,
	SPX_LISTENING,
	SPX_CONNECT_REQUEST_SENT,
	SPX_DISCONNECTING,
	SPX_CONNECTED,

	NUMBER_OF_SPX_STATES,
	NO_CHANGE_TO_SPX_STATE,
	ILLEGAL_SPX_STATE
};

enum SPX_EVENT
{
	SPX_START_CONNECTION,
	SPX_LISTEN_FOR_CONNECTION,
	SPX_CONNECTION_REQUEST_RXED,
	SPX_CONNECTION_ACK_RXED,
	SPX_WAITING_FOR_ACK_FROM_TARGET,
	SPX_NO_ANSWER_FROM_TARGET,
	SPX_DISCONNECT_RXED,
	SPX_DISCONNECT_ACK_RXED,
	SPX_STOP_CONNECTION,
	SPX_WAITING_FOR_DACK_FROM_TARGET,
	SPX_NO_ANSWER_FOR_DISCONNECT_FROM_TARGET,
	SPX_TX_DATA,
	SPX_TX_DATA_ACK_RXED,
	SPX_TX_DATA_NO_ACK,
	SPX_TX_DATA_NO_ACK_TIMEOUT,
	SPX_RX_DATA,
	SPX_RX_WATCHDOG,
	SPX_RX_WATCHDOG_RETRY,
	SPX_TX_WATCHDOG,
	SPX_TX_WATCHDOG_RETRY,
	SPX_TX_WATCHDOG_TIMEOUT,

	NUMBER_OF_SPX_EVENTS,
	UNDETERMINED_SPX_EVENT,
	ILLEGAL_SPX_EVENT
};

enum SPX_PACKET_TYPE
{
	SPX_DATA_PACKET,
	SPX_DATA_ACK_PACKET,
	SPX_WATCHDOG_PACKET,
	SPX_WATCHDOG_RETRY_PACKET,
	SPX_CONNECT_REQUEST_PACKET,
	SPX_CONNECT_ACK_PACKET,
	SPX_DISCONNECT_PACKET,
	SPX_INTERNAL_DISCONNECT_PACKET, /* Introduced, Sanjay, 24, July, 1996 */
	SPX_DISCONNECT_ACK_PACKET
};
