#include "defs.h"
/************************************************************************/
/*	Copyright (C) 1994 RouterWare, Inc.												*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Blvd. Suite 212, Newport Beach Ca   */
/************************************************************************/
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include "spx.h"
/****************************************************************************/
static SPX_ECB_SOCKET_LIST_ENTRY *build_connect_ecb (IPX_ADDRESS local_address, IPX_ADDRESS remote_address);
static void spx_build_packet_header (SPX_ECB_SOCKET_LIST_ENTRY *sptr_ecb_socket_entry);
static void establish_connection_completion_routine (ECB_WITH_BACKWARD_REFERENCE *sptr_ecb);
static void	set_remote_ipx_port_number_for_connection (SPX_ECB_SOCKET_LIST_ENTRY *sptr_ecb_socket_entry,
	ECB_WITH_BACKWARD_REFERENCE *sptr_ecb);
static void disconnect_completion_routine (ECB_WITH_BACKWARD_REFERENCE *sptr_ecb);
static ECB_WITH_PACKET *build_listen_ecb (SPX_ECB_SOCKET_LIST_ENTRY *sptr_ecb_socket_entry);
static void listen_completion_routine (EVENT_CONTROL_BLOCK *sptr_ecb);
/****************************************************************************/
SPX_ECB_SOCKET_LIST_ENTRY *spx_establish_connection (USER_SOCKET *sptr_user_socket, IPX_ADDRESS local_address,
	IPX_ADDRESS remote_address)
{
	SPX_ECB_SOCKET_LIST_ENTRY *sptr_ecb_socket_entry;

	sptr_ecb_socket_entry = build_connect_ecb (local_address, remote_address);

	if (sptr_ecb_socket_entry != NULL)
		{
		sptr_ecb_socket_entry->sptr_user_socket = sptr_user_socket;

		sptr_ecb_socket_entry->application_id = sptr_user_socket->application_id;

		spx_connect (sptr_ecb_socket_entry->local_address.socket, 0x10, TRUE,
			&sptr_ecb_socket_entry->session_handle, &sptr_ecb_socket_entry->connect_ecb.ecb,
			&sptr_ecb_socket_entry->listen_connect_ecb.ecb);

		sptr_ecb_socket_entry->connection_initiated = TRUE;

		add_entry_to_list ((LINK *) &spx.ecb_socket_list, (LINK *) sptr_ecb_socket_entry);

		++spx.number_of_ecb_socket_entries;
		}

	return (sptr_ecb_socket_entry);
}
/****************************************************************************/
static SPX_ECB_SOCKET_LIST_ENTRY *build_connect_ecb (IPX_ADDRESS local_address, IPX_ADDRESS remote_address)
{
	SPX_ECB_SOCKET_LIST_ENTRY *sptr_ecb_socket_entry;
	void *vptr_buffer;

	sptr_ecb_socket_entry = table_malloc (1, sizeof (SPX_ECB_SOCKET_LIST_ENTRY));

 	spx_printf (SPX_MEMORY_PRINTF, "SPX: Allocated ECB SOCKET ENTRY %p\r\n", sptr_ecb_socket_entry);

	if (sptr_ecb_socket_entry == NULL)
		{
		return (NULL);
		}

	sptr_ecb_socket_entry->connect_ecb.ecb.in_use = 0x00;
	sptr_ecb_socket_entry->connect_ecb.ecb.completion_code = 0x00;
	sptr_ecb_socket_entry->connect_ecb.ecb.socket_number = local_address.socket;

	memcpy ((void *) &sptr_ecb_socket_entry->connect_ecb.ecb.destination_ipx_address, &remote_address,
		sizeof (ULONG) + sizeof (MAC_ADDRESS));

	sptr_ecb_socket_entry->connect_ecb.ecb.fragment_count = 1;

	vptr_buffer	= buffer_malloc (sizeof (SPX_PACKET_HEADER) + MINIMAL_EXTRA_FRAME_HEADER_BYTES);

	if (vptr_buffer == NULL)
		{
	 	spx_printf (SPX_MEMORY_PRINTF, "SPX: buffer_malloc failed\n");

		return (NULL);
		}

 	spx_printf (SPX_MEMORY_PRINTF, "SPX: Allocated connect ecb buffer %p\r\n", vptr_buffer);

	sptr_ecb_socket_entry->connect_ecb.ecb.fragment_descriptor[0].type.vptr_buffer =
		(void *)	((ULONG) vptr_buffer + MINIMAL_EXTRA_FRAME_HEADER_BYTES);

	sptr_ecb_socket_entry->connect_ecb.ecb.fragment_descriptor[0].size_of_buffer = sizeof (SPX_PACKET_HEADER);
	sptr_ecb_socket_entry->connect_ecb.ecb.fptr_event_service_routine =
		(void (*) (EVENT_CONTROL_BLOCK *)) establish_connection_completion_routine;

	memcpy (&sptr_ecb_socket_entry->connect_ecb.ecb.immediate_address, &local_address.node_address, sizeof (MAC_ADDRESS));

	memcpy (&sptr_ecb_socket_entry->local_address, &local_address, sizeof (IPX_ADDRESS));

	memcpy (&sptr_ecb_socket_entry->remote_address, &remote_address, sizeof (IPX_ADDRESS));

	spx_build_packet_header (sptr_ecb_socket_entry);

	sptr_ecb_socket_entry->connect_ecb.sptr_ecb_socket_entry = sptr_ecb_socket_entry;

 	spx_printf (SPX_DATA_PRINTF, "SPX: Build establish connection ECB\r\n");

	return (sptr_ecb_socket_entry);
}
/*************************************************************************/
static void spx_build_packet_header (SPX_ECB_SOCKET_LIST_ENTRY *sptr_ecb_socket_entry)
{
	SPX_PACKET_HEADER *sptr_packet_header;

	sptr_packet_header =
		(SPX_PACKET_HEADER *) sptr_ecb_socket_entry->connect_ecb.ecb.fragment_descriptor[0].type.vptr_buffer;

	memcpy (&sptr_packet_header->ipx_header.destination, &sptr_ecb_socket_entry->remote_address, sizeof (IPX_ADDRESS));

	memcpy (&sptr_packet_header->ipx_header.source, &sptr_ecb_socket_entry->local_address, sizeof (IPX_ADDRESS));
}
/****************************************************************************/
static void establish_connection_completion_routine (ECB_WITH_BACKWARD_REFERENCE *sptr_ecb)
{
	SPX_ECB_SOCKET_LIST_ENTRY *sptr_ecb_socket_entry;
	LSL_MESSAGE *sptr_lsl_message;

	sptr_ecb_socket_entry = sptr_ecb->sptr_ecb_socket_entry;

	if (sptr_ecb_socket_entry == NULL)
		{
		spx_printf (SPX_ALARM_PRINTF, "SPX: pointer to ecb socket entry is NULL\n");

		return;
		}
		
	if (sptr_ecb->ecb.completion_code == SPX_CONNECTION_COMPLETED)
		{
		spx_printf (SPX_DATA_PRINTF, "SPX: VALID call to establish_connection_completion_routine\n");

		if (sptr_ecb_socket_entry->connection_initiated == TRUE)
			{
			sptr_ecb_socket_entry->connection_initiated = FALSE;

			sptr_ecb_socket_entry->connection_is_up = TRUE;

			set_remote_ipx_port_number_for_connection (sptr_ecb_socket_entry, sptr_ecb);

			sptr_lsl_message = spx_generate_message (sptr_ecb_socket_entry->sptr_user_socket, sptr_ecb_socket_entry,
				CONNECTION_COMPLETED);

			lsl_control (RESOLVE_SOCKET_API, LINK_SERVICES_LAYER_TYPE, (ULONG) ADD_MESSAGE_TO_QUEUE, (ULONG) sptr_lsl_message,
				(ULONG) NULL);

			spx_printf (SPX_MESSAGE_PRINTF, "SPX: CONNECTION COMPLETED message placed in mailbox: %d\n",
				sptr_lsl_message->destination_id);

			spx_listen_for_data (sptr_ecb_socket_entry);

			build_disconnect_ecb (sptr_ecb_socket_entry);

			((SPX_SESSION_CLASS *) sptr_ecb_socket_entry->session_handle)->sptr_disconnect_ecb =
				(EVENT_CONTROL_BLOCK *) &sptr_ecb_socket_entry->disconnect_ecb;
			}
		else
			{
			spx_printf (SPX_ALARM_PRINTF, "SPX: UNRECOGNIZED call to establish_connection_completion_routine\n");
			}
		}
	else if (sptr_ecb->ecb.completion_code == SPX_OUT_OF_RESOURCES)
		{
		spx_printf (SPX_ALARM_PRINTF, "SPX: OUT OF RESOURCES call to establish_connection_completion_routine\n");

		spx_listen_for_data (sptr_ecb_socket_entry);
		}
	else
		{
		spx_printf (SPX_ALARM_PRINTF, "SPX: UNRECOGNIZED call to establish_connection_completion_routine\n");
		}
}
/****************************************************************************/
static void	set_remote_ipx_port_number_for_connection (SPX_ECB_SOCKET_LIST_ENTRY *sptr_ecb_socket_entry,
	ECB_WITH_BACKWARD_REFERENCE *sptr_ecb)
{
	USHORT allocated_remote_ipx_port;
	USER_SOCKET *sptr_user_socket;
	SPX_SESSION_CLASS *sptr_session;

	allocated_remote_ipx_port = sptr_ecb->ecb.destination_ipx_address.socket;

	sptr_ecb_socket_entry->remote_address.socket = allocated_remote_ipx_port;

	sptr_session = (SPX_SESSION_CLASS *) sptr_ecb_socket_entry->session_handle;

	sptr_session->destination_ipx_address.socket = allocated_remote_ipx_port;

	sptr_user_socket = sptr_ecb_socket_entry->sptr_user_socket;

	((SOCKADDR_IPX *) sptr_user_socket->vptr_peer_address)->port = allocated_remote_ipx_port;
}
/****************************************************************************/
SPX_ECB_SOCKET_LIST_ENTRY *build_disconnect_ecb (SPX_ECB_SOCKET_LIST_ENTRY *sptr_ecb_socket_entry)
{
	void *vptr_buffer;

	sptr_ecb_socket_entry->disconnect_ecb.ecb.in_use = 0x00;
	sptr_ecb_socket_entry->disconnect_ecb.ecb.completion_code = 0x00;
	sptr_ecb_socket_entry->disconnect_ecb.ecb.socket_number = sptr_ecb_socket_entry->local_address.socket;

	memcpy ((void *) &sptr_ecb_socket_entry->disconnect_ecb.ecb.destination_ipx_address,
		(void *) &sptr_ecb_socket_entry->connect_ecb.ecb.destination_ipx_address, sizeof (ULONG) + sizeof (MAC_ADDRESS));

	sptr_ecb_socket_entry->disconnect_ecb.ecb.fragment_count = 1;

	vptr_buffer	= buffer_malloc (sizeof (SPX_PACKET_HEADER) + MINIMAL_EXTRA_FRAME_HEADER_BYTES);

	if (vptr_buffer == NULL)
		{
	 	spx_printf (SPX_MEMORY_PRINTF, "SPX: buffer_malloc failed\n");

		return (NULL);
		}

 	spx_printf (SPX_MEMORY_PRINTF, "SPX: Allocated disconnect ecb buffer %p\r\n", vptr_buffer);

	sptr_ecb_socket_entry->disconnect_ecb.ecb.fragment_descriptor[0].type.vptr_buffer =
		(void *) ((ULONG)	vptr_buffer + MINIMAL_EXTRA_FRAME_HEADER_BYTES);

	sptr_ecb_socket_entry->disconnect_ecb.ecb.fragment_descriptor[0].size_of_buffer = sizeof (SPX_PACKET_HEADER);
	sptr_ecb_socket_entry->disconnect_ecb.ecb.fptr_event_service_routine =
		(void (*) (EVENT_CONTROL_BLOCK *)) disconnect_completion_routine;

	memcpy ((void *) &sptr_ecb_socket_entry->disconnect_ecb.ecb.immediate_address,
		&sptr_ecb_socket_entry->connect_ecb.ecb.immediate_address, sizeof (MAC_ADDRESS));

	sptr_ecb_socket_entry->disconnect_ecb.sptr_ecb_socket_entry = sptr_ecb_socket_entry;

 	spx_printf (SPX_DATA_PRINTF, "SPX: Build disconnect ECB\r\n");

	return (sptr_ecb_socket_entry);
}
/****************************************************************************/
static void disconnect_completion_routine (ECB_WITH_BACKWARD_REFERENCE *sptr_ecb)
{
	SPX_ECB_SOCKET_LIST_ENTRY *sptr_ecb_socket_entry;
	LSL_MESSAGE *sptr_lsl_message;
	USER_SOCKET *sptr_user_socket;

	if (sptr_ecb->ecb.completion_code == SPX_CONNECT_TERMINATED)
		{
		spx_printf (SPX_DATA_PRINTF, "SPX: VALID call to disconnect_completion_routine\n");

		sptr_ecb_socket_entry = sptr_ecb->sptr_ecb_socket_entry;

		if (sptr_ecb_socket_entry == NULL)
			{
			spx_printf (SPX_ALARM_PRINTF, "SPX: pointer to ecb socket entry is NULL\n");

			return;
			}
			
		sptr_user_socket = sptr_ecb_socket_entry->sptr_user_socket;

		if ((sptr_user_socket != NULL) && (sptr_user_socket != (USER_SOCKET *) INVALID_SOCKET_DESCRIPTOR))
			{
			if (sptr_ecb_socket_entry->connection_terminated == FALSE)
				{
				sptr_lsl_message = spx_generate_message (sptr_ecb_socket_entry->sptr_user_socket, sptr_ecb_socket_entry,
					CONNECTION_CLOSED);

				spx_printf (SPX_MESSAGE_PRINTF, "SPX: CONNECTION CLOSED message placed in mailbox\n");

				spx_close_socket (sptr_ecb_socket_entry->listen_connect_ecb.ecb.socket_number);

				sptr_user_socket->vptr_protocol_control_block = NULL;
				}
			else
				{
				sptr_lsl_message = spx_generate_message (sptr_ecb_socket_entry->sptr_user_socket, sptr_ecb_socket_entry,
					CONNECTION_CLOSE_COMPLETED);

				spx_printf (SPX_MESSAGE_PRINTF, "SPX: CONNECTION CLOSE COMPLETED message placed in mailbox\n");

				spx_close_socket (sptr_ecb_socket_entry->connect_ecb.ecb.socket_number);
				}

			lsl_control (RESOLVE_SOCKET_API, LINK_SERVICES_LAYER_TYPE, (ULONG) ADD_MESSAGE_TO_QUEUE, (ULONG) sptr_lsl_message,
				(ULONG) NULL);

			free_ecb_socket_entry_rx_list (sptr_ecb_socket_entry);

			free_ecb_socket_entry (sptr_ecb_socket_entry);
			}
		else
			{
			spx_printf (SPX_ALARM_PRINTF, "SPX: pointer to user socket is NULL\n");
			}
		}
	else
		{
		spx_printf (SPX_ALARM_PRINTF, "SPX: UNRECOGNIZED call to disconnect_completion_routine\n");
		}

	spx_printf (SPX_DATA_PRINTF, "SPX: number of listen sessions = %d\n", spx.number_of_listen_connections);

	spx_printf (SPX_DATA_PRINTF, "SPX: number of active sessions = %d\n", spx.number_of_active_connections);

	spx_printf (SPX_DATA_PRINTF, "SPX: number of open sockets = %d\n", spx.number_of_open_sockets);

	spx_printf (SPX_DATA_PRINTF, "SPX: number of ecb socket entries = %d\n", spx.number_of_ecb_socket_entries);
}
/****************************************************************************/
void free_ecb_socket_entry_rx_list (SPX_ECB_SOCKET_LIST_ENTRY *sptr_ecb_socket_entry)
{
	ECB_WITH_PACKET *sptr_ecb_with_packet;
	ECB_WITH_PACKET *sptr_ecb_with_packet_next;

	sptr_ecb_with_packet = (ECB_WITH_PACKET *) get_pointer_to_first_entry_in_list (
		(LINK *) &sptr_ecb_socket_entry->rx_ecb_list);

	while (sptr_ecb_with_packet != NULL)
		{
		sptr_ecb_with_packet_next = (ECB_WITH_PACKET *) get_pointer_to_next_entry_in_list (
			(LINK *) sptr_ecb_with_packet);

		delete_entry_from_list ((LINK *) &sptr_ecb_socket_entry->rx_ecb_list, (LINK *) sptr_ecb_with_packet);

	 	spx_printf (SPX_MEMORY_PRINTF, "SPX: Freeing ECB with packet (rx_ecb_list) %p\r\n", sptr_ecb_with_packet);

		buffer_free ((void *) sptr_ecb_with_packet);

		sptr_ecb_with_packet = sptr_ecb_with_packet_next;
		}
}
/****************************************************************************/
void free_ecb_socket_entry (SPX_ECB_SOCKET_LIST_ENTRY *sptr_ecb_socket_entry)
{
	void *vptr_buffer;

	if (sptr_ecb_socket_entry->listen_connect_ecb.ecb.fragment_descriptor[0].type.vptr_buffer != NULL)
		{
		vptr_buffer = ((void *) ((ULONG) sptr_ecb_socket_entry->listen_connect_ecb.ecb.fragment_descriptor[0].type.vptr_buffer -
			MINIMAL_EXTRA_FRAME_HEADER_BYTES));

	 	spx_printf (SPX_MEMORY_PRINTF, "SPX: Freeing listen connect ecb buffer %p\r\n",	vptr_buffer);

		buffer_free (vptr_buffer);
		}
		
	if (sptr_ecb_socket_entry->connect_ecb.ecb.fragment_descriptor[0].type.vptr_buffer != NULL)
		{
		vptr_buffer = ((void *) ((ULONG) sptr_ecb_socket_entry->connect_ecb.ecb.fragment_descriptor[0].type.vptr_buffer -
			MINIMAL_EXTRA_FRAME_HEADER_BYTES));

	 	spx_printf (SPX_MEMORY_PRINTF, "SPX: Freeing connect ecb buffer %p\r\n", vptr_buffer);

		buffer_free (vptr_buffer);
		}
		
	if (sptr_ecb_socket_entry->disconnect_ecb.ecb.fragment_descriptor[0].type.vptr_buffer != NULL)
		{
		vptr_buffer = ((void *) ((ULONG) sptr_ecb_socket_entry->disconnect_ecb.ecb.fragment_descriptor[0].type.vptr_buffer -
			MINIMAL_EXTRA_FRAME_HEADER_BYTES));

	 	spx_printf (SPX_MEMORY_PRINTF, "SPX: Freeing disconnect ecb buffer %p\r\n", vptr_buffer);

		buffer_free (vptr_buffer);
		}
		
	delete_entry_from_list ((LINK *) &spx.ecb_socket_list, (LINK *) sptr_ecb_socket_entry);

 	spx_printf (SPX_MEMORY_PRINTF, "SPX: Freeing ECB SOCKET ENTRY %p\r\n", sptr_ecb_socket_entry);

	table_free ((void *) sptr_ecb_socket_entry);

	--spx.number_of_ecb_socket_entries;
}
/*****************************************************************************************/
USHORT spx_get_data_from_ecb (SPX_ECB_SOCKET_LIST_ENTRY *sptr_ecb_socket_entry, ECB_WITH_PACKET **ptr_to_sptr_ecb_with_packet,
	void *vptr_data, USHORT length)
{
	USHORT current_length;

	current_length = length;

	while (current_length > 0x0000)
		{
		if (current_length >= (*ptr_to_sptr_ecb_with_packet)->ecb.fragment_descriptor[0].size_of_buffer)
			{
			*ptr_to_sptr_ecb_with_packet = (ECB_WITH_PACKET *) get_entry_from_list ((LINK *)
				&sptr_ecb_socket_entry->rx_ecb_list);

			memcpy (vptr_data, &(*ptr_to_sptr_ecb_with_packet)->data[(*ptr_to_sptr_ecb_with_packet)->current_byte_index],
				(*ptr_to_sptr_ecb_with_packet)->ecb.fragment_descriptor[0].size_of_buffer);

			current_length = (USHORT) (current_length -
				(*ptr_to_sptr_ecb_with_packet)->ecb.fragment_descriptor[0].size_of_buffer);

			vptr_data = (void *) ((ULONG) vptr_data + (*ptr_to_sptr_ecb_with_packet)->ecb.fragment_descriptor[0].size_of_buffer);

		 	spx_printf (SPX_MEMORY_PRINTF, "SPX: Freeing ECB with packet (when app reads data) %p\r\n",
		 		*ptr_to_sptr_ecb_with_packet);

			buffer_free (*ptr_to_sptr_ecb_with_packet);

			spx_listen_for_data (sptr_ecb_socket_entry);
			}
		else
			{
			memcpy (vptr_data, &(*ptr_to_sptr_ecb_with_packet)->data[(*ptr_to_sptr_ecb_with_packet)->current_byte_index],
				current_length);

			(*ptr_to_sptr_ecb_with_packet)->ecb.fragment_descriptor[0].size_of_buffer =
				(USHORT) ((*ptr_to_sptr_ecb_with_packet)->ecb.fragment_descriptor[0].size_of_buffer - current_length);

			(*ptr_to_sptr_ecb_with_packet)->current_byte_index = (USHORT) ((*ptr_to_sptr_ecb_with_packet)->current_byte_index +
				current_length);

			current_length = 0x0000;

			if ((*ptr_to_sptr_ecb_with_packet)->ecb.fragment_descriptor[0].size_of_buffer == 0x0000)
				{
				delete_entry_from_list ((LINK *) &sptr_ecb_socket_entry->rx_ecb_list, (LINK *) *ptr_to_sptr_ecb_with_packet);

			 	spx_printf (SPX_MEMORY_PRINTF, "SPX: Freeing ECB with packet (when app reads data) %p\r\n",
			 		*ptr_to_sptr_ecb_with_packet);

				buffer_free (*ptr_to_sptr_ecb_with_packet);

				spx_listen_for_data (sptr_ecb_socket_entry);
				}

			break;
			}

		*ptr_to_sptr_ecb_with_packet = (ECB_WITH_PACKET *) sptr_ecb_socket_entry->rx_ecb_list.sptr_forward_link;

		if (*ptr_to_sptr_ecb_with_packet == NULL)
			{
			break;
			}

		(*ptr_to_sptr_ecb_with_packet)->current_byte_index	= 0x0000;
		}

	return ((USHORT) (length - current_length));
}
/****************************************************************************/
void spx_listen_for_data (SPX_ECB_SOCKET_LIST_ENTRY *sptr_ecb_socket_entry)
{
	ECB_WITH_PACKET *sptr_ecb_with_packet;

	sptr_ecb_with_packet = build_listen_ecb (sptr_ecb_socket_entry);

   /* Naveen 20/06/1997 */
   if (!sptr_ecb_with_packet)
      return ;
   /* Naveen 20/06/1997 */

	spx_listen_for_sequenced_packets (sptr_ecb_socket_entry->session_handle, &sptr_ecb_with_packet->ecb);
}
/****************************************************************************/
static ECB_WITH_PACKET *build_listen_ecb (SPX_ECB_SOCKET_LIST_ENTRY *sptr_ecb_socket_entry)
{
	ECB_WITH_PACKET *sptr_ecb_with_packet;

	sptr_ecb_with_packet = buffer_malloc (sizeof (ECB_WITH_PACKET));

	if (sptr_ecb_with_packet == NULL)
		{
	 	spx_printf (SPX_MEMORY_PRINTF, "SPX: buffer_malloc failed\n");

		return (sptr_ecb_with_packet);
		}

 	spx_printf (SPX_MEMORY_PRINTF, "SPX: Allocated ECB with packet %p\r\n", sptr_ecb_with_packet);

	sptr_ecb_with_packet->ecb.links.sptr_forward_link = NULL;
	sptr_ecb_with_packet->ecb.in_use = 0x00;
	sptr_ecb_with_packet->ecb.completion_code = 0x00;
	sptr_ecb_with_packet->ecb.socket_number = sptr_ecb_socket_entry->local_address.socket;

	memcpy ((void *) &sptr_ecb_with_packet->ecb.destination_ipx_address, &sptr_ecb_socket_entry->remote_address,
		sizeof (ULONG) + sizeof (MAC_ADDRESS));

	sptr_ecb_with_packet->ecb.fragment_count = 1;
	sptr_ecb_with_packet->ecb.fragment_descriptor[0].type.vptr_buffer = &sptr_ecb_with_packet->mac_header;
	sptr_ecb_with_packet->ecb.fragment_descriptor[0].size_of_buffer =	(USHORT) (sizeof (SPX_PACKET) + 1520);
	sptr_ecb_with_packet->sptr_ecb_socket_entry = sptr_ecb_socket_entry;
	sptr_ecb_with_packet->ecb.fptr_event_service_routine = (void (*) (EVENT_CONTROL_BLOCK *)) listen_completion_routine;

	sptr_ecb_with_packet->current_byte_index = 0x0000;

 	spx_printf (SPX_DATA_PRINTF, "SPX: Build listen ECB\r\n");

	return (sptr_ecb_with_packet);
}
/****************************************************************************/
static void listen_completion_routine (EVENT_CONTROL_BLOCK *sptr_ecb)
{
	ECB_WITH_PACKET *sptr_ecb_with_packet;
	SPX_ECB_SOCKET_LIST_ENTRY *sptr_ecb_socket_entry;
	LSL_MESSAGE *sptr_lsl_message;

	sptr_ecb_with_packet = (ECB_WITH_PACKET *) ((ULONG) sptr_ecb - sizeof (ECB_WITH_PACKET_LINKS));

	if (sptr_ecb_with_packet->ecb.completion_code == SPX_SUCCESSFUL)
		{
		sptr_ecb_with_packet->current_byte_index = 0x0000;

		sptr_ecb_socket_entry = sptr_ecb_with_packet->sptr_ecb_socket_entry;

		if (sptr_ecb_socket_entry == NULL)
			{
			spx_printf (SPX_ALARM_PRINTF, "SPX: pointer to ecb socket entry is NULL\n");

			return;
			}

		add_entry_to_list ((LINK *) &sptr_ecb_socket_entry->rx_ecb_list, (LINK *) &sptr_ecb_with_packet->links);

		sptr_lsl_message = spx_generate_message (sptr_ecb_socket_entry->sptr_user_socket, sptr_ecb_socket_entry,
			READ_DATA_FROM_SOCKET);

		lsl_control (RESOLVE_SOCKET_API, LINK_SERVICES_LAYER_TYPE, (ULONG) ADD_MESSAGE_TO_QUEUE, (ULONG) sptr_lsl_message,
			(ULONG) NULL);

		spx_printf (SPX_MESSAGE_PRINTF, "SPX: READ DATA FROM SOCKET message placed in mailbox: %d\n",
			sptr_lsl_message->destination_id);
		}
	else
		{
		/* should the ecb be freed ##### */

		spx_printf (SPX_ALARM_PRINTF, "SPX: UNRECOGNIZED call to listen_completion_routine\n");
		}
}
