#include "defs.h"
/*	$Modname: spxstate.c$  $version: 1.4$      $date: 08/08/94$   */
/*
* 	$lgb$
1.0 07/19/94 ross
1.1 07/21/94 ross
1.2 07/23/94 ross watchdog across router timed correctly.
1.3 08/08/94 ross Initial release
1.4 08/08/94 ross Added copyright
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1994 RouterWare, Inc.												*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Blvd. Suite 212, Newport Beach Ca   */
/************************************************************************/
#include "spx.h"
#include "vspxstat.h"
/****************************************************************************/
void execute_spx_state_machine (enum SPX_EVENT spx_event, SPX_SESSION_CLASS *sptr_session, EVENT_CONTROL_BLOCK *sptr_ecb)
{
	enum SPX_CONNECTION_STATE original_state;

	original_state = (enum SPX_CONNECTION_STATE) sptr_session->state;

	if (spx_state_machine_table[original_state][spx_event].end_state == ILLEGAL_SPX_STATE)
		{
		spx_printf (SPX_ALARM_PRINTF,"SPX:Error in state machine %04x, Event %04x \r\n",
			sptr_session->connection_id,(USHORT) spx_event);

		return;
		}

	if (spx_state_machine_table[original_state][spx_event].fptr_state_function != NULL)
		{
		if ((spx_state_machine_table[original_state][spx_event].end_state != NO_CHANGE_TO_SPX_STATE) &&
			(spx_state_machine_table[original_state][spx_event].fptr_state_function != set_spx_state))
			{
			set_spx_state (sptr_session,sptr_ecb,spx_state_machine_table[original_state][spx_event].end_state);

			sptr_session->old_state = (BYTE_ENUM (SPX_CONNECTION_STATE)) original_state;
			}

		(*spx_state_machine_table[original_state][spx_event].fptr_state_function) (sptr_session,sptr_ecb,
			spx_state_machine_table[original_state][spx_event].end_state);
		}

	if (spx_state_machine_table[original_state][spx_event].fptr_state_function_1 != NULL)
		{
		if ((spx_state_machine_table[original_state][spx_event].end_state_1 != NO_CHANGE_TO_SPX_STATE) &&
			(spx_state_machine_table[original_state][spx_event].fptr_state_function_1 != set_spx_state))
			{
			set_spx_state (sptr_session,sptr_ecb,spx_state_machine_table[original_state][spx_event].end_state_1);

			sptr_session->old_state = (BYTE_ENUM (SPX_CONNECTION_STATE)) original_state;
			}

		(*spx_state_machine_table[original_state][spx_event].fptr_state_function_1) (sptr_session,sptr_ecb,
			spx_state_machine_table[original_state][spx_event].end_state_1);
		}

	if (spx_state_machine_table[original_state][spx_event].fptr_state_function_2 != NULL)
		{
		if ((spx_state_machine_table[original_state][spx_event].end_state_2 != NO_CHANGE_TO_SPX_STATE) &&
			(spx_state_machine_table[original_state][spx_event].fptr_state_function_2 != set_spx_state))
			{
			set_spx_state (sptr_session,sptr_ecb,spx_state_machine_table[original_state][spx_event].end_state_2);

			sptr_session->old_state = (BYTE_ENUM (SPX_CONNECTION_STATE)) original_state;
			}

		(*spx_state_machine_table[original_state][spx_event].fptr_state_function_2) (sptr_session,sptr_ecb,
			spx_state_machine_table[original_state][spx_event].end_state_2);
		}
}
/****************************************************************************/
void set_spx_state (SPX_SESSION_CLASS *sptr_session,EVENT_CONTROL_BLOCK *sptr_ecb,enum SPX_CONNECTION_STATE end_state)
{
	PARAMETER_NOT_USED (sptr_ecb);

	if (end_state == ILLEGAL_SPX_STATE)
		{
		spx_printf (SPX_ALARM_PRINTF,"SPX:Error in state machine %04x, Event %04x \r\n",
			sptr_session->connection_id,(USHORT) end_state);

		return;
		}

	spx_printf (SPX_STATE_PRINTF,"SPX:Connection ID %04x - New State %04x\r\n",sptr_session->connection_id,(USHORT) end_state);

	sptr_session->state = (BYTE_ENUM (SPX_CONNECTION_STATE)) end_state;
}
/****************************************************************************/
void spx_null_state (SPX_SESSION_CLASS *sptr_session,EVENT_CONTROL_BLOCK *sptr_ecb,enum SPX_CONNECTION_STATE end_state)
{
	PARAMETER_NOT_USED (sptr_session);
	PARAMETER_NOT_USED (sptr_ecb);
	PARAMETER_NOT_USED (end_state);
}

