#include "defs.h"
/*	$Modname: spxtimer.c$  $version: 1.6$      $date: 08/02/95$   */
/*
* 	$lgb$
1.0 07/19/94 ross
1.1 07/21/94 ross
1.2 07/23/94 ross watchdog across router timed correctly.
1.3 08/08/94 ross Initial release
1.4 08/08/94 ross Added copyright
1.5 11/21/94 ross changed to compile under C++.
1.6 08/02/95 ross
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1994 RouterWare, Inc.												*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Blvd. Suite 212, Newport Beach Ca   */
/************************************************************************/
#include <stdio.h>
#include "spx.h"
/*************************************************************************/
static void session_timer (SPX_SESSION_CLASS *sptr_session);
static void monitor_connected_session (SPX_SESSION_CLASS *sptr_session);
/*************************************************************************/
void spx_timer (void)
{
	SPX_SESSION_CLASS *sptr_session;
	SPX_SESSION_CLASS *sptr_next_session;

	if (spx.timer_enabled == FALSE)
		{
		return;
		}

	if (++spx._1_second_counter >= spx.clock_ticks_per_second)
		{
		spx._1_second_counter = 0x00000000L;
		}

	for (sptr_session = (SPX_SESSION_CLASS *) spx.session_list.sptr_forward_link; sptr_session != NULL; )
		{
		sptr_next_session	= (SPX_SESSION_CLASS *) sptr_session->links.sptr_forward_link;

		if (sptr_session->state == SPX_CONNECTED)
			{
			/* Call connection monitor stuff once per "tick" when in state */

			monitor_connected_session (sptr_session);
			}
		else if (spx._1_second_counter == 0)
			{
			/* Call session_timer stuff once per second when in state */

			session_timer (sptr_session);	/* this can remove a session so get next link */
			}

		sptr_session = sptr_next_session;
		}
#if 0
	fflush (stdout);
#endif
}
/*************************************************************************/
static void session_timer (SPX_SESSION_CLASS *sptr_session)
{
	EVENT_CONTROL_BLOCK *sptr_connect_ecb;

	if (sptr_session->sptr_connect_ecb != NULL)
		{
		sptr_connect_ecb = sptr_session->sptr_connect_ecb;
		}
	else
		{
		sptr_connect_ecb = sptr_session->sptr_listen_connect_ecb;
		}

	if (sptr_session->state == SPX_CONNECT_REQUEST_SENT)
		{
		if (sptr_session->current_number_of_connection_retries >= sptr_session->number_of_connection_retries)
			{
			sptr_session->current_number_of_connection_retries = 0x0000;

			execute_spx_state_machine (SPX_NO_ANSWER_FROM_TARGET,sptr_session,sptr_session->sptr_disconnect_ecb);
			}
		else
			{
			++sptr_session->current_number_of_connection_retries;

			execute_spx_state_machine (SPX_WAITING_FOR_ACK_FROM_TARGET,sptr_session,sptr_connect_ecb);
			}
		}
	else if (sptr_session->state == SPX_DISCONNECTING)
		{
		if (sptr_session->current_number_of_disconnection_retries >= sptr_session->number_of_disconnection_retries)
			{
			sptr_session->current_number_of_disconnection_retries = 0x0000;

			execute_spx_state_machine (SPX_NO_ANSWER_FOR_DISCONNECT_FROM_TARGET,sptr_session,sptr_session->sptr_disconnect_ecb);
			}
		else
			{
			++sptr_session->current_number_of_disconnection_retries;

			execute_spx_state_machine (SPX_WAITING_FOR_DACK_FROM_TARGET,sptr_session,sptr_connect_ecb);
			}
		}
	else if (sptr_session->state == SPX_CONNECTED)
		{
		monitor_connected_session (sptr_session);
		}
}
/*************************************************************************/
static void monitor_connected_session (SPX_SESSION_CLASS *sptr_session)
{
	EVENT_CONTROL_BLOCK *sptr_connect_ecb;

	if (sptr_session->sptr_connect_ecb != NULL)
		{
		sptr_connect_ecb = sptr_session->sptr_connect_ecb;
		}
	else
		{
		sptr_connect_ecb = sptr_session->sptr_listen_connect_ecb;
		}

	if (sptr_session->watchdog == TRUE)
		{
		++sptr_session->time_since_last_watchdog_packet_rxed;

		if (sptr_session->time_since_last_watchdog_packet_rxed > sptr_session->watchdog_timeout)
			{
			if (sptr_session->current_number_of_watchdog_retries >= spx.number_of_watchdog_retries)
				{
				sptr_session->current_number_of_watchdog_retries = 0x0000;
				sptr_session->time_since_last_watchdog_packet_rxed = 0x00000000L;
				sptr_session->current_watchdog_timer = 0x00000000L;

				spx_printf (SPX_ALARM_PRINTF,"SPX: Watchdog Timeout Occurred\r\n");

				++spx.statistics.number_of_session_aborts;

				execute_spx_state_machine (SPX_TX_WATCHDOG_TIMEOUT,sptr_session,sptr_session->sptr_disconnect_ecb);
				}
			else
				{
				++sptr_session->current_number_of_watchdog_retries;

				sptr_session->current_watchdog_timer = 0x00000000L;

				spx_printf (SPX_MESSAGE_PRINTF,"SPX: Watchdog Retry Transmitted\r\n");

				execute_spx_state_machine (SPX_TX_WATCHDOG_RETRY,sptr_session,sptr_connect_ecb);
				}
			}
		else if (++sptr_session->current_watchdog_timer >= sptr_session->watchdog_timeout)
			{
			sptr_session->current_watchdog_timer = 0x00000000L;

			spx_printf (SPX_MESSAGE_PRINTF,"SPX: Transmit Watchdog\r\n");

			execute_spx_state_machine (SPX_TX_WATCHDOG,sptr_session,sptr_connect_ecb);
			}
		}

	if (sptr_session->ack_number != sptr_session->sequence_number)
		{
		++sptr_session->time_since_last_data_ack_packet_rxed;

		if ((sptr_session->time_since_last_data_ack_packet_rxed >= spx.ack_timeout) && (spx.ack_timeout > 0x0000))
			{
			if (sptr_session->current_number_of_data_retries >= sptr_session->number_of_data_retries)
				{
				sptr_session->current_number_of_data_retries = 0x0000;
				sptr_session->time_since_last_data_ack_packet_rxed = 0x00000000L;

				spx_printf (SPX_ALARM_PRINTF,"SPX: Retransmission Failure \r\n");

				execute_spx_state_machine (SPX_TX_DATA_NO_ACK_TIMEOUT,sptr_session,sptr_session->sptr_disconnect_ecb);
				}
			else
				{
				spx_printf (SPX_ALARM_PRINTF,"SPX: Retransmitting Packet \r\n");

				++sptr_session->current_number_of_data_retries;

				sptr_session->time_since_last_data_ack_packet_rxed = 0x00000000L;

				execute_spx_state_machine (SPX_TX_DATA_NO_ACK,sptr_session,sptr_connect_ecb);
				}
			}
		}
}
