/*	$Modname: vspxstr.h$  $version: 1.6$      $date: 08/02/95$   */
/*
* 	$lgb$
1.0 07/19/94 ross
1.1 07/21/94 ross
1.2 07/23/94 ross watchdog across router timed correctly.
1.3 08/08/94 ross Initial release
1.4 08/08/94 ross Added copyright
1.5 11/21/94 ross changed to compile under C++.
1.6 08/02/95 ross
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1994 RouterWare, Inc.												*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Blvd. Suite 212, Newport Beach Ca   */
/************************************************************************/

typedef	struct	SPX_STATE_MACHINE_TABLE
{
	void (*fptr_state_function) (struct SPX_SESSION_CLASS *sptr_session,struct EVENT_CONTROL_BLOCK *sptr_ecb,
		enum SPX_CONNECTION_STATE end_state);

	enum SPX_CONNECTION_STATE end_state;

	void (*fptr_state_function_1) (struct SPX_SESSION_CLASS *sptr_session,struct EVENT_CONTROL_BLOCK *sptr_ecb,
		enum SPX_CONNECTION_STATE end_state);

	enum SPX_CONNECTION_STATE end_state_1;

	void (*fptr_state_function_2) (struct SPX_SESSION_CLASS *sptr_session,struct EVENT_CONTROL_BLOCK *sptr_ecb,
		enum SPX_CONNECTION_STATE end_state);

	enum SPX_CONNECTION_STATE end_state_2;
} SPX_STATE_MACHINE_TABLE;


typedef	union	UNION_NETWARE_BUFFER
{
	void  				*vptr_buffer;
	BYTE  				*bptr_buffer;
	IPX_HEADER  		*sptr_ipx_header;
	struct SPX_HEADER	*sptr_spx_header;
	struct SPX_PACKET	*sptr_spx_packet;
} UNION_NETWARE_BUFFER;


typedef struct ECB_BUFFER_DESCRIPTOR
{
	UNION_NETWARE_BUFFER 	type;
	USHORT	 					size_of_buffer;	
} ECB_BUFFER_DESCRIPTOR;


typedef struct EVENT_CONTROL_BLOCK_LINK
{
	struct EVENT_CONTROL_BLOCK *sptr_forward_link;
	struct EVENT_CONTROL_BLOCK *sptr_backward_link;
} EVENT_CONTROL_BLOCK_LINK;


typedef struct EVENT_CONTROL_BLOCK
{
	EVENT_CONTROL_BLOCK_LINK 	links;

	void 								(*fptr_event_service_routine) (struct EVENT_CONTROL_BLOCK *sptr_ecb);

	BYTE  							in_use;
	BYTE  							completion_code;
	USHORT							socket_number;

	ULONG								session_handle;
	IPX_ADDRESS						destination_ipx_address;

	MAC_ADDRESS  					immediate_address;
	USHORT							fragment_count;
	ECB_BUFFER_DESCRIPTOR		fragment_descriptor[1];

} EVENT_CONTROL_BLOCK;


typedef	struct	SPX_CONNECTION_CONTROL
{
#ifndef BIG_ENDIAN
	unsigned	int	reserved:4;
	unsigned	int	end_of_message:1;
	unsigned	int	attention:1;
	unsigned	int	ack_required:1;
	unsigned	int	system_packet:1;
#else
	unsigned	int	system_packet:1;
	unsigned	int	ack_required:1;
	unsigned	int	attention:1;
	unsigned	int	end_of_message:1;
	unsigned	int	reserved:4;
#endif
} SPX_CONNECTION_CONTROL;


typedef	union	UNION_SPX_CONNECTION_CONTROL
{
	SPX_CONNECTION_CONTROL	_bit;
	BYTE							_byte;
} UNION_SPX_CONNECTION_CONTROL;


typedef	struct	SPX_HEADER
{
	UNION_SPX_CONNECTION_CONTROL		connection_control;
	BYTE_ENUM (SPX_DATASTREAM_TYPE)	datastream_type;

	/* all below are big endian */

	USHORT									source_connection_id;
	USHORT									destination_connection_id;

	USHORT									sequence_number;
	USHORT									ack_number;
	USHORT									allocation_number;
} SPX_HEADER;


typedef	struct	SPX_PACKET
{
	MAC_HEADER		mac_header;
	IPX_HEADER		ipx_header;
	SPX_HEADER		spx_header;
	BYTE				data[VARIABLE_NUMBER_OF_BYTES];
} SPX_PACKET;


typedef	struct	SPX_ACK_PACKET
{
	MAC_HEADER		mac_header;
	IPX_HEADER		ipx_header;
	SPX_HEADER		spx_header;
} SPX_ACK_PACKET;


typedef	struct	SPX_SOCKET_LIST_ENTRY_LINK
{
	struct SPX_SOCKET_LIST_ENTRY *sptr_forward_link;
	struct SPX_SOCKET_LIST_ENTRY *sptr_backward_link;
} SPX_SOCKET_LIST_ENTRY_LINK;


typedef	struct	SPX_SOCKET_LIST_ENTRY
{
	SPX_SOCKET_LIST_ENTRY_LINK		links;
	USHORT								socket;
} SPX_SOCKET_LIST_ENTRY;


typedef	struct	SPX_STATISTICS
{
	ULONG	number_of_tx_frames;
	ULONG	number_of_tx_bytes;
	ULONG	number_of_tx_frames_discarded;
	ULONG	number_of_tx_resyncs;
	ULONG	number_of_session_aborts;
	ULONG	number_of_unknown_dlcis;
	ULONG	number_of_illegal_dlcis;
	ULONG	number_rxed_greater_than_maximum_size;
	ULONG	number_rxed_less_than_minumum_size;
	ULONG	number_rxed_in_disabled_port;
	ULONG	number_txed_on_disabled_port;
	ULONG	number_of_rx_frames;
	ULONG	number_of_rx_bytes;
	ULONG	number_of_rx_frames_discarded;
	ULONG	number_of_invalid_ipx_frames; 							/* temporary */
} SPX_STATISTICS;


typedef	struct	SPX_ECB_SOCKET_LIST_ENTRY_LINK
{
	struct SPX_ECB_SOCKET_LIST_ENTRY 		*sptr_forward_link;
	struct SPX_ECB_SOCKET_LIST_ENTRY 		*sptr_backward_link;
} SPX_ECB_SOCKET_LIST_ENTRY_LINK;


typedef	struct	ECB_WITH_BACKWARD_REFERENCE
{
	EVENT_CONTROL_BLOCK							ecb;
	struct	SPX_ECB_SOCKET_LIST_ENTRY		*sptr_ecb_socket_entry;
} ECB_WITH_BACKWARD_REFERENCE;


typedef	struct	ECB_WITH_PACKET_LINKS
{
	struct	ECB_WITH_PACKET 					*sptr_forward_link;
	struct	ECB_WITH_PACKET 					*sptr_backward_link;
} ECB_WITH_PACKET_LINKS;


typedef	struct	ECB_WITH_PACKET
{
	ECB_WITH_PACKET_LINKS						links;
	EVENT_CONTROL_BLOCK 							ecb;
	USHORT 											current_byte_index;
	struct SPX_ECB_SOCKET_LIST_ENTRY			*sptr_ecb_socket_entry;

	BYTE												packet_extra_header_bytes[MINIMAL_EXTRA_FRAME_HEADER_BYTES];
	MAC_HEADER										mac_header;
	IPX_HEADER										ipx_header;
	SPX_HEADER										spx_header;
	BYTE												data[1520];
} ECB_WITH_PACKET;


typedef	struct	SPX_ECB_SOCKET_LIST_ENTRY
{
	SPX_ECB_SOCKET_LIST_ENTRY_LINK			links;
	IPX_ADDRESS										local_address;
	IPX_ADDRESS										remote_address;
	USER_SOCKET 									*sptr_user_socket;
	ULONG 											application_id;
	USHORT 											listen_mode;
	ECB_WITH_BACKWARD_REFERENCE 				listen_connect_ecb;
	ECB_WITH_BACKWARD_REFERENCE 				connect_ecb;
	ECB_WITH_BACKWARD_REFERENCE 				disconnect_ecb;
	ULONG												session_handle;
	enum BOOLEAN 									listening_for_connection;
	enum BOOLEAN 									connection_initiated;
	enum BOOLEAN 									connection_is_up;
	enum BOOLEAN 									connection_terminated;
	ECB_WITH_PACKET_LINKS						rx_ecb_list;
	ULONG												total_number_of_bytes_in_rx_packets;
	ULONG												number_of_packets_rxed;
	ULONG												number_of_packets_txed;
} SPX_ECB_SOCKET_LIST_ENTRY;


typedef	struct	SPX_PACKET_HEADER
{
	MAC_HEADER					mac_header;
	IPX_HEADER					ipx_header;
	SPX_HEADER					spx_header;
} SPX_PACKET_HEADER;


typedef	struct	SPX_SESSION_CLASS_LINK
{
	struct SPX_SESSION_CLASS 		*sptr_forward_link;
	struct SPX_SESSION_CLASS 		*sptr_backward_link;
} SPX_SESSION_CLASS_LINK;


typedef	struct	SPX_SESSION_CLASS
{
	SPX_SESSION_CLASS_LINK				links;
	BYTE_ENUM (SPX_CONNECTION_STATE)	state;
	BYTE_ENUM (SPX_CONNECTION_STATE)	old_state;

	EVENT_CONTROL_BLOCK_LINK			unacked_send_ecb_list;
	EVENT_CONTROL_BLOCK_LINK			unsent_send_ecb_list;
	EVENT_CONTROL_BLOCK_LINK			listen_ecb_list;

	EVENT_CONTROL_BLOCK					*sptr_connect_ecb;
	EVENT_CONTROL_BLOCK					*sptr_listen_connect_ecb;
	EVENT_CONTROL_BLOCK					*sptr_disconnect_ecb;

	ULONG										ack_timeout;
	USHORT									number_of_data_retries;
	USHORT									current_number_of_data_retries;
	ULONG										time_since_last_data_ack_packet_rxed;

	enum BOOLEAN							watchdog;
	USHORT									current_number_of_watchdog_retries;
	ULONG										time_since_last_watchdog_packet_rxed;
	ULONG										current_watchdog_timer;
	ULONG										watchdog_timeout;

	USHORT									socket;
	IPX_ADDRESS								destination_ipx_address;

	USHORT									connection_id;
	USHORT									sequence_number;
	USHORT									ack_number;
	USHORT									last_ack_number;
	USHORT									allocation_number;

	USHORT									remote_connection_id;
	USHORT									remote_sequence_number;
	USHORT									remote_ack_number;
	USHORT									remote_allocation_number;

	USHORT									number_of_connection_retries;
	USHORT									current_number_of_connection_retries;
	USHORT									number_of_disconnection_retries;
	USHORT									current_number_of_disconnection_retries;

	USHORT									retry_count;				
	ULONG										round_trip_timer;			
	USHORT									retransmit_count;

	USHORT									lprotocol_id;			
	BYTE										protocol_id[6];		
	MAC_ADDRESS								router_or_destination_mac_address;
	void										*vptr_context;
	SPX_STATISTICS							statistics;
	EVENT_CONTROL_BLOCK					*previous_unacked_packet;
} SPX_SESSION_CLASS;


typedef	struct	SPX_CLASS
{
	BYTE_ENUM (BOOLEAN)					enabled;
	BYTE_ENUM (BOOLEAN) 					timer_enabled;
	USHORT									transport_id;
	ULONG										total_number_of_spx_ports;

	USHORT 									maximum_number_of_ecbs;
	USHORT 									maximum_packet_size;
	USHORT 									maximum_number_of_connections;
	USHORT 									maximum_number_of_available_connections;

	USHORT									number_of_connection_retries;
	USHORT									number_of_disconnection_retries;
	USHORT									number_of_data_retries;
	USHORT									number_of_watchdog_retries;

	ULONG										ack_timeout;
	ULONG										watchdog_timeout;

	BYTE										major_revision;
	BYTE										minor_revision;
	BYTE										revision_level;

	SPX_SESSION_CLASS_LINK				session_list;
	USHORT 									number_of_listen_connections;
	USHORT 									number_of_active_connections;
	SPX_SOCKET_LIST_ENTRY_LINK			socket_list;
	USHORT 									number_of_open_sockets;
	SPX_ECB_SOCKET_LIST_ENTRY_LINK	ecb_socket_list;
	USHORT 									number_of_ecb_socket_entries;
	EVENT_CONTROL_BLOCK_LINK			internal_ecb_list;

	BYTE_ENUM (BOOLEAN)					printing_enabled;
	BYTE_ENUM (BOOLEAN)					message_printing_enabled;
	BYTE_ENUM (BOOLEAN)					state_printing_enabled;
	BYTE_ENUM (BOOLEAN)					snmp_printing_enabled;
	BYTE_ENUM (BOOLEAN)					alarm_printing_enabled;
	BYTE_ENUM (BOOLEAN)					memory_printing_enabled;
	BYTE_ENUM (BOOLEAN)					data_printing_enabled;

	ULONG										clock_ticks_per_second;
	ULONG										_1_second_counter;
	SPX_STATISTICS							statistics;

	void 										(*fptr_alarm_function) (enum SPX_ALARM_TYPE error_type,
													USHORT port_number,ULONG parameter_1,ULONG parameter_2);

	void 										(*fptr_snmp_trap_function) (ULONG index,USHORT dlci,enum SPX_RETURN_CODE state);

	SOCKET_FUNCTION_POINTERS 			socket_fptrs;
} SPX_CLASS;




/* spxapi.c */

SPX_ECB_SOCKET_LIST_ENTRY *spx_establish_connection (USER_SOCKET *sptr_user_socket, IPX_ADDRESS local_address,
	IPX_ADDRESS remote_address);
SPX_ECB_SOCKET_LIST_ENTRY *build_disconnect_ecb (SPX_ECB_SOCKET_LIST_ENTRY *sptr_ecb_socket_entry);
void free_ecb_socket_entry_rx_list (SPX_ECB_SOCKET_LIST_ENTRY *sptr_ecb_socket_entry);
void free_ecb_socket_entry (SPX_ECB_SOCKET_LIST_ENTRY *sptr_ecb_socket_entry);
USHORT spx_get_data_from_ecb (SPX_ECB_SOCKET_LIST_ENTRY *sptr_ecb_socket_entry, ECB_WITH_PACKET **ptr_to_sptr_ecb_with_packet,
	void *vptr_data, USHORT length);
void spx_listen_for_data (SPX_ECB_SOCKET_LIST_ENTRY *sptr_ecb_socket_entry);


/* spxlapi.c */

SPX_ECB_SOCKET_LIST_ENTRY *spx_listen_connect (USER_SOCKET *sptr_user_socket, IPX_ADDRESS local_address, USHORT mode);
enum BOOLEAN check_if_connection_to_destination_already_exists (ECB_WITH_BACKWARD_REFERENCE *sptr_ecb);
LSL_MESSAGE *spx_generate_message (USER_SOCKET *sptr_user_socket, SPX_ECB_SOCKET_LIST_ENTRY *sptr_ecb_socket_entry,
	enum APPLICATION_CONTROL_OPERATION command);
USHORT spx_send_data (SPX_ECB_SOCKET_LIST_ENTRY *sptr_ecb_socket_entry, void *vptr_data, USHORT length);


/* spxsock.c */

enum TEST socket_spx (USER_SOCKET *sptr_user_socket, USHORT protocol);
enum TEST socket_spx_listen (USER_SOCKET *sptr_user_socket, USHORT mode);
enum TEST socket_spx_connect (USER_SOCKET *sptr_user_socket);
USHORT socket_spx_receive (USER_SOCKET *sptr_user_socket, void *vptr_data, USHORT length, SOCKADDR *sptr_sockaddr,
	USHORT *usptr_address_length, enum TEST *eptr_error);
USHORT socket_spx_send (USER_SOCKET *sptr_user_socket, void *vptr_data, USHORT length, SOCKADDR *sptr_sockaddr,
	enum TEST *eptr_error);
enum TEST socket_spx_close (USER_SOCKET *sptr_user_socket);
enum TEST spx_check_ipx_address (SOCKADDR *sptr_sockaddr, USHORT sockaddr_length);


/* spxinit.c */


/* spxctrl.c */

enum TEST spx_control (enum TRANSPORT_CONTROL_OPERATION command, ULONG parameter_0, ULONG parameter_1);
void set_spx_class_to_zero (void);

/* spxcfg.c */

enum TEST spx_configuration (enum TRANSPORT_CONTROL_OPERATION command, ULONG parameter_0, ULONG parameter_1);
enum SPX_RETURN_CODE spx_get_configuration (USHORT *usptr_maximum_number_of_connections,
	USHORT *usptr_number_of_available_connections);
enum SPX_RETURN_CODE spx_get_version (BYTE *bptr_major_version,BYTE *bptr_minor_version,BYTE	*bptr_revision_level);


/* spxconn.c */

enum SPX_RETURN_CODE spx_connect (USHORT socket, BYTE number_of_connection_retries, enum BOOLEAN watchdog,
	ULONG *ulptr_session_handle, EVENT_CONTROL_BLOCK *sptr_connect_ecb, EVENT_CONTROL_BLOCK *sptr_listen_ecb);
void spx_abort_connection (ULONG connection_handle);
void spx_transmit_connection_ack (SPX_SESSION_CLASS *sptr_session,EVENT_CONTROL_BLOCK *sptr_ecb);
SPX_SESSION_CLASS *get_session_using_connection_id (USHORT connection_id);
void spx_transmit_disconnect (SPX_SESSION_CLASS *sptr_session,EVENT_CONTROL_BLOCK *sptr_ecb,enum SPX_CONNECTION_STATE end_state);
void spx_transmit_disconnect_ack (SPX_SESSION_CLASS *sptr_session,EVENT_CONTROL_BLOCK *sptr_ecb,enum SPX_CONNECTION_STATE end_state);
void spx_transmit_connection_established (SPX_SESSION_CLASS *sptr_session,EVENT_CONTROL_BLOCK *sptr_ecb);
void spx_connection_status (ULONG connection_handle,SPX_SESSION_CLASS *sptr_return_session);
SPX_SESSION_CLASS *get_session_using_socket (USHORT socket);
enum TEST set_connection_number (SPX_SESSION_CLASS *sptr_new_session);
SPX_SESSION_CLASS *find_session_class_corresponding_to_received_packet (SPX_PACKET *sptr_spx_rx_packet);
void spx_terminate_connection (ULONG connection_handle,EVENT_CONTROL_BLOCK *sptr_ecb);
void spx_delete_session	(SPX_SESSION_CLASS *sptr_session,EVENT_CONTROL_BLOCK *sptr_ecb,
	enum SPX_CONNECTION_STATE end_state);
void spx_abort_session	(SPX_SESSION_CLASS *sptr_session,EVENT_CONTROL_BLOCK *sptr_ecb,
	enum SPX_CONNECTION_STATE end_state);


/* spxtx.c */

enum TEST send_spx_packet (SPX_SESSION_CLASS *sptr_session,EVENT_CONTROL_BLOCK *sptr_ecb,enum SPX_PACKET_TYPE packet_type);
void spx_packet_transmitted (void *vptr_txed_buffer,USHORT number_of_bytes_txed);
void spx_send_data_ack_packet (SPX_SESSION_CLASS *sptr_session);
void spx_transmit_connection_request (SPX_SESSION_CLASS *sptr_session,EVENT_CONTROL_BLOCK *sptr_ecb);
void spx_transmit_watchdog_packet (SPX_SESSION_CLASS *sptr_session,EVENT_CONTROL_BLOCK *sptr_ecb,enum SPX_CONNECTION_STATE end_state);
void spx_transmit_watchdog_retry_packet (SPX_SESSION_CLASS *sptr_session,EVENT_CONTROL_BLOCK *sptr_ecb,
	enum SPX_CONNECTION_STATE end_state);
void spx_send_sequenced_packet (ULONG connection_handle,EVENT_CONTROL_BLOCK *sptr_ecb);
void spx_resend_data_packet (SPX_SESSION_CLASS *sptr_session,EVENT_CONTROL_BLOCK *sptr_ecb,
	enum SPX_CONNECTION_STATE end_state);
void spx_send_internal_packet (SPX_SESSION_CLASS *sptr_session,enum SPX_PACKET_TYPE packet_type);
void spx_internal_transmit_disconnect (SPX_SESSION_CLASS *sptr_session,EVENT_CONTROL_BLOCK *sptr_ecb,
	enum SPX_CONNECTION_STATE end_state);
void kickstart_transmit_queues (SPX_SESSION_CLASS *sptr_session);


/* spxrx.c */

enum RX_PACKET_STATE spx_receive_packet (SPX_PACKET *sptr_spx_rx_packet,USHORT number_of_bytes_received);
enum SPX_RETURN_CODE spx_listen_for_connection (BYTE number_of_connection_retries,enum BOOLEAN watchdog,
	ULONG *ulptr_connection_handle,EVENT_CONTROL_BLOCK *sptr_listen_connect_ecb,
	EVENT_CONTROL_BLOCK *sptr_disconnect_ecb);
void spx_listen_for_sequenced_packets (ULONG connection_handle,EVENT_CONTROL_BLOCK *sptr_listen_ecb);
void spx_pass_rx_packet_to_upper_layer (SPX_SESSION_CLASS *sptr_session,EVENT_CONTROL_BLOCK *sptr_listen_ecb,
	enum SPX_CONNECTION_STATE end_state);
void spx_data_ack_received (SPX_SESSION_CLASS *sptr_session,SPX_PACKET *sptr_spx_ack_packet,enum SPX_CONNECTION_STATE end_state);
void spx_watchdog_packet_received (SPX_SESSION_CLASS *sptr_session,EVENT_CONTROL_BLOCK *sptr_listen_ecb,
	enum SPX_CONNECTION_STATE end_state);
void spx_watchdog_retry_packet_received (SPX_SESSION_CLASS *sptr_session,EVENT_CONTROL_BLOCK *sptr_ecb,
	enum SPX_CONNECTION_STATE end_state);
void check_hop_count (SPX_SESSION_CLASS *sptr_session,BYTE hop_count);


/* spxutil.c */

SPX_PACKET *spx_get_a_send_packet (ULONG size_of_packet);
void spx_free_a_send_packet (SPX_PACKET *sptr_txed_packet);
void spx_send_completion (USHORT port_number, SPX_PACKET *sptr_txed_packet);
enum SPX_RETURN_CODE spx_ecb_error_check (enum BOOLEAN error_checking_on);
enum SPX_RETURN_CODE spx_cancel_packet (EVENT_CONTROL_BLOCK  *sptr_ecb);
enum SPX_RETURN_CODE spx_check_socket (USHORT socket);
enum SPX_RETURN_CODE spx_open_socket (USHORT *usptr_socket);
enum SPX_RETURN_CODE spx_close_socket (USHORT socket);
void call_ecb_esr (EVENT_CONTROL_BLOCK *sptr_ecb);
void spx_printf (enum SPX_PRINTF_GROUPS printf_group,const char *cptr_format, ...);
SPX_SOCKET_LIST_ENTRY *find_socket (USHORT socket);


/* spxsnmp.c */


/* spxstate.c */

void execute_spx_state_machine (enum SPX_EVENT spx_event,SPX_SESSION_CLASS *sptr_session,EVENT_CONTROL_BLOCK *sptr_ecb);


/* spxtimer.c */

void spx_timer (void);


/* ipxinit.c */

enum TEST register_transport_to_ipx (char *cptr_transport_name,enum TRANSPORT_TYPE type,
	void (*fptr_packet_transmitted) (void *vptr_buffer,USHORT number_of_bytes),
	enum RX_PACKET_STATE (*fptr_rx_routine) (void *vptr_buffer,USHORT number_of_bytes),
	void (*fptr_timer_routine) (void),
	enum TEST (*fptr_control_routine) (enum TRANSPORT_CONTROL_OPERATION command,ULONG parameter_0,ULONG parameter_1),
	void *vptr_context[NUMBER_OF_IPX_PORTS],
	USHORT *usptr_return_transport_id);


/* ipxsnmp.c */

extern void get_ipx_mac_address_for_port (USHORT port_number,MAC_ADDRESS *sptr_mac_address);
