/*
** KTCP.H -- Constants and enumerated types related to TCP.
**			    Other constants are in TCP.H and TCPHDR.H.
*/

#ifndef _KTCP_
#define _KTCP_

#define PRINT_BUFSIZ		256

#define TCP_PORT_NUMBER			1024
#define TCP_RESERVED_PORT_NUMBER	900
#define MAX_TCP_PORT_NUMBER		0xFFFF

typedef ULONG IPADDR;
typedef long TCPSEQ;

enum TCP_PORT_TYPE
{
    NORMAL_PORT,
    RESERVED_PORT
};

enum TCP_PRINTF_GROUPS
{
	TCP_PRINTF,
	TCP_ALARM_PRINTF,
	TCP_DATA_PRINTF,
	TCP_DEBUG_PRINTF,
	TCP_STATES_PRINTF
};

/* FREE is for our convenience. The spec mentions only the others. */
enum TCP_STATES { FREE, CLOSED, LISTEN, SYN_RCVD, SYN_SENT, ESTAB, FIN_WAIT_1, 
						FIN_WAIT_2, CLOSING, TIME_WAIT, CLOSE_WAIT, LAST_ACK 
};

#endif

