/*
** TCPBUF.C -- Buffer management (huh?) routines
*/

#include <stdlib.h>

#include "rtrstd.h"
#include "all.h"
#include "tcpextrn.h"

/*
** tcp_get_user_buffer()
**		Call this function to retrieve a buffer to prepare a TCP segment in.
** Params:
**		Size of TCP header + TCP options + data to send
** Returns:
**		Ptr to a buffer from where TCP header can be built
** NOTES:
**		This routine reserves space for everything from the MAC header and the
**			frame header to the IP header also within the buffer, but returns a 
**			ptr to the point from where TCP header can be built.
*/
BYTE *
tcp_get_user_buffer(USHORT data_and_tcp_header_size)
{
	BYTE *bptr;

	bptr = (BYTE *) buffer_malloc(data_and_tcp_header_size + 
						sizeof(UNION_MAC_HEADER) + 
						MINIMUM_IP_HEADER_LENGTH +
						EXTRA_FRAME_HEADER_BYTES);
	if (bptr == NULL)
	{
		tcp_printf(TCP_ALARM_PRINTF, "TCP: Unable to allocate memory for segment...send postponed\n");
	}
	else
	{
#if defined(DEBUG)
		tcp_printf(TCP_ALARM_PRINTF, "TCP: Alloced - %d\n",bptr);
#endif /* DEBUG */
		bptr += EXTRA_FRAME_HEADER_BYTES + MINIMUM_IP_HEADER_LENGTH +
						sizeof(UNION_MAC_HEADER);
	}
	return bptr;
}


/* 
** tcp_free_user_buffer()
**		Performs the reverse of tcp_get_user_buffer()
** Params:
**		Ptr to buffer to free
** NOTES:
**	1. Though when allocating, we adjust the buffer pointer forward by
**		IP header length + MAC header length + some extra bytes, here we
**		adjust back only by the extra bytes length. This is because the lower
**		layers, from where the buffer would have come back for freeing, would
**		have done the adjustment by the IP header and the MAC header lengths.
*/
void
tcp_free_user_buffer(BYTE *bptr)
{
	bptr -= EXTRA_FRAME_HEADER_BYTES;
#if defined(DEBUG)
	tcp_printf(TCP_ALARM_PRINTF, "TCP: Releasing - %d\n",bptr);
#endif /* DEBUG */
	buffer_free((void *)bptr);
}

/* 
** tcp_alt_free_user_buffer()
**		Performs the reverse of tcp_get_user_buffer(). Similar to 
**		tcp_free_user_buffer() but adjusts the pointer to consider the space
**		for the IPX header and the MAC header.
** Params:
**		Ptr to buffer to free
** NOTES:
** 1.	tcp_free_user_buffer() should actually be called from a lower
** 	layer (IP) which would have adjusted the buffer pointer to
** 	covert the IP header and the MAC header (in the MAC layer). Since
** 	we are freeing the buffer here, we should do the lower layer's
** 	job.  So this alt function.
*/
void
tcp_alt_free_user_buffer(BYTE *bptr)
{
	bptr -= (EXTRA_FRAME_HEADER_BYTES + MINIMUM_IP_HEADER_LENGTH +
						sizeof(UNION_MAC_HEADER));
#if defined(DEBUG)
	tcp_printf(TCP_ALARM_PRINTF, "TCP: Releasing - %d\n",bptr);
#endif /* DEBUG */
	buffer_free((void *)bptr);
}


