/*
** TCPFGND.C -- The foreground function to be called for TCP. 
*/

#include "rtrstd.h"
#include "all.h"
#include "tcpextrn.h"

/*
** tcp_send_fgnd()
**		Decide on whether to send a segment or not and then invoke the
**		send function if needed.
*/
void
tcp_send_fgnd()
{
	USHORT i;
	TCP_PER_CONN *ptr_conn_info;


	ptr_conn_info = tcp.tcp_conn_table;
	for (i = 0; i < tcp.max_tcp_connection; i++, ptr_conn_info++)
	{
		if (ptr_conn_info->tcp_state == FREE)
			continue;

		if (
			(ptr_conn_info->send_filled != 0) 
			&&
			(
			((ptr_conn_info->conn_flags & (TCPF_SENDPSH | TCPF_SENDFIN)) != 0)
			||
			(ptr_conn_info->send_filled >= (ptr_conn_info->send_max_advert >> 1))
			||
			(ptr_conn_info->send_filled >= ptr_conn_info->send_mss)
			||
			(ptr_conn_info->send_filled >= ((ptr_conn_info->send_buf_size * 3) / 4))
			)
			)
		{
			/* Initiate a send if a PUSH or "Socket Close" has been requested
			** or the "current" send window is full.
			*/
			tcp_send(ptr_conn_info);
		}
		if (((ptr_conn_info->conn_flags & TCPF_SENDFIN) != 0) &&
			(ptr_conn_info->send_filled == 0))
		{
#if defined(DEBUG)
			tcp_printf(TCP_ALARM_PRINTF, "TCP: Sending FIN packet, State = %s\n",
						get_state_string(ptr_conn_info->tcp_state));
#endif /* DEBUG */
			/* Send also a FIN segment if all of other data has been sent */
			send_tcp_control_seg(ptr_conn_info, ptr_conn_info->send_nxt,
					ptr_conn_info->recv_nxt, FIN | ACK);
			add_to_tcp_rtx_queue(ptr_conn_info, ptr_conn_info->send_nxt, 0);
			ptr_conn_info->send_nxt += 1;	/* FIN has sequence space */

			/* Turn off the FIN bit, so we won't needlessly keep sending FIN.
			** If needed, the retransmit mechansim will take care of resending
			** the FIN if ACK is not received on time.
			*/
			ptr_conn_info->conn_flags &= ~TCPF_SENDFIN;

			/* Change TCP states */
			switch (ptr_conn_info->tcp_state)
			{
			default:
#if defined(DEBUG)
				tcp_printf(TCP_DEBUG_PRINTF, "TCP: Funny, FIN sent in state "
							"%s\n", get_state_string(ptr_conn_info->tcp_state));
#endif /* DEBUG */
				break;
			case SYN_RCVD:
			case ESTAB:
				tcp_printf(TCP_STATES_PRINTF, "TCP: Moved from %s state to FIN_WAIT_1 state\n", 
						get_state_string(ptr_conn_info->tcp_state));
				ptr_conn_info->tcp_state = FIN_WAIT_1;
				break;
			case CLOSE_WAIT:
				tcp_printf(TCP_STATES_PRINTF, "TCP: Moved from %s to LAST_ACK state\n", 
						get_state_string(ptr_conn_info->tcp_state));
				ptr_conn_info->tcp_state = LAST_ACK;
				/* Start the 2MSL timeout */
				tcp_start_2msl_timer(ptr_conn_info);
			}
		}
	}
}

#if defined(DEBUG)

/*
** tcp_debug()
**		Call this in debug code to check all connection records for reasonable
**		correctness.
*/
void
tcp_debug()
{
	USHORT i;
	TCP_PER_CONN *ptr_conn_info;


	ptr_conn_info = tcp.tcp_conn_table;
	for (i = 0; i < tcp.max_tcp_connection; i++, ptr_conn_info++)
	{
		if (is_not_valid_state(ptr_conn_info->tcp_state))
		{
			tcp_printf(TCP_DEBUG_PRINTF, "TCP: !@!@! Bad connection record\n");
		}
		if (ptr_conn_info->tcp_state == FREE)
			continue;

		/*
		if (is_broadcast_addr(ptr_conn_info->local_addr) ||
				is_broadcast_addr(ptr_conn_info->remote_addr))
		{
			tcp_printf(TCP_DEBUG_PRINTF, "TCP: !@!@! What! Broadcast addresses!\n");
		}
		*/
	}
}

BYTE_ENUM(BOOLEAN)
is_not_valid_state(enum TCP_STATES tcp_state)
{
	switch (tcp_state)
	{
	default:
		return TRUE;
		break;
	case FREE:
	case CLOSED:
	case LISTEN:
	case SYN_RCVD:
	case SYN_SENT:
	case ESTAB:
	case FIN_WAIT_1:
	case FIN_WAIT_2:
	case CLOSING:
	case TIME_WAIT:
	case CLOSE_WAIT:
	case LAST_ACK:
		return FALSE;
		break;
	}
}

#endif /* DEBUG */

