/*
** TCPRTX.C -- Code handling retransmissions and its support
*/

#include <string.h>
#include <stdlib.h>

#include "rtrstd.h"
#include "all.h"
#include "tcpextrn.h"

/*
** tcp_rtx()
**		Retransmits unack'ed part of send window. Keeps track of number of
**		retries (aborting connection if it exceeds max configured) and handles
**		KARN'S Algorithm for calculation of ack timeouts.
** Params:
**		Ptr to connection record for connection to retransmit on
*/

#if 0
void 
tcp_rtx(TCP_PER_CONN *ptr_conn_info)
{
	USHORT i;
	ULONG first_to_send;
	BYTE *ptcpbuf, *pdata;
	TCP_HEADER tcp_header;
	RTX_INFO_RECORD *rtx_record_ptr;
	ULONG previous_rtx_segment_sizes;


#if defined(DEBUG)
	tcp_printf(TCP_DEBUG_PRINTF, "TCP: Retransmit requested, timeout = %d ticks\n", ptr_conn_info->rtx_timeout);
#endif /* DEBUG */

	if (ptr_conn_info->rtx_retries >= tcp.max_transmit_retries)
	{
		/* Persist in retransmissions without aborting if the send window 
		** size if 0.
		*/
		if (ptr_conn_info->send_wnd != 0)
		{
#if defined(DEBUG)
			tcp_printf(TCP_DEBUG_PRINTF, "TCP: %d retransmit retries -- aborting connection\n", ptr_conn_info->rtx_retries);
#endif /* DEBUG */
/* Connect failure is handled separetly. If connect failes the we need   */
/* to notify the app somehow. So we just set the valid_ready_field 		 */
/* The app then sees the connect fail and closes the socket				 */
/* Satish - 27th Jan 1997 */

			if (ptr_conn_info->tcp_state == SYN_SENT) 
         {
				ptr_conn_info->socket_record_ptr->valid_ready_socket = 
						CONNECTION_REFUSED_ERROR;
			}
			tcp_abort(ptr_conn_info, ABORT_ERROR);
			return;
		}
		else
		{
#if defined(DEBUG)
		tcp_printf(TCP_DEBUG_PRINTF, "TCP: Persist retransmit\n");
#endif /* DEBUG */
		}
	}

	/* Okay, we do a retransmit of the all segments referred to in
	** the retransmit queue 
	*/
	rtx_record_ptr = ptr_conn_info->rtx_queue;
	previous_rtx_segment_sizes = 0;		/* Running sum of rtx segment sizes */

	while (rtx_record_ptr != NULL)
	{
#if defined(DEBUG)
		tcp_printf(TCP_ALARM_PRINTF, "TCP: rtx seg size = %d\n",rtx_record_ptr->rtx_seg_len + sizeof(TCP_HEADER));
#endif /* DEBUG */

		ptcpbuf = tcp_get_user_buffer(rtx_record_ptr->rtx_seg_len + 
																sizeof(TCP_HEADER));
		if (ptcpbuf == NULL)
			return;			/* Ignore retransmit of subsequent segments */
		
		if (rtx_record_ptr->rtx_seg_len == 0)
		{
			/* A FIN or SYN segment needs to be retransmitted. It's a SYN
			** segment if the tcp state is anything before ESTAB. Else it's
			** a FIN. Handle these two cases of retransmission differently.
			*/
			tcp_alt_free_user_buffer(ptcpbuf);	/* We'll acquire buffer in routines
															** below.
															*/

/* sudhir 14/2/97 */
         if (ptr_conn_info->tcp_state == SYN_SENT)
         {
            send_tcp_control_seg(ptr_conn_info, rtx_record_ptr->rtx_seg_seq_num,
                  ptr_conn_info->recv_nxt, SYN);
         }
			else
			if (ptr_conn_info->tcp_state < ESTAB)
			{
				send_tcp_control_seg(ptr_conn_info, rtx_record_ptr->rtx_seg_seq_num,
						ptr_conn_info->recv_nxt, SYN | ACK);
#if defined(DEBUG)
				tcp_printf(TCP_DEBUG_PRINTF, "TCP: ********** SYN being resent *********\n");
#endif /* DEBUG */
			}
			else
			{
				send_tcp_control_seg(ptr_conn_info, rtx_record_ptr->rtx_seg_seq_num,
						ptr_conn_info->recv_nxt, FIN | ACK);
#if defined(DEBUG)
				tcp_printf(TCP_DEBUG_PRINTF, "TCP: ********** FIN being resent *********\n");
#endif /* DEBUG */
			}
			break;
		}

		pdata = ptcpbuf + sizeof(TCP_HEADER);
		first_to_send = (ptr_conn_info->send_bstart + previous_rtx_segment_sizes) % ptr_conn_info->send_buf_size;
		for (i = 0; i < rtx_record_ptr->rtx_seg_len; i++)
		{
			pdata[i] = (ptr_conn_info->send_buf)[first_to_send];
			first_to_send = (first_to_send + 1) % ptr_conn_info->send_buf_size;
		}
	
		if (pdata[0] != 8)
		{
			tcp_printf(TCP_DEBUG_PRINTF, "TCP: Surprise\n\r");
		}
		/* Prepare TCP header */
		tcp_header.src_port = ptr_conn_info->local_port;
		tcp_header.dst_port = ptr_conn_info->remote_port;
		tcp_header.seq_num = rtx_record_ptr->rtx_seg_seq_num;
		tcp_header.ack_num = ptr_conn_info->recv_nxt;		/* piggy-ACK */
		ptr_conn_info->conn_flags &= ~TCPF_NEEDACK;			/* we ACK all */
		tcp_header.code_and_hlen.code_and_hdrlen_word = 0;
		tcp_header.code_and_hlen.code_and_hdrlen.hlen = 
																sizeof(TCP_HEADER) / 4;
		TURN_ACK_ON(&tcp_header);
		/* PATCH -- For now, for all retransmit packets, simply turn on the
		** PSH bit. Actually we should set the PSH bit based on the setting in
		** the original packet sent.
		*/
		TURN_PSH_ON(&tcp_header);
	
		tcp_header.win_size = tcp_recv_wnd(ptr_conn_info);
		tcp_header.urg_ptr = 0;
	
		/* to network format... */
		tcp_hdr_hton((TCP_HEADER *)ptcpbuf, &tcp_header);
	
#ifdef INTERNET_TYPE_OF_SERVICE_BUG
		/* send packet on its way to IP */
		send_tcp_packet(ptr_conn_info->local_addr, ptr_conn_info->remote_addr,
			ptr_conn_info->socket_record_ptr->internet_type_of_service, ptcpbuf, 
			rtx_record_ptr->rtx_seg_len + sizeof(TCP_HEADER), TRUE);
#endif

		/* send packet on its way to IP */
	
		if (pdata[0] != 8)
		{
			tcp_printf(TCP_DEBUG_PRINTF, "TCP: Surprise\n\r");
		}
	
		send_tcp_packet(ptr_conn_info->local_addr, ptr_conn_info->remote_addr,
			0, ptcpbuf, 
			rtx_record_ptr->rtx_seg_len + sizeof(TCP_HEADER), TRUE);
	
		if (pdata[0] != 8)
		{
			tcp_printf(TCP_DEBUG_PRINTF, "TCP: Surprise\n\r");
		}

		/* Keep track of where to send from next */
		previous_rtx_segment_sizes += rtx_record_ptr->rtx_seg_len;

		/* Move on to next segment */
		rtx_record_ptr = rtx_record_ptr->next_rtx_record_ptr;
	}

	if (ptr_conn_info->rtx_retries < tcp.max_transmit_retries)
		++ptr_conn_info->rtx_retries;	/* One more retry */

	/* Indicate we have attempted a retransmission */
	ptr_conn_info->conn_flags |= TCPF_RTXON;

	/* Stop normal RTT estimation */
	ptr_conn_info->conn_flags &= ~TCPF_TIMEACK;

	/* Adjust RTO exponentially for each retry -- Karn's method */
	ptr_conn_info->rtx_timeout = (ptr_conn_info->rtx_timeout << 1);

	if (ptr_conn_info->rtx_timeout > tcp.max_rtx_timeout)
		ptr_conn_info->rtx_timeout = tcp.max_rtx_timeout;	/* limit to 2MSL */

	/* restart timer */
	ptr_conn_info->rtx_counter = 0;
}

#endif


void 
tcp_rtx(TCP_PER_CONN *ptr_conn_info)
{
	USHORT i;
	ULONG first_to_send;
	BYTE *ptcpbuf, *pdata;
	TCP_HEADER tcp_header;
	RTX_INFO_RECORD *rtx_record_ptr;
	ULONG previous_rtx_segment_sizes;


#if defined(DEBUG)
	tcp_printf(TCP_DEBUG_PRINTF, "TCP: Retransmit requested, timeout = %d ticks\n", ptr_conn_info->rtx_timeout);
#endif /* DEBUG */

	if (ptr_conn_info->rtx_retries >= tcp.max_transmit_retries)
	{
		/* Persist in retransmissions without aborting if the send window 
		** size if 0.
		*/
		if (ptr_conn_info->send_wnd != 0)
		{
#if defined(DEBUG)
			tcp_printf(TCP_DEBUG_PRINTF, "TCP: %d retransmit retries -- aborting connection\n", ptr_conn_info->rtx_retries);

#endif /* DEBUG */

/* Connect failure is handled separetly. If connect failes the we need   */
/* to notify the app somehow. So we just set the valid_ready_field 		 */
/* The app then sees the connect fail and closes the socket				 */
/* Satish - 27th Jan 1997 */

			if (ptr_conn_info->tcp_state == SYN_SENT) {
				ptr_conn_info->socket_record_ptr->valid_ready_socket = 
						CONNECTION_REFUSED_ERROR;
			}
			tcp_abort(ptr_conn_info, ABORT_ERROR);
			return;
		}
		else
		{
#if defined(DEBUG)
		tcp_printf(TCP_DEBUG_PRINTF, "TCP: Persist retransmit\n");
#endif /* DEBUG */
		}
	}
	/* Okay, we do a retransmit of the all segments referred to in
	** the retransmit queue 
	*/
	rtx_record_ptr = ptr_conn_info->rtx_queue;
	previous_rtx_segment_sizes = 0;		/* Running sum of rtx segment sizes */

/* We have replaced the way TCP handles retransmissions. Initially we were waiting for the timer on a segment to expire
** then only retransmit the segment. But now if a timer expires on a segment we retransmit all the un-acked segments
** without waiting for the their timers to expire. This is to take care of problems with a few WINSOCK packages.
-  Satish.
*/

	while (rtx_record_ptr != NULL)
	{
#if defined(DEBUG)
		tcp_printf(TCP_ALARM_PRINTF, "TCP: rtx seg size = %d\n",rtx_record_ptr->rtx_seg_len + sizeof(TCP_HEADER));
#endif /* DEBUG */

		ptcpbuf = tcp_get_user_buffer(rtx_record_ptr->rtx_seg_len + sizeof(TCP_HEADER));
											
		if (ptcpbuf == NULL)
			return;			/* Ignore retransmit of subsequent segments */
		
		if (rtx_record_ptr->rtx_seg_len == 0)
		{
			/* A FIN or SYN segment needs to be retransmitted. It's a SYN
			** segment if the tcp state is anything before ESTAB. Else it's
			** a FIN. Handle these two cases of retransmission differently.
			*/
			/* A SYN could be with a ACK or without a ACK. Handle this
			** seprately depending on the state
			*/
			tcp_alt_free_user_buffer(ptcpbuf);	/* We'll acquire buffer in routines
								** below.
								*/
			if (ptr_conn_info->tcp_state == SYN_SENT)
			{
				send_tcp_control_seg(ptr_conn_info, rtx_record_ptr->rtx_seg_seq_num,
					ptr_conn_info->recv_nxt, SYN );
			}
			else if (ptr_conn_info->tcp_state < ESTAB)
			{
				send_tcp_control_seg(ptr_conn_info, rtx_record_ptr->rtx_seg_seq_num,
						ptr_conn_info->recv_nxt, SYN | ACK);
#if defined(DEBUG)
				tcp_printf(TCP_DEBUG_PRINTF, "TCP: ********** SYN being resent *********\n");
#endif /* DEBUG */
			}
			else
			{
				send_tcp_control_seg(ptr_conn_info, rtx_record_ptr->rtx_seg_seq_num,
						ptr_conn_info->recv_nxt, FIN | ACK);
#if defined(DEBUG)
				tcp_printf(TCP_DEBUG_PRINTF, "TCP: ********** FIN being resent *********\n");
#endif /* DEBUG */
			}
			break;
		}

		pdata = ptcpbuf + sizeof(TCP_HEADER);
		first_to_send = (ptr_conn_info->send_bstart + previous_rtx_segment_sizes) % ptr_conn_info->send_buf_size;
		for (i = 0; i < rtx_record_ptr->rtx_seg_len; i++)
		{
			pdata[i] = (ptr_conn_info->send_buf)[first_to_send];
			first_to_send = (first_to_send + 1) % ptr_conn_info->send_buf_size;
		}
	
		/* Prepare TCP header */
		tcp_header.src_port = ptr_conn_info->local_port;
		tcp_header.dst_port = ptr_conn_info->remote_port;
		tcp_header.seq_num = rtx_record_ptr->rtx_seg_seq_num;
		tcp_header.ack_num = ptr_conn_info->recv_nxt;		/* piggy-ACK */
		ptr_conn_info->conn_flags &= ~TCPF_NEEDACK;		/* we ACK all */
		tcp_header.code_and_hlen.code_and_hdrlen_word = 0;
		tcp_header.code_and_hlen.code_and_hdrlen.hlen = sizeof(TCP_HEADER) / 4;
									
		TURN_ACK_ON(&tcp_header);
		/* PATCH -- For now, for all retransmit packets, simply turn on the
		** PSH bit. Actually we should set the PSH bit based on the setting in
		** the original packet sent.
		*/
		TURN_PSH_ON(&tcp_header);
	
		tcp_header.win_size = tcp_recv_wnd(ptr_conn_info);
		tcp_header.urg_ptr = 0;
	
		/* to network format... */
		tcp_hdr_hton((TCP_HEADER *)ptcpbuf, &tcp_header);
	
#ifdef INTERNET_TYPE_OF_SERVICE_BUG
		/* send packet on its way to IP */
		send_tcp_packet(ptr_conn_info->local_addr, ptr_conn_info->remote_addr,
			ptr_conn_info->socket_record_ptr->internet_type_of_service, ptcpbuf, 
			rtx_record_ptr->rtx_seg_len + sizeof(TCP_HEADER), TRUE);
#endif

		/* send packet on its way to IP */
	
		if (pdata[0] != 8)
		{
			tcp_printf(TCP_DEBUG_PRINTF, "TCP: Surprise\n\r");
		}
	
		send_tcp_packet(ptr_conn_info->local_addr, ptr_conn_info->remote_addr,
			0, ptcpbuf, 
			rtx_record_ptr->rtx_seg_len + sizeof(TCP_HEADER), TRUE);
	
		if (pdata[0] != 8)
		{
			tcp_printf(TCP_DEBUG_PRINTF, "TCP: Surprise\n\r");
		}

		/* Keep track of where to send from next */
		previous_rtx_segment_sizes += rtx_record_ptr->rtx_seg_len;

		/* Move on to next segment */
		rtx_record_ptr = rtx_record_ptr->next_rtx_record_ptr;
	}

	if (ptr_conn_info->rtx_retries < tcp.max_transmit_retries)
		++ptr_conn_info->rtx_retries;	/* One more retry */

	/* Indicate we have attempted a retransmission */
	ptr_conn_info->conn_flags |= TCPF_RTXON;

	/* Stop normal RTT estimation */
	ptr_conn_info->conn_flags &= ~TCPF_TIMEACK;

	/* Adjust RTO exponentially for each retry -- Karn's method */
	ptr_conn_info->rtx_timeout = (ptr_conn_info->rtx_timeout << 1);

	if (ptr_conn_info->rtx_timeout > tcp.max_rtx_timeout)
		ptr_conn_info->rtx_timeout = tcp.max_rtx_timeout;	/* limit to 2MSL */

	/* restart timer */
	ptr_conn_info->rtx_counter = 0;

#if 0
#if defined(DEBUG)
	if (rtx_record_ptr == NULL)
	{
		/* this cannot be */
		tcp_printf(TCP_ALARM_PRINTF, "TCP: !@!@!@!@ tcp_rtx() called when no elements in retransmit queue\n");
		return;
	}
	else
	{
		tcp_printf(TCP_ALARM_PRINTF, "TCP: rtx seg size = %d\n",rtx_record_ptr->rtx_seg_len + sizeof(TCP_HEADER));
	}
#endif /* DEBUG */

	ptcpbuf = tcp_get_user_buffer(rtx_record_ptr->rtx_seg_len + sizeof(TCP_HEADER));
							
	if (ptcpbuf == NULL)
	{
		/* recover -- do rtx later; don't term this attempt a retry */
		return;
	}

	if (ptr_conn_info->rtx_retries < tcp.max_transmit_retries)
		++ptr_conn_info->rtx_retries;					/* One more retry */

	/* Indicate we are going to attempt a retransmission */
	ptr_conn_info->conn_flags |= TCPF_RTXON;

	/* Stop normal RTT estimation */
	ptr_conn_info->conn_flags &= ~TCPF_TIMEACK;

	/* Adjust RTO exponentially for each retry -- Karn's method */
	ptr_conn_info->rtx_timeout = (ptr_conn_info->rtx_timeout << 1);

	if (ptr_conn_info->rtx_timeout > tcp.max_rtx_timeout)
		ptr_conn_info->rtx_timeout = tcp.max_rtx_timeout;	/* limit to 2MSL */

	if (rtx_record_ptr->rtx_seg_len == 0)
	{
		/* A FIN or SYN segment needs to be retransmitted. It's a SYN
		** segment if the tcp state is anything before ESTAB. Else it's
		** a FIN. Handle these two cases of retransmission differently.
		*/
		/* A SYN could be with a ACK or without a ACK. Handle this 
		** seprately depending on the state
		*/

		tcp_alt_free_user_buffer(ptcpbuf);	/* We'll acquire buffer in routines
							** below.
							*/
		if (ptr_conn_info->tcp_state == SYN_SENT)
		{
			send_tcp_control_seg(ptr_conn_info, rtx_record_ptr->rtx_seg_seq_num,
					ptr_conn_info->recv_nxt, SYN );
		}
		else if (ptr_conn_info->tcp_state < ESTAB)
		{
			send_tcp_control_seg(ptr_conn_info, rtx_record_ptr->rtx_seg_seq_num,
					ptr_conn_info->recv_nxt, SYN | ACK);
#if defined(DEBUG)
			tcp_printf(TCP_DEBUG_PRINTF, "TCP: ********** SYN being resent *********\n");
#endif /* DEBUG */
		}
		else
		{
			send_tcp_control_seg(ptr_conn_info, rtx_record_ptr->rtx_seg_seq_num,
					ptr_conn_info->recv_nxt, FIN | ACK);
#if defined(DEBUG)
			tcp_printf(TCP_DEBUG_PRINTF, "TCP: ********** FIN being resent *********\n");
#endif /* DEBUG */
		}
		ptr_conn_info->rtx_counter = 0;
		return;
	}

	pdata = ptcpbuf + sizeof(TCP_HEADER);
	first_to_send = ptr_conn_info->send_bstart;
	for (i = 0; i < rtx_record_ptr->rtx_seg_len; i++)
	{
		pdata[i] = (ptr_conn_info->send_buf)[first_to_send];
		first_to_send = (first_to_send + 1) % ptr_conn_info->send_buf_size;
	}

	/* Prepare TCP header */
	tcp_header.src_port = ptr_conn_info->local_port;
	tcp_header.dst_port = ptr_conn_info->remote_port;
	tcp_header.seq_num = rtx_record_ptr->rtx_seg_seq_num;
	tcp_header.ack_num = ptr_conn_info->recv_nxt;		/* piggy-ACK */
	ptr_conn_info->conn_flags &= ~TCPF_NEEDACK;		/* we ACK all */
	tcp_header.code_and_hlen.code_and_hdrlen_word = 0;
	tcp_header.code_and_hlen.code_and_hdrlen.hlen =	sizeof(TCP_HEADER) / 4;
								
	TURN_ACK_ON(&tcp_header);
	/* PATCH -- For now, for all retransmit packets, simply turn on the
	** PSH bit. Actually we should set the PSH bit based on the setting in
	** the original packet sent.
	*/
	TURN_PSH_ON(&tcp_header);

	tcp_header.win_size = tcp_recv_wnd(ptr_conn_info);
	tcp_header.urg_ptr = 0;

	/* to network format... */
	tcp_hdr_hton((TCP_HEADER *)ptcpbuf, &tcp_header);

#ifdef INTERNET_TYPE_OF_SERVICE_BUG
	/* send packet on its way to IP */
	send_tcp_packet(ptr_conn_info->local_addr, ptr_conn_info->remote_addr,
		ptr_conn_info->socket_record_ptr->internet_type_of_service, ptcpbuf, 
		rtx_record_ptr->rtx_seg_len + sizeof(TCP_HEADER), TRUE);
#endif

	/* send packet on its way to IP */
	send_tcp_packet(ptr_conn_info->local_addr, ptr_conn_info->remote_addr,
		0, ptcpbuf, 
		rtx_record_ptr->rtx_seg_len + sizeof(TCP_HEADER), TRUE);

	/* restart timer */
	ptr_conn_info->rtx_counter = 0;
#endif
}

/*
** add_to_tcp_rtx_queue()
**		Adds info related to the latest segment sent on the network to the
**		end of the linked list of retransmit segments.
** Params:
**		Ptr to connection info record related to this operation
**		Sequence number of segment sent
**		Length of data sent (only data -- no TCP_HEADER, IP_HEADER, etc)
*/
void 
add_to_tcp_rtx_queue(TCP_PER_CONN *ptr_conn_info, TCPSEQ tx_seg_seq_num,
		ULONG tx_seg_len)
{
	RTX_INFO_RECORD *rtx_record_ptr;
	RTX_INFO_RECORD *first_ptr, *step_ptr;

	rtx_record_ptr = (RTX_INFO_RECORD *) table_malloc(1, sizeof(RTX_INFO_RECORD));
	if (rtx_record_ptr == NULL)
	{
		/* Nothing can be done -- segment won't be guaranteed thats all */

		tcp_printf(TCP_ALARM_PRINTF, "TCP: Buffer allocation for retransmit information recording failed\n");
		return;
	}

	/* Init the new record */
	rtx_record_ptr->next_rtx_record_ptr = NULL;
	rtx_record_ptr->rtx_seg_seq_num = tx_seg_seq_num;
	rtx_record_ptr->rtx_seg_len = tx_seg_len;

	/* Scan to find end of linked list of the retransmit queue */
	step_ptr = NULL;
	first_ptr = ptr_conn_info->rtx_queue; 
	while (first_ptr != NULL)
	{
		step_ptr = first_ptr;
		first_ptr = first_ptr->next_rtx_record_ptr;
	}

	/* Attach new record to end of linked list */
	if (step_ptr == NULL)
	{
		/* First entry in queue */
		ptr_conn_info->rtx_queue = rtx_record_ptr;

		/* Also do some first time init-ing */
		ptr_conn_info->rtx_retries = 0;
		ptr_conn_info->rtx_counter = 0;
	}
	else
	{
		step_ptr->next_rtx_record_ptr = rtx_record_ptr;
	}
}

/*
** remove_from_tcp_rtx_queue()
**		Removes a segment info item from the retransmit queue and frees
**		buffer for the info record.
** Params:
**		Ptr to connection info record for the connection
**		Ptr to the retransmit info record to de-link
*/
void
remove_from_tcp_rtx_queue(TCP_PER_CONN *ptr_conn_info, 
		RTX_INFO_RECORD *rtx_record_ptr)
{
	RTX_INFO_RECORD *first_ptr, *step_ptr;


	if (rtx_record_ptr == NULL || ptr_conn_info == NULL)
	{
		tcp_printf(TCP_DEBUG_PRINTF, "TCP: Bad pointers to remove_from_tcp_rtx_queue()\n");
		return;
	}

	step_ptr = NULL;
	first_ptr = ptr_conn_info->rtx_queue;
	while (first_ptr != NULL)
	{
		if (first_ptr == rtx_record_ptr)
			break;

		step_ptr = first_ptr;
		first_ptr = first_ptr->next_rtx_record_ptr;
	}

	if (first_ptr == NULL)
	{
		/* What!!! Not found in the retransmit queue */
		tcp_printf(TCP_DEBUG_PRINTF, "TCP: Bad retransmit record pointer to remove_from_tcp_rtx_queue()\n");
		return;
	}

	/* Relink ignoring the one to be released */
	if (step_ptr == NULL)
		ptr_conn_info->rtx_queue = first_ptr->next_rtx_record_ptr;
	else
		step_ptr->next_rtx_record_ptr = first_ptr->next_rtx_record_ptr;

	/* Also each entry deleted implies retransmit mechanism restarted for
	** next entry in the retransmit queue
	*/
	ptr_conn_info->rtx_retries = 0;
	ptr_conn_info->rtx_counter = 0;
	ptr_conn_info->conn_flags &= ~TCPF_RTXON;

	table_free(first_ptr);

	return;
}

/*
** clear_rtx_queue()
**		Stops all retransmit related stuff (timer and flags) and releases
**		buffers maintained.
** Params:
**		Ptr to connection record to cleare retransmit queue for
*/
void 
clear_rtx_queue(TCP_PER_CONN *ptr_conn_info)
{
	RTX_INFO_RECORD *rtx_record_ptr, *lag_ptr;


	ptr_conn_info->conn_flags &= ~TCPF_RTXON;

	rtx_record_ptr = ptr_conn_info->rtx_queue;
	ptr_conn_info->rtx_queue = NULL;

	while (rtx_record_ptr != NULL)
	{
		lag_ptr = rtx_record_ptr;
		rtx_record_ptr = rtx_record_ptr->next_rtx_record_ptr;
		table_free(lag_ptr);
	}
}

/*
** check_effect_of_ack_on_rtx()
**		Called when an ACK is received to remove ack'ed segments from the
**		retransmit queue.
** Params:
**		Ptr to connection record for ack
**		Ptr to host format TCP header of segment received
*/
void
check_effect_of_ack_on_rtx(TCP_PER_CONN *ptr_conn_info, 
		TCP_HEADER *tcp_header)
{
	ULONG amount_acked;
	RTX_INFO_RECORD *rtx_record_ptr, *lag_ptr;


	rtx_record_ptr = ptr_conn_info->rtx_queue;
#if defined(DEBUG)

	if (rtx_record_ptr == NULL)
	{
		tcp_printf(TCP_DEBUG_PRINTF, "!@!@!@! TCP: ACK received though nothing on retransmit queue\n");
	}

#endif /* DEBUG */


	while (rtx_record_ptr != NULL)
	{
		if ((tcp_header->ack_num - (TCPSEQ) (rtx_record_ptr->rtx_seg_seq_num + 
				rtx_record_ptr->rtx_seg_len)) >= 0)
		{
			/* ACK acks all of a segment in the retransmit queue */
			/* For each segment ACK'ed, update the index into the un-ack'ed
			** portion of the send window.
			*/
			ptr_conn_info->send_bstart = (ptr_conn_info->send_bstart + 
					rtx_record_ptr->rtx_seg_len) % ptr_conn_info->send_buf_size;
			ptr_conn_info->send_una_amount -= rtx_record_ptr->rtx_seg_len;

			lag_ptr = rtx_record_ptr;
			rtx_record_ptr = rtx_record_ptr->next_rtx_record_ptr;

			remove_from_tcp_rtx_queue(ptr_conn_info, lag_ptr);
		}
		else if ((tcp_header->ack_num - rtx_record_ptr->rtx_seg_seq_num) > 0)
		{
			/* The ACK has ack'ed part of the retransmit item. So update
			** accordingly. NOTE that the previous conditional will trap ack's
			** to SYN and FIN segments and so they will never come here.
			** NOTE that normally we do not use the ACK/SEQuence numbers to
			** compute amount of data. Here there is no other choice.
			*/

			amount_acked = tcp_header->ack_num - rtx_record_ptr->rtx_seg_seq_num;
#if defined(DEBUG)
			printf("TCP: Part ACK amount = %lu, actual = %lu\n\r",
					amount_acked, rtx_record_ptr->rtx_seg_len);
#endif /* DEBUG */
			ptr_conn_info->send_bstart = (ptr_conn_info->send_bstart + 
					amount_acked) % ptr_conn_info->send_buf_size;

			rtx_record_ptr->rtx_seg_seq_num += amount_acked;
			rtx_record_ptr->rtx_seg_len -= amount_acked;

			/* Restart retransmit timer */
			ptr_conn_info->rtx_retries = 0;
			ptr_conn_info->rtx_counter = 0;
			ptr_conn_info->conn_flags &= ~TCPF_RTXON;

			break;			/* Go no further */
		}
		else
		{
			break;
		}
	}
}

/* 
** check_if_rtx_queue_empty()
**		Returns TRUE if retransmit queue is empty, else returns FALSE.
** Params:
**		Ptr to connection record to check retransmit queue for
** NOTES:
**		Call this function to decide if all data on a connection has been
**			fully received.
*/
enum BOOLEAN
check_if_rtx_queue_empty(TCP_PER_CONN *ptr_conn_info)
{
	if (ptr_conn_info->rtx_queue == NULL)
		return TRUE;
	return FALSE;
}



