/*
** TCPURG.C -- Urgent data processing support code
*/

/* General Notes:
** 	See design docs for our kind of URGent data processing
*/

#include "rtrstd.h"
#include "all.h"
#include "tcpextrn.h"

/*
** tcp_urgent()
**		If the urgent bit is set in the incoming segment, informs app
**		related to connection that some urgent data has come in.
** Params:
**		Ptr to connection record for connection
**		Ptr to host format TCP header for segment that came in
** NOTES:
**		We will simply call app function, ignore the URGENT data field and
**			leave the urgent data in the normal data stream.
*/
void 
tcp_urgent(TCP_PER_CONN *ptr_conn_info, TCP_HEADER *tcp_header)
{
	if (IS_URG_ON(tcp_header))
	{
#if defined(DEBUG)
		tcp_printf(TCP_DEBUG_PRINTF, "TCP: URRRRRGENT!!! Data\n");
#endif /* DEBUG */

		switch (ptr_conn_info->tcp_state)
		{
		case CLOSE_WAIT:
		case CLOSING:
		case LAST_ACK:
		case TIME_WAIT:
#if defined(DEBUG)
			tcp_printf(TCP_DEBUG_PRINTF, "TCP: URGENT data rx-ed in bad state (%s)\n",
							get_state_string(ptr_conn_info->tcp_state));
#endif /* DEBUG */
			TURN_URG_OFF(tcp_header);
			return;
		}

		TURN_URG_OFF(tcp_header);
		ptr_conn_info->conn_flags |= TCPF_RECVPSH;	/* PUSH data on next 
																	** socket receive call
																	*/
		if (ptr_conn_info->socket_record_ptr != NULL)
		{

         /* Upcall to app -- app should increment a counter and return */
         (*ptr_conn_info->urgent_data_handler)(ptr_conn_info->socket_record_ptr);
		}
	}
}


