/* 
** VTCPSNMP.H -- TCP SNMP related definitions
*/

/* Some Notes:
** 1.	tcpConnState info is got from the 'tcp_state' field of the 
**		'tcp_conn_table' connection table. This field is of enum type.
**		Assumption is made that sizeof(enum ...) == sizeof(USHORT). This
**		is the convention followed for the RouterWare code compiles.
** 2. In 'snmp_table_entry', the 'tcpConnLocalPort' and 'tcpConnRemPort'
**		info is retrieved from fields declared USHORT in the connection
**		table. So the retrieval function provided is 'snmp_get_or_set_ushort'.
**		Yet we say the sizeof() this field is ULONG. This is to patch for
**		an assumption made in the SNMP code that all sizeof(INTEGER) ==
**		sizeof(ULONG). INTEGER is one of the object-id's defined by SNMP.
**	3. tcpConnState is handled by a non-standard function (others use
**		standard functions found in the rwutils directory) as special
**		action needs to be taken on SNMP SET operation.
*/
#ifndef _TCPSNMP_
#define _TCPSNMP_


#define SNMP_DELETE_TCB		12

/* Global function prototypes */
/* Srikar, Mar 25, 1997. Added the last parameter variable_found to identify if the variable was found or not. */
/* The return value is used to identify if the get/set operation was successful. The last parameter is used to */
/* distinguish the nature of the failure. */
enum TEST process_tcp_table_mib_variable(MIB_ACCESS_PARAMETERS *,
		SNMP_TABLE_ENTRY *, enum BOOLEAN *variable_found);
enum TEST tcp_snmp_get_or_set_conn_state(USHORT, enum MIB_OPERATION, 
		ULONG, ULONG, ULONG, void *, USHORT *);

#ifdef __MSDOS__
	SNMP_TABLE_ENTRY_PARAMETERS far tcp_snmp_table_parameters[] =
#else
	SNMP_TABLE_ENTRY_PARAMETERS tcp_snmp_table_parameters[] =
#endif
{
	{ (ULONG) &tcp.mib, FALSE },
	{ 
		(ULONG) NULL, 
		TRUE, 
		/* Srikar, Mar 18, 1997. Changed no. of indices from 5 to 4. */
		0x04,
		{ 
			{	
				SNMP_SCALAR_TYPE, sizeof(ULONG),
				offsetof(TCP_PER_CONN, local_addr), FALSE
			},
			{	
				/* Srikar, Mar 18, 1997. Size changed from ULONG to USHORT. */
				SNMP_SCALAR_TYPE, sizeof(ULONG),
				offsetof(TCP_PER_CONN, local_port), FALSE
			},
			{	
				SNMP_SCALAR_TYPE, sizeof(ULONG),
				offsetof(TCP_PER_CONN, remote_addr), FALSE
			},
			{	
				/* Srikar, Mar 18, 1997. Size changed from ULONG to USHORT. */
				SNMP_SCALAR_TYPE, sizeof(ULONG),
				offsetof(TCP_PER_CONN, remote_port), FALSE
			},
		}, 
		MIB_TABLE_AS_AN_ARRAY, 
		0,					/* Filled during init time */
		sizeof(TCP_PER_CONN), 
		0, 				/* Filled during init time */
		0, 0
	}
};

#ifdef __MSDOS__
	SNMP_TABLE_ENTRY far tcp_snmp_table[] = 
#else
	SNMP_TABLE_ENTRY tcp_snmp_table[] = 
#endif
{
	{
		"tcpRtoAlgorithm", sizeof(INTEGER),snmp_get_or_set_ulong,
		FALSE, FALSE,
		(ULONG) offsetof(TCP_MIB, tcpRtoAlgorithm), 
		&tcp_snmp_table_parameters[0]
	},
	{
		"tcpRtoMin", sizeof(INTEGER), snmp_get_or_set_ulong,
		FALSE, FALSE,
		(ULONG) offsetof(TCP_MIB, tcpRtoMin),
		&tcp_snmp_table_parameters[0]
	},
	{
		"tcpRtoMax", sizeof(INTEGER), snmp_get_or_set_ulong,
		FALSE, FALSE,
		(ULONG) offsetof(TCP_MIB, tcpRtoMax), 
		&tcp_snmp_table_parameters[0]
	},
	{
		"tcpMaxConn", sizeof(INTEGER), snmp_get_or_set_ulong,
		FALSE, FALSE,
		(ULONG) offsetof(TCP_MIB, tcpMaxConn),
		&tcp_snmp_table_parameters[0]
	},
	{
		"tcpActiveOpens", sizeof(INTEGER), snmp_get_or_set_ulong,
		FALSE, FALSE,
		(ULONG) offsetof(TCP_MIB, tcpActiveOpens), 
		&tcp_snmp_table_parameters[0]
	},
	{
		"tcpPassiveOpens", sizeof(INTEGER), snmp_get_or_set_ulong,
		FALSE, FALSE,
		(ULONG) offsetof(TCP_MIB, tcpPassiveOpens), 
		&tcp_snmp_table_parameters[0]
	},
	{
		"tcpAttemptFails", sizeof(INTEGER), snmp_get_or_set_ulong,
		FALSE, FALSE,
		(ULONG) offsetof(TCP_MIB, tcpAttemptFails), 
		&tcp_snmp_table_parameters[0]
	},
	{
		"tcpEstabResets", sizeof(INTEGER), snmp_get_or_set_ulong,
		FALSE, FALSE,
		(ULONG) offsetof(TCP_MIB, tcpEstabResets), 
		&tcp_snmp_table_parameters[0]
	},
	{
		"tcpCurrEstab", sizeof(INTEGER), snmp_get_or_set_ulong,
		FALSE, FALSE,
		(ULONG) offsetof(TCP_MIB, tcpCurrEstab), 
		&tcp_snmp_table_parameters[0]
	},
	{
		"tcpInSegs", sizeof(INTEGER), snmp_get_or_set_ulong,
		FALSE, FALSE,
		(ULONG) offsetof(TCP_MIB, tcpInSegs),
		&tcp_snmp_table_parameters[0]
	},
	{
		"tcpOutSegs", sizeof(INTEGER), snmp_get_or_set_ulong,
		FALSE, FALSE,
		(ULONG) offsetof(TCP_MIB, tcpOutSegs), 
		&tcp_snmp_table_parameters[0]
	},
	{
		"tcpRetransSegs", sizeof(INTEGER), snmp_get_or_set_ulong,
		FALSE, FALSE,
		(ULONG) offsetof(TCP_MIB, tcpRetransSegs), 
		&tcp_snmp_table_parameters[0]
	},
	{
		"tcpConnState", sizeof(ULONG), tcp_snmp_get_or_set_conn_state,
		FALSE, FALSE,
		(ULONG) offsetof(TCP_PER_CONN, tcp_state), 
		&tcp_snmp_table_parameters[1]
	},
	{
		"tcpConnLocalAddress", sizeof(IPADDR), snmp_get_or_set_ulong,
		FALSE, FALSE,
		(ULONG) offsetof(TCP_PER_CONN, local_addr), 
		&tcp_snmp_table_parameters[1]
	},
	{
		"tcpConnLocalPort", sizeof(INTEGER), snmp_get_or_set_ushort,
		FALSE, FALSE,
		(ULONG) offsetof(TCP_PER_CONN, local_port), 
		&tcp_snmp_table_parameters[1]
	},
	{
		"tcpConnRemAddress", sizeof(IPADDR), snmp_get_or_set_ulong,
		FALSE, FALSE,
		(ULONG) offsetof(TCP_PER_CONN, remote_addr), 
		&tcp_snmp_table_parameters[1]
	},
	{
		"tcpConnRemPort", sizeof(INTEGER), snmp_get_or_set_ushort,
		FALSE, FALSE,
		(ULONG) offsetof(TCP_PER_CONN, remote_port), 
		&tcp_snmp_table_parameters[1]
	},
	{
		"tcpInErrs", sizeof(INTEGER), snmp_get_or_set_ulong,
		FALSE, FALSE,
		(ULONG) offsetof(TCP_MIB, tcpInErrs), 
		&tcp_snmp_table_parameters[0]
	},
	{
		"tcpOutRsts", sizeof(INTEGER), snmp_get_or_set_ulong,
		FALSE, FALSE,
		(ULONG) offsetof(TCP_MIB, tcpOutRsts), 
		&tcp_snmp_table_parameters[0]
	},
  	{
		"",0x0000,NULL,FALSE,FALSE,0L,NULL
	}
};

#endif

