/*
** VTCPSTR.H -- Has RouterWare style TCP_CLASS structure definition and
**					 related definitions.
*/

/* General Notes:
**		Some TCP_CLASS fields are marked as "configurable". But some of these
**			fields are actually not allowed to be modified and are kept 
**			constant. See the configuration code for details. Maybe in a later
**			version, the configuration can be allowed.
*/

#ifndef _VTCPSTR_
#define _VTCPSTR_



typedef struct TCP_STATISTICS {
	int a;/* ?? */
} TCP_STATISTICS;

#define INTEGER 		ULONG
#define Counter 		ULONG
#define Guage	 		ULONG
#define IpAddress 	ULONG

typedef struct TcpConnEntry {
	INTEGER tcpConnState;
	IpAddress tcpConnLocalAddress;
	INTEGER tcpConnLocalPort;
	IpAddress tcpConnRemAddress;
	INTEGER tcpConnRemPort;
} TcpConnEntry;

/* The MIB info to be maintained and SNMP-ed for TCP stack */
typedef struct TCP_MIB {
#ifdef _BIG_PROXY_ /* Jo 19/05/99 */
	INTEGER tcpRtoAlgorithm;		/* The RTO calc. alg. used (Van Jacobsons) */
	INTEGER tcpRtoMin;				/* constant */
	INTEGER tcpRtoMax;				/* constant */
	INTEGER tcpMaxConn;				/* constant */
	Counter tcpActiveOpens;			/* always 0 for us */
	Counter tcpEstabResets;			/* ESTAB or CLOSE_WAIT to CLOSED transits */
	Guage   tcpCurrEstab;			/* conns. in ESTAB or CLOSE_WAIT state */
#endif /* Jo 19/05/99 */

	Counter tcpPassiveOpens;		/* incr on every succ listen */
	Counter tcpAttemptFails;		/* SYN_RCVD or SYN_SENT to CLOSED transits,
											** or SYN_RCVD to LISTEN transits
											*/
	Counter tcpInSegs;				/* incr everytime tcp_receive is called */
	Counter tcpOutSegs;				/* incr everytime send_to_ip_.. is called */
	Counter tcpRetransSegs;			/* incr on every retransmit */
	Counter tcpInErrs;				/* errors in incoming segments */
	Counter tcpOutRsts;				/* segments with RST sent */
} TCP_MIB;

typedef struct TCP_PRINT_CLASS {
	BYTE_ENUM (BOOLEAN) tcp_print_switch_on;
	BYTE_ENUM (BOOLEAN) tcp_printing_enabled;
	BYTE_ENUM (BOOLEAN) alarm_printing_enabled;
	BYTE_ENUM (BOOLEAN) data_printing_enabled;
	BYTE_ENUM (BOOLEAN) debug_printing_enabled;
	BYTE_ENUM (BOOLEAN) state_printing_enabled;
} TCP_PRINT_CLASS;

typedef struct TCP_CLASS
{
	BYTE_ENUM (BOOLEAN) enabled;						/* TCP on or off */
	TCP_MIB				mib;								/* TCP MIB's */
																
#ifdef _BIG_PROXY_ /* Jo 19/05/99 */
	ULONG					transport_id;					/* info filled in by LSL */
	ULONG 				clock_ticks_per_second;		/* ticks/sec */
	IPADDR				local_ip_address;				/* IP address of "this" 
																** machine
																*/

	USHORT				max_tcp_connection;			/* max tcp connections */
	TCP_PER_CONN		*tcp_conn_table;				/* connection table ptr */
	BYTE_ENUM (BOOLEAN) timer_enabled;				/* can start timer if TRUE */
	ULONG					isn_clk_time;					/* ISN generator */
	ULONG					tcp_ack_timer;					/* delayed ack timer */
	USHORT				max_send_mss;					/* least of MTU's of attached
																**	interfaces considering all
																** all header sizes
																*/
	/* Currently there is no support for below field */
	USHORT				next_user_port;				
	TCP_PRINT_CLASS	print_class;					/* TCP printf's */
	char 					print_buffer[PRINT_BUFSIZ];
	
	SOCKET_FUNCTION_POINTERS socket_fptrs;			/* Ptrs to callup functions
																** in the socket library
																*/

	/* Some user configurable stuff */
	ULONG					recv_win_size;					/* receive buffer size */
	ULONG					send_win_size;					/* send buffer size */
	ULONG					max_seg_size;					/* seg size to advertise */
	BYTE					max_transmit_retries;		/* retries on retransmit */

	/* Configurable times. At config time, these values will be picked up
	** as milliseconds. Later during init time, they will be recalculated
	** and stored as ticks in relation to the 'clock_ticks_per_second' value.
	*/	
	ULONG					two_msl;							/* 2 * max seg lifetime */
	ULONG					conn_idle_time;				/* connection idle time, also
																** called "alive timer"
																*/
	ULONG					max_rtx_timeout;				/* max timeout for rtx */
	ULONG					min_rtx_timeout;				/* min timeout for rtx */
	ULONG					max_ack_delay;					/* max time ack can be delayed */

	TCP_STATISTICS		stats;							/* other TCP stats */
#endif /* Jo 19/05/99 */

} TCP_CLASS;

#endif
