/*.BM*******************************************************************
	Copyright (C) 1982, 1983 Intermetrics, Inc.
AUTHOR		:   Randy Hudson, modified by David Sotkowitz
SECTION		:   C Run Time Library
MODULE		:   m/rt/c/ansi/btoi.c
SCCS ID		:   1.4
LAST DELTA	:   9/25/92  10:54:57
DATE OF GET	:   9/25/92  10:55:01
UNIX FILE	:   s.btoi.c
@(#)m/rt/c/ansi/btoi.c	1.4
    MODULES DEFINED:
	__btoi
    RELATION:
	Internal routines for converting an ASCII string
	to a binary integer .  Used by xprintf and xscanf.
************************************************************************
.EM*/


#include "stdio.h"
#include "string.h"
#include "rt.h"

static int isnumber();

    /* Convert an integer (ASCII string) to binary. */
    /* Returns the number of characters scanned.    */
    INT16
__btoi(sptrarg,slen,pi,base)
    char *sptrarg;
    INT16  slen;

#ifdef NOLONGS
    INT16  *pi;
#else
    INT32  *pi;
#endif

    INT16  base;
{
    char *s, c ;
    INT16 d,sign;
#ifdef NOLONGS
    INT16 result;
#else
    INT32 result;
#endif
    char sptr[128];

	/* Make a copy of the input field */
	/* Note: can't use strcpy - may not be null-terminated soon */
	/* enough to avoid overflowing this buffer, c.f. ptm 2905.  */
    if (slen > 127) slen = 127; /* avoid overflowing sptr buffer */
    strncpy(sptr,sptrarg,slen);
    sptr[slen] = '\0'; /* cap the end */
    s = sptr;

    result = 0;
    /* skip initial white space */
    while ((c = *s++) && ((c==' ') || (c=='\t') || (c=='\n')));
    --s;

    /* recognize optional plus or minus sign */
    if (*s == '-') {
	sign = -1;
	s++;
    } else if (*s == '+') {
	sign = 1;
	s++;
    } else {
	sign = 1;
    }

    if (base == 16) {
	    /* skip over the optional 0x hex# prefix */
	if ( (*s=='0') && ( (*(s+1)=='x') || (*(s+1)=='X') ) )
	    s += 2;
	    /* recognize digits */
	for ( ; (c = *s++) && isnumber(&d,c,base); ) {
		/* result = result*16 + d; */
	    result = (result << 4) + d ;
	}
    } else if (base == 10) {
	    /* recognize digits */
	for ( ; (c = *s++) && isnumber(&d,c,base); ) {
		/* result = result*10 + d; */
	    result = (result << 3) + result + result + d ;
	}
    } else {
	    /* recognize digits */
	for ( ; (c = *s++) && isnumber(&d,c,base); ) {
	    result = base * result + d ;
	}
    }

    if (sign == -1) result = -result;
    *pi = result;
    return (s-sptr-1);
} /* __btoi */


    static int
isnumber(pi, c, base)
    INT16 *	pi;
    unsigned char c;
    INT16	base;
{
    /* return 1 if c is a digit in the give base, else return 0 */
    /* place value of digit at pi */

    if (base==16) {
	if ('0'<=c && c<='9') {
	    *pi = c - '0' ;
	    return (1);
	} else if ( 'a'<=c && c<='f' ) {
	    *pi = c - 'a' + 10;
	    return (1);
	} else if ( 'A'<=c && c<='F' ) {
	    *pi = c - 'A' + 10;
	    return (1);
	} else {
	    return (0);
	}
    }

    c -= '0' ;
    if (c<base) {
	*pi = c;
	return (1);
    } else {
	return (0);
    }
} /* isnumber */

