/*.BM*********************************************************************
	Copyright (C) 1989 Intermetrics, Inc.
AUTHOR		:   Mark Hertel
SECTION		:   C Run Time Library
MODULE		:   m/rt/c/ansi/ctype.c
SCCS ID		:   1.5
LAST DELTA	:   9/21/93  17:33:58
DATE OF GET	:   9/21/93  17:34:00
UNIX FILE	:   /usr2/millen/m/rt/c/ansi/s.ctype.c
@(#)m/rt/c/ansi/ctype.c	1.5

	RELATION:  Defines the __ctype[] array

**************************************************************************
.EM*/

#pragma separate __ctype class constant segment S___libcdata

#define _C    1    /* is control character */
#define _S    2    /* is white space */
#define _P    4    /* is punctuation */
#define _SP   8    /* is space */
#define _D   16    /* is decimal */
#define _UC  32    /* is uppercase */
#define _X   64    /* is hex */
#define _LC 128    /* is lower case */

const unsigned char __ctype[257] =
	{
	/*  -1 ~0x0 ~000     */ 0,
	/*   0 0x00 0000 nul */ _C,
	/*   1 0x01 0001 soh */ _C,
	/*   2 0x02 0002 stx */ _C,
	/*   3 0x03 0003 etx */ _C,
	/*   4 0x04 0004 eot */ _C,
	/*   5 0x05 0005 enq */ _C,
	/*   6 0x06 0006 ack */ _C,
	/*   7 0x07 0007 bel */ _C,
	/*   8 0x08 0010 bs  */ _C,
	/*   9 0x09 0011 '\t'*/ _S | _C,
	/*  10 0x0a 0012 '\n'*/ _S | _C,
	/*  11 0x0b 0013 '\v'*/ _S | _C,
	/*  12 0x0c 0014 '\f'*/ _S | _C,
	/*  13 0x0d 0015 '\r'*/ _S | _C,
	/*  14 0x0e 0016 so  */ _C,
	/*  15 0x0f 0017 si  */ _C,
	/*  16 0x10 0020 dle */ _C,
	/*  17 0x11 0021 dc1 */ _C,
	/*  18 0x12 0022 dc2 */ _C,
	/*  19 0x13 0023 dc3 */ _C,
	/*  20 0x14 0024 dc4 */ _C,
	/*  21 0x15 0025 nak */ _C,
	/*  22 0x16 0026 syn */ _C,
	/*  23 0x17 0027 etb */ _C,
	/*  24 0x18 0030 can */ _C,
	/*  25 0x19 0031 em  */ _C,
	/*  26 0x1a 0032 sub */ _C,
	/*  27 0x1b 0033 esc */ _C,
	/*  28 0x1c 0034 fs  */ _C,
	/*  29 0x1d 0035 gs  */ _C,
	/*  30 0x1e 0036 rs  */ _C,
	/*  31 0x1f 0037 us  */ _C,
	/*  32 0x20 0040 ' ' */ _SP | _S,
	/*  33 0x21 0041 '!' */ _P,
	/*  34 0x22 0042 '"' */ _P,
	/*  35 0x23 0043 '#' */ _P,
	/*  36 0x24 0044 '$' */ _P,
	/*  37 0x25 0045 '%' */ _P,
	/*  38 0x26 0046 '&' */ _P,
	/*  39 0x27 0047 ''' */ _P,
	/*  40 0x28 0050 '(' */ _P,
	/*  41 0x29 0051 ')' */ _P,
	/*  42 0x2a 0052 '*' */ _P,
	/*  43 0x2b 0053 '+' */ _P,
	/*  44 0x2c 0054 ',' */ _P,
	/*  45 0x2d 0055 '-' */ _P,
	/*  46 0x2e 0056 '.' */ _P,
	/*  47 0x2f 0057 '/' */ _P,
	/*  48 0x30 0060 '0' */ _D | _X,
	/*  49 0x31 0061 '1' */ _D | _X,
	/*  50 0x32 0062 '2' */ _D | _X,
	/*  51 0x33 0063 '3' */ _D | _X,
	/*  52 0x34 0064 '4' */ _D | _X,
	/*  53 0x35 0065 '5' */ _D | _X,
	/*  54 0x36 0066 '6' */ _D | _X,
	/*  55 0x37 0067 '7' */ _D | _X,
	/*  56 0x38 0070 '8' */ _D | _X,
	/*  57 0x39 0071 '9' */ _D | _X,
	/*  58 0x3a 0072 ':' */ _P,
	/*  59 0x3b 0073 ';' */ _P,
	/*  60 0x3c 0074 '<' */ _P,
	/*  61 0x3d 0075 '=' */ _P,
	/*  62 0x3e 0076 '>' */ _P,
	/*  63 0x3f 0077 '?' */ _P,
	/*  64 0x40 0100 '@' */ _P,
	/*  65 0x41 0101 'A' */ _UC | _X,
	/*  66 0x42 0102 'B' */ _UC | _X,
	/*  67 0x43 0103 'C' */ _UC | _X,
	/*  68 0x44 0104 'D' */ _UC | _X,
	/*  69 0x45 0105 'E' */ _UC | _X,
	/*  70 0x46 0106 'F' */ _UC | _X,
	/*  71 0x47 0107 'G' */ _UC,
	/*  72 0x48 0110 'H' */ _UC,
	/*  73 0x49 0111 'I' */ _UC,
	/*  74 0x4a 0112 'J' */ _UC,
	/*  75 0x4b 0113 'K' */ _UC,
	/*  76 0x4c 0114 'L' */ _UC,
	/*  77 0x4d 0115 'M' */ _UC,
	/*  78 0x4e 0116 'N' */ _UC,
	/*  79 0x4f 0117 'O' */ _UC,
	/*  80 0x50 0120 'P' */ _UC,
	/*  81 0x51 0121 'Q' */ _UC,
	/*  82 0x52 0122 'R' */ _UC,
	/*  83 0x53 0123 'S' */ _UC,
	/*  84 0x54 0124 'T' */ _UC,
	/*  85 0x55 0125 'U' */ _UC,
	/*  86 0x56 0126 'V' */ _UC,
	/*  87 0x57 0127 'W' */ _UC,
	/*  88 0x58 0130 'X' */ _UC,
	/*  89 0x59 0131 'Y' */ _UC,
	/*  90 0x5a 0132 'Z' */ _UC,
	/*  91 0x5b 0133 '[' */ _P,
	/*  92 0x5c 0134 '\' */ _P,
	/*  93 0x5d 0135 ']' */ _P,
	/*  94 0x5e 0136 '^' */ _P,
	/*  95 0x5f 0137 '_' */ _P,
	/*  96 0x60 0140 '`' */ _P,
	/*  97 0x61 0141 'a' */ _LC | _X,
	/*  98 0x62 0142 'b' */ _LC | _X,
	/*  99 0x63 0143 'c' */ _LC | _X,
	/* 100 0x64 0144 'd' */ _LC | _X,
	/* 101 0x65 0145 'e' */ _LC | _X,
	/* 102 0x66 0146 'f' */ _LC | _X,
	/* 103 0x67 0147 'g' */ _LC,
	/* 104 0x68 0150 'h' */ _LC,
	/* 105 0x69 0151 'i' */ _LC,
	/* 106 0x6a 0152 'j' */ _LC,
	/* 107 0x6b 0153 'k' */ _LC,
	/* 108 0x6c 0154 'l' */ _LC,
	/* 109 0x6d 0155 'm' */ _LC,
	/* 110 0x6e 0156 'n' */ _LC,
	/* 111 0x6f 0157 'o' */ _LC,
	/* 112 0x70 0160 'p' */ _LC,
	/* 113 0x71 0161 'q' */ _LC,
	/* 114 0x72 0162 'r' */ _LC,
	/* 115 0x73 0163 's' */ _LC,
	/* 116 0x74 0164 't' */ _LC,
	/* 117 0x75 0165 'u' */ _LC,
	/* 118 0x76 0166 'v' */ _LC,
	/* 119 0x77 0167 'w' */ _LC,
	/* 120 0x78 0170 'x' */ _LC,
	/* 121 0x79 0171 'y' */ _LC,
	/* 122 0x7a 0172 'z' */ _LC,
	/* 123 0x7b 0173 '{' */ _P,
	/* 124 0x7c 0174 '|' */ _P,
	/* 125 0x7d 0175 '}' */ _P,
	/* 126 0x7e 0176 '~' */ _P,
	/* 127 0x7f 0177 del */ _C,
	/* 128 0x80 0200 TO 255 0xff 0377 iswhite */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
	};
