/*.BM*********************************************************************
	Copyright (C) 1982 Intermetrics, Inc.
AUTHOR 		:  Andrew Lantz
SECTION		:  Floating Point Run-Time Library for Motorola 68000
MODULE		:   m/rt/c/68000/com/fpdef.h
SCCS ID		:   1.7
LAST DELTA 	:   2/25/84  20:58:55
DATE OF GET	:   6/27/85  18:11:59
UNIX FILE	:   /usr/1/millen/m/rt/c/68000/com/s.fpdef.h
@(#)m/rt/c/68000/com/fpdef.h	1.7
    MODULES DEFINED : (none)
    RELATION : 
    EXTERNAL PROCEDURES:
    EXTERNAL DATA:
**************************************************************************
.EM*/

#define FP_WORDSIZE      16
#define FP_NUMWORDS       4
#define FP_FLT            0
#define FP_DBL            1
#define BIAS           1023
#define MAX_EXP        2046
#define MIN_EXP         -51
#define FMAX_EXP        254
#define FMIN_EXP        -22

#define HIGH            0
#define LOW             1

#define MS  0
#define NMS 1
#define NLS 2
#define LS  3

#define LTES(i,j)   ((i)>=(j))
#define GTES(i,j)   ((i)<=(j))

#define INCS(i)     ((i)--)
#define DECS(i)     ((i)++)
#define MORE(i)     ((i)-1)
#define LESS(i)     ((i)+1)

#define INCR(x)     if((++((x)[LOW]))==0)(++((x)[HIGH]))

#define RSH1(x)     ((x)[LOW] = ((x)[LOW]>>1) | (((x)[HIGH]&0x1L)?0x80000000L:0),\
		    (x[HIGH]>>=1))

#define LSH1(x)     ((x)[HIGH] = ((x)[HIGH]<<1) | (((x)[LOW]&0x80000000L)!=0),\
		    (x[LOW]<<=1))

typedef struct {
    UINT32 arr[2];
} twolongs;

/* bit mask macro names    (these mask unsigned longs)            */
#define LOW_MASK        0x0000ffffL
#define HIGH_MASK       0xffff0000L

#define EXP_MASK        0x7ff00000L
#define FEXP_MASK       0x7f800000L

#define SIGN_MASK       0x80000000L

#define MAXEXP_MASK     0x000007ffL
#define FMAXEXP_MASK    0x000000ffL

#define MANT_MASK       0x000fffffL
#define FMANT_MASK      0x007fffffL

#define HIDDEN_MASK     0x00100000L
#define FHIDDEN_MASK    0x00800000L

/* macros for a, where a is the address of 64 bits of ieee double */
#define EXPOF(a)        (((a)[HIGH] & EXP_MASK) >> 20)
#define FEXPOF(a)       (((a) & FEXP_MASK) >> 23)

#define SIGNOF(a)       (((a)[HIGH] & SIGN_MASK) != 0)
#define FSIGNOF(a)      (((a) & SIGN_MASK) != 0)

#define ISZERO(a)       ( !( ((a)[HIGH] & ~SIGN_MASK) | ((a)[LOW])) )
#define FISZERO(a)      (((a) & 0x7fffffffL) == 0)

#define MANTZERO(a)     ( !( ((a)[HIGH] &  MANT_MASK) | ((a)[LOW])) )
#define FMANTZERO(a)    (((a) &  FMANT_MASK) == 0)

#define ISINFINITY(a)   ((EXPOF(a) == MAXEXP_MASK) &&  MANTZERO(a))
#define FISINFINITY(a)  ((FEXPOF(a) == FMAXEXP_MASK) &&  FMANTZERO(a))

#define ISNAN(a)        ((EXPOF(a) == MAXEXP_MASK) && !(MANTZERO(a)))
#define FISNAN(a)       ((FEXPOF(a) == FMAXEXP_MASK) && !(FMANTZERO(a)))

extern VOID  _shift();
extern VOID  _denorm();
extern VOID  _normalize();

extern VOID  _fdenorm();
extern VOID  _fnormalize();

#define ZERO        0
#define OTHER       1
#define INFINITY    2
#define NAN         3
#define NUM_TYPES   4

#define ADD         0
#define MULT        1
#define DIV         2
#define NUM_OPS     3

extern INT16 _typeof();
extern BOOL  _excepcheck();

extern INT16 _ftypeof();
extern BOOL _fexcepcheck();
