/*.BM*********************************************************************
	Copyright (C) 1982, 1983 Intermetrics, Inc.
AUTHOR		:   Keith Crews
SECTION		:   68000 Run Time Library
MODULE		:   m/rt/c/68000/dm/getc.c
SCCS ID		:   1.15
LAST DELTA	:   9/29/93  14:42:01
DATE OF GET	:   9/29/93  14:42:09
UNIX FILE	:   s.getc.c
@(#)m/rt/c/68000/dm/getc.c	1.15

**************************************************************************
.EM*/

#define MAXUG 10
/* __unget_count is globally visible so we can zap it during initialization */
int __unget_count = 0;
static unsigned char ugstr[MAXUG];

#include "stdio.h"

extern int _getc();

/*ARGSUSED*/
    int
getc(FILE *file)
    /* This is a simple input routine that does echoing, but no other */
    /* processing.  This corresponds to full-duplex raw mode input.   */
{
    int c;

    /* first check for ungotten char - no echo for them */
    if (__unget_count) {
	c = ugstr[--__unget_count];
    } else {
	c = _getc();
	if (c == '\r') {
	    c = '\n'; /* change carriage return to line-feed */
	}
	if (c != EOF) {
	    putc(c, file); /* echo whatever we just read */
	}
    }
    return(c);
}


/*ARGSUSED*/
    int
ungetc(int c, FILE *file)
{
    if (c != EOF) {
        if (__unget_count >= MAXUG) {
	    return (EOF);           /* buffer is full */
	}
	ugstr[__unget_count++] = c; /* add non-EOF characters to buffer */
    }
    return(c);                      /* return what was passed in */
}
