/*.BM**************************************************************************
	Copyright (C) 1989 Intermetrics, Inc.
AUTHOR		: Chris Newbold, Mark Hertel
SECTION		: C Run Time Library
MODULE		: m/rt/c/ansi/memmove.c
SCCS ID		: 1.5
LAST DELTA	: 10/15/90 18:32:44
UNIX FILE	: /usr2/millen/m/rt/c/ansi/s.memmove.c
@(#)m/rt/c/ansi/memmove.c	1.5

	PROCEDURES:
	    memmove - Moves a string of length "n" from "s2" to "s1".
		    The source and destination are allowed to overlap
		    without data loss.  Returns the value of "s1".
*******************************************************************************
.EM*/
/* #ifdef _BIG_PROXY_  Commented by Imran */

#include "string.h"

#ifdef M96002
#undef memmove
#endif

    void *
memmove (void *s1, const void *s2, size_t n)
{
    size_t i;
    void *temp;

    if ((char *)s1 < (char *)s2) {
	    /* no danger of data loss, do a straight copy but save s1 */
	temp = s1;
	for (i = 0; i < n; i++) {
	    *(char *)temp = *(char *)s2;
	    temp = (char *)temp + sizeof(char);
	    s2 = (char *)s2 + sizeof(char);
	}
    } else if ((char *)s1 > (char *)s2)	{
	    /* danger of loss, so copy backwards to avoid */
	n--;
	temp = (char *)s1 + (sizeof(char) * n);
	(char *)s2 += (sizeof(char) * n);
	for (i = n + 1; i != 0; i--) {
	    *(char *)temp = *(char *)s2;
	    temp = (char *)temp - sizeof(char);
	    s2 = (char *)s2 - sizeof(char);
	}
    }
    return (s1);
}
/* #endif */
