/*.BM*********************************************************************
	Copyright (C) 1989 Intermetrics, Inc.
AUTHOR		:   Mark Hertel
SECTION		:   C Run Time Library
MODULE		:   m/rt/c/68000/dm/stdlib.h
SCCS ID		:   1.4
LAST DELTA	:   3/19/91  18:51:36
DATE OF GET	:   9/29/93  09:54:27
UNIX FILE	:   /usr2/millen/m/rt/c/68000/dm/s.stdlib.h
@(#)m/rt/c/68000/dm/stdlib.h	1.4
**************************************************************************
.EM*/

#ifndef __STDLIB_INCLUDED
#define __STDLIB_INCLUDED

#ifndef __SIZE_T
#define __SIZE_T
typedef unsigned long size_t;
#endif

#ifndef __WCHAR_T
#define __WCHAR_T
#ifdef _LONGINT
typedef short wchar_t;
#else
typedef int wchar_t;
#endif
#endif

#ifndef DIV_T
#define DIV_T
typedef struct {
    int quot;
    int rem;
} div_t;
#endif

#ifndef LDIV_T
#define LDIV_T
typedef struct {
    long int quot;
    long int rem;
} ldiv_t;
#endif

#ifndef NULL
#define NULL ((void *)0)
#endif

#define EXIT_FAILURE	1
#define EXIT_SUCCESS	0
#define RAND_MAX	32767
#define MB_CUR_MAX	2

/* String conversion functions */

extern double	atof(const char *);
extern int	atoi(const char *);
extern long	int atol(const char *);
extern double	strtod(const char *, char **);
extern long int	strtol(const char *, char **, int);
extern unsigned long int strtoul(const char *, char **, int);

 /* Pseudo-random sequence generation functions */

extern int	rand(void);
extern void	srand(unsigned int);

/* Memory management functions */

extern void *	calloc(size_t, size_t);
extern void	free(void *);
extern void *	malloc(size_t);
extern void *	realloc(void *, size_t);

/* Communication with the environment */

extern void	abort(void);
extern int	atexit(void (*)(void));
extern void	exit(int);
extern char *	getenv(const char *);
extern int	system(const char *);

/* Searching and sorting utilities */

extern void *	bsearch(const void *, const void *, size_t,
			size_t, int (*)(const void *, const void *));
extern void	qsort(void *, size_t, size_t,
			int (*)(const void *, const void *));

/* Integer arithmetic functions */

extern int	abs(int);
extern div_t	div(int, int);
extern long int	labs(long int);
extern ldiv_t	ldiv(long int, long int);

/* Multibyte character functions */

extern int	mblen(const char *, size_t);
extern int	mbtowc(wchar_t *, const char *, size_t);
extern int	wctomb(char *, wchar_t);

/* Multibyte string functions */

extern size_t	mbstowcs(wchar_t *, const char *, size_t);
extern size_t	wcstombs(char *, const wchar_t *, size_t);

#endif
