/*.BM*******************************************************************
	Copyright (C) 1990 Intermetrics, Inc.
AUTHOR		:   Mark Hertel
SECTION		:   C Run Time Library
MODULE		:   m/rt/c/68000/dm/string.h
SCCS ID		:   1.3
LAST DELTA	:   10/16/90 16:48:40
DATE OF GET	:   9/29/93 09:54:27
UNIX FILE	:   /usr2/millen/m/rt/c/68000/dm/s.string.h
@(#)m/rt/c/68000/dm/string.h	1.3
************************************************************************
.EM*/

#ifndef __STRING_INCLUDED
#define __STRING_INCLUDED

#ifndef __SIZE_T
#define __SIZE_T
typedef unsigned long size_t;
#endif

#ifndef NULL
#define NULL ((void *)0)
#endif

/* Copying functions */

extern void *	memcpy(register unsigned long*, register unsigned long*, register size_t);
extern void *	memmove(void *, const void *, size_t);
extern char *	strcpy(char *, const char *);
extern char *	strncpy(char *, const char *, size_t);

/* Concatenation functions */

extern char *	strcat(char *, const char *);
extern char *	strncat(char *, const char *, size_t);

/* Comparison functions */

extern int	memcmp(const void *, const void *, size_t);
extern int	strcmp(const char *, const char *);
extern int	strcoll(const char *, const char *);
extern int	strncmp(const char *, const char *, size_t);
extern size_t	strxfrm(char *, const char *, size_t);

/* Search functions */

extern void *	memchr(const void *, int, size_t);
extern char *	strchr(const char *, int);
extern size_t	strcspn(const char *, const char *);
extern char *	strpbrk(const char *, const char *);
extern char *	strrchr(const char *, int);
extern size_t	strspn(const char *, const char *);
extern char *	strstr(const char *, const char *);
extern char *	strtok(char *, const char *);

/* Miscellaneous functions */

extern void *	memset(void *, int, size_t);
extern char *	strerror(int);
extern size_t	strlen(const char *);

/* this endif matches the ifndef __STRING_INCLUDED at the start of this file */
#endif
