/*.BM**************************************************************************
	Copyright (C) 1994 Intermetrics, Inc.
AUTHOR		: Julian Horn
SECTION		: C Run Time Library
MODULE		: m/rt/c/ansi/strstr.c
SCCS ID		: 1.3
LAST DELTA	: 2/11/94 14:05:35
UNIX FILE	: s.strstr.c
@(#)m/rt/c/ansi/strstr.c	1.3

	PROCEDURES: strstr
	RELATION:
	    Locates the first occurance of the string "s2" in the string "s1".
	    If s2 is a null string, then s1 is returned.  Otherwise it
	    returns a pointer to the embedded string if found, or NULL if
	    no match was made.
	METHODS
	    Get the first character in s2.  If it's null, then return s1.
	    Otherwise push s2 ahead one character.  Then we loop doing
	    the following actions:
	    a)  Push s1 forwards until we hit a null (in which case we
		return NULL) or a character matching the first one in s2.
	    b)  Compare the string starting at s2 with the string starting
		at s1 (both are one past the initial successful compare).
		If we hit a null at the end of the s2 string then it's a 
		successful compare, so we return s1-1.  Otherwise we will
		eventually hit a miscompare, so we go back to pushing s1 again.
	    The string compare in step b) requires a two temporary pointers,
	    p1 and p2, since we have to maintain the original values of s1
	    and s2 in case we get a miscompare.  The p2 pointer is set up
	    at the beginning, when we fetch the first character from s2.
	    It is reset from original s2 plus 1 after each miscompare.
	    To make this easier, we increment s2 at the beginning.

	    This routine was carefully coded to pack nicely in the 68000
	    case using three pointer and two integer register variables,
	    leaving s2 in memory.  Since s2 is a parameter, it is already
	    in memory.  You can think of the "p2" variable as a register
	    which you load from that memory location, first when you need to
	    get the lead character from s2, and then each time you check out
	    an apparent match.  Since it is set up for free the first time,
	    we only reset it AFTER a (failed) compare rather than before.
*******************************************************************************
.EM*/


    char *
strstr (register const char *s1, const char *s2)
{
    register char c1;
    register char c2;
    register const char *p1;
    register const char *p2;

    p2 = s2;
    if (!(c2 = *p2++)) { /* if s2 is a null string, then s1 is returned. */
	return ((char *)s1);
    }
    s2++; /* keep match check point in s2 */
    while (1) {
	/* push s1 ahead until we hit a null or the start of a match */
	do {
	    if (!(c1 = *s1++)) return (0); /* no match found */
	} while (c1 != c2);
	/* When we get here we have the start of a match: go check it */
	p1 = s1;
	do {
	    if (!(c1 = *p2++)) return ((char *)(s1-1)); /* match verified */
	} while (*p1++ == c1);
	/* match failed: reset s2 and push s1 ahead */
	p2 = s2;
    }

} /* strstr */
