#include	"defs.h"
/***************************************************************************
	File	:	buserr.c
	Synop	:	This file contains the bus error handler which will print out
				the buserror stack frame if an exception occurs while
				the code is running
	First ver	:	Vidy 27/9/95
	Modifications :
*****************************************************************************/
#include	<kstart.h>
#include	"buserr.h"

/*Deepak... - To stop conf thru' SMC in the case of BUS ERROR*/
extern Bus_error_occured;
/*...Deepak*/

void BusErrorHandler(BusErrorFrame *Frame)
{
	ULONG	i;

/*Deepak... - printf's are blocked during conf thru' SMC. As an exceptional case 
if a BUS ERROR occurs the printf is enabled and conf thru'SMC is stopped*/
	Bus_error_occured = 1;

/*...Deepak*/

	for (i=0; i < 0xFFFFF; i++);

	while(1) {

		printf("\n\r<<BUSERROR>>\n\r  Status Register =0x%x\n\r", Frame->StatusRegister);
		printf("          Next PC =0x%x\n\r", Frame->NextPC);
		printf("    Vector Offset =0x%x\n\r", Frame->VectorOffset);
		printf("    Fault Address =0x%x\n\r", Frame->FaultAddress);
		printf("             DBUF =0x%x\n\r", Frame->DBUF);
		printf("        CurrentPC =0x%x\n\r", Frame->CurrentPC);
		printf("     XferCountReg =0x%x\n\r", Frame->TransferCountRegister);
		printf("              SSW =0x%x\n\r", Frame->SpecialStatusWord);

		for (i=0; i < 0x1FFFFF; i++);
      Reset(); 
	}
}
