#include	"defs.h"
/*	$Modname: brouter.c$  $version: 1.6$      $date: 07/08/94$   */
/*
* 	$lgb$
1.0 10/30/93 ross certification version.
1.1 12/09/93 ross added new lsl.
1.2 03/26/94 ross new startup file.
1.3 04/04/94 ross removed header file, and moved CLOCK_TICKS... into this c file.
1.4 04/04/94 ross got rid of some extraneous include files.
1.5 06/13/94 ross ndis test version.
1.6 07/08/94 ross
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1990 - 1994 Router Engines, Inc.								*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	Router Engines, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
/************************************************************************/

/* Jyothi : 21/07/98  
				Made changes for low cost proxy server */

/*----------------------------------------------------------------------------
Changes :
	chetan 21st July 1997
	see the comments NEW_BOOT
	Assignment the Boot Mode flag pointer done statically
	rather than dynamically
----------------------------------------------------------------------------*/

#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>

#include <kstart.h>
#include <v8022str.h>
#include <vethstr.h>
#include <lslproto.h>
#include	<softquot.h>

#include "lsl.h"
#define	byte BYTE
#define	word USHORT
#define	dword ULONG
#define	BOOL int
#include "boot.h"
#include	<rcopy.h>		/* This is for idata init */
#if EVENT_LOG
#include	<logif.h>
#endif
extern	char *rompOutSeg;

extern int	FrmRxed;
extern int	FrmTxed;
extern int StdLibInit(int,void *);

extern enum TEST initialize_test_socket_udp (ULONG clock_ticks_per_second);
extern enum TEST initialize_test_socket_tcp (ULONG clock_ticks_per_second);
extern void	enable_wan_tx_rx(void);
extern void	EnableEthTXAndRx(int);
extern	int InitMicroCode(void);
extern	int IsBridgingEnabled(void);

extern void calculate_crc_table (void) ;

void	enable_tx_rx(void);
#include "vrtrwstr.h"
#include <rwarebuf.h>
#include <serial.h>
extern void ChatForeground(void);
extern void do_telnet_receives(void);

ULONG code_stack_size ;
ULONG rmon_data_and_vect_table_size ;

ULONG idata_udata_size ;

/****************************************************************************/
#define CLOCK_TICKS_PER_SECOND 20
#if __SPEED__ == 25
#define	COUNT_50MS	1250000l
#define	COUNT_15MS	375000l
#elif __SPEED__ == 258048
#define	COUNT_50MS	1290240l
#define	COUNT_15MS	387072l
#elif __SPEED__ == 33344
#define	COUNT_50MS	1667200l
#define	COUNT_15MS	500160l
#else
&&&& - to check for null def
#endif

extern void initialize_system_timer (ULONG count_50ms, ULONG count_15ms);
extern void restore_timer (void);

extern void disable_dma (USHORT channel);
extern enum TEST initialize_dlsw_tcp_connection (void);

/* version number and date are also inside the program
the c structure for version and date are */

#pragma separate VersionDate
const VersionDateType VersionDate =
{"2.00", "January 27, 2000", "ABCD"};

extern void SetErrorVec(void); /* implementation */
void operating_system (void);
enum TEST initialize_routerware_software (ROUTERWARE_MODULE_DEFINITION *sptr_routerware_device_drivers);
/****************************************************************************/
int	InitializationDone = 0;
int	SyncRxError;
int	SyncTxError;
char *PtrToIniFile;
/* char *TmpPtrToIniFile; */
ULONG WatchDogServiceRegister = 0xffff102f;
char ethernet_address[8] ;


/* vidy 13/11/98 moved the following from data seg to code seg */
ULONG	SCC4RMONINTHDLR;
ULONG	SCC3RMONINTHDLR;
ULONG	RMONRXBUF;
ULONG	BRGC3Val;
ULONG	BRGC4Val;
BYTE	one_sec_tick;

#pragma separate BootBinIOPB
BootBinIOPBType BootBinIOPB ;

#if 0	/* Jo 27/04/99 */
void	big_delay()
{
	int x=0xfffff;

	while(--x);
}
#endif

void main ()
{
	HeaderType *sptr_cfg_header = (HeaderType *)FL_CFG_HDR ;
	ULONG available_dram ;

	int micro_init;
	BootConfigType  *ptr_boot_config;

/*
	in pmain.68k we are clearing off the idata segment. we need to put the
	proper initialized values for the variables. this is kept in rompOutSeg
	segment. so we copy it into idata using rcopy. see manuals for details.
*/
	rcopy((struct hdr *) &rompOutSeg);		/* This is the idata initialization code  */
	InitializationDone = 0;

	*((BYTE *)WatchDogServiceRegister)= 0x55;
	*((BYTE *)WatchDogServiceRegister)= 0xAA;

	ptr_boot_config = (BootConfigType *)FL_BOOT_HDR;
	/*
	   First parameter  : Ram size,
	   Second parameter : Heap start
	*/

	StdLibInit((ptr_boot_config->RamSize - code_stack_size - rmon_data_and_vect_table_size - idata_udata_size),
	           (ptr_boot_config->RamStart + code_stack_size + rmon_data_and_vect_table_size + idata_udata_size)) ;

/*  initialize the micro code */
	micro_init = InitMicroCode();

/* initialize the timer */
	initialize_system_timer (COUNT_50MS, COUNT_15MS);


	if (initialize_uim_controller() == -1) 
		while(1);

/*  on smc there might be a modem also. So send AT and wait for Ok.if Ok 
	is recvd then modem is present else absent although it might be off.*/
	SendModemCommand();

	SMCForeground(TRUE);

	printf ("\r\n\r\n\r\n\r\nProxy Server Version : %s\r\n", VersionDate.Version);
	printf ("Dated : %s\r\n\r\n\r\n", VersionDate.Date);

	printf ("Copyright (C) 1998 Multi-Tech Systems, Inc.\r\n");
	printf ("Multi-Tech Systems, Inc., 2205 Woodale Drive\r\nMounds View, Minnesota 55112, USA.\r\n");

	SetErrorVec(); /* sets the cpm error vector */

	available_dram = (ptr_boot_config->RamSize - code_stack_size - rmon_data_and_vect_table_size - idata_udata_size) ;

	printf ("\n\n\rOperating with %d K SRAM for device drivers, applications and stacks\r\n",
	          (int) (available_dram/1024)) ;

	while(!micro_init)
		printf("AHDLC Micro code init failure\n");

/* All routers will be pre programmed to have a unique ethernet address. But
	this can be overridden by initalizing it in the config */

	PtrToIniFile = (char * )&lsl.port[0].rfc1213_ifEntry.ifPhysAddress;

	memcpy(ethernet_address, (char*)&ptr_boot_config->EthernetAddr_H, 6);
	memcpy(PtrToIniFile, ethernet_address, 6);



/* Jo 21/07/98 */

	if (initialize_nvram ((ULONG) NULL,(ULONG) sptr_cfg_header->DnLdAddr) == FAIL)
	{
		printf ("\n\rNVRAM Failed to initialize properly\r\n");
		return;
	}
/* Jo 21/07/98 */


	printf ("\n\rNVRAM Initialized\r\n");

	initialize_lsl_config_parameters ();
	initialize_lsl_port_config_parameters ();

	/* in lsl section lsl total buffer size tells about the maximum amount
	of memory that can be allocated to the different device drivers (ethernet 
	& ppp ports ). The mtu specified in the lsl section is used to caluculate
	the number of buffers that be allocated equally to all the different
	ports. lsl maintains these buffers as device driver buffers. freeing these
	and allocating is thro device_driver_free and device_driver_malloc().
	*/

	if (lsl_control (INITIALIZE_BUFFER_CLASS,(ULONG) NULL) == FAIL)
  	{
		return;
  	}

	printf ("Buffers Initialized\r\n");

	calculate_crc_table () ;

#ifndef SMALL_MEM_MAP
	init_flash_write_scheduler () ;
#endif

#if EVENT_LOG
	init_log();
	printf("Events log inited\n\r");
	write_log(LOG_EVENT_LOG_INIT, (BYTE) 0);  /* Imran */
#endif

	if (initialize_routerware_software (&routerware_device_drivers[0]) == FAIL)
  	{
		return;
  	}

	printf ("Device Drivers Initialized\r\n");

	if (initialize_lsl (CLOCK_TICKS_PER_SECOND) == FAIL)
	{
		printf ("LSL Failed To Initialize Properly");
		return;
  	}

	printf ("LSL Initialized\r\n");
	
	if (initialize_routerware_software (&routerware_protocol_software[0]) == FAIL)
	{
		return;
	}
	printf ("Initialized Protocol Stacks\n");

	enable_tx_rx();
	operating_system ();
}

/****************************************************************************/
extern ULONG old_timer_ulong, lsl_timer_ulong ;
void operating_system (void)
{
	USHORT num_of_calls = 0;
	InitializationDone = 1;

	*(ULONG *)0xff000014 = 0xFF;	/* Turn off Fail LED */

	old_timer_ulong = lsl_timer_ulong ;

	do
	{
			*( (BYTE *)WatchDogServiceRegister)= 0x55;
			*( (BYTE *)WatchDogServiceRegister)= 0xAA;

			poll_for_packet_received (TRUE); 
			if(++num_of_calls == 100){


			*( (BYTE *)WatchDogServiceRegister)= 0x55;
			*( (BYTE *)WatchDogServiceRegister)= 0xAA;

				SMCForeground(FALSE);
				ChatForeground();			/* 10/11/95 Sowmya */
#ifdef _BIG_PROXY_
				serial_foreground();
#endif
				do_telnet_receives();		/* 13, July, 1996, Sanjay */

				polling_timer_interrupt (); 
				num_of_calls = 0;

			}
	} while (TRUE);

}
/****************************************************************************/
/*static enum TEST initialize_routerware_software (ROUTERWARE_MODULE_DEFINITION *sptr_routerware_device_drivers)*/
enum TEST initialize_routerware_software (ROUTERWARE_MODULE_DEFINITION *sptr_routerware_device_drivers)
{
	enum TEST return_code;

	while (sptr_routerware_device_drivers->fptr_initialization_function != NULL)
		{
		return_code = (*sptr_routerware_device_drivers->fptr_initialization_function) (CLOCK_TICKS_PER_SECOND);

		if (return_code == FAIL)
			{
			printf ("No function pointer FAILED\n");
			break;
			}

		++sptr_routerware_device_drivers;
		}

	return (return_code);
}

void enable_tx_rx(void)
{
	EnableEthTXAndRx(FALSE);
}
