/************************************************************************/
/*	Copyright (C) 1994 RouterWare, Inc.												*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Blvd. Suite 212, Newport Beach Ca   */
/************************************************************************/
extern enum TEST initialize_ethernet_controller(ULONG clock_ticks_per_second);

/* Jo :21/7/98 Made changes for Small proxy */

#if !defined __DLL__

typedef	struct	ROUTERWARE_MODULE_DEFINITION
{
	BYTE_ENUM (BOOLEAN)	enabled;
	enum TEST 				(*fptr_initialization_function) (ULONG clock_ticks_per_second);
	char const				*cptr_version_string;
} ROUTERWARE_MODULE_DEFINITION;

/* Jo 27/04/99 */
const ROUTERWARE_MODULE_DEFINITION routerware_device_drivers[] = 
{

	/* high level wan device drivers */

	{TRUE,initialize_ethernet_controller,(ULONG) NULL},

/* FRAME_RELAY */
#if PROXY_SERVER
#else
	{TRUE,initialize_frame_relay,(ULONG) NULL},
#endif

	{TRUE,initialize_ppp,(ULONG) NULL},

#ifdef _BIG_PROXY_
	/* ppp compression routines */
	{TRUE,initialize_cipx,(ULONG) NULL},
	{TRUE,initialize_vjc,(ULONG) NULL},

	/* low level wan device drivers */
#endif

	{TRUE,initialize_wan_controller,(ULONG) NULL},

	/* console device driver */

	{FALSE,NULL}
};

/* Jo 27/04/99 */
const ROUTERWARE_MODULE_DEFINITION routerware_protocol_software[] =
{
	/* protocol stacks */

#if PROXY_SERVER
#else
	{TRUE,initialize_IPX_router,(ULONG) NULL},
#endif
	{TRUE,initialize_ip,(ULONG) NULL},
#if PROXY_SERVER
#else
	{TRUE,initialize_bridge,(ULONG) NULL},
#endif

	/* transport stacks */

#if PROXY_SERVER
#else
	{TRUE,initialize_spx,(ULONG) NULL},
#endif

#ifdef _BIG_PROXY_
   {TRUE,initialize_tcp,(ULONG) NULL},
#endif
	/* applications */

#ifdef _BIG_PROXY_
	{TRUE,initialize_msm_module,(ULONG) NULL},
#endif

	{TRUE,initialize_socket,(ULONG) NULL},

#ifdef _BIG_PROXY_
	{TRUE,initialize_snmp,(ULONG) NULL},
#endif
	{TRUE,initialize_tftp,(ULONG) NULL},

#ifdef _BIG_PROXY_
#if WEB
    {TRUE,initialize_http,(ULONG)NULL},
#endif
#endif

/* Kamalnath  5\9\96 */	
	{TRUE,initialize_dhcp,(ULONG) NULL},
/* Kamalnath  5\9\96 */	

#if defined (__SOCKET_TEST_APPS__)
	{TRUE,initialize_test_socket_tcp,(ULONG) NULL},
#endif

	{TRUE, initialize_proxy_server, (ULONG) NULL},
	{TRUE, initialize_proxy_server_discovery, (ULONG) NULL},


/* #ifdef _BIG_PROXY_ Imran,15/1/98 */  
	{TRUE,initialize_telnet,(ULONG) NULL}, 
/* #endif	 */
	
   /* For NOW ONLY **************************** /

#if PROXY_SERVER
#else
	{TRUE,initialize_ag,(ULONG) NULL},
#endif

/*	{TRUE,initialize_proxy_server,(ULONG) NULL},   */
	{FALSE,NULL}
};

#else

typedef	struct	ROUTERWARE_MODULE_DEFINITION
{
	char const				*cptr_initialization_function_name;
	char const				*cptr_module_name;
	BYTE_ENUM (BOOLEAN)	enabled;
	ULONG						library_handle;
	enum TEST 				(*fptr_initialization_function) (ULONG clock_ticks_per_second);
	char const				*cptr_version_string;
} ROUTERWARE_MODULE_DEFINITION;

ROUTERWARE_MODULE_DEFINITION routerware_device_drivers[] = 
{
	/* operating system */

	{NULL,"rwutils.dll",TRUE,(ULONG) NULL,NULL,NULL},
	{"_initialize_nvram","nvram.dll",TRUE,(ULONG) NULL,NULL,NULL},
	{"_initialize_lsl","lsl.dll",TRUE,(ULONG) NULL,NULL,NULL},

	/* lan device drivers */


	/* high level wan device drivers */

	{"_initialize_ppp","ppp.dll",TRUE,(ULONG) NULL,NULL,NULL},
/*	{"_initialize_frame_relay","fr.dll",TRUE,(ULONG) NULL,NULL,NULL},*/

	/* low level wan device drivers */

	{"_initialize_wan_controller","wan.dll",TRUE,(ULONG) NULL,NULL,NULL},

	/* console device driver */

	{"_initialize_console","console.dll",TRUE,(ULONG) NULL,NULL,NULL},

	/* compression */


	{NULL,NULL,FALSE,(ULONG) NULL,NULL,NULL}
};

ROUTERWARE_MODULE_DEFINITION routerware_protocol_software[] =
{
	/* protocol stacks */

	{"_initialize_IP","ip.dll",TRUE,(ULONG) NULL,NULL,NULL},
	{"_initialize_IPX_router","ipx.dll",TRUE,(ULONG) NULL,NULL,NULL},
	{"_initialize_bridge","stp.dll",TRUE,(ULONG) NULL,NULL,NULL},

	/* transport stacks */


	/* applications */
  
	{"_initialize_socket","socket.dll",TRUE,(ULONG) NULL,NULL,NULL},
	{"_initialize_snmp","snmp.dll",TRUE,(ULONG) NULL,NULL,NULL},
	{"_initialize_tftp","tftp.dll",TRUE,(ULONG) NULL,NULL,NULL},
#if defined (__SOCKET_TEST_APPS__)
	{"_initialize_test_socket_tcp","rconsole.dll",TRUE,(ULONG) NULL,NULL,NULL},
#endif
	{NULL,NULL,FALSE,(ULONG) NULL,NULL,NULL}
};

#endif

