// applicat.cpp : implementation file
//

#include "stdafx.h"
#include "procon.h"
#include "applicat.h"
#include "cryptfns.h"
#include	"secthdr.h"

LPCSTR TNETSectionHeader = "TELNET Server";
LPCSTR TFTPSectionHeader = "TFTP";
LPCSTR WEBSectionHeader = "WEB Server";
LPCSTR SNMPSectionHeader = "SNMP Management";

#define PASSWORD_LEN 48

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// APPLICAT dialog


APPLICAT::APPLICAT(CWnd* pParent /*=NULL*/)
	: CDialog(APPLICAT::IDD, pParent)
{
	//{{AFX_DATA_INIT(APPLICAT)
	m_PWordStr = "";
	m_TFTPEnable = FALSE;
	m_TNETEnable = FALSE;
	m_DumbTerminalMgmtEnable = FALSE;
	m_WEBServer = FALSE;
	m_IPAddr = "";
	m_SNMPEnable = FALSE;
	//}}AFX_DATA_INIT

	m_bDialogInited = FALSE ;
}

void APPLICAT::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(APPLICAT)
	DDX_Control(pDX, IDC_ENABLE_WEB_SERVER_MGMT, m_WEBWnd);
	DDX_Control(pDX, IDC_EDIT_PWORD, m_EditPasWordWnd);
	DDX_Text(pDX, IDC_EDIT_PWORD, m_PWordStr);
	DDX_Check(pDX, IDC_ENABLE_TFTP, m_TFTPEnable);
	DDX_Check(pDX, IDC_ENABLE_TNET, m_TNETEnable);
	DDX_Check(pDX, IDC_ENABLE_DUMB_TERMINAL, m_DumbTerminalMgmtEnable);
	DDX_Check(pDX, IDC_ENABLE_WEB_SERVER_MGMT, m_WEBServer);
	DDX_Text(pDX, IDC_EDITIP_ADDRESS, m_IPAddr);
	DDX_Check(pDX, IDC_CHECK_SNMP, m_SNMPEnable);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(APPLICAT, CDialog)
	//{{AFX_MSG_MAP(APPLICAT)
	ON_EN_UPDATE(IDC_EDIT_PWORD, OnUpdateEditPword)
	ON_BN_CLICKED(IDC_HELP, OnHelp)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// APPLICAT message handlers

BOOL APPLICAT::OnInitDialog()
{
	CDialog::OnInitDialog();
	
	char szBuf[100] ;
	char szPWord[100];
	char WindowHeader[80], CurrentHeading[80], *SubHeadingPointer ;

	GetWindowText (CurrentHeading, 80) ;
	SubHeadingPointer = strchr (CurrentHeading, '-') ;
	if (SubHeadingPointer == NULL)
		SubHeadingPointer = CurrentHeading ;
	else
		SubHeadingPointer += 2 ;

	strcpy (WindowHeader, WindowText.GetBuffer(0)) ;
	strcat (WindowHeader, " - ") ;

	strcat (WindowHeader, SubHeadingPointer) ;
	SetWindowText (WindowHeader) ;

	if (!OKBmpBtn.LoadBitmaps ("OK1", "OK2", "OK3", "OK4"))
		AfxMessageBox ("Failed to load OK bitmap");

	VERIFY (OKBmpBtn.SubclassDlgItem (IDOK, this));
	OKBmpBtn.SizeToContent();

	if (!CancelBmpBtn.LoadBitmaps ("CANCEL1", "CANCEL2", "CANCEL3", "CANCEL4"))
		AfxMessageBox ("Failed to load CANCEL bitmap");

	VERIFY (CancelBmpBtn.SubclassDlgItem (IDCANCEL, this));
	CancelBmpBtn.SizeToContent();

	if (!HelpBmpBtn.LoadBitmaps ("SHELP1", "SHELP2", "SHELP3", "SHELP4"))
		AfxMessageBox ("Failed to load HELP bitmap");

	VERIFY (HelpBmpBtn.SubclassDlgItem (IDC_HELP, this));
	HelpBmpBtn.SizeToContent();

	GetPrivateProfileString ((LPCSTR) TNETSectionHeader,
		(LPCSTR) "Telnet Server", (LPCSTR) StrDisabled,
			(LPSTR) szBuf, sizeof (szBuf), (LPCSTR) IniInWinForm) ;
	if (!strcmp (szBuf, StrEnabled))
		m_TNETEnable = TRUE ;
	else
		m_TNETEnable = FALSE ;

	m_EditPasWordWnd.LimitText (PASSWORD_LEN - 1) ;
	GetPrivateProfileString ((LPCSTR) TNETSectionHeader, 
		(LPCSTR) "Telnet Server Password",
				(LPCSTR)	StrNull, (LPSTR) szBuf, sizeof (szBuf),
						(LPCSTR) IniInWinForm) ;
	Decrypt(szBuf, szPWord);
	m_PWordStr = szPWord ;

	GetPrivateProfileString ((LPCSTR) TFTPSectionHeader,
			(LPCSTR) "TFTP", (LPCSTR) StrDisabled,
				(LPSTR) szBuf, sizeof (szBuf),
						(LPCSTR) IniInWinForm) ;
	if (!strcmp (szBuf, StrEnabled))
		m_TFTPEnable = TRUE ;
	else
		m_TFTPEnable = FALSE ;

	GetPrivateProfileString ((LPCSTR) WEBSectionHeader, (LPCSTR) "WEB Server", (LPCSTR) StrDisabled,
			(LPSTR) szBuf, sizeof (szBuf), (LPCSTR) IniInWinForm) ;
	if (!strcmp (szBuf, StrEnabled))
		m_WEBServer = TRUE;
	else
		m_WEBServer = FALSE;

	GetPrivateProfileString ((LPCSTR) TNETSectionHeader, (LPCSTR) "Telnet Dumb TTY Management", (LPCSTR) StrDisabled,
			(LPSTR) szBuf, sizeof (szBuf), (LPCSTR) IniInWinForm) ;
	if (!strcmp (szBuf, StrEnabled))
		m_DumbTerminalMgmtEnable = TRUE;
	else
		m_DumbTerminalMgmtEnable = FALSE;

	GetPrivateProfileString ((LPCSTR) SNMPSectionHeader, (LPCSTR) "SNMP", (LPCSTR) StrDisabled,
			(LPSTR) szBuf, sizeof (szBuf), (LPCSTR) IniInWinForm) ;
	if (!strcmp (szBuf, StrEnabled))
		m_SNMPEnable = TRUE;
	else
		m_SNMPEnable = FALSE;

	GetPrivateProfileString (SNMPSectionHeader,
			(LPCSTR) "SNMP Local Internet Address",
					StrNull, (LPSTR) szBuf ,sizeof(szBuf),
							(LPCSTR) IniInWinForm);
	m_IPAddr = szBuf;

	CenterWindow() ;

	// Update the Dialog Box fields.
	UpdateData (FALSE) ;
	m_bDialogInited = TRUE ;
	return TRUE ;  // return TRUE  unless you set the focus to a control
}

void APPLICAT::OnOK()
{   
	char szNewHeader[50] ;
	char CurrentHeading[80];

	GetWindowText (CurrentHeading, 80) ;
	ModifyHeader (CurrentHeading, szNewHeader) ;

	// TODO: Add extra validation here
	if (!UpdateData (TRUE))
		return ;

	LPCSTR temp ;

	if (m_TNETEnable)
		temp = StrEnabled ;
	else 
		temp = StrDisabled ;
	WritePrivateProfileString ((LPCSTR) TNETSectionHeader,
		(LPCSTR) "Telnet Server", (LPCSTR) temp, (LPCSTR) IniInWinForm) ;

	char szPassWd[PASSWORD_LEN] ;
	char szEncryptPassWd[PASSWORD_LEN] ;
	if (m_EditPasWordWnd.GetModify())
	{
		strcpy (szPassWd, (LPCSTR) m_PWordStr) ;
		Encrypt (szPassWd, szEncryptPassWd) ;
		WritePrivateProfileString ((LPCSTR) TNETSectionHeader,
			(LPCSTR) "Telnet Server Password",
					(LPCSTR) szEncryptPassWd, (LPCSTR) IniInWinForm) ;
	}

	if (m_TFTPEnable)
		temp = StrEnabled ;
	else 
		temp = StrDisabled ;
	WritePrivateProfileString ((LPCSTR) TFTPSectionHeader,
		(LPCSTR) "TFTP", (LPCSTR) temp, (LPCSTR) IniInWinForm) ;

	if (m_WEBServer)
		temp = StrEnabled ;
	else 
		temp = StrDisabled ;
	WritePrivateProfileString ((LPCSTR) WEBSectionHeader,
		(LPCSTR) "WEB Server", (LPCSTR) temp, (LPCSTR) IniInWinForm) ;

	if (m_DumbTerminalMgmtEnable)
		temp = StrEnabled ;
	else 
		temp = StrDisabled ;
	WritePrivateProfileString ((LPCSTR) TNETSectionHeader,
		(LPCSTR) "Telnet Dumb TTY Management", (LPCSTR) temp, (LPCSTR) IniInWinForm) ;

   //Write the BOOL parameters
	if(m_SNMPEnable)
		temp = StrEnabled;
	else temp = StrDisabled;
		
	WritePrivateProfileString(SNMPSectionHeader , (LPCSTR) "SNMP",
					temp, (LPCSTR) IniInWinForm);	

	CDialog::OnOK();
}

void APPLICAT::OnHelp()
{
	AfxGetApp()->WinHelp (0x20000 + IDD_DIALOG_APPLICATIONS, HELP_CONTEXT) ;
}

void APPLICAT::OnCancel()
{
	// TODO: Add extra cleanup here
	
	CDialog::OnCancel();
}

void APPLICAT::OnUpdateEditPword()
{
	// TODO: Add your control notification handler code here

	int nPassLen = m_PWordStr.GetLength() ;
	if (m_bDialogInited)
	{
		if ((m_EditPasWordWnd.LineLength (-1) > nPassLen || m_EditPasWordWnd.LineLength (-1) < nPassLen) && nPassLen)
		{
			m_PWordStr = "" ;
			UpdateData (FALSE) ;
		}
	}
}
