#include <stdio.h>
#include <malloc.h>

#ifndef	ULONG
#define	ULONG 	unsigned long 
#define	USHORT 	unsigned short 
#define	BYTE 		unsigned char 
#define	DWORD 	unsigned long
#define	NULL 		0
#endif

#define	NUMBER_OF_APPLICATION_ENTRIES		95

#define	CNF_IP_MAGIC_NUMBER		   		0x5580
#define	CNF_PPP_MAGIC_NUMBER		   		0x5581
#define	CNF_WAN_MAGIC_NUMBER		   		0x5582
#define	CNF_PROXY_MAGIC_NUMBER				0x5583
#define	CNF_DHCP_MAGIC_NUMBER				0x5584
#define	CNF_STATIC_ROUTES_MAGIC_NUMBER	0x5585
#define 	END_OF_SECTION 			   		0xFFFF 

DWORD ltl_endian_word (DWORD num) ;
unsigned short change_endian (unsigned short num) ;
enum CNF_DATA_VALUE_DATA_TYPE change_endian_enum (enum CNF_DATA_VALUE_DATA_TYPE num) ;

enum CNF_DATA_VALUE_DATA_TYPE
{
	H1, 
	H2, 
	H3, 
	H4, 
	H4S,
	H6, 
	H7, 
	D2, 
	IP
} ;

typedef struct CNF_IP_HEADER_STRUCT {
      USHORT   magic_number ;
      USHORT   section_length ;
      USHORT   number_of_ports ;  
/*      ULONG    default_gateway ;*/
      BYTE     dns_enabled ;
      ULONG    primary_address ;
      ULONG    secondary_address ;
} CNF_IP_HEADER ;

typedef struct CNF_IP_PORT_STRUCT {
      BYTE  isp_assigns_address ;
      BYTE  bootp ;
      ULONG ip_address ;
      ULONG subnet_mask ;
      ULONG remote_ip_address ;
} CNF_IP_PORT ;

typedef struct CNF_IP_STRUCT {
     CNF_IP_HEADER ip_header ;
     CNF_IP_PORT ip_ports[4] ;
} CNF_IP ;

typedef struct CNF_PPP_HEADER_STRUCT {
      USHORT magic_number ;
      USHORT section_length ;
      BYTE   enabled ;
      USHORT number_of_ports ;  
		BYTE   need_to_dial_out_initially ;

#ifdef	BIG_ENDIAN
   	BYTE		printf:1 ;
   	BYTE		printf_LCP:1 ;
	   BYTE		printf_NCP:1 ;
   	BYTE		printf_alarm:1 ;
	   BYTE		printf_filler:4 ;
#else
	   BYTE		printf_filler:4 ;
   	BYTE		printf_alarm:1 ;
	   BYTE		printf_NCP:1 ;
	   BYTE		printf_LCP:1 ;
   	BYTE		printf:1 ;
#endif

} CNF_PPP_HEADER ;

typedef struct CNF_PPP_OPTION_STRUCT {
   	BYTE   option_type ;

#ifdef BIG_ENDIAN
     	BYTE		Auto:1 ;
     	BYTE		NegNotReqd:1 ;
     	BYTE		Negotiable:1 ;
		BYTE     valid:1 ; 
	  	BYTE		option_filler:4 ;
#else
	  	BYTE		option_filler:4 ;
		BYTE     valid:1 ; 
     	BYTE		Negotiable:1 ;
     	BYTE		NegNotReqd:1 ;
     	BYTE		Auto:1 ;
#endif
		enum CNF_DATA_VALUE_DATA_TYPE	    value_type ;
  		BYTE     option_value[15] ;
} CNF_PPP_OPTION ;

typedef struct CNF_PPP_PORT_STRUCT {
      BYTE     enabled ;
   	BYTE		user_name[128] ;
   	BYTE		user_password[128] ;
      BYTE     connection_dod ;
      USHORT   hangup_time ; 
      BYTE     ip ;
      BYTE     authentication_type ;
      BYTE     remote_port_client_only ;

      CNF_PPP_OPTION   lcp_accm ;
      CNF_PPP_OPTION   remote_lcp_accm ;
      CNF_PPP_OPTION   lcp_mru ;   
      CNF_PPP_OPTION   remote_lcp_mru ;   
      CNF_PPP_OPTION   remote_lcp_authentication ;   
      CNF_PPP_OPTION   lcp_magic_number ;   
      CNF_PPP_OPTION   remote_lcp_magic_number ;   
      CNF_PPP_OPTION   ipcp_ip_address ;   
      CNF_PPP_OPTION   remote_ipcp_ip_address ;   
      CNF_PPP_OPTION   lcp_epd ;
      CNF_PPP_OPTION   remote_lcp_epd ;
      CNF_PPP_OPTION   lcp_mrru ;
      CNF_PPP_OPTION   remote_lcp_mrru ;
      CNF_PPP_OPTION   remote_lcp_callback ;
      CNF_PPP_OPTION   ipcp_dns_address1 ;
      CNF_PPP_OPTION   ipcp_dns_address2 ;
      CNF_PPP_OPTION   ras_remote_ipcp_dns_address1 ;
      CNF_PPP_OPTION   ras_remote_ipcp_dns_address2 ;
      CNF_PPP_OPTION   ras_lcp_authentication ;   
      CNF_PPP_OPTION   ras_ipcp_ip_address ;   
      CNF_PPP_OPTION   ras_remote_ipcp_ip_address ;   
} CNF_PPP_PORT ;

typedef struct CNF_PPP_STRUCT {
   	CNF_PPP_HEADER	   ppp_header ;
   	CNF_PPP_PORT	   ppp_ports[3] ;
} CNF_PPP ;


typedef struct CNF_WAN_HEADER_STRUCT {
      USHORT   magic_number ;
      USHORT   section_length ;
      BYTE     enabled ;
      USHORT   number_of_ports ;  
} CNF_WAN_HEADER ;

typedef struct CNF_WAN_PORT_STRUCT {
      BYTE     enabled ;
      ULONG    speed ;
   	BYTE		script_enabled ;
   	BYTE		restart_script_on_comm_failure ;
		BYTE		direct_connect ;
		BYTE		auto_answer ;

      BYTE     modem_type[50] ;
      BYTE     modem_init_string1 [41] ; 
      BYTE     modem_init_string2 [41] ; 
      BYTE     modem_init_string3 [41] ; 
      BYTE     modem_init_string4 [41] ; 
      BYTE     modem_init_string5 [41] ; 
      BYTE     dial_prefix[21] ;
      BYTE     dial_number[60] ;
      BYTE     dial_suffix[21] ;
      BYTE     ring_message[21] ; 
      BYTE     hangup_string[41] ; 
      BYTE     ok_message[21] ; 
      BYTE     no_carrier_message[21] ; 
      BYTE     error_message[21] ; 
      BYTE     no_dial_tone_message[21] ; 
      BYTE     busy_message[21] ; 
      BYTE     no_answer_message[21] ; 
      BYTE     response_string[41] ; 
}CNF_WAN_PORT ;


typedef struct CNF_WAN_STRUCT {
   	CNF_WAN_HEADER	   wan_header ;
   	CNF_WAN_PORT	   wan_ports[3] ;
} CNF_WAN ;


typedef struct CNF_PROXY_HEADER_STRUCT {
      USHORT   magic_number ;
      USHORT   section_length ;
      USHORT   number_of_ports ; 
      BYTE     enabled ;
		BYTE     proxy_any_app ;
		USHORT	ftp_control_port ;
		USHORT	ftp_data_port ;
} CNF_PROXY_HEADER ;


typedef struct CNF_PROXY_APP_STRUCT {
     USHORT    port ;
     USHORT    protocol ;
}  CNF_PROXY_APP ;

typedef struct CNF_PROXY_USER_DEFINED_APP_STRUCT {
     USHORT    protocol ;
     USHORT    lower_port_number ;
     USHORT    higher_port_number ;
     BYTE	   port_description[16] ;
}  CNF_PROXY_USER_DEFINED_APP ;

typedef struct CNF_PROXY_ADDRESS_INFO_STRUCT {
      ULONG address ;
}  CNF_PROXY_ADDRESS_INFO ;

typedef struct CNF_PROXY_MAC_ADDRESS_INFO_STRUCT {
      BYTE address[13] ;
}  CNF_PROXY_MAC_ADDRESS_INFO ;

typedef struct CNF_PROXY_STATIC_STRUCT {
      ULONG global_address ;
      ULONG local_address ;
}  CNF_PROXY_STATIC_INFO ;

/*typedef struct CNF_TRIPLET_INFO_STRUCT {
      ULONG     local_address ;
      USHORT    port ;
      USHORT    protocol ;
}  CNF_TRIPLET_INFO ;*/

typedef struct CNF_PROXY_DYNAMIC_STRUCT {
      ULONG     local_address ;
      USHORT    port ;
      USHORT    protocol ;
}  CNF_PROXY_DYNAMIC_INFO ;

typedef struct CNF_PROXY_DOMAIN_NAME_STRUCT {
      BYTE domain_name[255] ;
}  CNF_PROXY_DOMAIN_NAME_INFO ;

typedef struct CNF_PROXY_APPLICATION_STRUCT {
      USHORT         number_of_application_entries ;
      CNF_PROXY_APP  application_entries[1] ; 
}  CNF_PROXY_APPLICATION ;

typedef struct CNF_PROXY_USER_DEFINED_APPLICATION_STRUCT {
      USHORT         number_of_user_defined_application_entries ;
      CNF_PROXY_USER_DEFINED_APP  user_defined_application_entries[1] ; 
}  CNF_PROXY_USER_DEFINED_APPLICATION ;

typedef struct CNF_PROXY_VIRTUAL_SERVER_STRUCT {
      USHORT                  number_of_global_address_entries ;
      USHORT                  number_of_static_mapping_entries ;
      USHORT                  number_of_dynamic_mapping_entries ;
      ULONG                   dynamic_mapping_global_address ;
      CNF_PROXY_ADDRESS_INFO  global_address_entries[1] ;
      CNF_PROXY_STATIC_INFO   static_mapping_entries[1];
      CNF_PROXY_DYNAMIC_INFO  dynamic_mapping_entries[1];
}  CNF_PROXY_VIRTUAL_SERVER ;

typedef struct CNF_PROXY_FILTER_STRUCT {
      USHORT     number_of_forbidden_sites_entries ;
      USHORT     number_of_restricted_clients_entries ;
      USHORT     number_of_restricted_application_entries ;
      USHORT     number_of_mac_address_entries ;
      USHORT     number_of_domain_name_entries ;

      CNF_PROXY_ADDRESS_INFO      forbidden_sites_entries[1] ;
      CNF_PROXY_ADDRESS_INFO      restricted_clients_entries[1] ;
      CNF_PROXY_APP               restricted_application_entries[1] ;
      CNF_PROXY_MAC_ADDRESS_INFO  mac_address_entries[1] ;
      CNF_PROXY_DOMAIN_NAME_INFO  domain_name_entries[1] ;

}  CNF_PROXY_FILTER ;

typedef struct CNF_PROXY_PORT_STRUCT {
      BYTE     enabled ;
      USHORT   number_of_address_entries ;
      USHORT   number_of_connections_to_trigger ;
      USHORT   number_of_hosts_to_trigger ;
      CNF_PROXY_ADDRESS_INFO  port_address[1] ;
}  CNF_PROXY_PORT ;


typedef struct CNF_PROXY_STRUCT {
      CNF_PROXY_HEADER           proxy_header ;
	   CNF_PROXY_APPLICATION      proxy_application[1] ;
		CNF_PROXY_USER_DEFINED_APPLICATION    	proxy_user_defined_application[1] ;
      CNF_PROXY_VIRTUAL_SERVER   proxy_virtual_server[1] ;
      CNF_PROXY_FILTER           proxy_filter[1] ; 
      CNF_PROXY_PORT             proxy_ports[4] ;
}  CNF_PROXY ;

typedef struct CNF_DHCP_HEADER_STRUCT {
      USHORT   magic_number ;
      USHORT   section_length ;
      USHORT   number_of_address_range_entries ;
      BYTE     dhcp_server_enabled ;
      BYTE     dhcp_client_enabled ;
      ULONG    dhcp_server_ip_address ;
} CNF_DHCP_HEADER ;


typedef struct CNF_BINDING_INFO_STRUCT {
      ULONG    ip_address ;
      BYTE     mac_address_length ;
      BYTE     mac_address[13] ;
}  CNF_BINDING_INFO ;

/* typedef struct CNF_OPTIONS_INFO_STRUCT {
      BYTE     option_type ;
      BYTE     option_length ;
}  CNF_OPTIONS_INFO ; */

typedef struct CNF_OPTIONS_INFO_STRUCT {
		ULONG  			router_address ;
		BYTE				domain_name[40] ;
		USHORT			reassembly_size ;
		BYTE				default_ip_ttl ;
		USHORT			mtu ;
		BYTE				default_tcp_ttl ;
		ULONG			   lease_time ;
}  CNF_OPTIONS_INFO ;

typedef struct CNF_DHCP_ADDRESS_RANGE_STRUCT {
      ULONG    lower_ip_address ;
      ULONG    higher_ip_address ;
      ULONG    address_mask ;

      USHORT   number_of_bindings_entries ;


      ULONG    exclude_lower_ip_address ;
      ULONG    exclude_higher_ip_address ;
      CNF_OPTIONS_INFO     options_entries ;
      CNF_BINDING_INFO     bindings_entries[1] ;

}  CNF_DHCP_ADDRESS_RANGE ;

typedef struct CNF_DHCP_STRUCT {
      CNF_DHCP_HEADER      dhcp_header ;
      CNF_DHCP_ADDRESS_RANGE    dhcp_address_range_entries[1] ;
}  CNF_DHCP ;

typedef struct CNF_STATIC_ROUTES_HEADER_STRUCT {
      USHORT   magic_number ;
      USHORT   section_length ;
      USHORT   number_of_static_routes ;  
} CNF_STATIC_ROUTES_HEADER ;

typedef struct CNF_STATIC_ROUTES_INFO_STRUCT {
      ULONG host_ip_address ;
      ULONG host_gateway ;
      ULONG host_address_mask ;
		USHORT port_number ;
      BYTE	metric ;
} CNF_STATIC_ROUTES_INFO ;

typedef struct CNF_STATIC_ROUTES_STRUCT {
     CNF_STATIC_ROUTES_HEADER static_routes_header ;
     CNF_STATIC_ROUTES_INFO static_routes_info[1] ;
} CNF_STATIC_ROUTES ;

main()
{
 	FILE *output ; 
 	char RouterBitmapFile[50] ;
	CNF_IP *ip_ptr =NULL;
	CNF_WAN *wan_ptr =NULL;
	CNF_PPP *ppp_ptr =NULL;
	CNF_PROXY_HEADER *proxy_header_ptr =NULL;
	CNF_PROXY_APPLICATION *proxy_application_ptr =NULL ;
   CNF_PROXY_USER_DEFINED_APPLICATION *proxy_user_defined_application_ptr = NULL ;
	CNF_PROXY_VIRTUAL_SERVER *proxy_virtual_ptr =NULL ;
   CNF_PROXY_FILTER *proxy_filter_ptr =NULL ;
   CNF_PROXY_PORT *proxy_ports_ptr =NULL ;
   CNF_DHCP_HEADER *dhcp_header_ptr=NULL ;
	CNF_DHCP_ADDRESS_RANGE *dhcp_address_range_ptr1 = NULL ;
	CNF_DHCP_ADDRESS_RANGE *dhcp_address_range_ptr2 = NULL ;
	CNF_OPTIONS_INFO *dhcp_options_ptr1 =NULL ;
	CNF_OPTIONS_INFO *dhcp_options_ptr2 =NULL ;
	CNF_STATIC_ROUTES_HEADER *static_routes_header_ptr = NULL ;

	USHORT dummy_value ;
	int cnt, length = 0 ;

	strcpy (RouterBitmapFile, "..\\pro_def.bmp") ;
	if ((output=fopen(RouterBitmapFile,"wb"))==NULL)
       printf ("could not open file\n") ;
	printf ("ip_ptr :	%d\n", ip_ptr) ;

 	ip_ptr = (CNF_IP*) calloc (sizeof(struct CNF_IP_STRUCT), 1) ;
	printf ("ip port size :	%u\n", sizeof(struct CNF_IP_PORT_STRUCT)) ;
	printf ("ip size :	%u\n", sizeof(CNF_IP)) ;
	wan_ptr = (CNF_WAN*) calloc (sizeof(struct CNF_WAN_STRUCT), 1) ;
	ppp_ptr = (CNF_PPP*) calloc (sizeof(struct CNF_PPP_STRUCT), 1) ;
   proxy_header_ptr = (CNF_PROXY_HEADER*)
                calloc (sizeof(struct CNF_PROXY_HEADER_STRUCT), 1) ;
	proxy_application_ptr = (CNF_PROXY_APPLICATION*)
        calloc (sizeof(struct CNF_PROXY_APPLICATION_STRUCT ) +
                (sizeof(struct CNF_PROXY_APP_STRUCT ) * (NUMBER_OF_APPLICATION_ENTRIES - 1)), 1) ;

  proxy_user_defined_application_ptr = (CNF_PROXY_USER_DEFINED_APPLICATION*)
                calloc (sizeof(struct CNF_PROXY_USER_DEFINED_APPLICATION_STRUCT) -
                (sizeof(struct CNF_PROXY_USER_DEFINED_APP_STRUCT )), 1) ;

  	proxy_virtual_ptr = (CNF_PROXY_VIRTUAL_SERVER*)
                calloc (sizeof(struct CNF_PROXY_VIRTUAL_SERVER_STRUCT) -
                (sizeof(struct CNF_PROXY_ADDRESS_INFO_STRUCT ) +
                 sizeof(struct CNF_PROXY_STATIC_STRUCT ) +
                 sizeof(struct CNF_PROXY_DYNAMIC_STRUCT )), 1) ;

    proxy_filter_ptr = (CNF_PROXY_FILTER*)
                calloc (sizeof(struct CNF_PROXY_FILTER_STRUCT ) -
                (sizeof(struct CNF_PROXY_ADDRESS_INFO_STRUCT ) +
                 sizeof(struct CNF_PROXY_ADDRESS_INFO_STRUCT ) +
                 sizeof(struct CNF_PROXY_APP_STRUCT ) +
                 sizeof(struct CNF_PROXY_MAC_ADDRESS_INFO_STRUCT ) +
                 sizeof(struct CNF_PROXY_DOMAIN_NAME_STRUCT )), 1) ;

        proxy_ports_ptr = (CNF_PROXY_PORT*)
		  			calloc(4 * (sizeof(struct CNF_PROXY_PORT_STRUCT ) -
					(sizeof(struct CNF_PROXY_ADDRESS_INFO_STRUCT ))), 1) ;

	dhcp_header_ptr = (CNF_DHCP_HEADER*) calloc (sizeof(struct CNF_DHCP_HEADER_STRUCT), 1) ;
	dhcp_address_range_ptr1 = (CNF_DHCP_ADDRESS_RANGE*) calloc (sizeof(struct CNF_DHCP_ADDRESS_RANGE_STRUCT), 1) ;
	dhcp_address_range_ptr2 = (CNF_DHCP_ADDRESS_RANGE*) calloc (sizeof(struct CNF_DHCP_ADDRESS_RANGE_STRUCT), 1) ;
	dhcp_options_ptr1 = (CNF_OPTIONS_INFO*) calloc (sizeof(struct CNF_OPTIONS_INFO_STRUCT), 1) ;
	dhcp_options_ptr2 = (CNF_OPTIONS_INFO*) calloc (sizeof(struct CNF_OPTIONS_INFO_STRUCT), 1) ;
	static_routes_header_ptr = (CNF_STATIC_ROUTES_HEADER *) calloc (sizeof(struct CNF_STATIC_ROUTES_HEADER_STRUCT), 1) ;

	ip_ptr->ip_header.magic_number = change_endian (CNF_IP_MAGIC_NUMBER) ;
	ip_ptr->ip_header.section_length = change_endian (sizeof(struct CNF_IP_STRUCT)) ;
	ip_ptr->ip_header.number_of_ports = change_endian (04) ;	
/*	ip_ptr->ip_header.default_gateway = ltl_endian_word (0) ;*/
	ip_ptr->ip_header.dns_enabled = 1 ;
   ip_ptr->ip_header.primary_address = 0;
   ip_ptr->ip_header.secondary_address = 0;
	ip_ptr->ip_ports[0].isp_assigns_address = 0 ;
	ip_ptr->ip_ports[0].bootp = 0 ;
	ip_ptr->ip_ports[0].ip_address = ltl_endian_word (3232235521) ;
	ip_ptr->ip_ports[0].subnet_mask = ltl_endian_word (4294967040) ;
	ip_ptr->ip_ports[0].remote_ip_address = 0 ;
	ip_ptr->ip_ports[1].isp_assigns_address = 1 ;
	ip_ptr->ip_ports[1].bootp = 0 ;
	ip_ptr->ip_ports[1].ip_address = 0 ;
	ip_ptr->ip_ports[1].subnet_mask = ltl_endian_word (4294967040) ;
	ip_ptr->ip_ports[1].remote_ip_address = 0 ;
	ip_ptr->ip_ports[2].isp_assigns_address = 1 ;
	ip_ptr->ip_ports[2].bootp = 0 ;
	ip_ptr->ip_ports[2].ip_address = 0 ;
	ip_ptr->ip_ports[2].subnet_mask = ltl_endian_word (4294967040) ;
	ip_ptr->ip_ports[2].remote_ip_address = 0 ;
	ip_ptr->ip_ports[3].isp_assigns_address = 1 ;
	ip_ptr->ip_ports[3].bootp = 0 ;
	ip_ptr->ip_ports[3].ip_address = 0 ;
	ip_ptr->ip_ports[3].subnet_mask = ltl_endian_word (4294967040) ;
	ip_ptr->ip_ports[3].remote_ip_address = 0 ;

	wan_ptr->wan_header.magic_number = change_endian (CNF_WAN_MAGIC_NUMBER) ;
	wan_ptr->wan_header.section_length = change_endian (sizeof(struct CNF_WAN_STRUCT)) ;
	wan_ptr->wan_header.enabled = 1 ;
	wan_ptr->wan_header.number_of_ports = change_endian (3) ;
	wan_ptr->wan_ports[0].enabled = 1;
	wan_ptr->wan_ports[0].speed = ltl_endian_word (115200) ;
	wan_ptr->wan_ports[0].script_enabled = 0 ;
	wan_ptr->wan_ports[0].restart_script_on_comm_failure = 0 ; 
   wan_ptr->wan_ports[0].direct_connect = 0 ;   
	wan_ptr->wan_ports[0].auto_answer = 0 ;
   strcpy ((char *)wan_ptr->wan_ports[0].modem_type, "Standard 28K/33.6K/56K Modem") ; 
   strcpy ((char *)wan_ptr->wan_ports[0].modem_init_string1, "AT&FX4&C1&D2S0=0") ;
	strcpy ((char *)wan_ptr->wan_ports[0].modem_init_string2, "") ;
	strcpy ((char *)wan_ptr->wan_ports[0].modem_init_string3, "") ;
	strcpy ((char *)wan_ptr->wan_ports[0].modem_init_string4, "") ;
	strcpy ((char *)wan_ptr->wan_ports[0].modem_init_string5, "") ;

   strcpy ((char *)wan_ptr->wan_ports[0].dial_prefix, "ATDT") ; 
	strcpy ((char *)wan_ptr->wan_ports[0].dial_number, "") ;
	strcpy ((char *)wan_ptr->wan_ports[0].dial_suffix, "") ;
   strcpy ((char *)wan_ptr->wan_ports[0].ring_message, "RING");  
   strcpy ((char *)wan_ptr->wan_ports[0].hangup_string, "+++ATH0") ; 
   strcpy ((char *)wan_ptr->wan_ports[0].ok_message, "OK") ; 

   strcpy ((char *)wan_ptr->wan_ports[0].no_carrier_message, "NO\bCARRIER") ;
   strcpy ((char *)wan_ptr->wan_ports[0].error_message, "ERROR") ;
   strcpy ((char *)wan_ptr->wan_ports[0].no_dial_tone_message, "NO\bDIALTONE") ;
   strcpy ((char *)wan_ptr->wan_ports[0].busy_message, "BUSY") ; 
   strcpy ((char *)wan_ptr->wan_ports[0].no_answer_message, "NO\bANSWER") ; 
   strcpy ((char *)wan_ptr->wan_ports[0].response_string, "CONNECT") ; 

	wan_ptr->wan_ports[1].enabled = 1;
	wan_ptr->wan_ports[1].speed = ltl_endian_word (115200) ;
	wan_ptr->wan_ports[1].script_enabled = 0 ;
	wan_ptr->wan_ports[1].restart_script_on_comm_failure = 0 ; 
   wan_ptr->wan_ports[1].direct_connect = 0 ;
	wan_ptr->wan_ports[1].auto_answer = 0 ;
   strcpy ((char *)wan_ptr->wan_ports[1].modem_type, "Standard 28K/33.6K/56K Modem") ; 
   strcpy ((char *)wan_ptr->wan_ports[1].modem_init_string1, "AT&FX4&C1&D2S0=0") ;
	strcpy ((char *)wan_ptr->wan_ports[1].modem_init_string2, "") ;
	strcpy ((char *)wan_ptr->wan_ports[1].modem_init_string3, "") ;
	strcpy ((char *)wan_ptr->wan_ports[1].modem_init_string4, "") ;
	strcpy ((char *)wan_ptr->wan_ports[1].modem_init_string5, "") ;
   strcpy ((char *)wan_ptr->wan_ports[1].dial_prefix, "ATDT") ;
	strcpy ((char *)wan_ptr->wan_ports[1].dial_number, "") ;
	strcpy ((char *)wan_ptr->wan_ports[1].dial_suffix, "") ;
   strcpy ((char *)wan_ptr->wan_ports[1].ring_message, "RING") ;
   strcpy ((char *)wan_ptr->wan_ports[1].hangup_string, "+++ATH0") ;
   strcpy ((char *)wan_ptr->wan_ports[1].ok_message, "OK") ;
   strcpy ((char *)wan_ptr->wan_ports[1].no_carrier_message, "NO\bCARRIER") ; 
   strcpy ((char *)wan_ptr->wan_ports[1].error_message, "ERROR") ; 
   strcpy ((char *)wan_ptr->wan_ports[1].no_dial_tone_message, "NO\bDIALTONE") ;
   strcpy ((char *)wan_ptr->wan_ports[1].busy_message, "BUSY") ; 
   strcpy ((char *)wan_ptr->wan_ports[1].no_answer_message, "NO\bANSWER") ;
   strcpy ((char *)wan_ptr->wan_ports[1].response_string, "CONNECT") ;

	wan_ptr->wan_ports[2].enabled = 1;
	wan_ptr->wan_ports[2].speed = ltl_endian_word (115200) ;
	wan_ptr->wan_ports[2].script_enabled = 0 ;
	wan_ptr->wan_ports[2].restart_script_on_comm_failure = 0 ; 
   wan_ptr->wan_ports[2].direct_connect = 0 ;
	wan_ptr->wan_ports[2].auto_answer = 0 ;
   strcpy ((char *)wan_ptr->wan_ports[2].modem_type, "Standard 28K/33.6K/56K Modem") ; 
   strcpy ((char *)wan_ptr->wan_ports[2].modem_init_string1, "AT&FX4&C1&D2S0=0") ;
	strcpy ((char *)wan_ptr->wan_ports[2].modem_init_string2, "") ;
	strcpy ((char *)wan_ptr->wan_ports[2].modem_init_string3, "") ;
	strcpy ((char *)wan_ptr->wan_ports[2].modem_init_string4, "") ;
	strcpy ((char *)wan_ptr->wan_ports[2].modem_init_string5, "") ;
   strcpy ((char *)wan_ptr->wan_ports[2].dial_prefix, "ATDT") ;
	strcpy ((char *)wan_ptr->wan_ports[2].dial_number, "") ;
	strcpy ((char *)wan_ptr->wan_ports[2].dial_suffix, "") ;
   strcpy ((char *)wan_ptr->wan_ports[2].ring_message, "RING") ; 
   strcpy ((char *)wan_ptr->wan_ports[2].hangup_string, "+++ATH0") ;
   strcpy ((char *)wan_ptr->wan_ports[2].ok_message, "OK") ;
   strcpy ((char *)wan_ptr->wan_ports[2].no_carrier_message, "NO\bCARRIER") ;
   strcpy ((char *)wan_ptr->wan_ports[2].error_message, "ERROR") ;
   strcpy ((char *)wan_ptr->wan_ports[2].no_dial_tone_message, "NO\bDIALTONE") ; 
   strcpy ((char *)wan_ptr->wan_ports[2].busy_message, "BUSY") ;
   strcpy ((char *)wan_ptr->wan_ports[2].no_answer_message, "NO\bANSWER") ;
   strcpy ((char *)wan_ptr->wan_ports[2].response_string, "CONNECT") ; 

	ppp_ptr->ppp_header.magic_number = change_endian (CNF_PPP_MAGIC_NUMBER) ;
	ppp_ptr->ppp_header.section_length = change_endian (sizeof(struct CNF_PPP_STRUCT)) ;
	ppp_ptr->ppp_header.enabled = 1 ;
	ppp_ptr->ppp_header.number_of_ports = change_endian (3) ;
	ppp_ptr->ppp_header.need_to_dial_out_initially = 1 ;
	ppp_ptr->ppp_header.printf = 0 ;
	ppp_ptr->ppp_header.printf_LCP = 0 ;
	ppp_ptr->ppp_header.printf_NCP = 0 ;
	ppp_ptr->ppp_header.printf_alarm = 0 ;
	ppp_ptr->ppp_ports[0].enabled = 1 ;
	strcpy ((char *)ppp_ptr->ppp_ports[0].user_name, "") ;
	strcpy ((char *)ppp_ptr->ppp_ports[0].user_password, "") ;
	ppp_ptr->ppp_ports[0].connection_dod = 1 ;
	ppp_ptr->ppp_ports[0].hangup_time = change_endian (600) ;
	ppp_ptr->ppp_ports[0].ip = 1 ;
   ppp_ptr->ppp_ports[0].authentication_type = 2 ;
   ppp_ptr->ppp_ports[0].remote_port_client_only = 0 ;

	ppp_ptr->ppp_ports[0].lcp_accm.option_type = 2 ;
	ppp_ptr->ppp_ports[0].lcp_accm.Auto = 1 ;
	ppp_ptr->ppp_ports[0].lcp_accm.NegNotReqd = 1 ;
	ppp_ptr->ppp_ports[0].lcp_accm.Negotiable = 1 ;
	ppp_ptr->ppp_ports[0].lcp_accm.value_type = change_endian_enum (H4S) ;
	ppp_ptr->ppp_ports[0].lcp_accm.valid = 1 ;
	strcpy (ppp_ptr->ppp_ports[0].lcp_accm.option_value, "000A0000") ;

	ppp_ptr->ppp_ports[0].remote_lcp_accm.option_type = 2 ;
	ppp_ptr->ppp_ports[0].remote_lcp_accm.Auto = 1 ;
	ppp_ptr->ppp_ports[0].remote_lcp_accm.NegNotReqd = 1 ;
	ppp_ptr->ppp_ports[0].remote_lcp_accm.Negotiable = 1 ;
	ppp_ptr->ppp_ports[0].remote_lcp_accm.value_type = change_endian_enum (H4) ;
	ppp_ptr->ppp_ports[0].remote_lcp_accm.valid = 1 ;
	strcpy (ppp_ptr->ppp_ports[0].remote_lcp_accm.option_value, "00000000") ;

	ppp_ptr->ppp_ports[0].lcp_mru.option_type = 1 ;
	ppp_ptr->ppp_ports[0].lcp_mru.Auto = 1 ;
	ppp_ptr->ppp_ports[0].lcp_mru.NegNotReqd = 1 ;
	ppp_ptr->ppp_ports[0].lcp_mru.Negotiable = 1 ;
	ppp_ptr->ppp_ports[0].lcp_mru.value_type = change_endian_enum (D2) ;
	ppp_ptr->ppp_ports[0].lcp_mru.valid = 1 ;
	strcpy (ppp_ptr->ppp_ports[0].lcp_mru.option_value, "1534") ;
	ppp_ptr->ppp_ports[0].remote_lcp_mru.option_type = 1 ;
	ppp_ptr->ppp_ports[0].remote_lcp_mru.Auto = 1 ;
	ppp_ptr->ppp_ports[0].remote_lcp_mru.NegNotReqd = 1 ;
	ppp_ptr->ppp_ports[0].remote_lcp_mru.Negotiable = 1 ;
	ppp_ptr->ppp_ports[0].remote_lcp_mru.value_type = change_endian_enum (D2) ;
	ppp_ptr->ppp_ports[0].remote_lcp_mru.valid = 1 ;
	strcpy (ppp_ptr->ppp_ports[0].remote_lcp_mru.option_value, "1534") ;

	ppp_ptr->ppp_ports[0].remote_lcp_authentication.option_type = 3 ;
	ppp_ptr->ppp_ports[0].remote_lcp_authentication.Auto = 1 ;
	ppp_ptr->ppp_ports[0].remote_lcp_authentication.NegNotReqd = 1 ;
   ppp_ptr->ppp_ports[0].remote_lcp_authentication.Negotiable = 1 ;
	ppp_ptr->ppp_ports[0].remote_lcp_authentication.value_type = change_endian_enum (H2) ;
	ppp_ptr->ppp_ports[0].remote_lcp_authentication.valid = 1 ;
	strcpy (ppp_ptr->ppp_ports[0].remote_lcp_authentication.option_value, "c023") ;

	ppp_ptr->ppp_ports[0].lcp_magic_number.option_type = 5 ;
	ppp_ptr->ppp_ports[0].lcp_magic_number.Auto = 1 ;
	ppp_ptr->ppp_ports[0].lcp_magic_number.NegNotReqd = 1 ;
	ppp_ptr->ppp_ports[0].lcp_magic_number.Negotiable = 1 ;
	ppp_ptr->ppp_ports[0].lcp_magic_number.value_type = change_endian_enum (H4) ;
	ppp_ptr->ppp_ports[0].lcp_magic_number.valid = 1 ;
	strcpy (ppp_ptr->ppp_ports[0].lcp_magic_number.option_value, "00000000") ;
	ppp_ptr->ppp_ports[0].remote_lcp_magic_number.option_type = 5 ;
	ppp_ptr->ppp_ports[0].remote_lcp_magic_number.Auto = 1 ;
	ppp_ptr->ppp_ports[0].remote_lcp_magic_number.NegNotReqd = 1 ;
	ppp_ptr->ppp_ports[0].remote_lcp_magic_number.Negotiable = 1 ;
	ppp_ptr->ppp_ports[0].remote_lcp_magic_number.value_type = change_endian_enum (H4) ;
	ppp_ptr->ppp_ports[0].remote_lcp_magic_number.valid = 1 ;
	strcpy (ppp_ptr->ppp_ports[0].remote_lcp_magic_number.option_value, "00000000") ;

	ppp_ptr->ppp_ports[0].ipcp_ip_address.option_type = 3 ;
	ppp_ptr->ppp_ports[0].ipcp_ip_address.Auto = 1 ;
	ppp_ptr->ppp_ports[0].ipcp_ip_address.NegNotReqd = 1 ;
	ppp_ptr->ppp_ports[0].ipcp_ip_address.Negotiable = 1 ;
	ppp_ptr->ppp_ports[0].ipcp_ip_address.value_type = change_endian_enum (IP) ;
	ppp_ptr->ppp_ports[0].ipcp_ip_address.valid = 1 ;
	strcpy (ppp_ptr->ppp_ports[0].ipcp_ip_address.option_value, "0.0.0.0") ;
	ppp_ptr->ppp_ports[0].remote_ipcp_ip_address.option_type = 3 ;
	ppp_ptr->ppp_ports[0].remote_ipcp_ip_address.Auto = 1 ;
	ppp_ptr->ppp_ports[0].remote_ipcp_ip_address.NegNotReqd = 1 ;
	ppp_ptr->ppp_ports[0].remote_ipcp_ip_address.Negotiable = 1 ;
	ppp_ptr->ppp_ports[0].remote_ipcp_ip_address.value_type = change_endian_enum (IP) ;
	ppp_ptr->ppp_ports[0].remote_ipcp_ip_address.valid = 1 ;
	strcpy (ppp_ptr->ppp_ports[0].remote_ipcp_ip_address.option_value, "0.0.0.0") ;

  	ppp_ptr->ppp_ports[0].lcp_epd.option_type = 19 ;
	ppp_ptr->ppp_ports[0].lcp_epd.Auto = 1 ;
	ppp_ptr->ppp_ports[0].lcp_epd.NegNotReqd = 1 ;
	ppp_ptr->ppp_ports[0].lcp_epd.Negotiable = 0 ;
	ppp_ptr->ppp_ports[0].lcp_epd.value_type = change_endian_enum (H7) ;
	ppp_ptr->ppp_ports[0].lcp_epd.valid = 0 ;
	strcpy ((char *)ppp_ptr->ppp_ports[0].lcp_epd.option_value, "03000000000000") ;

	ppp_ptr->ppp_ports[0].remote_lcp_epd.option_type = 19 ;
	ppp_ptr->ppp_ports[0].remote_lcp_epd.Auto = 1 ;
	ppp_ptr->ppp_ports[0].remote_lcp_epd.NegNotReqd = 1 ;
	ppp_ptr->ppp_ports[0].remote_lcp_epd.Negotiable = 1 ;
	ppp_ptr->ppp_ports[0].remote_lcp_epd.value_type = change_endian_enum (H7) ;
	ppp_ptr->ppp_ports[0].remote_lcp_epd.valid = 0 ;
	strcpy ((char *)ppp_ptr->ppp_ports[0].remote_lcp_epd.option_value, "03000000000000") ;

	ppp_ptr->ppp_ports[0].lcp_mrru.option_type = 17 ;
	ppp_ptr->ppp_ports[0].lcp_mrru.Auto = 1 ;
	ppp_ptr->ppp_ports[0].lcp_mrru.NegNotReqd = 1 ;
	ppp_ptr->ppp_ports[0].lcp_mrru.Negotiable = 1 ;
	ppp_ptr->ppp_ports[0].lcp_mrru.value_type = change_endian_enum (D2) ;
	ppp_ptr->ppp_ports[0].lcp_mrru.valid = 1 ;
   strcpy ((char *)ppp_ptr->ppp_ports[0].lcp_mrru.option_value, "1534") ;

	ppp_ptr->ppp_ports[0].remote_lcp_mrru.option_type = 17 ;
	ppp_ptr->ppp_ports[0].remote_lcp_mrru.Auto = 1 ;
	ppp_ptr->ppp_ports[0].remote_lcp_mrru.NegNotReqd = 1 ;
	ppp_ptr->ppp_ports[0].remote_lcp_mrru.Negotiable = 1 ;
	ppp_ptr->ppp_ports[0].remote_lcp_mrru.value_type = change_endian_enum (D2) ;
	ppp_ptr->ppp_ports[0].remote_lcp_mrru.valid = 1 ;
   strcpy ((char *)ppp_ptr->ppp_ports[0].remote_lcp_mrru.option_value, "1534") ;

  	ppp_ptr->ppp_ports[0].remote_lcp_callback.option_type = 13 ;
	ppp_ptr->ppp_ports[0].remote_lcp_callback.Auto = 1 ;
	ppp_ptr->ppp_ports[0].remote_lcp_callback.NegNotReqd = 1 ;
	ppp_ptr->ppp_ports[0].remote_lcp_callback.Negotiable = 1 ;
	ppp_ptr->ppp_ports[0].remote_lcp_callback.value_type = change_endian_enum (H1) ;
	ppp_ptr->ppp_ports[0].remote_lcp_callback.valid = 1 ;
   strcpy ((char *)ppp_ptr->ppp_ports[0].remote_lcp_callback.option_value, "00") ;

	ppp_ptr->ppp_ports[0].ipcp_dns_address1.option_type = 129 ;
	ppp_ptr->ppp_ports[0].ipcp_dns_address1.Auto = 1 ;
	ppp_ptr->ppp_ports[0].ipcp_dns_address1.NegNotReqd = 1 ;
	ppp_ptr->ppp_ports[0].ipcp_dns_address1.Negotiable = 1 ;
	ppp_ptr->ppp_ports[0].ipcp_dns_address1.value_type = change_endian_enum (IP) ;
	ppp_ptr->ppp_ports[0].ipcp_dns_address1.valid = 0 ;
	strcpy ((char *)ppp_ptr->ppp_ports[0].ipcp_dns_address1.option_value, "0.0.0.0") ;

	ppp_ptr->ppp_ports[0].ipcp_dns_address2.option_type = 131 ;
	ppp_ptr->ppp_ports[0].ipcp_dns_address2.Auto = 1 ;
	ppp_ptr->ppp_ports[0].ipcp_dns_address2.NegNotReqd = 1 ;
	ppp_ptr->ppp_ports[0].ipcp_dns_address2.Negotiable = 1 ;
	ppp_ptr->ppp_ports[0].ipcp_dns_address2.value_type = change_endian_enum (IP) ;
	ppp_ptr->ppp_ports[0].ipcp_dns_address2.valid = 0 ;
	strcpy ((char *)ppp_ptr->ppp_ports[0].ipcp_dns_address2.option_value, "0.0.0.0") ;

/* RAS strings */

	ppp_ptr->ppp_ports[0].ras_remote_ipcp_dns_address1.option_type = 129 ;
	ppp_ptr->ppp_ports[0].ras_remote_ipcp_dns_address1.Auto = 1 ;
	ppp_ptr->ppp_ports[0].ras_remote_ipcp_dns_address1.NegNotReqd = 1 ;
	ppp_ptr->ppp_ports[0].ras_remote_ipcp_dns_address1.Negotiable = 0 ;
	ppp_ptr->ppp_ports[0].ras_remote_ipcp_dns_address1.value_type = change_endian_enum (IP) ;
	ppp_ptr->ppp_ports[0].ras_remote_ipcp_dns_address1.valid = 0 ;
	strcpy ((char *)ppp_ptr->ppp_ports[0].ras_remote_ipcp_dns_address1.option_value, "0.0.0.0") ;

	ppp_ptr->ppp_ports[0].ras_remote_ipcp_dns_address2.option_type = 131 ;
	ppp_ptr->ppp_ports[0].ras_remote_ipcp_dns_address2.Auto = 1 ;
	ppp_ptr->ppp_ports[0].ras_remote_ipcp_dns_address2.NegNotReqd = 1 ;
	ppp_ptr->ppp_ports[0].ras_remote_ipcp_dns_address2.Negotiable = 0 ;
	ppp_ptr->ppp_ports[0].ras_remote_ipcp_dns_address2.value_type = change_endian_enum (IP) ;
	ppp_ptr->ppp_ports[0].ras_remote_ipcp_dns_address2.valid = 0 ;
	strcpy ((char *)ppp_ptr->ppp_ports[0].ras_remote_ipcp_dns_address2.option_value, "0.0.0.0") ;

	ppp_ptr->ppp_ports[0].ras_lcp_authentication.option_type = 3 ;
	ppp_ptr->ppp_ports[0].ras_lcp_authentication.Auto = 1 ;
	ppp_ptr->ppp_ports[0].ras_lcp_authentication.NegNotReqd = 1 ;
   ppp_ptr->ppp_ports[0].ras_lcp_authentication.Negotiable = 0 ;
	ppp_ptr->ppp_ports[0].ras_lcp_authentication.value_type = change_endian_enum (H2) ;
	ppp_ptr->ppp_ports[0].ras_lcp_authentication.valid = 1 ;
	strcpy (ppp_ptr->ppp_ports[0].ras_lcp_authentication.option_value, "c023") ;

	ppp_ptr->ppp_ports[0].ras_ipcp_ip_address.option_type = 3 ;
	ppp_ptr->ppp_ports[0].ras_ipcp_ip_address.Auto = 1 ;
	ppp_ptr->ppp_ports[0].ras_ipcp_ip_address.NegNotReqd = 1 ;
	ppp_ptr->ppp_ports[0].ras_ipcp_ip_address.Negotiable = 1 ;
	ppp_ptr->ppp_ports[0].ras_ipcp_ip_address.value_type = change_endian_enum (IP) ;
	ppp_ptr->ppp_ports[0].ras_ipcp_ip_address.valid = 0 ;
	strcpy (ppp_ptr->ppp_ports[0].ras_ipcp_ip_address.option_value, "0.0.0.0") ;

	ppp_ptr->ppp_ports[0].ras_remote_ipcp_ip_address.option_type = 3 ;
	ppp_ptr->ppp_ports[0].ras_remote_ipcp_ip_address.Auto = 1 ;
	ppp_ptr->ppp_ports[0].ras_remote_ipcp_ip_address.NegNotReqd = 1 ;
	ppp_ptr->ppp_ports[0].ras_remote_ipcp_ip_address.Negotiable = 1 ;
	ppp_ptr->ppp_ports[0].ras_remote_ipcp_ip_address.value_type = change_endian_enum (IP) ;
	ppp_ptr->ppp_ports[0].ras_remote_ipcp_ip_address.valid = 0 ;
	strcpy (ppp_ptr->ppp_ports[0].ras_remote_ipcp_ip_address.option_value, "0.0.0.0") ;

	ppp_ptr->ppp_ports[1].enabled = 1 ;
	strcpy ((char *)ppp_ptr->ppp_ports[1].user_name, "") ;
	strcpy ((char *)ppp_ptr->ppp_ports[1].user_password, "") ;
	ppp_ptr->ppp_ports[1].connection_dod = 1 ;
	ppp_ptr->ppp_ports[1].hangup_time = change_endian (600) ;
	ppp_ptr->ppp_ports[1].ip = 1 ;
   ppp_ptr->ppp_ports[1].authentication_type = 2 ;
   ppp_ptr->ppp_ports[1].remote_port_client_only = 0 ;
	
	ppp_ptr->ppp_ports[1].lcp_accm.option_type = 2 ;
	ppp_ptr->ppp_ports[1].lcp_accm.Auto = 1 ;
	ppp_ptr->ppp_ports[1].lcp_accm.NegNotReqd = 1 ;
	ppp_ptr->ppp_ports[1].lcp_accm.Negotiable = 1 ;
	ppp_ptr->ppp_ports[1].lcp_accm.value_type = change_endian_enum (H4S) ;
	ppp_ptr->ppp_ports[1].lcp_accm.valid = 1 ;
	strcpy (ppp_ptr->ppp_ports[1].lcp_accm.option_value, "000A0000") ;
	ppp_ptr->ppp_ports[1].remote_lcp_accm.option_type = 2 ;
	ppp_ptr->ppp_ports[1].remote_lcp_accm.Auto = 1 ;
	ppp_ptr->ppp_ports[1].remote_lcp_accm.NegNotReqd = 1 ;
	ppp_ptr->ppp_ports[1].remote_lcp_accm.Negotiable = 1 ;
	ppp_ptr->ppp_ports[1].remote_lcp_accm.value_type = H4 ;
	ppp_ptr->ppp_ports[1].remote_lcp_accm.valid = 1 ;
	strcpy (ppp_ptr->ppp_ports[1].remote_lcp_accm.option_value, "00000000") ;

	ppp_ptr->ppp_ports[1].lcp_mru.option_type = 1 ;
	ppp_ptr->ppp_ports[1].lcp_mru.Auto = 1 ;
	ppp_ptr->ppp_ports[1].lcp_mru.NegNotReqd = 1 ;
	ppp_ptr->ppp_ports[1].lcp_mru.Negotiable = 1 ;
	ppp_ptr->ppp_ports[1].lcp_mru.value_type = change_endian_enum (D2) ;
	ppp_ptr->ppp_ports[1].lcp_mru.valid = 1 ;
	strcpy (ppp_ptr->ppp_ports[1].lcp_mru.option_value, "1534") ;
	ppp_ptr->ppp_ports[1].remote_lcp_mru.option_type = 1 ;
	ppp_ptr->ppp_ports[1].remote_lcp_mru.Auto = 1 ;
	ppp_ptr->ppp_ports[1].remote_lcp_mru.NegNotReqd = 1 ;
	ppp_ptr->ppp_ports[1].remote_lcp_mru.Negotiable = 1 ;
	ppp_ptr->ppp_ports[1].remote_lcp_mru.value_type = change_endian_enum (D2) ;
	ppp_ptr->ppp_ports[1].remote_lcp_mru.valid = 1 ;
	strcpy (ppp_ptr->ppp_ports[1].remote_lcp_mru.option_value, "1534") ;

	ppp_ptr->ppp_ports[1].remote_lcp_authentication.option_type = 3 ;
	ppp_ptr->ppp_ports[1].remote_lcp_authentication.Auto = 1 ;
	ppp_ptr->ppp_ports[1].remote_lcp_authentication.NegNotReqd = 1 ;
	ppp_ptr->ppp_ports[1].remote_lcp_authentication.Negotiable = 1 ;
	ppp_ptr->ppp_ports[1].remote_lcp_authentication.value_type = change_endian_enum (H2) ;
	ppp_ptr->ppp_ports[1].remote_lcp_authentication.valid = 1 ;
	strcpy (ppp_ptr->ppp_ports[1].remote_lcp_authentication.option_value, "c023") ;

	ppp_ptr->ppp_ports[1].lcp_magic_number.option_type = 5 ;
	ppp_ptr->ppp_ports[1].lcp_magic_number.Auto = 1 ;
	ppp_ptr->ppp_ports[1].lcp_magic_number.NegNotReqd = 1 ;
	ppp_ptr->ppp_ports[1].lcp_magic_number.Negotiable = 1 ;
	ppp_ptr->ppp_ports[1].lcp_magic_number.value_type = change_endian_enum (H4) ;
	ppp_ptr->ppp_ports[1].lcp_magic_number.valid = 1 ;
	strcpy (ppp_ptr->ppp_ports[1].lcp_magic_number.option_value, "00000000") ;
	ppp_ptr->ppp_ports[1].remote_lcp_magic_number.option_type = 5 ;
	ppp_ptr->ppp_ports[1].remote_lcp_magic_number.Auto = 1 ;
	ppp_ptr->ppp_ports[1].remote_lcp_magic_number.NegNotReqd = 1 ;
	ppp_ptr->ppp_ports[1].remote_lcp_magic_number.Negotiable = 1 ;
	ppp_ptr->ppp_ports[1].remote_lcp_magic_number.value_type = change_endian_enum (H4) ;
	ppp_ptr->ppp_ports[1].remote_lcp_magic_number.valid = 1 ;
	strcpy (ppp_ptr->ppp_ports[1].remote_lcp_magic_number.option_value, "00000000") ;

	ppp_ptr->ppp_ports[1].ipcp_ip_address.option_type = 3 ;
	ppp_ptr->ppp_ports[1].ipcp_ip_address.Auto = 1 ;
	ppp_ptr->ppp_ports[1].ipcp_ip_address.NegNotReqd = 1 ;
	ppp_ptr->ppp_ports[1].ipcp_ip_address.Negotiable = 1 ;
	ppp_ptr->ppp_ports[1].ipcp_ip_address.value_type = change_endian_enum (IP) ;
	ppp_ptr->ppp_ports[1].ipcp_ip_address.valid = 1 ;
	strcpy (ppp_ptr->ppp_ports[1].ipcp_ip_address.option_value, "0.0.0.0") ;
	ppp_ptr->ppp_ports[1].remote_ipcp_ip_address.option_type = 3 ;
	ppp_ptr->ppp_ports[1].remote_ipcp_ip_address.Auto = 1 ;
	ppp_ptr->ppp_ports[1].remote_ipcp_ip_address.NegNotReqd = 1 ;
	ppp_ptr->ppp_ports[1].remote_ipcp_ip_address.Negotiable = 1 ;
	ppp_ptr->ppp_ports[1].remote_ipcp_ip_address.value_type = change_endian_enum (IP) ;
	ppp_ptr->ppp_ports[1].remote_ipcp_ip_address.valid = 1 ;
	strcpy (ppp_ptr->ppp_ports[1].remote_ipcp_ip_address.option_value, "0.0.0.0") ;

  	ppp_ptr->ppp_ports[1].lcp_epd.option_type = 19 ;
	ppp_ptr->ppp_ports[1].lcp_epd.Auto = 1 ;
	ppp_ptr->ppp_ports[1].lcp_epd.NegNotReqd = 1 ;
	ppp_ptr->ppp_ports[1].lcp_epd.Negotiable = 0 ;
	ppp_ptr->ppp_ports[1].lcp_epd.value_type = change_endian_enum (H7) ;
	ppp_ptr->ppp_ports[1].lcp_epd.valid = 0 ;
	strcpy ((char *)ppp_ptr->ppp_ports[1].lcp_epd.option_value, "03000000000000") ;

	ppp_ptr->ppp_ports[1].remote_lcp_epd.option_type = 19 ;
	ppp_ptr->ppp_ports[1].remote_lcp_epd.Auto = 1 ;
	ppp_ptr->ppp_ports[1].remote_lcp_epd.NegNotReqd = 1 ;
	ppp_ptr->ppp_ports[1].remote_lcp_epd.Negotiable = 1 ;
	ppp_ptr->ppp_ports[1].remote_lcp_epd.value_type = change_endian_enum (H7) ;
	ppp_ptr->ppp_ports[1].remote_lcp_epd.valid = 0 ; 
	strcpy ((char *)ppp_ptr->ppp_ports[1].remote_lcp_epd.option_value, "03000000000000") ;

	ppp_ptr->ppp_ports[1].lcp_mrru.option_type = 17 ;
	ppp_ptr->ppp_ports[1].lcp_mrru.Auto = 1 ;
	ppp_ptr->ppp_ports[1].lcp_mrru.NegNotReqd = 1 ;
	ppp_ptr->ppp_ports[1].lcp_mrru.Negotiable = 1 ;
	ppp_ptr->ppp_ports[1].lcp_mrru.value_type = change_endian_enum (D2) ;
	ppp_ptr->ppp_ports[1].lcp_mrru.valid = 1 ;
   strcpy ((char *)ppp_ptr->ppp_ports[1].lcp_mrru.option_value, "1534") ;

	ppp_ptr->ppp_ports[1].remote_lcp_mrru.option_type = 17 ;
	ppp_ptr->ppp_ports[1].remote_lcp_mrru.Auto = 1 ;
	ppp_ptr->ppp_ports[1].remote_lcp_mrru.NegNotReqd = 1 ;
	ppp_ptr->ppp_ports[1].remote_lcp_mrru.Negotiable = 1 ;
	ppp_ptr->ppp_ports[1].remote_lcp_mrru.value_type = change_endian_enum (D2) ;
	ppp_ptr->ppp_ports[1].remote_lcp_mrru.valid = 1 ;
   strcpy ((char *)ppp_ptr->ppp_ports[1].remote_lcp_mrru.option_value, "1534") ;

  	ppp_ptr->ppp_ports[1].remote_lcp_callback.option_type = 13 ;
	ppp_ptr->ppp_ports[1].remote_lcp_callback.Auto = 1 ;
	ppp_ptr->ppp_ports[1].remote_lcp_callback.NegNotReqd = 1 ;
	ppp_ptr->ppp_ports[1].remote_lcp_callback.Negotiable = 1 ;
	ppp_ptr->ppp_ports[1].remote_lcp_callback.value_type = change_endian_enum (H1) ;
	ppp_ptr->ppp_ports[1].remote_lcp_callback.valid = 1 ;
	strcpy ((char *)ppp_ptr->ppp_ports[1].remote_lcp_callback.option_value, "00") ;

	ppp_ptr->ppp_ports[1].ipcp_dns_address1.option_type = 129 ;
	ppp_ptr->ppp_ports[1].ipcp_dns_address1.Auto = 1 ;
	ppp_ptr->ppp_ports[1].ipcp_dns_address1.NegNotReqd = 1 ;
	ppp_ptr->ppp_ports[1].ipcp_dns_address1.Negotiable = 1 ;
	ppp_ptr->ppp_ports[1].ipcp_dns_address1.value_type = change_endian_enum (IP) ;
	ppp_ptr->ppp_ports[1].ipcp_dns_address1.valid = 0 ;
	strcpy ((char *)ppp_ptr->ppp_ports[1].ipcp_dns_address1.option_value, "0.0.0.0") ;

	ppp_ptr->ppp_ports[1].ipcp_dns_address2.option_type = 131 ;
	ppp_ptr->ppp_ports[1].ipcp_dns_address2.Auto = 1 ;
	ppp_ptr->ppp_ports[1].ipcp_dns_address2.NegNotReqd = 1 ;
	ppp_ptr->ppp_ports[1].ipcp_dns_address2.Negotiable = 1 ;
	ppp_ptr->ppp_ports[1].ipcp_dns_address2.value_type = change_endian_enum (IP) ;
	ppp_ptr->ppp_ports[1].ipcp_dns_address2.valid = 0 ;
	strcpy ((char *)ppp_ptr->ppp_ports[1].ipcp_dns_address2.option_value, "0.0.0.0") ;

/* RAS strings */

	ppp_ptr->ppp_ports[1].ras_remote_ipcp_dns_address1.option_type = 129 ;
	ppp_ptr->ppp_ports[1].ras_remote_ipcp_dns_address1.Auto = 1 ;
	ppp_ptr->ppp_ports[1].ras_remote_ipcp_dns_address1.NegNotReqd = 1 ;
	ppp_ptr->ppp_ports[1].ras_remote_ipcp_dns_address1.Negotiable = 0 ;
	ppp_ptr->ppp_ports[1].ras_remote_ipcp_dns_address1.value_type = change_endian_enum (IP) ;
	ppp_ptr->ppp_ports[1].ras_remote_ipcp_dns_address1.valid = 0 ;
	strcpy ((char *)ppp_ptr->ppp_ports[1].ras_remote_ipcp_dns_address1.option_value, "0.0.0.0") ;

	ppp_ptr->ppp_ports[1].ras_remote_ipcp_dns_address2.option_type = 131 ;
	ppp_ptr->ppp_ports[1].ras_remote_ipcp_dns_address2.Auto = 1 ;
	ppp_ptr->ppp_ports[1].ras_remote_ipcp_dns_address2.NegNotReqd = 1 ;
	ppp_ptr->ppp_ports[1].ras_remote_ipcp_dns_address2.Negotiable = 0 ;
	ppp_ptr->ppp_ports[1].ras_remote_ipcp_dns_address2.value_type = change_endian_enum (IP) ;
	ppp_ptr->ppp_ports[1].ras_remote_ipcp_dns_address2.valid = 0 ;
	strcpy ((char *)ppp_ptr->ppp_ports[1].ras_remote_ipcp_dns_address2.option_value, "0.0.0.0") ;

	ppp_ptr->ppp_ports[1].ras_lcp_authentication.option_type = 3 ;
	ppp_ptr->ppp_ports[1].ras_lcp_authentication.Auto = 1 ;
	ppp_ptr->ppp_ports[1].ras_lcp_authentication.NegNotReqd = 1 ;
   ppp_ptr->ppp_ports[1].ras_lcp_authentication.Negotiable = 0 ;
	ppp_ptr->ppp_ports[1].ras_lcp_authentication.value_type = change_endian_enum (H2) ;
	ppp_ptr->ppp_ports[1].ras_lcp_authentication.valid = 1 ;
	strcpy (ppp_ptr->ppp_ports[1].ras_lcp_authentication.option_value, "c023") ;

	ppp_ptr->ppp_ports[1].ras_ipcp_ip_address.option_type = 3 ;
	ppp_ptr->ppp_ports[1].ras_ipcp_ip_address.Auto = 1 ;
	ppp_ptr->ppp_ports[1].ras_ipcp_ip_address.NegNotReqd = 1 ;
	ppp_ptr->ppp_ports[1].ras_ipcp_ip_address.Negotiable = 1 ;
	ppp_ptr->ppp_ports[1].ras_ipcp_ip_address.value_type = change_endian_enum (IP) ;
	ppp_ptr->ppp_ports[1].ras_ipcp_ip_address.valid = 0 ;
	strcpy (ppp_ptr->ppp_ports[1].ras_ipcp_ip_address.option_value, "0.0.0.0") ;

	ppp_ptr->ppp_ports[1].ras_remote_ipcp_ip_address.option_type = 3 ;
	ppp_ptr->ppp_ports[1].ras_remote_ipcp_ip_address.Auto = 1 ;
	ppp_ptr->ppp_ports[1].ras_remote_ipcp_ip_address.NegNotReqd = 1 ;
	ppp_ptr->ppp_ports[1].ras_remote_ipcp_ip_address.Negotiable = 1 ;
	ppp_ptr->ppp_ports[1].ras_remote_ipcp_ip_address.value_type = change_endian_enum (IP) ;
	ppp_ptr->ppp_ports[1].ras_remote_ipcp_ip_address.valid = 0 ;
	strcpy (ppp_ptr->ppp_ports[1].ras_remote_ipcp_ip_address.option_value, "0.0.0.0") ;

	ppp_ptr->ppp_ports[2].enabled = 1 ;
	strcpy ((char *)ppp_ptr->ppp_ports[2].user_name, "") ;
	strcpy ((char *)ppp_ptr->ppp_ports[2].user_password, "") ;
	ppp_ptr->ppp_ports[2].connection_dod = 1 ;
	ppp_ptr->ppp_ports[2].hangup_time = change_endian (600) ;
	ppp_ptr->ppp_ports[2].ip = 1 ;
   ppp_ptr->ppp_ports[2].authentication_type = 2 ; 
   ppp_ptr->ppp_ports[2].remote_port_client_only = 0 ;

	ppp_ptr->ppp_ports[2].lcp_accm.option_type = 2 ;
	ppp_ptr->ppp_ports[2].lcp_accm.Auto = 1 ;
	ppp_ptr->ppp_ports[2].lcp_accm.NegNotReqd = 1 ;
	ppp_ptr->ppp_ports[2].lcp_accm.Negotiable = 1 ;
	ppp_ptr->ppp_ports[2].lcp_accm.value_type = change_endian_enum (H4S) ;
	ppp_ptr->ppp_ports[2].lcp_accm.valid = 1 ;
	strcpy (ppp_ptr->ppp_ports[2].lcp_accm.option_value, "000A0000") ;
	ppp_ptr->ppp_ports[2].remote_lcp_accm.option_type = 2 ;
	ppp_ptr->ppp_ports[2].remote_lcp_accm.Auto = 1 ;
	ppp_ptr->ppp_ports[2].remote_lcp_accm.NegNotReqd = 1 ;
	ppp_ptr->ppp_ports[2].remote_lcp_accm.Negotiable = 1 ;
	ppp_ptr->ppp_ports[2].remote_lcp_accm.value_type = change_endian_enum (H4) ;
	ppp_ptr->ppp_ports[2].remote_lcp_accm.valid = 1 ;
	strcpy (ppp_ptr->ppp_ports[2].remote_lcp_accm.option_value, "00000000") ;

	ppp_ptr->ppp_ports[2].lcp_mru.option_type = 1 ;
	ppp_ptr->ppp_ports[2].lcp_mru.Auto = 1 ;
	ppp_ptr->ppp_ports[2].lcp_mru.NegNotReqd = 1 ;
	ppp_ptr->ppp_ports[2].lcp_mru.Negotiable = 1 ;
	ppp_ptr->ppp_ports[2].lcp_mru.value_type = change_endian_enum (D2) ;
	ppp_ptr->ppp_ports[2].lcp_mru.valid = 1 ;
	strcpy (ppp_ptr->ppp_ports[2].lcp_mru.option_value, "1534") ;
	ppp_ptr->ppp_ports[2].remote_lcp_mru.option_type = 1 ;
	ppp_ptr->ppp_ports[2].remote_lcp_mru.Auto = 1 ;
	ppp_ptr->ppp_ports[2].remote_lcp_mru.NegNotReqd = 1 ;
	ppp_ptr->ppp_ports[2].remote_lcp_mru.Negotiable = 1 ;
	ppp_ptr->ppp_ports[2].remote_lcp_mru.value_type = change_endian_enum (D2) ;
	ppp_ptr->ppp_ports[2].remote_lcp_mru.valid = 1 ;
	strcpy (ppp_ptr->ppp_ports[2].remote_lcp_mru.option_value, "1534") ;

	ppp_ptr->ppp_ports[2].remote_lcp_authentication.option_type = 3 ;
	ppp_ptr->ppp_ports[2].remote_lcp_authentication.Auto = 1 ;
	ppp_ptr->ppp_ports[2].remote_lcp_authentication.NegNotReqd = 1 ;
	ppp_ptr->ppp_ports[2].remote_lcp_authentication.Negotiable = 1 ;
	ppp_ptr->ppp_ports[2].remote_lcp_authentication.value_type = change_endian_enum (H2) ;
	ppp_ptr->ppp_ports[2].remote_lcp_authentication.valid = 1 ;
	strcpy (ppp_ptr->ppp_ports[2].remote_lcp_authentication.option_value, "c023") ;

	ppp_ptr->ppp_ports[2].lcp_magic_number.option_type = 5 ;
	ppp_ptr->ppp_ports[2].lcp_magic_number.Auto = 1 ;
	ppp_ptr->ppp_ports[2].lcp_magic_number.NegNotReqd = 1 ;
	ppp_ptr->ppp_ports[2].lcp_magic_number.Negotiable = 1 ;
	ppp_ptr->ppp_ports[2].lcp_magic_number.value_type = change_endian_enum (H4) ;
	ppp_ptr->ppp_ports[2].lcp_magic_number.valid = 1 ;
	strcpy (ppp_ptr->ppp_ports[2].lcp_magic_number.option_value, "00000000") ;
	ppp_ptr->ppp_ports[2].remote_lcp_magic_number.option_type = 5 ;
	ppp_ptr->ppp_ports[2].remote_lcp_magic_number.Auto = 1 ;
	ppp_ptr->ppp_ports[2].remote_lcp_magic_number.NegNotReqd = 1 ;
	ppp_ptr->ppp_ports[2].remote_lcp_magic_number.Negotiable = 1 ;
	ppp_ptr->ppp_ports[2].remote_lcp_magic_number.value_type = change_endian_enum (H4) ;
	ppp_ptr->ppp_ports[2].remote_lcp_magic_number.valid = 1 ;
	strcpy (ppp_ptr->ppp_ports[2].remote_lcp_magic_number.option_value, "00000000") ;

	ppp_ptr->ppp_ports[2].ipcp_ip_address.option_type = 3 ;
	ppp_ptr->ppp_ports[2].ipcp_ip_address.Auto = 1 ;
	ppp_ptr->ppp_ports[2].ipcp_ip_address.NegNotReqd = 1 ;
	ppp_ptr->ppp_ports[2].ipcp_ip_address.Negotiable = 1 ;
	ppp_ptr->ppp_ports[2].ipcp_ip_address.value_type = change_endian_enum (IP) ;
	ppp_ptr->ppp_ports[2].ipcp_ip_address.valid = 1 ;
	strcpy ((char *)ppp_ptr->ppp_ports[2].ipcp_ip_address.option_value, "0.0.0.0") ;
	ppp_ptr->ppp_ports[2].remote_ipcp_ip_address.option_type = 3 ;
	ppp_ptr->ppp_ports[2].remote_ipcp_ip_address.Auto = 1 ;
	ppp_ptr->ppp_ports[2].remote_ipcp_ip_address.NegNotReqd = 1 ;
	ppp_ptr->ppp_ports[2].remote_ipcp_ip_address.Negotiable = 1 ;
	ppp_ptr->ppp_ports[2].remote_ipcp_ip_address.value_type = change_endian_enum (IP) ;
	ppp_ptr->ppp_ports[2].remote_ipcp_ip_address.valid = 1 ;
	strcpy ((char *)ppp_ptr->ppp_ports[2].remote_ipcp_ip_address.option_value, "0.0.0.0") ;

  	ppp_ptr->ppp_ports[2].lcp_epd.option_type = 19 ;
	ppp_ptr->ppp_ports[2].lcp_epd.Auto = 1 ;
	ppp_ptr->ppp_ports[2].lcp_epd.NegNotReqd = 1 ;
	ppp_ptr->ppp_ports[2].lcp_epd.Negotiable = 0 ;
	ppp_ptr->ppp_ports[2].lcp_epd.value_type = change_endian_enum (H7) ;
	ppp_ptr->ppp_ports[2].lcp_epd.valid = 0 ;
	strcpy ((char *)ppp_ptr->ppp_ports[2].lcp_epd.option_value, "03000000000000") ;

	ppp_ptr->ppp_ports[2].remote_lcp_epd.option_type = 19 ;
	ppp_ptr->ppp_ports[2].remote_lcp_epd.Auto = 1 ;
	ppp_ptr->ppp_ports[2].remote_lcp_epd.NegNotReqd = 1 ;
	ppp_ptr->ppp_ports[2].remote_lcp_epd.Negotiable = 1 ;
	ppp_ptr->ppp_ports[2].remote_lcp_epd.value_type = change_endian_enum (H7) ;
	ppp_ptr->ppp_ports[2].remote_lcp_epd.valid = 0 ;
	strcpy ((char *)ppp_ptr->ppp_ports[2].remote_lcp_epd.option_value, "03000000000000") ;

	ppp_ptr->ppp_ports[2].lcp_mrru.option_type = 17 ;
	ppp_ptr->ppp_ports[2].lcp_mrru.Auto = 1 ;
	ppp_ptr->ppp_ports[2].lcp_mrru.NegNotReqd = 1 ;
	ppp_ptr->ppp_ports[2].lcp_mrru.Negotiable = 1 ;
	ppp_ptr->ppp_ports[2].lcp_mrru.value_type = change_endian_enum (D2) ;
	ppp_ptr->ppp_ports[2].lcp_mrru.valid = 1 ;
   strcpy ((char *)ppp_ptr->ppp_ports[2].lcp_mrru.option_value, "1534") ;

	ppp_ptr->ppp_ports[2].remote_lcp_mrru.option_type = 17 ;
	ppp_ptr->ppp_ports[2].remote_lcp_mrru.Auto = 1 ;
	ppp_ptr->ppp_ports[2].remote_lcp_mrru.NegNotReqd = 1 ;
	ppp_ptr->ppp_ports[2].remote_lcp_mrru.Negotiable = 1 ;
	ppp_ptr->ppp_ports[2].remote_lcp_mrru.value_type = change_endian_enum (D2) ;
	ppp_ptr->ppp_ports[2].remote_lcp_mrru.valid = 1 ;
   strcpy ((char *)ppp_ptr->ppp_ports[2].remote_lcp_mrru.option_value, "1534") ;

  	ppp_ptr->ppp_ports[2].remote_lcp_callback.option_type = 13 ;
	ppp_ptr->ppp_ports[2].remote_lcp_callback.Auto = 1 ;
	ppp_ptr->ppp_ports[2].remote_lcp_callback.NegNotReqd = 1 ;
	ppp_ptr->ppp_ports[2].remote_lcp_callback.Negotiable = 1 ;
	ppp_ptr->ppp_ports[2].remote_lcp_callback.value_type = change_endian_enum (H1) ;
	ppp_ptr->ppp_ports[2].remote_lcp_callback.valid = 1 ;
	strcpy ((char *)ppp_ptr->ppp_ports[2].remote_lcp_callback.option_value, "00") ;

	ppp_ptr->ppp_ports[2].ipcp_dns_address1.option_type = 129 ;
	ppp_ptr->ppp_ports[2].ipcp_dns_address1.Auto = 1 ;
	ppp_ptr->ppp_ports[2].ipcp_dns_address1.NegNotReqd = 1 ;
	ppp_ptr->ppp_ports[2].ipcp_dns_address1.Negotiable = 1 ;
	ppp_ptr->ppp_ports[2].ipcp_dns_address1.value_type = change_endian_enum (IP) ;
	ppp_ptr->ppp_ports[2].ipcp_dns_address1.valid = 0 ;
	strcpy ((char *)ppp_ptr->ppp_ports[2].ipcp_dns_address1.option_value, "0.0.0.0") ;

	ppp_ptr->ppp_ports[2].ipcp_dns_address2.option_type = 131 ;
	ppp_ptr->ppp_ports[2].ipcp_dns_address2.Auto = 1 ;
	ppp_ptr->ppp_ports[2].ipcp_dns_address2.NegNotReqd = 1 ;
	ppp_ptr->ppp_ports[2].ipcp_dns_address2.Negotiable = 1 ;
	ppp_ptr->ppp_ports[2].ipcp_dns_address2.value_type = change_endian_enum (IP) ;
	ppp_ptr->ppp_ports[2].ipcp_dns_address2.valid = 0 ;
	strcpy ((char *)ppp_ptr->ppp_ports[2].ipcp_dns_address2.option_value, "0.0.0.0") ;

/* RAS strings */

	ppp_ptr->ppp_ports[2].ras_remote_ipcp_dns_address1.option_type = 129 ;
	ppp_ptr->ppp_ports[2].ras_remote_ipcp_dns_address1.Auto = 1 ;
	ppp_ptr->ppp_ports[2].ras_remote_ipcp_dns_address1.NegNotReqd = 1 ;
	ppp_ptr->ppp_ports[2].ras_remote_ipcp_dns_address1.Negotiable = 0 ;
	ppp_ptr->ppp_ports[2].ras_remote_ipcp_dns_address1.value_type = change_endian_enum (IP) ;
	ppp_ptr->ppp_ports[2].ras_remote_ipcp_dns_address1.valid = 0 ;
	strcpy ((char *)ppp_ptr->ppp_ports[2].ras_remote_ipcp_dns_address1.option_value, "0.0.0.0") ;

	ppp_ptr->ppp_ports[2].ras_remote_ipcp_dns_address2.option_type = 131 ;
	ppp_ptr->ppp_ports[2].ras_remote_ipcp_dns_address2.Auto = 1 ;
	ppp_ptr->ppp_ports[2].ras_remote_ipcp_dns_address2.NegNotReqd = 1 ;
	ppp_ptr->ppp_ports[2].ras_remote_ipcp_dns_address2.Negotiable = 0 ;
	ppp_ptr->ppp_ports[2].ras_remote_ipcp_dns_address2.value_type = change_endian_enum (IP) ;
	ppp_ptr->ppp_ports[2].ras_remote_ipcp_dns_address2.valid = 0 ;
	strcpy ((char *)ppp_ptr->ppp_ports[2].ras_remote_ipcp_dns_address2.option_value, "0.0.0.0") ;

	ppp_ptr->ppp_ports[2].ras_lcp_authentication.option_type = 3 ;
	ppp_ptr->ppp_ports[2].ras_lcp_authentication.Auto = 1 ;
	ppp_ptr->ppp_ports[2].ras_lcp_authentication.NegNotReqd = 1 ;
   ppp_ptr->ppp_ports[2].ras_lcp_authentication.Negotiable = 0 ;
	ppp_ptr->ppp_ports[2].ras_lcp_authentication.value_type = change_endian_enum (H2) ;
	ppp_ptr->ppp_ports[2].ras_lcp_authentication.valid = 1 ;
	strcpy (ppp_ptr->ppp_ports[2].ras_lcp_authentication.option_value, "c023") ;

	ppp_ptr->ppp_ports[2].ras_ipcp_ip_address.option_type = 3 ;
	ppp_ptr->ppp_ports[2].ras_ipcp_ip_address.Auto = 1 ;
	ppp_ptr->ppp_ports[2].ras_ipcp_ip_address.NegNotReqd = 1 ;
	ppp_ptr->ppp_ports[2].ras_ipcp_ip_address.Negotiable = 1 ;
	ppp_ptr->ppp_ports[2].ras_ipcp_ip_address.value_type = change_endian_enum (IP) ;
	ppp_ptr->ppp_ports[2].ras_ipcp_ip_address.valid = 0 ;
	strcpy (ppp_ptr->ppp_ports[2].ras_ipcp_ip_address.option_value, "0.0.0.0") ;

	ppp_ptr->ppp_ports[2].ras_remote_ipcp_ip_address.option_type = 3 ;
	ppp_ptr->ppp_ports[2].ras_remote_ipcp_ip_address.Auto = 1 ;
	ppp_ptr->ppp_ports[2].ras_remote_ipcp_ip_address.NegNotReqd = 1 ;
	ppp_ptr->ppp_ports[2].ras_remote_ipcp_ip_address.Negotiable = 1 ;
	ppp_ptr->ppp_ports[2].ras_remote_ipcp_ip_address.value_type = change_endian_enum (IP) ;
	ppp_ptr->ppp_ports[2].ras_remote_ipcp_ip_address.valid = 0 ;
	strcpy (ppp_ptr->ppp_ports[2].ras_remote_ipcp_ip_address.option_value, "0.0.0.0") ;

	proxy_header_ptr->magic_number = change_endian (CNF_PROXY_MAGIC_NUMBER) ;
	proxy_header_ptr->section_length = change_endian (444) ;
	proxy_header_ptr->number_of_ports = change_endian (4) ;
	proxy_header_ptr->enabled = 1 ;
   proxy_header_ptr->proxy_any_app = 0 ;
   proxy_header_ptr->ftp_control_port = change_endian (21) ;
   proxy_header_ptr->ftp_data_port = change_endian (20) ;
	
	proxy_application_ptr->number_of_application_entries = change_endian (NUMBER_OF_APPLICATION_ENTRIES) ;
	proxy_user_defined_application_ptr->number_of_user_defined_application_entries = 0 ;
	proxy_application_ptr->application_entries[0].port = 	change_endian (531) ; 
   proxy_application_ptr->application_entries[0].protocol = change_endian (6) ;
	proxy_application_ptr->application_entries[1].port = 	change_endian (53) ;	
   proxy_application_ptr->application_entries[1].protocol = change_endian (6) ;
	proxy_application_ptr->application_entries[2].port = 	change_endian (7) ;	
   proxy_application_ptr->application_entries[2].protocol = change_endian (6) ;
	proxy_application_ptr->application_entries[3].port = 	change_endian (79) ;	 
   proxy_application_ptr->application_entries[3].protocol = change_endian (6) ;
	proxy_application_ptr->application_entries[4].port = 	change_endian (20) ;	 
   proxy_application_ptr->application_entries[4].protocol = change_endian (6) ;
	proxy_application_ptr->application_entries[5].port = 	change_endian (21) ;	 
   proxy_application_ptr->application_entries[5].protocol = change_endian (6) ;
	proxy_application_ptr->application_entries[6].port = 	change_endian (70) ;	 
   proxy_application_ptr->application_entries[6].protocol = change_endian (6) ;
	proxy_application_ptr->application_entries[7].port = 	change_endian (443) ;
   proxy_application_ptr->application_entries[7].protocol = change_endian (6) ;
	proxy_application_ptr->application_entries[8].port = 	change_endian (143) ;
   proxy_application_ptr->application_entries[8].protocol = change_endian (6) ;
	proxy_application_ptr->application_entries[9].port = 	change_endian (220) ;
   proxy_application_ptr->application_entries[9].protocol = change_endian (6) ;
	proxy_application_ptr->application_entries[10].port = 	change_endian (194) ;  
   proxy_application_ptr->application_entries[10].protocol = change_endian (6) ;
	proxy_application_ptr->application_entries[11].port = 	change_endian (6667) ;
   proxy_application_ptr->application_entries[11].protocol = change_endian (6) ;
	proxy_application_ptr->application_entries[12].port = 	change_endian (1755) ;
   proxy_application_ptr->application_entries[12].protocol = change_endian (6) ;
	proxy_application_ptr->application_entries[13].port = 	change_endian (42) ;	 
   proxy_application_ptr->application_entries[13].protocol = change_endian (6) ;
	proxy_application_ptr->application_entries[14].port = 	change_endian (144) ;  
   proxy_application_ptr->application_entries[14].protocol = change_endian (6) ;
	proxy_application_ptr->application_entries[15].port = 	change_endian (119) ;  
   proxy_application_ptr->application_entries[15].protocol = change_endian (6) ;
	proxy_application_ptr->application_entries[16].port = 	change_endian (110) ;  
   proxy_application_ptr->application_entries[16].protocol = change_endian (6) ;
	proxy_application_ptr->application_entries[17].port = 	change_endian (1723) ;
   proxy_application_ptr->application_entries[17].protocol = change_endian (6) ;
	proxy_application_ptr->application_entries[18].port = 	change_endian (532) ; 
   proxy_application_ptr->application_entries[18].protocol = change_endian (6) ;
	proxy_application_ptr->application_entries[19].port = 	change_endian (1090) ;
   proxy_application_ptr->application_entries[19].protocol = change_endian (6) ;
	proxy_application_ptr->application_entries[20].port = 	change_endian (7070) ;
   proxy_application_ptr->application_entries[20].protocol = change_endian (6) ;
	proxy_application_ptr->application_entries[21].port = 	change_endian (513) ;  
   proxy_application_ptr->application_entries[21].protocol = change_endian (6) ;
	proxy_application_ptr->application_entries[22].port = 	change_endian (25) ;	 
   proxy_application_ptr->application_entries[22].protocol = change_endian (6) ;
	proxy_application_ptr->application_entries[23].port = 	change_endian (161) ;
   proxy_application_ptr->application_entries[23].protocol = change_endian (6) ;
	proxy_application_ptr->application_entries[24].port = 	change_endian (162) ;
   proxy_application_ptr->application_entries[24].protocol = change_endian (6) ;
	proxy_application_ptr->application_entries[25].port = 	change_endian (989) ;
   proxy_application_ptr->application_entries[25].protocol = change_endian (6) ;
	proxy_application_ptr->application_entries[26].port = 	change_endian (990) ;
   proxy_application_ptr->application_entries[26].protocol = change_endian (6) ;
	proxy_application_ptr->application_entries[27].port = 	change_endian (993) ;
   proxy_application_ptr->application_entries[27].protocol = change_endian (6) ;
	proxy_application_ptr->application_entries[28].port = 	change_endian (994) ;
   proxy_application_ptr->application_entries[28].protocol = change_endian (6) ;
	proxy_application_ptr->application_entries[29].port = 	change_endian (563) ;
   proxy_application_ptr->application_entries[29].protocol = change_endian (6) ;
	proxy_application_ptr->application_entries[30].port = 	change_endian (995) ;
   proxy_application_ptr->application_entries[30].protocol = change_endian (6) ;
	proxy_application_ptr->application_entries[31].port = 	change_endian (465) ;
   proxy_application_ptr->application_entries[31].protocol = change_endian (6) ;
	proxy_application_ptr->application_entries[32].port = 	change_endian (992) ;
   proxy_application_ptr->application_entries[32].protocol = change_endian (6) ;
	proxy_application_ptr->application_entries[33].port = 	change_endian (23) ;	  
   proxy_application_ptr->application_entries[33].protocol = change_endian (6) ;
	proxy_application_ptr->application_entries[34].port = 	change_endian (69) ;	  
   proxy_application_ptr->application_entries[34].protocol = change_endian (6) ;
	proxy_application_ptr->application_entries[35].port = 	change_endian (8000) ;
   proxy_application_ptr->application_entries[35].protocol = change_endian (6) ;
	proxy_application_ptr->application_entries[36].port = 	change_endian (80) ;	 
   proxy_application_ptr->application_entries[36].protocol = change_endian (6) ;
	proxy_application_ptr->application_entries[37].port = 	change_endian (5190) ;
   proxy_application_ptr->application_entries[37].protocol = change_endian (6) ;
	proxy_application_ptr->application_entries[38].port = 	change_endian (900) ;
   proxy_application_ptr->application_entries[38].protocol = change_endian (6) ;
	proxy_application_ptr->application_entries[39].port = 	change_endian (902) ;
   proxy_application_ptr->application_entries[39].protocol = change_endian (6) ;
	proxy_application_ptr->application_entries[40].port = 	change_endian (5004) ;
   proxy_application_ptr->application_entries[40].protocol = change_endian (6) ;
	proxy_application_ptr->application_entries[41].port = 	change_endian (5006) ;
   proxy_application_ptr->application_entries[41].protocol = change_endian (6) ;
	proxy_application_ptr->application_entries[42].port = 	change_endian (5005) ;
   proxy_application_ptr->application_entries[42].protocol = change_endian (6) ;
	proxy_application_ptr->application_entries[43].port = 	change_endian (5007) ;
   proxy_application_ptr->application_entries[43].protocol = change_endian (6) ;
	proxy_application_ptr->application_entries[44].port = 	change_endian (5000) ;
   proxy_application_ptr->application_entries[44].protocol = change_endian (6) ;
	proxy_application_ptr->application_entries[45].port = 	change_endian (6284) ;
   proxy_application_ptr->application_entries[45].protocol = change_endian (6) ;
	proxy_application_ptr->application_entries[46].port = 	change_endian (6285) ;
   proxy_application_ptr->application_entries[46].protocol = change_endian (6) ;
	proxy_application_ptr->application_entries[47].port = 	change_endian (7283) ;
   proxy_application_ptr->application_entries[47].protocol = change_endian (6) ;


	proxy_application_ptr->application_entries[48].port = 	change_endian (531) ;
   proxy_application_ptr->application_entries[48].protocol = change_endian (17) ;
	proxy_application_ptr->application_entries[49].port = 	change_endian (53) ;
   proxy_application_ptr->application_entries[49].protocol = change_endian (17) ;
	proxy_application_ptr->application_entries[50].port = 	change_endian (7) ;
   proxy_application_ptr->application_entries[50].protocol = change_endian (17) ;
	proxy_application_ptr->application_entries[51].port = 	change_endian (79) ;
   proxy_application_ptr->application_entries[51].protocol = change_endian (17) ;
	proxy_application_ptr->application_entries[52].port = 	change_endian (20) ;
   proxy_application_ptr->application_entries[52].protocol = change_endian (17) ;
	proxy_application_ptr->application_entries[53].port = 	change_endian (21) ;
   proxy_application_ptr->application_entries[53].protocol = change_endian (17) ;
	proxy_application_ptr->application_entries[54].port = 	change_endian (70) ;
   proxy_application_ptr->application_entries[54].protocol = change_endian (17) ;
	proxy_application_ptr->application_entries[55].port = 	change_endian (443) ;
   proxy_application_ptr->application_entries[55].protocol = change_endian (17) ;
	proxy_application_ptr->application_entries[56].port = 	change_endian (143) ;
   proxy_application_ptr->application_entries[56].protocol = change_endian (17) ;
	proxy_application_ptr->application_entries[57].port = 	change_endian (220) ;
   proxy_application_ptr->application_entries[57].protocol = change_endian (17) ;
	proxy_application_ptr->application_entries[58].port = 	change_endian (194) ;
   proxy_application_ptr->application_entries[58].protocol = change_endian (17) ;
	proxy_application_ptr->application_entries[59].port = 	change_endian (6667) ;
   proxy_application_ptr->application_entries[59].protocol = change_endian (17) ;
	proxy_application_ptr->application_entries[60].port = 	change_endian (1755) ;
   proxy_application_ptr->application_entries[60].protocol = change_endian (17) ;
	proxy_application_ptr->application_entries[61].port = 	change_endian (42) ;
   proxy_application_ptr->application_entries[61].protocol = change_endian (17) ;
	proxy_application_ptr->application_entries[62].port = 	change_endian (144) ;
   proxy_application_ptr->application_entries[62].protocol = change_endian (17) ;
	proxy_application_ptr->application_entries[63].port = 	change_endian (119) ;
   proxy_application_ptr->application_entries[63].protocol = change_endian (17) ;
	proxy_application_ptr->application_entries[64].port = 	change_endian (110) ;
   proxy_application_ptr->application_entries[64].protocol = change_endian (17) ;
	proxy_application_ptr->application_entries[65].port = 	change_endian (1723) ;
   proxy_application_ptr->application_entries[65].protocol = change_endian (17) ;
	proxy_application_ptr->application_entries[66].port = 	change_endian (532) ;
   proxy_application_ptr->application_entries[66].protocol = change_endian (17) ;
	proxy_application_ptr->application_entries[67].port = 	change_endian (1090) ;
   proxy_application_ptr->application_entries[67].protocol = change_endian (17) ;
	proxy_application_ptr->application_entries[68].port = 	change_endian (7070) ;
   proxy_application_ptr->application_entries[68].protocol = change_endian (17) ;
	proxy_application_ptr->application_entries[69].port = 	change_endian (25) ;
   proxy_application_ptr->application_entries[69].protocol = change_endian (17) ;
	proxy_application_ptr->application_entries[70].port = 	change_endian (161) ;
   proxy_application_ptr->application_entries[70].protocol = change_endian (17) ;
	proxy_application_ptr->application_entries[71].port = 	change_endian (162) ;
   proxy_application_ptr->application_entries[71].protocol = change_endian (17) ;
	proxy_application_ptr->application_entries[72].port = 	change_endian (989) ;
   proxy_application_ptr->application_entries[72].protocol = change_endian (17) ;
	proxy_application_ptr->application_entries[73].port = 	change_endian (990) ;
   proxy_application_ptr->application_entries[73].protocol = change_endian (17) ;
	proxy_application_ptr->application_entries[74].port = 	change_endian (993) ;
   proxy_application_ptr->application_entries[74].protocol = change_endian (17) ;
	proxy_application_ptr->application_entries[75].port = 	change_endian (994) ;
   proxy_application_ptr->application_entries[75].protocol = change_endian (17) ;
	proxy_application_ptr->application_entries[76].port = 	change_endian (563) ;
   proxy_application_ptr->application_entries[76].protocol = change_endian (17) ;
	proxy_application_ptr->application_entries[77].port = 	change_endian (995) ;
   proxy_application_ptr->application_entries[77].protocol = change_endian (17) ;
	proxy_application_ptr->application_entries[78].port = 	change_endian (465) ;
   proxy_application_ptr->application_entries[78].protocol = change_endian (17) ;
	proxy_application_ptr->application_entries[79].port = 	change_endian (992) ;
   proxy_application_ptr->application_entries[79].protocol = change_endian (17) ;
	proxy_application_ptr->application_entries[80].port = 	change_endian (23) ;
   proxy_application_ptr->application_entries[80].protocol = change_endian (17) ;
	proxy_application_ptr->application_entries[81].port = 	change_endian (69) ;
   proxy_application_ptr->application_entries[81].protocol = change_endian (17) ;
	proxy_application_ptr->application_entries[82].port = 	change_endian (8000) ;
   proxy_application_ptr->application_entries[82].protocol = change_endian (17) ;
	proxy_application_ptr->application_entries[83].port = 	change_endian (80) ;
   proxy_application_ptr->application_entries[83].protocol = change_endian (17) ;
	proxy_application_ptr->application_entries[84].port = 	change_endian (5190) ;
   proxy_application_ptr->application_entries[84].protocol = change_endian (17) ;

	proxy_application_ptr->application_entries[85].port = 	change_endian (900) ;
   proxy_application_ptr->application_entries[85].protocol = change_endian (17) ;
	proxy_application_ptr->application_entries[86].port = 	change_endian (902) ;
   proxy_application_ptr->application_entries[86].protocol = change_endian (17) ;
	proxy_application_ptr->application_entries[87].port = 	change_endian (5004) ;
   proxy_application_ptr->application_entries[87].protocol = change_endian (17) ;
	proxy_application_ptr->application_entries[88].port = 	change_endian (5006) ;
   proxy_application_ptr->application_entries[88].protocol = change_endian (17) ;
	proxy_application_ptr->application_entries[89].port = 	change_endian (5005) ;
   proxy_application_ptr->application_entries[89].protocol = change_endian (17) ;
	proxy_application_ptr->application_entries[90].port = 	change_endian (5007) ;
   proxy_application_ptr->application_entries[90].protocol = change_endian (17) ;

	proxy_application_ptr->application_entries[91].port = 	change_endian (5000) ;
   proxy_application_ptr->application_entries[91].protocol = change_endian (17) ;
	proxy_application_ptr->application_entries[92].port = 	change_endian (6284) ;
   proxy_application_ptr->application_entries[92].protocol = change_endian (17) ;
	proxy_application_ptr->application_entries[93].port = 	change_endian (6285) ;
   proxy_application_ptr->application_entries[93].protocol = change_endian (17) ;
	proxy_application_ptr->application_entries[94].port = 	change_endian (7283) ;
   proxy_application_ptr->application_entries[94].protocol = change_endian (17) ;

	proxy_virtual_ptr->number_of_global_address_entries = 0 ;
	proxy_virtual_ptr->number_of_static_mapping_entries = 0 ;
	proxy_virtual_ptr->number_of_dynamic_mapping_entries = 0 ;
	proxy_virtual_ptr->dynamic_mapping_global_address = 0 ;

	proxy_filter_ptr->number_of_forbidden_sites_entries = 0 ;
	proxy_filter_ptr->number_of_restricted_clients_entries = 0 ;
	proxy_filter_ptr->number_of_restricted_application_entries = 0 ;
	proxy_filter_ptr->number_of_mac_address_entries = 0 ;
	proxy_filter_ptr->number_of_domain_name_entries = 0 ;

	proxy_ports_ptr->enabled = 1 ;
	proxy_ports_ptr->number_of_address_entries = 0 ;
	proxy_ports_ptr->number_of_connections_to_trigger = 0 ;
	proxy_ports_ptr->number_of_hosts_to_trigger = 0 ;

	dhcp_header_ptr->magic_number = change_endian (CNF_DHCP_MAGIC_NUMBER) ;
	dhcp_header_ptr->section_length = change_endian (164) ;
	dhcp_header_ptr->number_of_address_range_entries = change_endian (02) ;
	dhcp_header_ptr->dhcp_server_enabled = 1 ;
	dhcp_header_ptr->dhcp_client_enabled = 0 ;
	dhcp_header_ptr->dhcp_server_ip_address = 0 ;
	dhcp_address_range_ptr1->lower_ip_address = ltl_endian_word (0) ;
	dhcp_address_range_ptr1->higher_ip_address = ltl_endian_word (2147483648) ;
	dhcp_address_range_ptr1->address_mask = ltl_endian_word (4294967040) ;
	dhcp_address_range_ptr1->number_of_bindings_entries = 0 ;
	dhcp_address_range_ptr1->exclude_lower_ip_address = 0 ;
	dhcp_address_range_ptr1->exclude_higher_ip_address = 0 ;
	dhcp_options_ptr1->router_address = ltl_endian_word (0) ;
	dhcp_options_ptr1->lease_time = ltl_endian_word (65535) ;

	dhcp_address_range_ptr2->lower_ip_address = ltl_endian_word (3232235524) ;
	dhcp_address_range_ptr2->higher_ip_address = ltl_endian_word (3232235720) ;
	dhcp_address_range_ptr2->address_mask = ltl_endian_word (4294967040) ;
	dhcp_address_range_ptr2->number_of_bindings_entries = 0 ;
	dhcp_address_range_ptr2->exclude_lower_ip_address = 0 ;
	dhcp_address_range_ptr2->exclude_higher_ip_address = 0 ;
	dhcp_options_ptr2->router_address = ltl_endian_word (3232235521) ;
	dhcp_options_ptr2->lease_time = ltl_endian_word (65535) ;
	static_routes_header_ptr->magic_number = change_endian (CNF_STATIC_ROUTES_MAGIC_NUMBER) ;
	static_routes_header_ptr->section_length = change_endian (6) ;
	static_routes_header_ptr->number_of_static_routes = 0 ;

	dummy_value = change_endian ((USHORT)65535) ;

	cnt = fwrite ((void *)ip_ptr, sizeof(struct CNF_IP_STRUCT), 1, output) ;
	printf ("ipcnt : %d", cnt) ;
	cnt = fwrite ((void *) wan_ptr, sizeof(struct CNF_WAN_STRUCT), 1, output) ;
	printf ("wancnt : %d", cnt) ;
	cnt = fwrite ((void *)ppp_ptr, sizeof(struct CNF_PPP_STRUCT), 1, output) ;
	printf ("pppcnt : %d", cnt) ;
	cnt = fwrite ((void *)proxy_header_ptr, sizeof(struct CNF_PROXY_HEADER_STRUCT), 1, output) ;
	printf ("proxycnt : %d", cnt) ;
	length = sizeof(USHORT) + (NUMBER_OF_APPLICATION_ENTRIES * sizeof(struct CNF_PROXY_APP_STRUCT)) ;
	printf ("proxylength : %d", length) ;
	cnt = fwrite ((void *)proxy_application_ptr, length, 1, output) ;
	printf ("proxycnt : %d", cnt) ;
	length = 2 ;
	cnt = fwrite ((void *)proxy_user_defined_application_ptr, length, 1, output) ;
	printf ("proxyusercnt : %d", cnt) ;
	length = 10 ;
	cnt = fwrite ((void *)proxy_virtual_ptr, length, 1, output) ;
	printf ("proxycnt : %d", cnt) ;
	length = 10 ;
	cnt = fwrite ((void *)proxy_filter_ptr, length, 1, output) ;
	printf ("proxycnt : %d", cnt) ;
	length = 7 ;
	cnt = fwrite ((void *)proxy_ports_ptr, length, 1, output) ;
	printf ("proxycnt : %d", cnt) ;
	cnt = fwrite ((void *)proxy_ports_ptr, length, 1, output) ;
	printf ("proxycnt : %d", cnt) ;
	cnt = fwrite ((void *)proxy_ports_ptr, length, 1, output) ;
	printf ("proxycnt : %d", cnt) ;
	cnt = fwrite ((void *)proxy_ports_ptr, length, 1, output) ;
	printf ("proxycnt : %d", cnt) ;
	cnt = fwrite ((void *)dhcp_header_ptr, sizeof(struct CNF_DHCP_HEADER_STRUCT), 1, output) ;
	printf ("dhcp_header_cnt : %d", cnt) ;
	length = 22 ;
	cnt = fwrite ((void *)dhcp_address_range_ptr1, length, 1, output) ;
	printf ("dhcpaddrcnt : %d", cnt) ;
	length = 54 ;
	cnt = fwrite ((void *)dhcp_options_ptr1, length, 1, output) ;
	length = 22 ;
	cnt = fwrite ((void *)dhcp_address_range_ptr2, length, 1, output) ;
	printf ("dhcpaddrcnt : %d", cnt) ;
	length = 54 ;
	cnt = fwrite ((void *)dhcp_options_ptr2, length, 1, output) ;

	length = 6 ;
	cnt = fwrite ((void *)static_routes_header_ptr, length, 1, output) ;
	length = 2 ;
	cnt = fwrite ((void *)&dummy_value, length, 1, output) ;

	printf ("dhcpoptcnt : %d", cnt) ;

	printf("ip_size : %d\n", sizeof(struct CNF_IP_STRUCT)) ;
	printf("wan_size : %d\n", sizeof(struct CNF_WAN_STRUCT)) ;
	printf("ppp_size : %d\n", sizeof(struct CNF_PPP_STRUCT)) ;
	printf("proxy_size : %d\n", sizeof(struct CNF_PROXY_STRUCT)) ;
	fclose(output) ;												
	free (ip_ptr) ;
	free (wan_ptr) ;
	free (ppp_ptr) ;
	free (proxy_header_ptr) ;
	free (proxy_application_ptr) ;
	free (proxy_user_defined_application_ptr) ;
	free (proxy_virtual_ptr) ;
	free (proxy_filter_ptr) ;
	free (proxy_ports_ptr) ;
	free (dhcp_header_ptr) ;
	free (dhcp_address_range_ptr1) ;
	free (dhcp_options_ptr1) ;
	free (dhcp_address_range_ptr2) ;
	free (dhcp_options_ptr2) ;
	free (static_routes_header_ptr) ;
}

unsigned short change_endian (unsigned short num)
{
	unsigned short num2 ;
	unsigned char *str1, *str2 ;

	str1 = (unsigned char *) &num ;
	str2 = (unsigned char *) &num2 ;
	str2[0] = str1[1] ;
	str2[1] = str1[0] ;
	return num2 ;
}

DWORD ltl_endian_word (DWORD num)
{
	DWORD num2 ;
	BYTE *str ;
	BYTE *str2 ;
	str = (BYTE *) &num ;
	str2 = (BYTE *) &num2 ;
	if ((int) sizeof (num) == (int) 4)
	{
		str2[3] = str[0] ;
		str2[2] = str[1] ;
		str2[1] = str[2] ;
		str2[0] = str[3] ;
	}
	else
	{ 
		str2[0] = str[1] ;
		str2[1] = str[0] ;
	}
	return num2 ;
}

enum CNF_DATA_VALUE_DATA_TYPE change_endian_enum (enum CNF_DATA_VALUE_DATA_TYPE num)
{
	enum CNF_DATA_VALUE_DATA_TYPE num2 ;
	unsigned char *str1, *str2 ;

	str1 = (unsigned char *) &num ;
	str2 = (unsigned char *) &num2 ;
	str2[0] = str1[1] ;
	str2[1] = str1[0] ;
	return num2 ;
}
