// -------------------------------------------------------------------------
// Project Name                 :       LCPR Setup for Windows 
// File Name                    :       BOOT.h
// Description                  :       Defines various structures.
// Start Date                   :       19th Oct 98
// Author                   	  :       Vidy
//	References						  : Memmap file in srcmain dir of boot files
// Date Last Modified   		  :       
// Modifications                :       
// -------------------------------------------------------------------------
#define	COLD_BOOT_MODE		0x00
#define	DOWNLOAD_MODE		0xA5		/* Number for download mode */
#define	WARM_BOOT_MODE		0x5A		/* Number for warm boot (after new cnf) mode */
#define	MAGIC_NUM			0xABCD   /* Magic number in CodeHeader and Config recs */
#define	FRAME_DELIM			0x7e		/* frame delimiter for packets */

#if BIG_PROXY
#define COD_LOAD_ADDR 0x00002000L
#define COD_START_ADDR 0x00002040L
#define UDB_DNLD_ADDR 0x080C0000L
#define OLD_COD_LOAD_ADDR 0x102000L
#define OLD_COD_START_ADDR 0x102040L
#else
#define COD_LOAD_ADDR	(64*1024L)
#define COD_START_ADDR	(64 * 1024L + 0x30L)
#define UDB_DNLD_ADDR 	0x8000L
#endif

#define SINGLE_SCR_SIZE (2 * 1024L)
#define TOT_SCR_SIZES (3 * SINGLE_SCR_SIZE)

#if BIG_PROXY
#define SCRIPT_ONE_DNLD_ADDR (UDB_DNLD_ADDR - TOT_SCR_SIZES)
#else
#define SCRIPT_ONE_DNLD_ADDR (18 * 1024L)
#endif

#define SCRIPT_TWO_DNLD_ADDR (SCRIPT_ONE_DNLD_ADDR + SINGLE_SCR_SIZE)
#define SCRIPT_THREE_DNLD_ADDR (SCRIPT_TWO_DNLD_ADDR + SINGLE_SCR_SIZE)

#if BIG_PROXY
#define BOOT_CODE_SIZE  ((unsigned long) 68 * 1024L) /* 68K for boot code */
#define FL_PAGE_SIZE 512
#else
#define BOOT_CODE_SIZE  ((unsigned long) 16 * 1024L) /* 16K for boot code */
#endif

#if BIG_PROXY
#define	FLASH_1_BASE 0x08000000L
#define	FL_HEADER_SIZE	512
#else
#define	FLASH_1_BASE 0x0L
#define	FL_HEADER_SIZE	0x40
#endif

#define	FL_ROMM_START FLASH_1_BASE

#define FL_BOOT_HDR     (FL_ROMM_START + BOOT_CODE_SIZE)

#define FL_CODE_HDR     (FL_BOOT_HDR + FL_HEADER_SIZE)

#define FL_CFG_HDR      (FL_CODE_HDR + FL_HEADER_SIZE)

#define UDB_HEADER_START (FL_CFG_HDR + FL_HEADER_SIZE)

#define SCRIPT_HEADER (UDB_HEADER_START + FL_HEADER_SIZE)

#define SNMP_HEADER (SCRIPT_HEADER + FL_HEADER_SIZE)

#define RESERVED_HDR_1 (SNMP_HEADER + FL_HEADER_SIZE)
#define RESERVED_HDR_2 (RESERVED_HDR_1 + FL_HEADER_SIZE)
#define RESERVED_HDR_3 (RESERVED_HDR_2 + FL_HEADER_SIZE)
		/* 3 pages reserved for later use */

#define SNMP_VARIABLES (RESERVED_HDR_3 + FL_HEADER_SIZE)
		/* 2 pages for snmp variables */

#if	BIG_PROXY
#define FL_SYSTEM_CFG (SNMP_VARIABLES + (2 * FL_HEADER_SIZE))
#else
#define FL_SYSTEM_CFG (24 * 1024L)
#endif
		/* 61400 for system cfg */

		/* Start of compressed code */
#if BIG_PROXY
#define FL_CODE_START (FLASH_1_BASE + 0x21600L)
#define OLD_FL_CODE_START 0x21600L
#else
#define FL_CODE_START 0x00010000L
#endif


#define RECV_7E     0
#define RECV_DATA   1
#define RECV_QUOTE  2

#define	NO_ERR			0
#define ERR_CRC         12      /* part of UI err codes */
#define ERR_PASSWORD    13
#define ERR_SCC1        14
#define ERR_SCC2        15
#define ERR_SCC3			16
#define ERR_SCC4			17

#define	ERR_NO_BRD_GET_PASSWORD		18
#define	ERR_NO_BRD_NO_PASSWORD		19
#define	ERR_INV_MEM_RANGE				20
#define	ERR_READ_EVENT_LOG			25
#define	ERR_NO_LOGGING					26

#define TRGT_CMND_TYPE  0   /* part of UI commands */
#define RES_TYPE        12
#define PASSWORD_TYPE   30
#define REBOOT_TYPE     22
#define READ_REQ_TYPE   31
#define READ_RESP_TYPE  32

/* configuration manager lock commands */
#define	GET_LOCK			48
#define	FREE_LOCK		49

// Lock Response Type
#define LOCK_RESP_TYPE	50
#define	HANGUP_AND_REDIAL	51

#define	OPEN_EVENT_LOG			61
#define	READ_EVENT_LOG			62
#define	CLOSE_EVENT_LOG		63
#define	RESET_EVENT_LOG		64

/* configuration manager lock command responses */
#define	LK_LOCKED_OK					0
#define	LK_LOCK_OWNED_BY_TELNET		1
#define	LK_LOCK_OWNED_BY_WEB			2
#define	LK_LOCK_OWNED_BY_DUMB_TTY	3
#define	LK_LOCK_OWNED_BY_ROUCON		4
#define	LK_LOCK_OWNED_BY_SOMEONE	5

/* target command types */
#define DNLOAD_CODE_TYPE        0
#define HW_DIAG_TYPE            1
#define DNLOAD_CFG_TYPE     3

/* download types */
#define NO_DNLD     0
#define DNLD_CODE   1
#define DNLD_CFG    2
#define ONLINE_FLASH_WRITE 4

/* Ports */
#define SCC1        1
#define SCC2        2
#define SCC3        3
#define SCC4        4

/* Packet types */
#define	PT_UNKNOWN	0
#define	PT_HEADER	1		/* download header type - from UI */
#define	PT_DATA		2		/* download data pkt - from UI */
#define	PT_ABORT  	3	    /* abort download pkt - from UI and Target */
#define	PT_EOF		4		/* endof download packet - from UI */
#define	PT_NACK		5		/* negative ack - from Target */
#define	PT_ACK		6		/* positive ack - from Target */
#define	PT_TMOUT	7		/* Timeout packet - from Target */
#define	PT_INFO		8		/* Info req./response - from UI and Target */

#define RES_TYPE             12
#define QUERY_BRIDGE_NAME    13
#define REBOOT_TYPE          22
#define TRGT_CMD_TYPE         0
#define PASSWD_TYPE          30
#define	READ_REQ_TYPE        31
#define	READ_RESP_TYPE       32
#define DN_LD                 0
#define TST_HW                1
#define	REBOOT		   		  2
#define DN_LD_CNF             3


#define STATUS_PACKET_TYPES 100
#define GET_PORT_STATUS (STATUS_PACKET_TYPES + 0)

#define	ERR_NO_BRD_GET_PASSWORD		 18
#define	ERR_NO_BRD_NO_PASSWORD		 19
#define	ERR_CRC			             12		/* part of UI err codes */
#define	ERR_PASSWORD	             13
#define  ERR_ROUTER_UP				    21

#define MIN_PKT_SIZE    4   /* DnLdPktHead(2 Abort Pkt) + CRC(2) */

#define INC_CIR_IDX(seqnum, maxval) seqnum++; seqnum &= (maxval - 1)

/* Packet format of all Target Command packets 
   +----+------+------+----+----+---+-----+----+----+---...----
   | 7e |  SMC header | Pkt data... |    CRC   | 7e |   
   +----+------+------+----+----+---------+----+----+---...----
	  1         4                          2      1
CRC is calculated from Type  */

// For Requesting
typedef struct {
	BYTE Ptype ;
	BYTE ReqType ;
	BYTE ReqSubType ;
	BYTE Dmy0 ;
} ReqType ;


// Result of a request
typedef struct	{
	BYTE Ptype ;	
	BYTE Dmy0 ;  	
	WORD ErrorCode ;		
} ResultType ;

// Getting the bridge name
typedef struct {
	BYTE Ptype ;
	BYTE BrdName[11] ;
	BYTE BridgeID[4] ;
} OpenConnectionType ;

typedef struct {
	BYTE Version[10] ;		/* version number as ASCIIZ */
	BYTE DateStamp[25] ;		/* date as ASCIIZ */	
	BYTE Dmy[3] ;			   	
	WORD MagicNum ;	
   DWORD LoadAddr ; 			/* Address to start loading at */
	DWORD StartAddr ;			/* Address to start execution at */
  	DWORD DnLdAddress ;		/* Address to download at */
  	BYTE Reserved[21] ;		/* 56.. 76	for future use */
} DnLdHeadType ;

typedef struct tagDnLdPktHdr {
  	BYTE PacketType ;
  	BYTE SeqNum ;
} DnLdPktHdrType ;
  				 
typedef struct {
	DnLdPktHdrType hdr ;
  	DnLdHeadType headtype ;
} dnld_head_type ;

#if BIG_PROXY
typedef struct {
	BYTE Version[10] ;        /* version number of this record ASCIIZ */
	BYTE EthernetAddr[6] ;    /* Ethernet address of bridge */
	BYTE PassWord[20] ;       /* passWORD for Boot config */   
	BYTE NumberOfPorts ;     /* Total Lan and Wan Ports */   
	BYTE	Base1;
	BYTE  Size1;
	BYTE  Base2;
	BYTE  Size2;
	BYTE	ClockSpeed;			/* added on 16/12/97 */
	BYTE	PROMWidth;
	BYTE	ModelNumber;
	BYTE Reserved[8] ;       /* for future use */   
	DWORD MagicNumber;		/* 0xA55AA55A to indicate valid config */
	DWORD FlashPromSize ;      /* System related information */  
	DWORD RamSize ;  
	DWORD RamStart ;  
} BootConfigType ;

#else

/* WARNING :
DO NOT INSERT ANY MEMBERS OR CHANGE THEIR SIZES. IF ADDITION IS REQUIRED
YOU MAY DO SO AT THE END OF THE STRUCTURE ONLY.
*/
typedef	struct {
	BYTE	MajorVersion;		/* major version number */
	BYTE	MinorVersion;		/* minor version number */
	WORD	EthernetAddr_H;	/* Ethernet address of bridge */
	DWORD	EthernetAddr_L;	/* Ethernet address of bridge */
	BYTE	PassWord[8];		/* password for Boot config */

	BYTE	NumberOfPorts;
	BYTE	ClockSpeed;
	BYTE	BootBusWidth;
	BYTE	ModelNumber;

	WORD MagicNumber;			/* 0xABCD to indicate valid config */
	DWORD	FlashPromSize;		/* System related information */
	DWORD	RamSize;
	DWORD	RamStart;
}BootConfigType;

/* Following structure is to communicate parameters between
the boot and the firware */
typedef struct {
	BYTE	BootMode;		/* is it warm boot, wit downlod etc */
	BYTE	Reserved[15];
}BootBinIOPBType;

#endif

/* Generic Header Pkt for all downloads. Each download type will use some 
or all of these fields */
typedef struct {
	BYTE Version[10] ;    /* 0 .. 9   version number as ASCIIZ */    
	BYTE DateStamp[25] ;  /* 10.. 34  date as ASCIIZ */    
	BYTE Dmy ;            /* 35 */    
	WORD MagicNum ;       /* 36.. 37 */    
	WORD CRC ;            /* 38.. 39  16bit CRC value */    
	DWORD CodeLength ;    /* 40.. 43  Valid length of compressed code */    
	DWORD DnLdAddr ;      /* 52.. 55  Address where compressed code is put */    
	DWORD LoadAddr ;      /* 44.. 47  Address to start loading at */    
	DWORD StartAddr ;     /* 48.. 51  Address to start execution at */    
#if BIG_PROXY
	BYTE Reserved[20] ;   /* 56.. 75  for future use */    
#endif
} HeaderType ;

typedef struct {
	BYTE BridgeNumber[4] ;
} SMCPktHeadType ;

typedef struct {
	BYTE Ptype ;              // 0
	char Password[11] ;       // 1 .. 11
} PasswordPktType ;

typedef struct {
	BYTE Ptype ;              // 0
	BYTE TargetAction ;       // 1
	BYTE Port ;               // 2      These 2 fields are for 
	BYTE BaudIndex ;          // 3      Hardware Diagnostics
} TargetCmdType ;

// Read Location Request
typedef struct {
	BYTE Ptype ;                // 0
	BYTE Length ;               // 1
	BYTE Dmy[2] ;               // 2..3
	DWORD Address ;             // 4..7
} ReadLocReqType ;

// Read Location Response
typedef struct {
	BYTE Ptype ;              // 0
	BYTE ErrCode ;                // 1
	BYTE Length ;             // 2
	BYTE Dmy[1] ;			// just for alignment
	DWORD Address ;				// 3
	BYTE buffer[128] ;        // 3..131
}  ReadLocRespType ;

typedef struct {
	BYTE Ptype ;	
	BYTE BootType ;
} RebootType ;

#define UDB_SENT_ONCE_COM 512

typedef struct {
	BYTE TargetAction ;
	DWORD DnLdAddress ;
	UINT Length ;
	BYTE buffer[UDB_SENT_ONCE_COM] ;
	UINT CRC ;
} OnLineFlashWriteType ;		

extern DWORD UDBDnldAddress ;

extern DWORD CodeLoadAddress ;
extern DWORD CodeStartAddress ;
extern DWORD FlCodeStartAddress ;
