// bootvers.cpp : implementation file
//

#include "stdafx.h"
#include "procon.h"
#include "bootvers.h"
#include "check.h"
#include "boot.h"
#include "dialdlg.h"
#include "locport.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CBootVersion dialog


CBootVersion::CBootVersion(CWnd* pParent /*=NULL*/)
	: CDialog(CBootVersion::IDD, pParent)
{
	//{{AFX_DATA_INIT(CBootVersion)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT

	TargetFound = FALSE ;
	RouterUp = FALSE ;
	VersionString = NULL ;
}

void CBootVersion::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CBootVersion)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CBootVersion, CDialog)
	//{{AFX_MSG_MAP(CBootVersion)
	ON_WM_TIMER()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CBootVersion message handlers

BOOL CBootVersion::OnInitDialog()
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
	if (!CBootCom.Open_Comm())
	{
		MessageBox ("Com Open Error") ;
		CDialog::OnCancel() ;
		return FALSE ;
	}

	if (!Connect())
	{
		MessageBox ("Connection Error") ;
		CBootCom.Close_Comm() ;
		CDialog::OnCancel() ;
		return FALSE ;
	}

	CCheck cCheck (AfxGetMainWnd()) ;
	GetRouterStatus() ;
	cCheck.DestroyWindow() ;

	if (!TargetFound)
	{
		MessageBox ("ProxyServer not found") ;
		CBootCom.Close_Comm() ;
		CDialog::OnCancel() ;
		return FALSE ;
	}

	GetBootHeader() ;

	CBootCom.Close_Comm() ;
	CDialog::OnOK();
	return TRUE;  // return TRUE  unless you set the focus to a control
}

BOOL CBootVersion::Connect()
{

	char szBuf[50] ;
	CString m_InitString, m_InitResponse, m_DialString, m_ConnectResponse ;

	GetPrivateProfileString ((LPCSTR) LPortSectionHeader,
			(LPCSTR) DialString,	(LPCSTR) "ATDP", (LPSTR) szBuf,
					sizeof (szBuf), (LPCSTR) OwnIniFile) ;
	m_DialString = szBuf ;
	if (m_DialString.IsEmpty() || CBootCom.IsDCDPresent())
		return TRUE ;

	CDialDlg cDialDlg (AfxGetMainWnd()) ;

	// Dial the Router.
	UINT nTimerID = 2 ;
	{
		char mdm_init_string[50] ;
		char mdm_resp[30] ;
		char *tmp ;

		GetPrivateProfileString ((LPCSTR) LPortSectionHeader,
				(LPCSTR) InitString,	(LPCSTR) "ATS0=1&E5",
					(LPSTR) szBuf, sizeof (szBuf), (LPCSTR) OwnIniFile) ;
		m_InitString = szBuf ;

		m_InitString += "^M" ;
		tmp = m_InitString.GetBuffer(50) ;
		CBootCom.ConvertControls ((BYTE *) mdm_init_string, (BYTE *) tmp) ;
		m_InitString.ReleaseBuffer() ;

		GetPrivateProfileString ((LPCSTR) LPortSectionHeader,
			(LPCSTR) InitRespString, (LPCSTR) "OK", (LPSTR) szBuf,
					sizeof(szBuf),	(LPCSTR) OwnIniFile) ;
		m_InitResponse = szBuf ;
		tmp = m_InitResponse.GetBuffer(30) ;
		CBootCom.ConvertControls ((BYTE *) mdm_resp, (BYTE *) tmp) ;
		m_InitResponse.ReleaseBuffer() ;

		CBootCom.TimeOut = FALSE ;
		while (nTimerID != SetTimer (nTimerID, (UINT) 5000, NULL))
		{
			if (IDCANCEL == MessageBox ("No Timer", NULL, MB_RETRYCANCEL))
			{
				SendMessage (WM_CLOSE) ;
				goto Error_Exit ;
			}
		}

		// send modem init string and look for response
		CBootCom.snd_mdm_command ((BYTE *) mdm_init_string,
													strlen (mdm_init_string)) ;
		if (!CBootCom.rcv_mdm_response ((BYTE *) mdm_resp, 
														(BOOL *) &CBootCom.TimeOut))
		{
			// timeout occured and no response
			KillTimer (nTimerID) ;
			MessageBox ("Modem not responding", NULL, MB_OK | MB_ICONSTOP) ;
			SendMessage (WM_CLOSE) ;
			goto Error_Exit ;
		}
		KillTimer (nTimerID) ;
	}

	// Modem initialized successfully now send the dial string.
	{	
		char mdm_dial_string[30] ;
		char mdm_connect_resp[30] ;
		char *tmp ;

		m_DialString += "^M" ;
		tmp = m_DialString.GetBuffer (30) ;
		CBootCom.ConvertControls ((BYTE *) mdm_dial_string, (BYTE *) tmp) ;
		m_DialString.ReleaseBuffer() ;

   	GetPrivateProfileString ((LPCSTR) LPortSectionHeader,
				(LPCSTR) ConnectString,	(LPCSTR) "CONNECT",
					(LPSTR) szBuf, sizeof (szBuf), (LPCSTR) OwnIniFile) ;
		m_ConnectResponse = szBuf ;
		tmp = m_ConnectResponse.GetBuffer (30) ;
		CBootCom.ConvertControls ((BYTE *) mdm_connect_resp, (BYTE *) tmp) ;
		m_ConnectResponse.ReleaseBuffer() ;

		CBootCom.TimeOut = FALSE ;
		nTimerID = 3 ;
		while (nTimerID != SetTimer (nTimerID, (UINT) 45000 ,NULL))
		{
			if (IDCANCEL == MessageBox ("No Timer", NULL, MB_RETRYCANCEL))
			{
				SendMessage (WM_CLOSE) ;
				goto Error_Exit ;
			}
		}

		// Send the dial string and wait for connect response.
		CBootCom.snd_mdm_command ((BYTE *) mdm_dial_string,
													strlen (mdm_dial_string)) ;
		if (!CBootCom.rcv_mdm_response ((BYTE *) mdm_connect_resp, 
													(BOOL *) &CBootCom.TimeOut))
		{
			KillTimer (nTimerID) ;
			UINT nTimerID = 4 ;
			CBootCom.TimeOut = FALSE ;
			char mdm_hangup[2] ;

			while (nTimerID != SetTimer (nTimerID, (UINT) 2000, NULL))
			{
				if (IDCANCEL == MessageBox ("No Timer", NULL, MB_RETRYCANCEL))
				{
					SendMessage (WM_CLOSE) ;
					goto Error_Exit ;
				}
			}

			mdm_hangup[0] = 0x1b ;
			mdm_hangup[1] = 0 ;
			CBootCom.hangup_mdm (mdm_hangup, (BOOL *) &CBootCom.TimeOut) ;
			KillTimer (nTimerID) ;
		}       
		else
		{
			KillTimer (nTimerID) ;
			cDialDlg.DestroyWindow();
			return TRUE ;
		}
	}
Error_Exit:
	cDialDlg.DestroyWindow();
	return FALSE ;
}

void CBootVersion::GetRouterStatus()
{
	ReqType RouterUpStateRequest ;
   OpenConnectionType RouterUpStateReply ;

	RouterUpStateRequest.Ptype = QUERY_BRIDGE_NAME ;
	CBootCom.TimeOut = FALSE ;
	TargetFound = RouterUp = FALSE ;
 
	UINT nTimerID = 15 ;
	while (nTimerID != SetTimer (nTimerID, (UINT) 4000, NULL))
	{
		if (IDCANCEL == MessageBox ("No Timer", NULL,
								MB_RETRYCANCEL | MB_ICONINFORMATION))
		{
			return ;    
		}
	}

	while (1)
	{
		CBootCom.snd_packet ((BYTE *) &RouterUpStateRequest,
														sizeof (RouterUpStateRequest)) ;
		if (!(CBootCom.rcv_packet2 ((BYTE *) &RouterUpStateReply,
					sizeof (RouterUpStateReply), (BOOL *) &CBootCom.TimeOut)))
		{
			break ;   // No CRC error
		}
	}

   KillTimer (nTimerID) ;
	TargetFound = !CBootCom.TimeOut ;

	if (TargetFound)
	{
		if (RouterUpStateReply.Ptype == RES_TYPE)
		{
			BYTE *incor ;
			WORD pra ;
			incor = (BYTE *) &pra ;
			incor[0] = RouterUpStateReply.BrdName[1] ;
			incor[1] = RouterUpStateReply.BrdName[2] ;
			pra = CBootCom.ltl_endian_word (pra) ;
			switch (pra)
			{
				case ERR_ROUTER_UP :       // Router is Up
					RouterUp = TRUE ;	      // Router is running 
					break ;                                                          

				default :
					break ;
			}
		}
	}
}

void CBootVersion::OnTimer(UINT nIDEvent)
{
	// TODO: Add your message handler code here and/or call default
	
	CBootCom.TimeOut = TRUE ;
	CDialog::OnTimer(nIDEvent);
}

void CBootVersion::GetBootHeader()
{
	ReadLocReqType BootRequest ;
	ReadLocRespType BootResponse ;
	BootConfigType BootHeader ;
	
	memset ((BYTE *) &BootHeader, 0, sizeof (BootHeader)) ;
	CBootCom.TimeOut = FALSE ;
	BootRequest.Address = CBootCom.little_endian (FL_BOOT_HDR) ;
   BootRequest.Ptype = READ_REQ_TYPE ;
   BootRequest.Length = sizeof (BootHeader) ;

   UINT nTimerID = 1 ;
   while (nTimerID != SetTimer (nTimerID, (UINT) 10000, NULL))
	{
      if (IDCANCEL == MessageBox ("No Timer", NULL, MB_RETRYCANCEL))
		{
			return ;
      }
	}

   while (1)
	{    
      CBootCom.snd_packet ((BYTE *) &BootRequest, sizeof (BootRequest)) ;
      if (!CBootCom.rcv_packet2 ((BYTE *) &BootResponse,
						sizeof (BootHeader) + 3, (BOOL *) &CBootCom.TimeOut))
		{
			break ;  // No CRC Error
		}
   }

	KillTimer (nTimerID) ;

	if (!CBootCom.TimeOut && BootResponse.ErrCode != ERR_INV_MEM_RANGE)
	{
		memcpy ((BYTE *) &BootHeader, BootResponse.buffer, sizeof (BootHeader)) ;
#if BIG_PROXY
		strcpy (VersionString, (LPCSTR) BootHeader.Version) ;
#else
		sprintf(VersionString, "%d.%d", BootHeader.MajorVersion, BootHeader.MinorVersion);
#endif
		model = BootHeader.ModelNumber;
	}
}
