/* Author : Jyothi 
   Date   :  29/5/98 
   Synopsis :
               The configuration file format will consist of variable 
               length records. Each record can be uniquely identified to 
               which section it belongs based on the magic number. 
               The records will be arranged in the following order.
               Any new records can be added to the end of the file in future.

         +------+-------+-------+---------+--------+-------------------+
         |      |       |       |         |        |  					  |
         |  IP  |  WAN  |  PPP  |  PROXY  |  DHCP  | IP STATIC ROUTES  |
         |      |       |       |         |        |		  				  |
         +------+-------+-------+---------+--------+-------------------+
*/

#ifndef	ULONG
#define	ULONG 	unsigned long 
#define	USHORT 	unsigned short 
#define	BYTE 		unsigned char 
#define	DWORD 	unsigned long
#define	NULL 		0
#endif

#define	CNF_IP_MAGIC_NUMBER		   		0x5580
#define	CNF_PPP_MAGIC_NUMBER		   		0x5581
#define	CNF_WAN_MAGIC_NUMBER		   		0x5582
#define	CNF_PROXY_MAGIC_NUMBER				0x5583
#define	CNF_DHCP_MAGIC_NUMBER				0x5584
#define	CNF_STATIC_ROUTES_MAGIC_NUMBER	0x5585
#define 	END_OF_SECTION 			   		0xFFFF 

#define IP_ID					0
#define WAN_ID					1
#define PPP_ID					2
#define PROXY_ID				3
#define DHCP_ID				4
#define STATIC_ROUTES_ID	5


enum CNF_DATA_VALUE_DATA_TYPE
{
	H1, 
	H2, 
	H3, 
	H4, 
	H4S,
	H6, 
	H7, 
	D2, 
	IP
} ;

typedef struct CNF_IP_HEADER_STRUCT {
      USHORT   magic_number ;
      USHORT   section_length ;
      USHORT   number_of_ports ;  
/*      ULONG    default_gateway ;*/
      BYTE     dns_enabled ;
      ULONG    primary_address ;
      ULONG    secondary_address ;
} CNF_IP_HEADER ;

typedef struct CNF_IP_PORT_STRUCT {
      BYTE  isp_assigns_address ;
      BYTE  bootp ;
      ULONG ip_address ;
      ULONG subnet_mask ;
      ULONG remote_ip_address ;
} CNF_IP_PORT ;

typedef struct CNF_IP_STRUCT {
     CNF_IP_HEADER ip_header ;
     CNF_IP_PORT ip_ports[4] ;
} CNF_IP ;

typedef struct CNF_PPP_HEADER_STRUCT {
      USHORT magic_number ;
      USHORT section_length ;
      BYTE   enabled ;
      USHORT number_of_ports ;  
		BYTE   need_to_dial_out_initially ;

#ifdef	BIG_ENDIAN
   	BYTE		printf:1 ;
   	BYTE		printf_LCP:1 ;
	   BYTE		printf_NCP:1 ;
   	BYTE		printf_alarm:1 ;
	   BYTE		printf_filler:4 ;
#else
	   BYTE		printf_filler:4 ;
   	BYTE		printf_alarm:1 ;
	   BYTE		printf_NCP:1 ;
	   BYTE		printf_LCP:1 ;
   	BYTE		printf:1 ;
#endif

} CNF_PPP_HEADER ;

typedef struct CNF_PPP_OPTION_STRUCT {

   	BYTE   option_type ;

#ifdef BIG_ENDIAN
     	BYTE		Auto:1 ;
     	BYTE		NegNotReqd:1 ;
     	BYTE		Negotiable:1 ;
		BYTE     valid:1 ; 
	  	BYTE		option_filler:4 ;
#else
	  	BYTE		option_filler:4 ;
		BYTE     valid:1 ; 
     	BYTE		Negotiable:1 ;
     	BYTE		NegNotReqd:1 ;
     	BYTE		Auto:1 ;
#endif
		CNF_DATA_VALUE_DATA_TYPE	    value_type ;
  		BYTE     option_value[15] ;
} CNF_PPP_OPTION ;

typedef struct CNF_PPP_PORT_STRUCT {
      BYTE     enabled ;
   	BYTE		user_name[128] ;
   	BYTE		user_password[128] ;
      BYTE     connection_dod ;
      USHORT   hangup_time ; 
      BYTE     ip ;
      BYTE     authentication_type ;
      BYTE     remote_port_client_only ;

      CNF_PPP_OPTION   lcp_accm ;
      CNF_PPP_OPTION   remote_lcp_accm ;
      CNF_PPP_OPTION   lcp_mru ;   
      CNF_PPP_OPTION   remote_lcp_mru ;   
      CNF_PPP_OPTION   remote_lcp_authentication ;   
      CNF_PPP_OPTION   lcp_magic_number ;   
      CNF_PPP_OPTION   remote_lcp_magic_number ;   
      CNF_PPP_OPTION   ipcp_ip_address ;   
      CNF_PPP_OPTION   remote_ipcp_ip_address ;   
      CNF_PPP_OPTION   lcp_epd ;
      CNF_PPP_OPTION   remote_lcp_epd ;
      CNF_PPP_OPTION   lcp_mrru ;
      CNF_PPP_OPTION   remote_lcp_mrru ;
      CNF_PPP_OPTION   remote_lcp_callback ;
      CNF_PPP_OPTION   ipcp_dns_address1 ;
      CNF_PPP_OPTION   ipcp_dns_address2 ;
      CNF_PPP_OPTION   ras_remote_ipcp_dns_address1 ;
      CNF_PPP_OPTION   ras_remote_ipcp_dns_address2 ;
      CNF_PPP_OPTION   ras_lcp_authentication ;   
      CNF_PPP_OPTION   ras_ipcp_ip_address ;   
      CNF_PPP_OPTION   ras_remote_ipcp_ip_address ;   
} CNF_PPP_PORT ;

typedef struct CNF_PPP_STRUCT {
   	CNF_PPP_HEADER	   ppp_header ;
   	CNF_PPP_PORT	   ppp_ports[3] ;
} CNF_PPP ;


typedef struct CNF_WAN_HEADER_STRUCT {
      USHORT   magic_number ;
      USHORT   section_length ;
      BYTE     enabled ;
      USHORT   number_of_ports ;  
} CNF_WAN_HEADER ;

typedef struct CNF_WAN_PORT_STRUCT {
      BYTE     enabled ;
      ULONG    speed ;
   	BYTE		script_enabled ;
   	BYTE		restart_script_on_comm_failure ;
		BYTE		direct_connect ;
		BYTE		auto_answer ;

      BYTE     modem_type[50] ;
      BYTE     modem_init_string1 [41] ; 
      BYTE     modem_init_string2 [41] ; 
      BYTE     modem_init_string3 [41] ; 
      BYTE     modem_init_string4 [41] ; 
      BYTE     modem_init_string5 [41] ; 
      BYTE     dial_prefix[21] ;
      BYTE     dial_number[60] ;
      BYTE     dial_suffix[21] ;
      BYTE     ring_message[21] ; 
      BYTE     hangup_string[41] ; 
      BYTE     ok_message[21] ; 
      BYTE     no_carrier_message[21] ; 
      BYTE     error_message[21] ; 
      BYTE     no_dial_tone_message[21] ; 
      BYTE     busy_message[21] ; 
      BYTE     no_answer_message[21] ; 
      BYTE     response_string[41] ; 
}CNF_WAN_PORT ;


typedef struct CNF_WAN_STRUCT {
   	CNF_WAN_HEADER	   wan_header ;
   	CNF_WAN_PORT	   wan_ports[3] ;
} CNF_WAN ;


typedef struct CNF_PROXY_HEADER_STRUCT {
      USHORT   magic_number ;
      USHORT   section_length ;
      USHORT   number_of_ports ; 
      BYTE     enabled ;
		BYTE     proxy_any_app ;
		USHORT	ftp_control_port ;
		USHORT	ftp_data_port ;
} CNF_PROXY_HEADER ;


typedef struct CNF_PROXY_APP_STRUCT {
     USHORT    port ;
     USHORT    protocol ;
}  CNF_PROXY_APP ;

typedef struct CNF_PROXY_USER_DEFINED_APP_STRUCT {
     USHORT    protocol ;
     USHORT    lower_port_number ;
     USHORT    higher_port_number ;
     BYTE	   port_description[16] ;
}  CNF_PROXY_USER_DEFINED_APP ;

typedef struct CNF_PROXY_ADDRESS_INFO_STRUCT {
      ULONG address ;
}  CNF_PROXY_ADDRESS_INFO ;

typedef struct CNF_PROXY_MAC_ADDRESS_INFO_STRUCT {
      BYTE address[13] ;
}  CNF_PROXY_MAC_ADDRESS_INFO ;

typedef struct CNF_PROXY_STATIC_STRUCT {
      ULONG global_address ;
      ULONG local_address ;
}  CNF_PROXY_STATIC_INFO ;

/*typedef struct CNF_TRIPLET_INFO_STRUCT {
      ULONG     local_address ;
      USHORT    port ;
      USHORT    protocol ;
}  CNF_TRIPLET_INFO ;*/

typedef struct CNF_PROXY_DYNAMIC_STRUCT {
      ULONG     local_address ;
      USHORT    port ;
      USHORT    protocol ;
}  CNF_PROXY_DYNAMIC_INFO ;

typedef struct CNF_PROXY_DOMAIN_NAME_STRUCT {
      BYTE domain_name[255] ;
}  CNF_PROXY_DOMAIN_NAME_INFO ;

typedef struct CNF_PROXY_APPLICATION_STRUCT {
      USHORT         number_of_application_entries ;
      CNF_PROXY_APP  application_entries[1] ; 
}  CNF_PROXY_APPLICATION ;

typedef struct CNF_PROXY_USER_DEFINED_APPLICATION_STRUCT {
      USHORT         number_of_user_defined_application_entries ;
      CNF_PROXY_USER_DEFINED_APP  user_defined_application_entries[1] ; 
}  CNF_PROXY_USER_DEFINED_APPLICATION ;

typedef struct CNF_PROXY_VIRTUAL_SERVER_STRUCT {
      USHORT                  number_of_global_address_entries ;
      USHORT                  number_of_static_mapping_entries ;
      USHORT                  number_of_dynamic_mapping_entries ;
		ULONG 						dynamic_mapping_global_address ;
      CNF_PROXY_ADDRESS_INFO  global_address_entries[1] ;
      CNF_PROXY_STATIC_INFO   static_mapping_entries[1];
      CNF_PROXY_DYNAMIC_INFO  dynamic_mapping_entries[1];
}  CNF_PROXY_VIRTUAL_SERVER ;

typedef struct CNF_PROXY_FILTER_STRUCT {
      USHORT     number_of_forbidden_sites_entries ;
      USHORT     number_of_restricted_clients_entries ;
      USHORT     number_of_restricted_application_entries ;
      USHORT     number_of_mac_address_entries ;
      USHORT     number_of_domain_name_entries ;

      CNF_PROXY_ADDRESS_INFO      forbidden_sites_entries[1] ;
      CNF_PROXY_ADDRESS_INFO      restricted_clients_entries[1] ;
      CNF_PROXY_APP               restricted_application_entries[1] ;
      CNF_PROXY_MAC_ADDRESS_INFO  mac_address_entries[1] ;
      CNF_PROXY_DOMAIN_NAME_INFO  domain_name_entries[1] ;

}  CNF_PROXY_FILTER ;

typedef struct CNF_PROXY_PORT_STRUCT {
      BYTE     enabled ;
      USHORT   number_of_address_entries ;
      USHORT   number_of_connections_to_trigger ;
      USHORT   number_of_hosts_to_trigger ;
      CNF_PROXY_ADDRESS_INFO  port_address[1] ;
}  CNF_PROXY_PORT ;


typedef struct CNF_PROXY_STRUCT {
      CNF_PROXY_HEADER           				proxy_header ;
	   CNF_PROXY_APPLICATION      				proxy_application[1] ;
		CNF_PROXY_USER_DEFINED_APPLICATION    	proxy_user_defined_application[1] ;
      CNF_PROXY_VIRTUAL_SERVER   				proxy_virtual_server[1] ;
      CNF_PROXY_FILTER           				proxy_filter[1] ; 
      CNF_PROXY_PORT             				proxy_ports[4] ;
}  CNF_PROXY ;


typedef struct CNF_DHCP_HEADER_STRUCT {
      USHORT   magic_number ;
      USHORT   section_length ;
      USHORT   number_of_address_range_entries ;
      BYTE     dhcp_server_enabled ;
      BYTE     dhcp_client_enabled ;
      ULONG    dhcp_server_ip_address ;

} CNF_DHCP_HEADER ;


typedef struct CNF_BINDING_INFO_STRUCT {
      ULONG    ip_address ;
      BYTE     mac_address_length ;
      BYTE     mac_address[13] ;
}  CNF_BINDING_INFO ;

/* typedef struct CNF_OPTIONS_INFO_STRUCT {
      BYTE     option_type ;
      BYTE     option_length ;
}  CNF_OPTIONS_INFO ; */

typedef struct CNF_OPTIONS_INFO_STRUCT {
		ULONG  			router_address ;
		BYTE				domain_name[40] ;
		USHORT			reassembly_size ;
		BYTE				default_ip_ttl ;
		USHORT			mtu ;
		BYTE				default_tcp_ttl ;
		ULONG			   lease_time ;
}  CNF_OPTIONS_INFO ;

typedef struct CNF_DHCP_ADDRESS_RANGE_STRUCT {
      ULONG    lower_ip_address ;
      ULONG    higher_ip_address ;
      ULONG    address_mask ;

      USHORT   number_of_bindings_entries ;

      ULONG    exclude_lower_ip_address ;
      ULONG    exclude_higher_ip_address ;
      CNF_OPTIONS_INFO     options_entries ;
      CNF_BINDING_INFO     bindings_entries[1] ;

}  CNF_DHCP_ADDRESS_RANGE ;

typedef struct CNF_DHCP_STRUCT {
      CNF_DHCP_HEADER      dhcp_header ;
      CNF_DHCP_ADDRESS_RANGE    dhcp_address_range_entries[1] ;
}  CNF_DHCP ;

typedef struct CNF_STATIC_ROUTES_HEADER_STRUCT {
      USHORT   magic_number ;
      USHORT   section_length ;
      USHORT   number_of_static_routes ;  
} CNF_STATIC_ROUTES_HEADER ;

typedef struct CNF_STATIC_ROUTES_INFO_STRUCT {
      ULONG host_ip_address ;
      ULONG host_gateway ;
      ULONG host_address_mask ;
		USHORT port_number ;
      BYTE	metric ;
} CNF_STATIC_ROUTES_INFO ;

typedef struct CNF_STATIC_ROUTES_STRUCT {
     CNF_STATIC_ROUTES_HEADER static_routes_header ;
     CNF_STATIC_ROUTES_INFO static_routes_info[1] ;
} CNF_STATIC_ROUTES ;

typedef struct ALL_STRUCTURES
{
	USHORT	section_id ;
	void 		*ptr_to_struct ;
	USHORT 	size_of_struct ;
	HGLOBAL  glblck ;
}  ALL_STRUCTURES ;
     
typedef struct HeaderTag{
	WORD	MagicNumber ;
	WORD	SectionLength ;
}  HeaderTagType ;

