// dhcp.cpp : implementation file
//
// 06/07/98  : Jyothi made changes for Small Proxy
// 06/07/98  : Jyothi, uses structures instead of Ini file.

// We assume that if any filed is present it is a valid one
// as far as the user uses only roucon to create and delete
// entries it is OK. (i.e. We don't check sanity of the cnf file)
//

#include <stdio.h>
#include "stdafx.h"
#include "procon.h"
#include "dot.h"
#include "maskdot.h"
#include "dhcpk.h"
#include "dhcp.h"
#include "dhcpadt.h"
#include "bind.h"
#include "dhcpoptn.h"
#include "cnffile.h"
#include "readbmp.h"
#include "utils.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

LPCSTR DHCPServerSect = "DHCP";
LPCSTR DHCPErrMsgHdr = "DHCP Server - Error";
BOOL	EditBindings = 0;

extern CNF_IP *ip_ptr ;
extern CNF_DHCP_HEADER *dhcp_header_ptr ;
void revert_char_string(char* original_string, char* converted_string);

/////////////////////////////////////////////////////////////////////////////
// CDHCP dialog


CDHCP::CDHCP(CWnd* pParent /*=NULL*/)
	: CDialog(CDHCP::IDD, pParent)
{
	m_Enable = FALSE;
	//{{AFX_DATA_INIT(CDHCP)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	m_EditedOptionValueIndex = LB_ERR;
}

void CDHCP::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDHCP)
	DDX_Control(pDX, IDC_BUTTON3, m_BtnOptnEdt);
	DDX_Control(pDX, IDC_BUTTON1, m_BtnOptnAdd);
	DDX_Control(pDX, IDC_BUTTON2, m_BtnOptnRem);
	DDX_Control(pDX, IDC_STATIC_TYPE, m_OTypeWnd);
	DDX_Control(pDX, IDC_LIST1, m_OptnEdtWnd);
	DDX_Control(pDX, IDC_LIST_OPTN, m_OptnLstWnd);
	DDX_Control(pDX, IDC_STATIC_SEL_IND, m_SelIndWnd);
	DDX_Control(pDX, IDC_BUTTON_EDIT2, m_BndBtn);
	DDX_Control(pDX, IDC_LIST_XADDR, m_XAdrLst);
	DDX_Control(pDX, IDC_STATIC_OPTN_MEANS, m_LineHelp);
	DDX_Control(pDX, IDC_BUTTON_REMOVE, m_RemBtn);
	DDX_Control(pDX, IDC_BUTTON_EDIT, m_EdtBtn);
	DDX_Control(pDX, IDC_BUTTON_ADD, m_AddBtn);
	DDX_Control(pDX, IDC_STATIC_X_LIST, m_XAdrHdrWnd);
	DDX_Control(pDX, IDC_LIST_ADR, m_AdrLstWnd);
	DDX_Control(pDX, IDC_STATIC_ADR_GRP, m_AdrGrpWnd);
	DDX_Check(pDX, IDC_CHECK_ENABLE, m_Enable);
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CDHCP, CDialog)
	//{{AFX_MSG_MAP(CDHCP)
	ON_LBN_SELCHANGE(IDC_LIST_ADR, OnSelchangeListAdr)
	ON_BN_CLICKED(IDC_BUTTON_REMOVE, OnButtonRemove)
	ON_BN_CLICKED(IDC_BUTTON_HELP, OnButtonHelp)
	ON_LBN_SELCHANGE(IDC_LIST_OPTN, OnSelchangeListOptn)
	ON_BN_CLICKED(IDC_BUTTON_ADD, OnButtonAdd)
	ON_BN_CLICKED(IDC_BUTTON_EDIT, OnButtonEdit)
	ON_BN_CLICKED(IDC_BUTTON_EDIT2, OnButtonBind)
	ON_LBN_SELCHANGE(IDC_LIST1, OnSelchangeVal)
	ON_BN_CLICKED(IDC_BUTTON1, OnButtonOptnAdd)
	ON_BN_CLICKED(IDC_BUTTON2, OnButtonOptnRem)
	ON_BN_CLICKED(IDC_BUTTON3, OnButtonOptnEdt)
	ON_LBN_DBLCLK(IDC_LIST_ADR, OnDblclkListAdr)
		// NOTE: the ClassWizard will add message map macros here
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CDHCP message handlers

void CDHCP::OnButtonHelp()
{
	// TODO: Add your control notification handler code here
	AfxGetApp()->WinHelp (0x20000 + IDD_DIALOGDHCP, HELP_CONTEXT) ;
	
}

/* Sachin, Oct. 4th, 1997 */
extern LPCSTR IPSectionHeader ;
/* Sachin, Oct. 4th, 1997 */
//travers the list and save the parameters one-by-one

/* Jo */
void CDHCP::SaveParams(void)
{
	int TagIndex, ptmp;
	AddrRangeType *tmpAddrRange;
	ULONG offset, return_offset, int_ip_addr ;
	CNF_BINDING_INFO *dhcp_binding_ptr ;
	CNF_DHCP_ADDRESS_RANGE *dhcp_address_range_ptr ;

	TagIndex = ip_ptr->ip_header.number_of_ports ; 
	if (m_Enable)
/* Sachin, Oct. 4th, 1997 */
	{
		ptmp = 1 ;
		for (int index = 0; index < TagIndex; index++)
		   ip_ptr->ip_ports[index].bootp = ptmp	;
	}
	else
	{
		ptmp = 0 ;
		for (int index = 0; index < TagIndex; index++)
		   ip_ptr->ip_ports[index].bootp = ptmp	;

	}
	dhcp_header_ptr->dhcp_server_enabled = ptmp ;
	ULONG temp_no_addr_range_entries = dhcp_header_ptr->number_of_address_range_entries ;
	dhcp_header_ptr->number_of_address_range_entries = m_AdrLstWnd.GetCount() ;

  	ULONG SizeToRealloc = (dhcp_header_ptr->section_length + (sizeof(CNF_DHCP_ADDRESS_RANGE) * (dhcp_header_ptr->number_of_address_range_entries - temp_no_addr_range_entries))) ;
	all_structures[DHCP_ID].glblck = GlobalReAlloc (all_structures[DHCP_ID].glblck, SizeToRealloc, GMEM_ZEROINIT) ;
	all_structures[DHCP_ID].ptr_to_struct = GlobalLock (all_structures[DHCP_ID].glblck) ;
	all_structures[DHCP_ID].size_of_struct = (USHORT) SizeToRealloc ;
	dhcp_header_ptr = (CNF_DHCP_HEADER *) all_structures[DHCP_ID].ptr_to_struct ;
	dhcp_header_ptr->section_length = (USHORT) SizeToRealloc ;

	offset = (ULONG) all_structures[DHCP_ID].ptr_to_struct ;
	calculate_offset_of_dhcp_address_range_entries (&offset, 0) ;
   dhcp_address_range_ptr = (CNF_DHCP_ADDRESS_RANGE *) offset ;

	TagIndex = 0 ;
	tmpAddrRange = PtrAddrRange ;

	while(tmpAddrRange)
	{

//Write the Tags first
		get_ip_address (tmpAddrRange->HAddr, &int_ip_addr) ;
		dhcp_address_range_ptr->higher_ip_address = int_ip_addr ;	   	
		get_ip_address (tmpAddrRange->LAddr, &int_ip_addr) ;
		dhcp_address_range_ptr->lower_ip_address = int_ip_addr ;	   	
		get_ip_address (tmpAddrRange->Mask, &int_ip_addr) ;
		dhcp_address_range_ptr->address_mask = int_ip_addr ;	   	


//write all exclusion address list
		int flag = 0 ;
		XAddrType *tmpXAddr1, *tmpXAddr2;
		tmpXAddr1 = tmpAddrRange->XAddrList;
		while(tmpXAddr1)
		{
			flag = 1 ;
			tmpXAddr2 = tmpXAddr1->NextNode;
			get_ip_address (tmpXAddr1->XLAddr, &int_ip_addr) ;
			dhcp_address_range_ptr->exclude_lower_ip_address = int_ip_addr ;	   	
			get_ip_address (tmpXAddr1->XHAddr, &int_ip_addr) ;
			dhcp_address_range_ptr->exclude_higher_ip_address = int_ip_addr	;   	
			tmpXAddr1 = tmpXAddr2;
			break;  //don't write more than 1
		}
		if (!flag)
		{
			dhcp_address_range_ptr->exclude_lower_ip_address = 0 ;
			dhcp_address_range_ptr->exclude_higher_ip_address = 0 ;
		}
//write properties next

		char TempBuf[45] ;
		int PropIndex;
		int PropStrIdx;
		OptionType *pCurOptn;
		ULONG ulong_value ;
		USHORT tmp_value ;

		PropStrIdx = 0;
		for (PropIndex = 0; PropIndex < NUM_OPTIONS ; PropIndex++)
		{
		     pCurOptn = &tmpAddrRange->OLPtr[PropIndex];
		     switch (pCurOptn->OptionType)
		     {
		        case 3 : if (pCurOptn->OptionList)  // Router address
					{
						revert_ip_address (pCurOptn, (char*)TempBuf) ;
				      get_ip_address (TempBuf, &ulong_value) ;
				      dhcp_address_range_ptr->options_entries.router_address = ulong_value ;
					}	
					else
						      dhcp_address_range_ptr->options_entries.router_address = 0 ;
					break ;

		        case 15 : if (pCurOptn->OptionCount)     // Domain Name
				  {
				      revert_char_string (pCurOptn->OptionList, (char*) TempBuf) ;
				      strcpy ((char *)dhcp_address_range_ptr->options_entries.domain_name, TempBuf) ;
				  }
				  else
				      strcpy ((char *)dhcp_address_range_ptr->options_entries.domain_name, "") ;
				  break ;

		        case 22 : if (pCurOptn->OptionList)   // Reassembly Size
					{
				     sscanf (pCurOptn->OptionList, "%04x", &tmp_value);
				     dhcp_address_range_ptr->options_entries.reassembly_size = tmp_value ;
					}
					else
				      dhcp_address_range_ptr->options_entries.reassembly_size = 0 ;
					break ;
	
		        case 23 : if (pCurOptn->OptionList)    // Default IP ttl
					{
						sscanf (pCurOptn->OptionList, "%02x", &tmp_value);
				     	dhcp_address_range_ptr->options_entries.default_ip_ttl = tmp_value ;
					}
					else
				      dhcp_address_range_ptr->options_entries.default_ip_ttl = 0 ;
					break ;
	
		        case 26 : if (pCurOptn->OptionList)    // MTU
					 {
					     sscanf (pCurOptn->OptionList, "%04x", &tmp_value);
					     dhcp_address_range_ptr->options_entries.mtu = tmp_value ;
					 }
					 else
				   	  dhcp_address_range_ptr->options_entries.mtu = 0 ;
					 break ;

		        case 37 : if (pCurOptn->OptionList)   // Default TCP ttl
					{
				     sscanf (pCurOptn->OptionList, "%02x", &tmp_value);
				     dhcp_address_range_ptr->options_entries.default_tcp_ttl = tmp_value ;
					}
					else
				     dhcp_address_range_ptr->options_entries.default_tcp_ttl = 0 ;
					break ;

		        case 51 : if (pCurOptn->OptionList)	// Lease Time
				  	{
				   	sscanf (pCurOptn->OptionList, "%08lx", &ulong_value);
						dhcp_address_range_ptr->options_entries.lease_time = ulong_value ;
					}
				 	else
				      dhcp_address_range_ptr->options_entries.lease_time = 0 ;
				 	break ;

				default : break ;
			  }
		}

//write Binds //for now we write one bind per ini



		USHORT temp_number_of_entries = dhcp_address_range_ptr->number_of_bindings_entries ;
		BindingType *tmpBind1, *tmpBind2 ;
		int BindIndex;

		tmpBind1 = tmpAddrRange->Binds ;
		BindIndex = 0 ;
		while(tmpBind1)
		{
			tmpBind2 = tmpBind1->NextNode ;
			BindIndex++ ;
			tmpBind1 = tmpBind2 ;
		}

		dhcp_address_range_ptr->number_of_bindings_entries = BindIndex ;
   	if (temp_number_of_entries < dhcp_address_range_ptr->number_of_bindings_entries)
   	{
   	   ULONG SizeToRealloc = (dhcp_header_ptr->section_length + (sizeof(CNF_BINDING_INFO) * (dhcp_address_range_ptr->number_of_bindings_entries - temp_number_of_entries))) ;
			all_structures[DHCP_ID].glblck = GlobalReAlloc (all_structures[DHCP_ID].glblck, SizeToRealloc, GMEM_ZEROINIT) ;
			all_structures[DHCP_ID].ptr_to_struct = GlobalLock (all_structures[DHCP_ID].glblck) ;
			all_structures[DHCP_ID].size_of_struct = (USHORT) SizeToRealloc ;
			dhcp_header_ptr = (CNF_DHCP_HEADER *) all_structures[DHCP_ID].ptr_to_struct ;
			dhcp_header_ptr->section_length = (USHORT) SizeToRealloc ;

			offset = (ULONG) all_structures[DHCP_ID].ptr_to_struct ;
	      calculate_offset_of_dhcp_address_range_entries (&offset, TagIndex) ;
         dhcp_address_range_ptr = (CNF_DHCP_ADDRESS_RANGE *) offset ;

         calculate_offset_of_dhcp_binding_entries (&offset, &return_offset) ;
         dhcp_binding_ptr = (CNF_BINDING_INFO *) return_offset ;

	      return_offset += (temp_number_of_entries * sizeof(CNF_BINDING_INFO)) ;

	      ULONG SizeToMove = ((ULONG) all_structures[DHCP_ID].ptr_to_struct + dhcp_header_ptr->section_length - return_offset - 
				(sizeof(CNF_BINDING_INFO) * (dhcp_address_range_ptr->number_of_bindings_entries - temp_number_of_entries))) ;
		   ULONG dst_offset = (return_offset + (dhcp_address_range_ptr->number_of_bindings_entries - temp_number_of_entries) * sizeof(CNF_BINDING_INFO)) ; 
		   memmove ((void *) dst_offset, (void *) return_offset, (int) SizeToMove) ;
		}
   	else
   	{
         if (temp_number_of_entries > dhcp_address_range_ptr->number_of_bindings_entries)
         {
  				offset = (ULONG) all_structures[DHCP_ID].ptr_to_struct ;
		      calculate_offset_of_dhcp_address_range_entries (&offset, TagIndex) ;
				dhcp_address_range_ptr = (CNF_DHCP_ADDRESS_RANGE *) offset ;
	        	calculate_offset_of_dhcp_binding_entries (&offset, &return_offset) ;
     	   	dhcp_binding_ptr = (CNF_BINDING_INFO *) return_offset ;

				return_offset += (temp_number_of_entries  * sizeof(CNF_BINDING_INFO)) ;

		 		ULONG SizeToMove = ((ULONG) all_structures[DHCP_ID].ptr_to_struct + dhcp_header_ptr->section_length - return_offset) ;
			 	ULONG dst_offset = (ULONG) (return_offset - ((temp_number_of_entries - dhcp_address_range_ptr->number_of_bindings_entries) * sizeof(CNF_BINDING_INFO))) ;
			 	_fmemmove ((void FAR *) dst_offset, (void FAR *) return_offset, (int) SizeToMove) ;

				ULONG SizeToRealloc = (dhcp_header_ptr->section_length + (sizeof(CNF_BINDING_INFO) * (dhcp_address_range_ptr->number_of_bindings_entries - temp_number_of_entries))) ;
		 		all_structures[DHCP_ID].glblck = GlobalReAlloc (all_structures[DHCP_ID].glblck, SizeToRealloc, GMEM_ZEROINIT) ;
			 	all_structures[DHCP_ID].ptr_to_struct = GlobalLock (all_structures[DHCP_ID].glblck) ;
			 	all_structures[DHCP_ID].size_of_struct = (USHORT) SizeToRealloc ;
			 	dhcp_header_ptr = (CNF_DHCP_HEADER *) all_structures[DHCP_ID].ptr_to_struct ;
		 		dhcp_header_ptr->section_length = (USHORT) SizeToRealloc ;
			}
   	}
		offset = (ULONG) all_structures[DHCP_ID].ptr_to_struct ;

		calculate_offset_of_dhcp_address_range_entries (&offset, TagIndex) ;
	   dhcp_address_range_ptr = (CNF_DHCP_ADDRESS_RANGE *) offset ;
      calculate_offset_of_dhcp_binding_entries (&offset, &return_offset) ;
      dhcp_binding_ptr = (CNF_BINDING_INFO *) return_offset ;
                
		tmpBind1 = tmpAddrRange->Binds;
		while(tmpBind1)
		{
		     tmpBind2 = tmpBind1->NextNode ;
		     get_ip_address (tmpBind1->IPAddr, &int_ip_addr) ;
	        dhcp_binding_ptr->ip_address = int_ip_addr ;
		     dhcp_binding_ptr->mac_address_length = tmpBind1->MacAddrLen ;
		     strcpy ((char *) dhcp_binding_ptr->mac_address, tmpBind1->MacAddr) ;
		     tmpBind1 = tmpBind2 ;	//write next bind
		     dhcp_binding_ptr++ ;
		}
		tmpAddrRange = tmpAddrRange->NextNode; //process next addr range
		TagIndex++ ; 
		offset = (ULONG) all_structures[DHCP_ID].ptr_to_struct ;
		calculate_offset_of_dhcp_address_range_entries (&offset, TagIndex) ;
	   dhcp_address_range_ptr = (CNF_DHCP_ADDRESS_RANGE *) offset ;
   }

}



//Walk thru all the big chain sniffing for mallocs and freeing
void CDHCP::FreeAllMem(void)
{
	AddrRangeType *tmpAddrRange;

	while(PtrAddrRange)
	{
		tmpAddrRange = PtrAddrRange->NextNode;

		FreeARange(PtrAddrRange);

		PtrAddrRange = tmpAddrRange;	//goto the next node
	}
}

void CDHCP::OnOK()
{
	// TODO: Add extra validation here
	//Clear all present strings from ini
	UpdateData(TRUE);

	//write all strings again
	SaveParams();

	//free all mem
	FreeAllMem();
	CDialog::OnOK();
}


/* Jo */

BOOL CDHCP::OnInitDialog()
{
	CDialog::OnInitDialog();
	// TODO: Add extra initialization here
	CenterWindow() ; 
	
	/* Change the title of the dialog as usual */
	char WindowHeader[80], CurrentHeading[80], *SubHeadingPointer ;

	GetWindowText (CurrentHeading, 80) ;
	SubHeadingPointer = strchr (CurrentHeading, '-') ;
	if (SubHeadingPointer == NULL)
		SubHeadingPointer = CurrentHeading ;
	else
		SubHeadingPointer += 2 ;

	sprintf(WindowHeader, DialogTitleFormat,
	WindowText.GetBuffer(0),SubHeadingPointer);
	SetWindowText (WindowHeader) ;

	if (!OKBmpBtn.LoadBitmaps ("OK1", "OK2", "OK3", "OK4"))
		AfxMessageBox ("Failed to load OK bitmap");

	VERIFY (OKBmpBtn.SubclassDlgItem (IDOK, this));
	OKBmpBtn.SizeToContent();

	if (!CancelBmpBtn.LoadBitmaps ("CANCEL1", "CANCEL2", "CANCEL3", "CANCEL4"))
		AfxMessageBox ("Failed to load CANCEL bitmap");

	VERIFY (CancelBmpBtn.SubclassDlgItem (IDCANCEL, this));
	CancelBmpBtn.SizeToContent();

	if (!HelpBmpBtn.LoadBitmaps ("SHELP1", "SHELP2", "SHELP3", "SHELP4"))
		AfxMessageBox ("Failed to load HELP bitmap");

	VERIFY (HelpBmpBtn.SubclassDlgItem (IDC_BUTTON_HELP, this));
	HelpBmpBtn.SizeToContent();

	if (!AddBmpBtn1.LoadBitmaps ("ADD1", "ADD2", "ADD3", "ADD4"))
		AfxMessageBox ("Failed to load ADD bitmap");

	VERIFY (AddBmpBtn1.SubclassDlgItem (IDC_BUTTON_ADD, this));
	AddBmpBtn1.SizeToContent();

	if (!DeleteBmpBtn1.LoadBitmaps ("DELETE1", "DELETE2", "DELETE3", "DELETE4"))
		AfxMessageBox ("Failed to load DELETE bitmap");

	VERIFY (DeleteBmpBtn1.SubclassDlgItem (IDC_BUTTON_REMOVE, this));
	DeleteBmpBtn1.SizeToContent();

	if (!EditBmpBtn1.LoadBitmaps ("EDIT1", "EDIT2", "EDIT3", "EDIT4"))
		AfxMessageBox ("Failed to load DELETE bitmap");

	VERIFY (EditBmpBtn1.SubclassDlgItem (IDC_BUTTON_EDIT, this));
	EditBmpBtn1.SizeToContent();

	if (!BindBmpBtn.LoadBitmaps ("BIND1", "BIND2", "BIND3", "BIND4"))
		AfxMessageBox ("Failed to load DELETE bitmap");

	VERIFY (BindBmpBtn.SubclassDlgItem (IDC_BUTTON_EDIT2, this));
	BindBmpBtn.SizeToContent();

	if (!AddBmpBtn2.LoadBitmaps ("ADD1", "ADD2", "ADD3", "ADD4"))
		AfxMessageBox ("Failed to load ADD bitmap");

	VERIFY (AddBmpBtn2.SubclassDlgItem (IDC_BUTTON1, this));
	AddBmpBtn2.SizeToContent();

	if (!DeleteBmpBtn2.LoadBitmaps ("DELETE1", "DELETE2", "DELETE3", "DELETE4"))
		AfxMessageBox ("Failed to load DELETE bitmap");

	VERIFY (DeleteBmpBtn2.SubclassDlgItem (IDC_BUTTON2, this));
	DeleteBmpBtn2.SizeToContent();

	if (!EditBmpBtn2.LoadBitmaps ("EDIT1", "EDIT2", "EDIT3", "EDIT4"))
		AfxMessageBox ("Failed to load DELETE bitmap");

	VERIFY (EditBmpBtn2.SubclassDlgItem (IDC_BUTTON3, this));
	EditBmpBtn2.SizeToContent();

	PtrAddrRange = NULL;	// Pointer to beginning of Address range
	pCurGBLTag = NULL;	// Pointer to current AddrRange
	pCurEditTag = NULL;	// used as a parameter to Edit/Add
	EditBindings = 0;


	int TagIndex;
	char szRHS[MAX_INI_OPTN_LEN*3];
	char addr1[20], addr2[20], addr3[20];
	char	RestRHS[80];
	char *ErrMsgPtr = NULL;
	int	BindStrIndex;
	char  *OptionsPtr;
	int	TabStop = 60;
	int	ListTabs[] = {70};
	int	Index;
	ULONG 	offset, return_offset ;
	CNF_BINDING_INFO *dhcp_binding_ptr ;
	CNF_DHCP_ADDRESS_RANGE *dhcp_address_range_ptr ;

	m_AdrLstWnd.SetTabStops (1, (LPINT)&ListTabs) ;
	m_XAdrLst.SetTabStops(1, (LPINT)&TabStop) ;

	AddrRangeType *pCurTag;		//pointer to current tag
	XAddrType *pXAddr;			//pointer for exclusion node

	m_Enable = dhcp_header_ptr->dhcp_server_enabled ;
	USHORT number_of_addr_entries = dhcp_header_ptr->number_of_address_range_entries ;

	for (int i = 0; i < number_of_addr_entries; i++)
	{
	     offset = (ULONG) all_structures[DHCP_ID].ptr_to_struct ;
	     calculate_offset_of_dhcp_address_range_entries (&offset, i) ;
	     dhcp_address_range_ptr = (CNF_DHCP_ADDRESS_RANGE *) offset ;

	     // CAllocate on node for this tag
	     pCurTag = (AddrRangeType *)calloc(1, sizeof(AddrRangeType));

	     if (!pCurTag)
	     {
	     	ErrMsgPtr = "No Memory!";
ErrorExit:
	     	sprintf(szRHS, "%s\nThe entry number is %d.", ErrMsgPtr, TagIndex);
	     	::MessageBox (GetSafeHwnd(), (LPCSTR) szRHS,
					(LPCSTR) DHCPErrMsgHdr, MB_OK | MB_ICONEXCLAMATION) ;
	     	FreeAllMem();
	     	CDialog::OnCancel();
	     	return TRUE;
	     }
	     //attach this node into chain ASAP. Better Append
	     if (PtrAddrRange)
	     {
		     	AddrRangeType *tmpPtr = PtrAddrRange;
		     	while (tmpPtr->NextNode)	//Travel till end
	   	  		tmpPtr = tmpPtr->NextNode;

	   		tmpPtr->NextNode = pCurTag ;
		   	pCurTag->PrevNode = tmpPtr ;
	     }
	     else
		     	PtrAddrRange = pCurTag ;
        get_dot_decimal_ip_address (dhcp_address_range_ptr->lower_ip_address, addr1) ;
	     strcpy(pCurTag->LAddr, addr1);
		  get_dot_decimal_ip_address (dhcp_address_range_ptr->higher_ip_address, addr2) ;
	     strcpy(pCurTag->HAddr, addr2);
        get_dot_decimal_ip_address (dhcp_address_range_ptr->address_mask, addr3) ;
	     strcpy(pCurTag->Mask,  addr3);

#if _WINDOWS_
		CDotDecimal	LAddr = addr1;
		CDotDecimal	HAddr = addr2;
		CDotDecimal Mask = addr3;

		if (!LAddr.IsValid() || !HAddr.IsValid() || !Mask.IsValid())
		{
			ErrMsgPtr = "Invalid Address Range Entry!";
			goto ErrorExit;
		}
#endif

// Now read exclusion. 
//But we now permit only one exclusion for a range

		if (dhcp_address_range_ptr->exclude_lower_ip_address)
		{
			// CAllocate on node for this exclusion
			pXAddr = (XAddrType *)calloc(1, sizeof(XAddrType));
			if (!pXAddr)
			{
				ErrMsgPtr = "No memory!";
				goto ErrorExit;
			}
			//attach the exclusion list to AddrRange ASAP
			pCurTag->XAddrList = pXAddr;

        	get_dot_decimal_ip_address (dhcp_address_range_ptr->exclude_lower_ip_address, addr1) ;
			strcpy(pXAddr->XLAddr, addr1);
        	get_dot_decimal_ip_address (dhcp_address_range_ptr->exclude_higher_ip_address, addr2) ;
			strcpy(pXAddr->XHAddr, addr2);
		}
#if _WINDOWS_
		CDotDecimal	LAddr = addr1;
		CDotDecimal	HAddr = addr2;

		if (!LAddr.IsValid() || !HAddr.IsValid())
		{
			ErrMsgPtr = "Invalid Exclusion Range Entry!",
			goto ErrorExit;
		}
#endif

//Now read the properties till all properties are read
		int type, count ;
		int no_of_options = 7 ;
		for (int i = 0;	i < no_of_options ; i++)
		{
				switch (i)
		      {
					case 0 : if (dhcp_address_range_ptr->options_entries.router_address)
						{
							type = 3 ;
					      OptionsPtr = (char *) malloc((sizeof(ULONG) * 2) + 2);
					      if (!OptionsPtr)
				   	   {
								ErrMsgPtr = "No Memory for options!";
								goto ErrorExit;
					      }
					      get_dot_decimal_ip_address (dhcp_address_range_ptr->options_entries.router_address, addr1) ;
					      convert_ip_address (addr1, (char*)OptionsPtr) ;
					      pCurTag->OLPtr[type].OptionList = OptionsPtr ;
				   	   pCurTag->OLPtr[type].OptionCount = sizeof(ULONG) ;
				      	pCurTag->OLPtr[type].OptionType = type ;

						}
					 	break ;

					case 1 : if (strcmp((char*)dhcp_address_range_ptr->options_entries.domain_name, "") != 0)
				 		{
							type = 15 ;
							OptionsPtr = (char *) malloc((strlen((char *)dhcp_address_range_ptr->options_entries.domain_name) * 2) + 4) ;
							if (!OptionsPtr)
							{
								ErrMsgPtr = "No Memory for options!";
								goto ErrorExit;
							}
				   	  	convert_char_string ((char *)dhcp_address_range_ptr->options_entries.domain_name, (char*) OptionsPtr) ;
							count = (strlen ((char *)dhcp_address_range_ptr->options_entries.domain_name) + 1) ;
				 	     	OptionsPtr[2*count-1] = 0 ;
							strcat (OptionsPtr, "00") ;
							pCurTag->OLPtr[type].OptionList = OptionsPtr;
							pCurTag->OLPtr[type].OptionCount = count ;
							pCurTag->OLPtr[type].OptionType = type ;
				 		}
						break ;

					case 2 : if (dhcp_address_range_ptr->options_entries.reassembly_size)
						{
							type = 22 ;
							OptionsPtr = (char *) malloc((sizeof(USHORT) * 2) + 2);
							if (!OptionsPtr)
							{
							ErrMsgPtr = "No Memory for options!";
							goto ErrorExit;
							}
							sprintf (addr1, "%04x", dhcp_address_range_ptr->options_entries.reassembly_size) ;
							strcpy(OptionsPtr, addr1) ;
							pCurTag->OLPtr[type].OptionList = OptionsPtr;
							pCurTag->OLPtr[type].OptionCount = sizeof(USHORT) ;
							pCurTag->OLPtr[type].OptionType = type ;
					 	}
						break ;

					case 3 : if (dhcp_address_range_ptr->options_entries.default_ip_ttl)
						{
							type = 23 ;
							OptionsPtr = (char *) malloc((sizeof(BYTE) * 2)+ 2);
							if (!OptionsPtr)
							{
							ErrMsgPtr = "No Memory for options!";
							goto ErrorExit;
							}
							sprintf (addr1, "%02x", dhcp_address_range_ptr->options_entries.default_ip_ttl) ;
							strcpy (OptionsPtr, addr1) ;
							pCurTag->OLPtr[type].OptionList = OptionsPtr;
							pCurTag->OLPtr[type].OptionCount = sizeof(BYTE) ;
							pCurTag->OLPtr[type].OptionType = type ;
						}
						break ;

					case 4 : if (dhcp_address_range_ptr->options_entries.mtu)
						{
							type = 26 ;
							OptionsPtr = (char *) malloc((sizeof(USHORT) * 2) + 2) ;
							if (!OptionsPtr)
							{
							ErrMsgPtr = "No Memory for options!";
							goto ErrorExit;
							}
							sprintf (addr1, "%04x", dhcp_address_range_ptr->options_entries.mtu) ;
							strcpy(OptionsPtr, addr1) ;
							pCurTag->OLPtr[type].OptionList = OptionsPtr;
							pCurTag->OLPtr[type].OptionCount = sizeof(USHORT) ;
							pCurTag->OLPtr[type].OptionType = type ;
						}
						break ;

					case 5 : if (dhcp_address_range_ptr->options_entries.default_tcp_ttl)
						{
							type = 37 ;
							OptionsPtr = (char *) malloc((sizeof(BYTE) * 2) + 2) ;
							if (!OptionsPtr)
							{
							ErrMsgPtr = "No Memory for options!";
							goto ErrorExit;
							}
							sprintf (addr1, "%02x", dhcp_address_range_ptr->options_entries.default_tcp_ttl) ;
							strcpy(OptionsPtr, addr1) ;
							pCurTag->OLPtr[type].OptionList = OptionsPtr;
							pCurTag->OLPtr[type].OptionCount = sizeof(BYTE) ;
							pCurTag->OLPtr[type].OptionType = type ;
						}
						break ;

						case 6 : if (dhcp_address_range_ptr->options_entries.lease_time)
							{
								type = 51 ;
								OptionsPtr = (char *) malloc((sizeof(ULONG) * 2) + 2);
								if (!OptionsPtr)
								{
								ErrMsgPtr = "No Memory for options!";
								goto ErrorExit;
								}
								sprintf (addr1, "%08lx", dhcp_address_range_ptr->options_entries.lease_time) ;
								strcpy(OptionsPtr, addr1) ;
								pCurTag->OLPtr[type].OptionList = OptionsPtr ;
								pCurTag->OLPtr[type].OptionCount = sizeof(ULONG) ;
								pCurTag->OLPtr[type].OptionType = type ;
							}
							break ;
						default : break ;
				}
		}

// Read static bindings of IP addresses to MAC addresses if any
		BindStrIndex = 0;
		BindingType *BindPtr;

	   calculate_offset_of_dhcp_binding_entries (&offset, &return_offset) ;
      dhcp_binding_ptr = (CNF_BINDING_INFO *) return_offset ;
		for (i = 0; i < dhcp_address_range_ptr->number_of_bindings_entries; i++)
		{
		      //Now Callocate a node for this
		      BindPtr = (BindingType *) calloc(1, sizeof(BindingType));
		      if (!BindPtr)
		      {
					ErrMsgPtr = "No Memory";
					goto ErrorExit;
		      }
		      //Chain this Binding to the end of the binding list
		      if (pCurTag->Binds)
		      {
		       	  BindingType *tmpBindPtr;
					  tmpBindPtr = pCurTag->Binds;
					  while(tmpBindPtr->NextNode)
					  tmpBindPtr = tmpBindPtr->NextNode;
					  tmpBindPtr->NextNode = BindPtr;
		      }	  
		      else
		      	  pCurTag->Binds = BindPtr;
		      
		      //Fillup this struct
   	      get_dot_decimal_ip_address (dhcp_binding_ptr->ip_address, addr1) ;
		      strcpy(BindPtr->IPAddr, addr1);
		      BindPtr->MacAddrLen = dhcp_binding_ptr->mac_address_length ;
		      strcpy(BindPtr->MacAddr, (char *) dhcp_binding_ptr->mac_address);
		      strcpy(szRHS, RestRHS);	//go for next tripple
		      dhcp_binding_ptr++ ;
		}
		//Add this tag to the list box
		if (TagIndex == 0)
			sprintf(szRHS, "%s", " Default range");
		else
			sprintf(szRHS, "%s\t%s", pCurTag->LAddr, pCurTag->HAddr);
		Index = m_AdrLstWnd.AddString(szRHS);

		//Set the list box word as the address of the TagStruct
		if (Index == LB_ERR)
			goto ErrorExit;

		m_AdrLstWnd.SetItemDataPtr(Index, pCurTag);

		TagIndex++;		//	goto the next tab
	}
	//Fill the options list with the items
	FillupOptionsList();
	//now set the cursel in options list to 0
	m_OptnLstWnd.SetCurSel(0);


	//if Tag0 is not present, we can't proceed
	if (TagIndex == 0)
	{
		::MessageBox (GetSafeHwnd(), (LPCSTR)"No Default Options Entry!\n\
		Please download default setup",
		(LPCSTR) DHCPErrMsgHdr, MB_OK | MB_ICONEXCLAMATION) ;
		CDialog::OnCancel();
		return TRUE;
	}

	Index = m_AdrLstWnd.SetCurSel(0);

	OnSelchangeListAdr();
	UpdateData(FALSE);

	m_AdrLstWnd.SetFocus();		// Sachin likes it here
	return FALSE;  // return TRUE  unless you set the focus to a control
}

void CDHCP::OnSelchangeListAdr()
{
	int CurIndex;
	char	szBuf[40];

	// TODO: Add your control notification handler code here
	CurIndex = m_AdrLstWnd.GetCurSel();
	if (CurIndex == LB_ERR)
	{
		pCurGBLTag = 0;	//No Tag for GBL

		//Disable Edit, Delete buttons in range group
		m_EdtBtn.EnableWindow(FALSE);
		m_RemBtn.EnableWindow(FALSE);
		m_SelIndWnd.SetWindowText("None");

		//Reset the contents of Exclude
		m_XAdrLst.ResetContent();

		//Redisplay the OptionsList
		OnSelchangeListOptn();
		return;
	}
	pCurGBLTag = (AddrRangeType *)m_AdrLstWnd.GetItemDataPtr(CurIndex);

	if ( CurIndex )
	{
		sprintf(szBuf, "Entry number %d.", CurIndex + 1);
	}
	else
	{
		sprintf(szBuf, "Default Entry (1)");
	}
	m_SelIndWnd.SetWindowText(szBuf);

//display contents of Exclude
	//Reset the contents of Exclude
	m_XAdrLst.ResetContent();
	szBuf[0] = NULL;
	if (pCurGBLTag->XAddrList)
		sprintf(szBuf, "%s\t%s", pCurGBLTag->XAddrList->XLAddr,
	pCurGBLTag->XAddrList->XHAddr);
	m_XAdrLst.AddString(szBuf);

//if the range selected is default range - No edit, remove or bind
	BOOL Editable;

	Editable = (pCurGBLTag == PtrAddrRange) ? FALSE : TRUE;

	m_EdtBtn.EnableWindow(Editable);
	m_RemBtn.EnableWindow(Editable);
	m_BndBtn.EnableWindow(Editable);

	//Redisplay the OptionsList
	OnSelchangeListOptn();
}

void CDHCP::OnButtonAdd()
{
	// TODO: Add your control notification handler code here
	pCurEditTag = NULL;

	CDHCPAdt DHCPAdd(this);
	DHCPAdd.DoModal();
	
}

void CDHCP::OnDblclkListAdr()
{
	// TODO: Add your control notification handler code here
	int index  = m_AdrLstWnd.GetCurSel();
	OnSelchangeListAdr();

	if (index != 0)
		OnButtonEdit();
}

void CDHCP::OnButtonEdit()
{
	// TODO: Add your control notification handler code here
	pCurEditTag = pCurGBLTag;

	CDHCPAdt DHCPEdit(this);
	DHCPEdit.DoModal();
	
	pCurEditTag = NULL;
}

void CDHCP::OnButtonRemove()
{
	// TODO: Add your control notification handler code here
	int CurIndex;
	AddrRangeType *pTmp;

	CurIndex = m_AdrLstWnd.GetCurSel();
	if (CurIndex == LB_ERR)
		return;

	pTmp = (AddrRangeType *)m_AdrLstWnd.GetItemDataPtr(CurIndex);

	// Deletestring at index;
	m_AdrLstWnd.DeleteString(CurIndex);
	//Set selection to prev
	m_AdrLstWnd.SetCurSel(CurIndex - 1);
	OnSelchangeListAdr();

	//Diconnect pTMp from the chain
	if (pTmp->PrevNode)
		pTmp->PrevNode->NextNode = pTmp->NextNode;
	if (pTmp->NextNode)
		pTmp->NextNode->PrevNode = pTmp->PrevNode;

	//Free the node
	FreeARange(pTmp);
}

void CDHCP::OnCancel()
{
	// TODO: Add extra cleanup here
 
	FreeAllMem();
	CDialog::OnCancel();
}

void CDHCP::OnButtonBind()
{
	// TODO: Add your control notification handler code here

	EditBindings = TRUE;
	CBind Bind(this);

	Bind.DoModal();
	EditBindings = FALSE;
}

/////////////////////////////////////////////////////////////////////////////
//Callocats memory for a node. Copies the options from the
// node passed as argument. If arg is NULL, copy from default node
//return pointer to new node if OK else NULL
AddrRangeType *CDHCP::GetAnAddrNode(AddrRangeType *pOptnsNode)
{
	AddrRangeType *pNewRange, *pCopyFrom;

		// CAllocate on node for this tag
	pNewRange = (AddrRangeType *)calloc(1, sizeof(AddrRangeType));

	if (!pNewRange)
		return NULL;

	if (pOptnsNode)
		pCopyFrom = pOptnsNode;		// copy from passed node
	else
		pCopyFrom = PtrAddrRange;	// copy from defaults node

	//Copy options
	int	OptnIndex;
	OptionType *from, *to;
	
	for (OptnIndex = 0; OptnIndex < NUM_OPTIONS; OptnIndex++)
	{
		if (pCopyFrom->OLPtr[OptnIndex].OptionList)
		{
			to = &pNewRange->OLPtr[OptnIndex];
			from = &pCopyFrom->OLPtr[OptnIndex];

			to->OptionType =from->OptionType;
			to->OptionCount =from->OptionCount;

			// allocate memmory for the options list;
			if (!(to->OptionList =	(char *) malloc(strlen(	from->OptionList)+1)))
			{
				//Free the mem for node
				free(pNewRange);
				//return false;
				return NULL;
			}
			strcpy(to->OptionList, from->OptionList);
		}
	}
	return pNewRange;
}

////////////////////////////////////////////////////////////////////////////
//check if lower bound of first >= pNext bounds
//	assumes integrity of each node by itself
BOOL EntriesClash(AddrRangeType *pFirst, AddrRangeType *pSecond)
{
	unsigned long fl, fu;		//first low and upper bound
	unsigned long fxl, fxu;		//first xclude low and upper bound
	unsigned long sl, su;		//first low and upper bound
	unsigned long sxl, sxu;		//first xclude low and upper bound

//Get all addresses in intger for comparison;
	get_ip_address(pFirst->LAddr, &fl);
	get_ip_address(pFirst->HAddr, &fu);
	get_ip_address(pSecond->LAddr, &sl);
	get_ip_address(pSecond->HAddr, &su);

	//if exclude is present for first
	if (pFirst->XAddrList)
	{
		get_ip_address(pFirst->XAddrList->XLAddr, &fxl);
		get_ip_address(pFirst->XAddrList->XHAddr, &fxu);
	}
	else
	{
		fxl = 0;
		fxu = 0;
	}

	//if exclude is present for second
	if (pSecond->XAddrList)
	{
		get_ip_address(pSecond->XAddrList->XLAddr, &sxl);
		get_ip_address(pSecond->XAddrList->XHAddr, &sxu);
	}
	else
	{
		sxl = 0;
		sxu = 0;
	}

	if (su < fl)		//Second upper is less than first lower, can't clash
		return FALSE;
	if (sl > fu)		//Second lower graer than first upper, can't clash
		return FALSE;
	if ((sl >= fxl) && (su <= fxu))	//Second fully in exclude of first
		return FALSE;
	if ((fl >= sxl) && (fu <= sxu))	//Second fully in exclude of first
		return FALSE;

	return TRUE;	// other wise clash
}

////////////////////////////////////////////////////////////////////////////
//Travel all the list and check for any range clash
//avoid the default range. it covers all ranges
//avoid the pSkip entry (for edit to work properly)
//return No_CLASING_ENTRY if no clash. Else return index of entry clashing
int	CDHCP::CheckUnique(AddrRangeType *pRange, AddrRangeType *pSkip)
{
	AddrRangeType	*pTmp, *pTmp2;
	int	CurIndex;

	for (pTmp = PtrAddrRange->NextNode; pTmp; pTmp = pTmp->NextNode)
	{
		if (pTmp == pSkip)		// avoid skip node
			continue;
		if (EntriesClash(pTmp, pRange))
		{
			//find the index of clashing entry and return
			//since we have added the serial number, FindString memeber is useless
			// so we take a different method
			for (CurIndex = 0; ;CurIndex++)
			{
				pTmp2 = (AddrRangeType *)m_AdrLstWnd.GetItemDataPtr(CurIndex);

				if (pTmp == pTmp2)
					return CurIndex;

				if (pTmp2 == (AddrRangeType *) -1)
					return 0;		//this must not happen
			}
		}
	}
	return NO_CLASHING_ENTRY;
}

////////////////////////////////////////////////////////////////////////////
//if pOriginal is non-null,
//				make pRange sit in its place and freeup pOriginal
//else
//				add this entry as the last entry in the list
void	CDHCP::AddOrReplaceRange(AddrRangeType *pRange, AddrRangeType *pOriginal)
{
	AddrRangeType *pTmp;
	int	CurIndex;
	char szBuf[60];


	if (pOriginal)
	{
		//Set pointers in pRnage to the pOriginal
		pRange->NextNode = pOriginal->NextNode;
		pRange->PrevNode = pOriginal->PrevNode;
		//Setup Next and Prev nodes of Original if any
		if(pOriginal->NextNode)
			pOriginal->NextNode->PrevNode = pRange;
		if(pOriginal->PrevNode)
			pOriginal->PrevNode->NextNode = pRange;

		//If there are bindings in the Original node we need
		//to retain that
		pRange->Binds = pOriginal->Binds;
		pOriginal->Binds = NULL;


		FreeARange(pOriginal);

//	Set the listbox itemdataptr to point to the pRange address
		//find the index of pOriginal
		for (CurIndex = 0; ;CurIndex++)
		{
			pTmp = (AddrRangeType *)m_AdrLstWnd.GetItemDataPtr(CurIndex);
			if (pTmp == pOriginal)
				break;

			if (pTmp == (AddrRangeType *) -1)
				return;		//this must not happen
		}

		//The range might have changed, so we need to delete the display
		m_AdrLstWnd.DeleteString(CurIndex);
 		sprintf(szBuf, "%s\t%s", pRange->LAddr, pRange->HAddr);
		CurIndex = m_AdrLstWnd.AddString(szBuf);			//Add this string
		m_AdrLstWnd.SetCurSel(CurIndex);		// make it cur sel
		m_AdrLstWnd.SetItemDataPtr(CurIndex, pRange); // set this as ItmDataPtr

		//need to refresh the exclude range
		OnSelchangeListAdr();
	}
	else
	{
		//Add this to the end of the list
		pTmp = PtrAddrRange;
		while (pTmp->NextNode) {			//Travel till end
			pTmp = pTmp->NextNode;
		}

		pTmp->NextNode = pRange;
		pRange->PrevNode = pTmp;

 		sprintf(szBuf, "%s\t%s", pRange->LAddr, pRange->HAddr);
		CurIndex = m_AdrLstWnd.AddString(szBuf);			//Add this string
		m_AdrLstWnd.SetCurSel(CurIndex);		// make it cur sel
		m_AdrLstWnd.SetItemDataPtr(CurIndex, pRange); // set this as ItmDataPtr
		//do this only after setting ItemDataPtr, it is used in selchange!!
		OnSelchangeListAdr();
	}
}

////////////////////////////////////////////////////////////////////////////
void	CDHCP::FreeBindings(BindingType *pNode)
{
	BindingType *tmpBind1, *tmpBind2;
	tmpBind1 = pNode;
	while(tmpBind1)
	{
		tmpBind2 = tmpBind1->NextNode;
		free(tmpBind1);
		tmpBind1 = tmpBind2;
	}
}

////////////////////////////////////////////////////////////////////////////
void	CDHCP::FreeARange(AddrRangeType *pNode)
{
	int Index;

//free all the options list mem
	for(Index = 0; Index < NUM_OPTIONS; Index++)
		free(pNode->OLPtr[Index].OptionList);

//free Binds
	FreeBindings(pNode->Binds);
	pNode->Binds = NULL;

//free all exclusion address list
	XAddrType *tmpXAddr1, *tmpXAddr2;
	tmpXAddr1 = pNode->XAddrList;
	while(tmpXAddr1)
	{
		tmpXAddr2 = tmpXAddr1->NextNode;
		free(tmpXAddr1);
		tmpXAddr1 = tmpXAddr2;
	}
//free the tag node itself
	free(pNode);
}

///////////////////////////////////////////////////////////////////
//Given a binding type node, check in the whole list to see
//if the MAC address is bound. If bound, return the index of this
//entry in the list and fillup the matching IP address also.
//If not found return NO_CLASHING_ENTRY
int	CDHCP::CheckIfMACAddressBound(BindingType *pBind, LPSTR RetAddress)

{
	int	CurIndex = 1;		//skip default
	int	LstCount;
	AddrRangeType *pAdrRange;
	BindingType *pTmpBnd;

	LstCount = m_AdrLstWnd.GetCount();
	if (LstCount == LB_ERR)
		return NO_CLASHING_ENTRY;

	for (CurIndex = 0; CurIndex < LstCount; CurIndex++)
	{
		pAdrRange = (AddrRangeType *)m_AdrLstWnd.GetItemDataPtr(CurIndex);

		if (EditBindings)
		{
			if (pAdrRange == pCurGBLTag)	//we have selected this entry for
				continue;						//avoid this node
		}

		pTmpBnd = pAdrRange->Binds;
		while(pTmpBnd)
		{
			if (pBind->MacAddrLen == pTmpBnd->MacAddrLen)
			{
				if (!strcmpi(pBind->MacAddr, pTmpBnd->MacAddr))
				{
					strcpy(RetAddress, pTmpBnd->IPAddr);
					return CurIndex;
				}
			}
			pTmpBnd = pTmpBnd->NextNode;
		}
	}
	return NO_CLASHING_ENTRY;
}

/////////////////////////////////////////////////////////////////////////////
// Options related routines


char *OptionTypeString[] =
{
	"Character string",
	"Character string - no null",
	"Dot decimal IP Address",
	"Unsigned 32 bit integer",
	"Unsigned 16 bit integer",
	"Unsigned 8 bit integer",

	"Unknown type"
};

LPCSTR	GetOptionTypeString(int Optn)
{
	if (Optn > OT_UNDEFINED)
		Optn = OT_UNDEFINED;

	return ((LPCSTR) OptionTypeString[Optn]);
}

//the flowwing struct contains all options that are configurable for the
//address range entries.
OptionEditType	EditOptions[] =
{
//********** IMPORTANT :: **************
//If any option is added to this list, It must be sorted on the first filed
//The values in various fields above are based on RFC1533.
//********** IMPORTANT :: **************
	{ 3, 1, 0, -1L, 0L, OT_IP_ADDRESS,"Router Address","Address of default gateway"},
//	{ 6, 1, 0, -1L, 0L, OT_IP_ADDRESS, "DNS Server", "Domain Name System Server"},
	{15, 1, 0, -1L, 0L, OT_STRINGZ, "Domain Name", "Domain name for client"},
	{22, 1, 0, 0xFFFFL, 576L, OT_U16,"Reassembly size","Maximum datagram reassembly size"},
	{23, 1, 0, 0xFFL, 1L, OT_U8,"Default IP TTL", "Default IP Time-to-live(max 255)"},
	{26, 1, 0, 0xFFFFL, 68L, OT_U16,"MTU","Interface Maximum Transfer Unit"},	//min 68
	{37, 1, 0, 0xFFL, 1L, OT_U8,"Default TCP TTL","TCP Default Time-to-live"},
	{51, 1, 1, 0xFFFFFFFFL, 600L, OT_U32,"Lease time","IP Address lease time(seconds)"},
//	{-1, OT_STRING, "User Defined", "A stream of bytes. Refer help"}
};

#define NUM_EDIT_OPTIONS  (sizeof(EditOptions) / sizeof(OptionEditType))

void CDHCP::FillupOptionsList()
{
	int	index;
	char	szBuf[100];
	int tabstop = 15;

	m_OptnLstWnd.SetTabStops(1, (LPINT)&tabstop) ;

	//for all options in the editoptions
	for (index = 0; index < NUM_EDIT_OPTIONS; index++)
	{
		if (EditOptions[index].OptionCode != -1)
		{
			// form the Options string and add it to the list
			sprintf(szBuf, "%3d\t%s", EditOptions[index].OptionCode,
												EditOptions[index].OptionName);
		}
		else
		{
			sprintf(szBuf, " **\t%s", EditOptions[index].OptionName);
		}
		m_OptnLstWnd.AddString(szBuf);
	}
}

BOOL	CDHCP::CheckOptionValuesAndDisplay(AddrRangeType *pAdrRange, int Optn)
{
	//First reset contents
	int	ocode, otype;
	char optnbuf[MAX_INI_OPTN_LEN+1];			//buffer to add to list
	char *srcptr;				//pointer to the options byte array
	int	count, curcount;	//to total options count, current count
	DWORD lvalue;
	WORD	wvalue;
	BYTE bvalue;
	int	index;
	char btmp[15];

	m_OptnEdtWnd.ResetContent();
	//Get the option code of the entry displayed
	ocode = EditOptions[Optn].OptionCode;
	otype = EditOptions[Optn].OptionType;

	if ( !pAdrRange->OLPtr[ocode].OptionList)
		return FALSE;

	srcptr = pAdrRange->OLPtr[ocode].OptionList;
	count = pAdrRange->OLPtr[ocode].OptionCount;

	index = 0;
	curcount = 0;
	//Get the type of the option
	switch (otype)
	{

		case OT_STRINGZ:	// a series of null terminated strings
		case OT_STRING:		//one string no null

			while (curcount < count)
			{
				strncpy(btmp,srcptr,sizeof(BYTE) * 2);
				btmp[sizeof(BYTE) * 2] = 0;
				sscanf(btmp, "%2x", &wvalue);
				srcptr += sizeof(BYTE) * 2;
				if (!wvalue)		// end if this value
					break;
				optnbuf[curcount] = (char)wvalue;
				curcount++;
			}
			optnbuf[curcount] = 0;
			m_OptnEdtWnd.AddString(optnbuf);

			break;

		case OT_IP_ADDRESS:

			while(curcount < count)
			{
				strncpy(btmp,srcptr,sizeof(DWORD) * 2);
				btmp[sizeof(DWORD) * 2] = 0;
				sscanf(btmp, "%lx", &lvalue);
				curcount += sizeof(DWORD);		//each IP address is a dword
				srcptr += sizeof(DWORD) * 2;
				get_dot_decimal_ip_address(lvalue, optnbuf);
				m_OptnEdtWnd.AddString(optnbuf);
			}
			break;

		case OT_U32:

			while(curcount < count)
			{
				strncpy(btmp,srcptr,sizeof(DWORD) * 2);
				btmp[sizeof(DWORD) * 2] = 0;
				sscanf(btmp, "%lx", &lvalue);
				curcount += sizeof(DWORD);		//each U32 dword
				srcptr += sizeof(DWORD) * 2;
				sprintf(optnbuf,"%lu",lvalue);
				m_OptnEdtWnd.AddString(optnbuf);
			}
			break;

		case OT_U16:

			while(curcount < count)
			{
				strncpy(btmp,srcptr,sizeof(DWORD) * 2);
				btmp[sizeof(WORD) * 2] = 0;
				sscanf(btmp, "%x", &wvalue);
				curcount += sizeof(WORD);		//each U16 is a word
				srcptr += sizeof(WORD) * 2;
				sprintf(optnbuf,"%u",wvalue);
				m_OptnEdtWnd.AddString(optnbuf);
			}
			break;

		case OT_U8:

			while(curcount < count)
			{
				strncpy(btmp,srcptr,sizeof(BYTE) * 2);
				btmp[sizeof(BYTE) * 2] = 0;
				sscanf(btmp, "%x", &bvalue);

				curcount += sizeof(BYTE);		//each U8 is a byte
				srcptr += sizeof(BYTE) * 2;
				sprintf(optnbuf,"%2u",bvalue);
				m_OptnEdtWnd.AddString(optnbuf);
			}
			break;

		default:
			::MessageBox (GetSafeHwnd(), (LPCSTR)"Invalid option type to edit!!",
					(LPCSTR) DHCPErrMsgHdr, MB_OK | MB_ICONEXCLAMATION) ;
			return FALSE;
	}
	return TRUE;
}

void CDHCP::OnSelchangeListOptn()
{
	// TODO: Add your control notification handler code here
	CurGBLOptn = m_OptnLstWnd.GetCurSel();

	if (CurGBLOptn == LB_ERR)
	{
		// Write type as N.A.
		m_OTypeWnd.SetWindowText("N. A.");

		//Reset the contents of value
		m_OptnEdtWnd.ResetContent();

		//	Disable Edit and Remove Buttons
		m_BtnOptnRem.EnableWindow(FALSE);
		m_BtnOptnAdd.EnableWindow(FALSE);
		m_BtnOptnEdt.EnableWindow(FALSE);

		//Ask user to select an option to edit
		m_LineHelp.SetWindowText("Select an option to edit");
		return;
	}

//Write type 
	m_OTypeWnd.SetWindowText(
			GetOptionTypeString(EditOptions[CurGBLOptn].OptionType));

//check if  a value is present for this option of selected address range
	CheckOptionValuesAndDisplay(pCurGBLTag, CurGBLOptn);

	m_OptnEdtWnd.SetCurSel(0);
	OnSelchangeVal();

	//Update the single line help
	m_LineHelp.SetWindowText(EditOptions[CurGBLOptn].OptionHelp);
}

void CDHCP::OnSelchangeVal()
{
	int	curcount;

	// TODO: Add your control notification handler code here
	if (m_OptnEdtWnd.GetCurSel() == LB_ERR)
	{
		m_BtnOptnRem.EnableWindow(FALSE);
		m_BtnOptnEdt.EnableWindow(FALSE);
	}
	else
	{
		m_BtnOptnRem.EnableWindow(TRUE);
		m_BtnOptnEdt.EnableWindow(TRUE);
	}

	//enable if we can add one more option
	curcount = m_OptnEdtWnd.GetCount();
	if (curcount < EditOptions[CurGBLOptn].OptionMaxEntries)
	 	m_BtnOptnAdd.EnableWindow(TRUE);
	else
	 	m_BtnOptnAdd.EnableWindow(FALSE);

	if (curcount <= EditOptions[CurGBLOptn].OptionMinEntries)
		m_BtnOptnRem.EnableWindow(FALSE);
}

void CDHCP::OnButtonOptnAdd()
{
	// TODO: Add your control notification handler code here
	m_EditedOptionValueIndex = LB_ERR;

	CDHCPOPTN dhcpoptn(this);

	dhcpoptn.DoModal();

	//reform the option list and update
	FormOptionValuesFromList(pCurGBLTag, CurGBLOptn);
//	OnSelchangeListOptn();	//update status of buttons
	OnSelchangeVal();	//update status of buttons

}

void CDHCP::OnButtonOptnEdt()
{

	// TODO: Add your control notification handler code here
	//if we are editing get the cursel value and call addit dialog
	if ((m_EditedOptionValueIndex = m_OptnEdtWnd.GetCurSel()) == LB_ERR)
		return;

	CDHCPOPTN dhcpoptn(this);

	dhcpoptn.DoModal();

	m_EditedOptionValueIndex = LB_ERR;

	//reform the option list and update
	FormOptionValuesFromList(pCurGBLTag, CurGBLOptn);
//	OnSelchangeListOptn();	//update status of buttons
	OnSelchangeVal();	//update status of buttons
}

void CDHCP::FormOptionValuesFromList(AddrRangeType *pAdrRange, int Optn)
{

	int	count, curcount;
	int	ocode, otype;
	char	szbuf[MAX_INI_OPTN_LEN * 2];			//buffer to add to list
	char	btmp[MAX_INI_OPTN_LEN];
	DWORD	lvalue;
	WORD	wvalue;
	int	basic_entry_len;
	char	*noptns;

	//form new options
	count = m_OptnEdtWnd.GetCount();
	
	ocode = EditOptions[Optn].OptionCode;
	otype = EditOptions[Optn].OptionType;

	//free old mem even if count 0. ****ALSO MUST RESET THE POINTER****
	if (!count)
	{
		free(pAdrRange->OLPtr[ocode].OptionList);
		pAdrRange->OLPtr[ocode].OptionList = NULL;
		pAdrRange->OLPtr[ocode].OptionCount = 0;
		pAdrRange->OLPtr[ocode].OptionType = ocode;
		return;
	}

	curcount = 0;
	szbuf[0] = 0;

	//Get the type of the option
	switch (otype)
	{
		case OT_STRINGZ:	// a series of null terminated strings

			//can have only one non-null terminated value.
			m_OptnEdtWnd.GetText(curcount, btmp);
			count = strlen(btmp) + 1;
			basic_entry_len = 1;

			int l_index;
			l_index = 0;
			while (btmp[l_index])
			{
				sprintf(&szbuf[l_index*2],"%02x",btmp[l_index]);
				l_index++;
			}
			sprintf(&szbuf[l_index*2],"00");
			break;

		case OT_STRING:		//one string no null
			//can have only one non-null terminated value.
			m_OptnEdtWnd.GetText(curcount, btmp);
			count = strlen(btmp);
			basic_entry_len = 1;

			l_index = 0;
			while (btmp[l_index])
			{
				sprintf(&szbuf[l_index*2],"%02x",btmp[l_index]);
				l_index++;
			}
			break;

		case OT_IP_ADDRESS:
			basic_entry_len = sizeof (DWORD);

			while(curcount < count)
			{
				//get entry from list
				m_OptnEdtWnd.GetText(curcount, btmp);
				get_ip_address(btmp, &lvalue);
				sprintf(btmp,"%08lx",lvalue);
				strcat(szbuf, btmp);
				curcount++;
			}
			break;

		case OT_U32:
			basic_entry_len = sizeof (DWORD);

			while(curcount < count)
			{
				//get entry from list
				m_OptnEdtWnd.GetText(curcount, btmp);
				sscanf(btmp,"%ld", &lvalue);
				sprintf(btmp,"%08lx",lvalue);
				strcat(szbuf, btmp);
				curcount++;
			}
			break;

		case OT_U16:
			basic_entry_len = sizeof (WORD);

			while(curcount < count)
			{
				//get entry from list
				m_OptnEdtWnd.GetText(curcount, btmp);
				sscanf(btmp,"%d", &wvalue);
				sprintf(btmp,"%04x",wvalue);
				strcat(szbuf, btmp);
				curcount++;
			}
			break;

		case OT_U8:
			basic_entry_len = sizeof (BYTE);

			while(curcount < count)
			{
				//get entry from list
				m_OptnEdtWnd.GetText(curcount, btmp);
				sscanf(btmp,"%d", &wvalue);
				sprintf(btmp,"%02x",wvalue);
				strcat(szbuf, btmp);
				curcount++;
			}
			break;

		default:
			::MessageBox (GetSafeHwnd(), (LPCSTR)"Invalid option type!!",
					(LPCSTR) DHCPErrMsgHdr, MB_OK | MB_ICONEXCLAMATION) ;
			return;
	}

	//terminate szbuf with NULL ....since one byte is represented as two chars
	szbuf[count * basic_entry_len * 2] = 0;

	//malloc for this much
	if ( !(noptns = (char *)malloc(strlen(szbuf) + 2)))
	{
		::MessageBox (GetSafeHwnd(), (LPCSTR)"No memory for options!!",
				(LPCSTR) DHCPErrMsgHdr, MB_OK | MB_ICONEXCLAMATION) ;
		return ;
	}
	strcpy(noptns, szbuf);

	free(pAdrRange->OLPtr[ocode].OptionList);
	pAdrRange->OLPtr[ocode].OptionList = noptns;
	pAdrRange->OLPtr[ocode].OptionCount = count * basic_entry_len;
	pAdrRange->OLPtr[ocode].OptionType = ocode;

}

void CDHCP::OnButtonOptnRem()
{
	// TODO: Add your control notification handler code here
	int value_index;

	//check if there is any selection to remove
	if ((value_index = m_OptnEdtWnd.GetCurSel()) == LB_ERR)
		return;

	//check for a valid option being selected
	if (CurGBLOptn == LB_ERR)
		return;

	//check if a valid selection of range
	if (!pCurGBLTag)
		return;

	//remove the list box item at the index;
	m_OptnEdtWnd.DeleteString(value_index);

	//reform the option list and update
	FormOptionValuesFromList(pCurGBLTag, CurGBLOptn);

	if (value_index > 0)
		m_OptnEdtWnd.SetCurSel(value_index - 1);

	OnSelchangeListOptn();	//update status of Edit and remove buttons
}

BOOL CheckIPAddressInRange(AddrRangeType *pAdrNode, LPCSTR IPAddress)
{
	//Set IP address to next unbound IP Address - UF
	unsigned long nadr, ladr, uadr, xladr, xuadr;

	get_ip_address(IPAddress, &nadr);
	get_ip_address(pAdrNode->LAddr, &ladr);
	get_ip_address(pAdrNode->HAddr, &uadr);
	if (pAdrNode->XAddrList)
	{
		get_ip_address(pAdrNode->XAddrList->XLAddr, &xladr);
		get_ip_address(pAdrNode->XAddrList->XHAddr, &xuadr);
	}
	else
	{
		xladr = xuadr = 0;
	}

	if (nadr < ladr || nadr > uadr)
		return FALSE;
	if (xladr)
	{
		if (nadr >= xladr && nadr <= xuadr)
			return FALSE;
	}
	return TRUE;
}

/* Jo 06/07/98 */

void convert_ip_address (char* original_string, char* converted_string)
{
   int  ip_address_array[4];

	sscanf (original_string,
           "%03hu.%03hu.%03hu.%03hu",
   		  (int *)(&ip_address_array[0]),
           (int *)(&ip_address_array[1]),
		     (int *)(&ip_address_array[2]),
           (int *)(&ip_address_array[3])
          );
   sprintf(converted_string, "%02X%02X%02X%02X\0", ip_address_array[0],
                                                   ip_address_array[1],
                                                   ip_address_array[2],
                                                   ip_address_array[3]);
}

void revert_ip_address (OptionType* sptr_option, char* converted_string)
{
   char temp_buf[3] ;
   int temp_string[4], index = 0, count, i = 0 ;

   while (index < 2 * sptr_option->OptionCount)
   {
     count = 0 ;
     while (count < 2)
     {
			temp_buf[count] = sptr_option->OptionList[index + count] ;
			count ++ ;
     }
     temp_buf[count] = 0 ;
     index+= 2 ;
     sscanf (temp_buf, "%02x", &temp_string[i++]) ;
   }
   sprintf (converted_string, "%d.%d.%d.%d", temp_string[0], temp_string[1], temp_string[2], temp_string[3]) ;
}

void convert_char_string (char* original_string, char* converted_string)
{
   BYTE index ;
   char temp_string[4] ;

   converted_string[0] = 0;
   for( index = 0 ; index < strlen(original_string) ; ++index)
   {
      sprintf(temp_string, "%02X", original_string[index]);
      strcat(converted_string, temp_string);
   }
}


void revert_char_string(char* original_string, char* converted_string)
{
#define NO_OF_CHARS_PER_BYTE 2

   char index, temp_ptr[5], temp_buffer[50];
   unsigned long temp_char;

   converted_string[0] = 0;
   for ( index = 0 ; index < strlen(original_string)/2 ; ++index)
   {
      strncpy(temp_ptr, original_string + index * 2, NO_OF_CHARS_PER_BYTE);
      temp_ptr[NO_OF_CHARS_PER_BYTE] = 0;
      sscanf(temp_ptr, "%02X", &temp_char);
      sprintf(temp_buffer, "%c\0", temp_char);
      strcat(converted_string, temp_buffer);
   }
   converted_string[index] = 0;
}

/* Jo 06/07/98 */
