// dhcp.h : header file
//

BOOL CheckIPAddressInRange(AddrRangeType *pAdrNode, LPCSTR IPAddress);
void revert_ip_address (OptionType* sptr_option, char* converted_string) ;
void convert_ip_address (char* original_string, char* converted_string)	;
void convert_char_string (char* original_string, char* converted_string) ;
void revert_char_string (char* original_string, char* converted_string) ;

/////////////////////////////////////////////////////////////////////////////
// CDHCP dialog

class CDHCP : public CDialog
{
// Construction
public:
	CDHCP(CWnd* pParent = NULL);	// standard constructor

// Dialog Data
	//{{AFX_DATA(CDHCP)
	enum { IDD = IDD_DIALOGDHCP };
	CButton	m_BtnOptnEdt;
	CButton	m_BtnOptnAdd;
	CButton	m_BtnOptnRem;
	CStatic	m_OTypeWnd;
	CListBox	m_OptnEdtWnd;
	CListBox	m_OptnLstWnd;
	CStatic	m_SelIndWnd;
	CButton	m_BndBtn;
	CListBox	m_XAdrLst;
	CStatic	m_LineHelp;
	CButton	m_RemBtn;
	CButton	m_EdtBtn;
	CButton	m_AddBtn;
	CStatic	m_XAdrHdrWnd;
	CListBox	m_AdrLstWnd;
	CButton	m_AdrGrpWnd;
	BOOL	m_Enable;
		// NOTE: the ClassWizard will add data members here
	//}}AFX_DATA

	CBitmapButton OKBmpBtn;
	CBitmapButton CancelBmpBtn;
	CBitmapButton HelpBmpBtn;
	CBitmapButton AddBmpBtn1;
	CBitmapButton DeleteBmpBtn1;
	CBitmapButton EditBmpBtn1;
	CBitmapButton BindBmpBtn;
	CBitmapButton AddBmpBtn2;
	CBitmapButton DeleteBmpBtn2;
	CBitmapButton EditBmpBtn2;

	AddrRangeType *PtrAddrRange;	// Pointer to beginning of Address range
	AddrRangeType *pCurGBLTag;		// Pointer to current AddrRange
	AddrRangeType *pCurEditTag;	// if OnEdit set this - reset for OnAdd
	int	CurGBLOptn;					// Global index of selected option
	int	m_EditedOptionValueIndex;		// is the option value as string if editing

	void	DeleteAllDHCPStrings();
	void	SaveParams(void);
	void	FreeAllMem(void);
	AddrRangeType *GetAnAddrNode(AddrRangeType *pOptnsNode);
	int	CheckUnique(AddrRangeType *pRange, AddrRangeType *pSkip);
	void	AddOrReplaceRange(AddrRangeType *pRange, AddrRangeType *pOriginal);
	void	FreeBindings(BindingType *pNode);
	void	FreeARange(AddrRangeType *pNode);
	int	CheckIfMACAddressBound(BindingType *pBind, LPSTR RetAddress);
	void	FillupOptionsList(void);
	BOOL	CheckOptionValuesAndDisplay(AddrRangeType *pAdrRange, int Optn);
	void FormOptionValuesFromList(AddrRangeType *pAdrRange, int Optn);

// Implementation
protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support

	// Generated message map functions
	//{{AFX_MSG(CDHCP)
	afx_msg void OnSelchangeListAdr();
	afx_msg void OnButtonRemove();
	afx_msg void OnButtonHelp();
	virtual void OnOK();
	virtual BOOL OnInitDialog();
	afx_msg void OnSelchangeListOptn();
	afx_msg void OnButtonAdd();
	afx_msg void OnButtonEdit();
	virtual void OnCancel();
	afx_msg void OnButtonBind();
	afx_msg void OnSelchangeVal();
	afx_msg void OnButtonOptnAdd();
	afx_msg void OnButtonOptnRem();
	afx_msg void OnButtonOptnEdt();
	afx_msg void OnDblclkListAdr();
		// NOTE: the ClassWizard will add member functions here
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};
