
#define	MAX_NUM_ADDR_RANGES	99	//Maximu number of address range to manage
#define	NUM_OPTIONS		70
#define	IP_ADDR_LEN		17
#define	MAX_INI_OPTN_LEN	40		//max length of a options entry
											//if more use another ini str
#define	MAX_OPTN_LEN		200	//this limits number of entries too
#define	MAX_MAC_ADDR_LEN	10		// maximum MAC addr len for bindings
#define	MAC_ADDR_STORE_LEN	(MAX_MAC_ADDR_LEN * 2 +2)		// maximum MAC addr len for bindings
#define	NO_CLASHING_ENTRY	-1		//no other AddrRange in list
#define	MAX_BINDINGS		100	//upto 99

// Added for management reasons


struct tagOption {
	int	OptionType;		// type number of this option
	int	OptionCount;
	char	*OptionList;
};
typedef struct tagOption OptionType;

typedef struct tagAddrRange{
	struct tagAddrRange	*NextNode;	// Pointer to next node
	struct tagAddrRange	*PrevNode;	// Pointer to previous node
	char LAddr[IP_ADDR_LEN];		// lower address in range
	char HAddr[IP_ADDR_LEN];		// higher address in range
	char Mask[IP_ADDR_LEN];		// higher address in range
	struct tagXAddr	*XAddrList;	// excluded address range list
	struct tagBindings *Binds;
	struct tagOption OLPtr[NUM_OPTIONS];	//this is for easy update of check button also
} AddrRangeType;

typedef struct tagBindings{
	struct tagBindings *NextNode;
	int MacAddrLen;
	char MacAddr[MAC_ADDR_STORE_LEN];
	char IPAddr[IP_ADDR_LEN];		// higher address in range
} BindingType;

typedef struct tagXAddr{
	struct tagXAddr	*NextNode;
	char XLAddr[IP_ADDR_LEN];		// exclude address in range from
	char XHAddr[IP_ADDR_LEN];		// exclude address in range upto
} XAddrType;

enum DHCP_OPTION_TYPE
{
   DHCP_PAD_OPTION = 0,
   SUBNET_MASK = 1,
   TIME_OFFSET = 2,
   ROUTER = 3,
   TIME_SERVER = 4,
   NAME_SERVER = 5,
   DNS = 6,
   LOG_SERVER = 7,
   COOKIE_SERVER = 8,
   LPR_SERVER = 9,
   IMPRESS_SERVER = 10,
   RESOURCE_LOCATION_SERVER = 11,
   HOST_NAME = 12,
   BOOT_FILE_SIZE = 13,
   MERIT_DUMP_FILE = 14,
   DOMAIN_NAME = 15,
   SWAP_SERVER = 16,
   ROOT_PATH = 17,
   EXTENSIONS_PATH = 18,
   IP_FORWARDING_ENABLE = 19,
   NON_LOCAL_SOURCE_ROUTING = 20,
   POLICY_FILTER = 21,
   MAXIMUM_REASSEMBLY_SIZE = 22,
   TTL = 23,
   PATH_MTU_AGING_TIMEOUT = 24,
   PATH_MTU_PLATEAU_TABLE = 25,
   MTU = 26,
   ALL_SUBNETS_ARE_LOCAL = 27,
   BROADCAST_ADDRESS = 28,
   PERFORM_MASK_RECOVERY = 29,
   MASK_SUPPLIER = 30,
   PERFORM_ROUTER_DISCOVERY = 31,
   ROUTER_SOLICITATION = 32,
   STATIC_ROUTE = 33,
   TRAILER_ENCAPSULATION = 34,
   ARP_CACHE_TIMEOUT = 35,
   ETHERNET_ENCAPSULATION = 36,
   TCP_TTL = 37,
   TCP_KEEP_ALIVE_INTERVAL = 38,
   TCP_KEEP_ALIVE_GARBAGE = 39,
   NETWORK_INFORMATION_SERVICE = 40,
   NETWORK_INFORMATION_SERVERS = 41,
   NETWORK_TIME_PROTOCOL_SERVERS = 42,
   X_WHAT_IS_THIS = 43,
   NB_OVER_TCPIP_NAME_SERVER = 44,
   NB_OVER_TCPIP_DRAM_DIST_SERVER = 45,
   NB_OVER_TCPIP_NODE_TYPE = 46,
   NB_OVER_TCPIP_SCOPE = 47,
   X_W_SYSTEM_FONT_SERVER = 48,
   X_W_SYSTEM_DISPLAY_MANAGER = 49,
   REQUESTED_IP_ADDRESS = 50,
   IP_ADDRESS_LEASE_TIME = 51,
   OPTION_OVERLOAD = 52,
   DHCP_MESSAGE_TYPE = 53,
   SERVER_ID = 54,
   PARAMETER_REQUEST_LIST = 55,
   MESSAGE = 56,
   MAXIMUM_DHCP_MESSAGE_TYPE = 57,
   RENEWAL_T1_TIME_VALUE = 58,
   REBINDING_T2_TIME_VALUE = 59,
   CLASS_ID = 60,
   CLIENT_ID = 61,

   FIRST_UNKNOWN_DHCP_OPTION_TYPE,

   DHCP_END_OPTION = 255
} ;

enum OPTION_TYPE		//Basic types of options
{
	OT_STRINGZ = 0,		//null terminated string
	OT_STRING,
	OT_IP_ADDRESS,
	OT_U32,
	OT_U16,
	OT_U8,

	OT_UNDEFINED
};

typedef struct tagOptionEdit {
	int	OptionCode;						//option code of the option
	int	OptionMaxEntries;				// not more than these many entries
	int	OptionMinEntries;				// at least these many entries
	DWORD	OptionMaxVal;					//max value of an option
	DWORD	OptionMinVal;					//Minimum value of an option
	OPTION_TYPE OptionType;				//type of the options (enum BASIC_TYPE)
	char *OptionName;						//name of option as in listing
	char *OptionHelp;						//line help of options as in dialog
} OptionEditType;

extern	OptionEditType	EditOptions[];
LPCSTR	GetOptionTypeString(int Optn);

