// dhcpoptn.cpp : implementation file
//
// 06/07/98  : Jyothi made changes for Small Proxy
// 06/07/98  : Jyothi, uses structures instead of Ini file.

#include "stdafx.h"
#include "procon.h"
#include "dhcpk.h"
#include "dhcp.h"
#include "dot.h"
#include "dhcpoptn.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CDHCPOPTN dialog


CDHCPOPTN::CDHCPOPTN(CWnd* pParent /*=NULL*/)
	: CDialog(CDHCPOPTN::IDD, pParent)
{
	//{{AFX_DATA_INIT(CDHCPOPTN)
	m_EdtStr = "";
	//}}AFX_DATA_INIT
}

void CDHCPOPTN::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDHCPOPTN)
	DDX_Control(pDX, IDC_STATIC_POS, m_PosWnd);
	DDX_Control(pDX, IDC_STATIC_OTYPE, m_OTypeWnd);
	DDX_Control(pDX, IDC_STATIC_ONAME, m_ONameWnd);
	DDX_Control(pDX, IDC_EDIT1, m_EdtWnd);
	DDX_Control(pDX, IDC_COMBO1, m_LstWnd);
	DDX_Text(pDX, IDC_EDIT1, m_EdtStr);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CDHCPOPTN, CDialog)
	//{{AFX_MSG_MAP(CDHCPOPTN)
	ON_BN_CLICKED(IDC_HELP, OnHelp)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CDHCPOPTN message handlers

BOOL CDHCPOPTN::OnInitDialog()
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
	CenterWindow() ; 
	
	/* Change the title of the dialog as usual */
	char WindowHeader[80], CurrentHeading[80], *SubHeadingPointer ;

	GetWindowText (CurrentHeading, 80) ;
	SubHeadingPointer = strchr (CurrentHeading, '-') ;
	if (SubHeadingPointer == NULL)
		SubHeadingPointer = CurrentHeading ;
	else
		SubHeadingPointer += 2 ;

	sprintf(WindowHeader, DialogTitleFormat,
			WindowText.GetBuffer(0),SubHeadingPointer);
	SetWindowText (WindowHeader) ;

	if (!OKBmpBtn.LoadBitmaps ("OK1", "OK2", "OK3", "OK4"))
		AfxMessageBox ("Failed to load OK bitmap");

	VERIFY (OKBmpBtn.SubclassDlgItem (IDOK, this));
	OKBmpBtn.SizeToContent();

	if (!CancelBmpBtn.LoadBitmaps ("CANCEL1", "CANCEL2", "CANCEL3", "CANCEL4"))
		AfxMessageBox ("Failed to load CANCEL bitmap");

	VERIFY (CancelBmpBtn.SubclassDlgItem (IDCANCEL, this));
	CancelBmpBtn.SizeToContent();

	if (!HelpBmpBtn.LoadBitmaps ("SHELP1", "SHELP2", "SHELP3", "SHELP4"))
		AfxMessageBox ("Failed to load HELP bitmap");

	VERIFY (HelpBmpBtn.SubclassDlgItem (IDC_HELP, this));
	HelpBmpBtn.SizeToContent();

	//Get the option code;
	OptnIndex = ((CDHCP *)GetParent())->CurGBLOptn;

	//get the count already in list box
	OptnCount =	((CDHCP *)GetParent())->m_OptnEdtWnd.GetCount();
	//add all the numbers upto this and set selection to last
	int count;
	char szbuf[10];

	for(count = 1; count <= (OptnCount + 1); count++)
	{
		sprintf(szbuf, "%3d",count);
		m_LstWnd.AddString(szbuf);
	}
	m_EditedOptionValueIndex = ((CDHCP *)GetParent())->m_EditedOptionValueIndex;

	//if we are editing, we need shouldn't let user change the insert
	//position. also we need to init the display with the edit value
	if (m_EditedOptionValueIndex != LB_ERR)
	{
		//set the index to this position
		m_LstWnd.SetCurSel(m_EditedOptionValueIndex);
		//disable the this combo so that user cant change
		m_LstWnd.EnableWindow(FALSE);
		m_PosWnd.SetWindowText("Edit value at &Postion");

		char tmp[80];
		((CDHCP*)GetParent())->m_OptnEdtWnd.GetText(m_EditedOptionValueIndex, tmp);
		m_EdtWnd.SetWindowText(tmp);
	}
	else
	{	//since we are not editing any option at the moment, we
		//normally append the new value to existing list
		m_LstWnd.SetCurSel(OptnCount);
	}


	m_ONameWnd.SetWindowText(EditOptions[OptnIndex].OptionName);
	m_OTypeWnd.SetWindowText(
			GetOptionTypeString(EditOptions[OptnIndex].OptionType));

	switch(EditOptions[OptnIndex].OptionType)
	{
		case OT_STRINGZ :
		case OT_STRING :
			m_EdtWnd.LimitText(MAX_INI_OPTN_LEN-1);
		break;

		case OT_IP_ADDRESS:
			m_EdtWnd.LimitText(15);
		break;

		case OT_U32:
			m_EdtWnd.LimitText(10);
		break;

		case OT_U16:
			m_EdtWnd.LimitText(5);
		break;

		case OT_U8:
			m_EdtWnd.LimitText(3);
		break;

	}

	return TRUE;  // return TRUE  unless you set the focus to a control
}

LPSTR ErrMsgs[] =
{
	"Value filed can't be null",
	"Invalid IP address",
	"Invalid 32 bit unsigned number",
	"Invalid 16 bit unsigned number",
	"Invalid 8 bit unsigned number",
};

void CDHCPOPTN::DispMsg(int index)
{
	::MessageBox (GetSafeHwnd(), (LPCSTR)ErrMsgs[index],
			(LPCSTR) "DHCP Option values", MB_OK | MB_ICONEXCLAMATION) ;
}

BOOL CDHCPOPTN::IsValidEditFields(LPSTR szBuf)
{
	int msg;
	DWORD lvalue;
	WORD	value;
	int vlen;
	char ErMsg[80];

	strcpy(szBuf, m_EdtStr);
	CDotDecimal IPAdr;

	if (!*szBuf)
	{
		msg = 0;
ErrorExit:
		*szBuf = 0;
		DispMsg(msg);
		m_EdtWnd.SetFocus();
		return FALSE;
	}
	vlen = strlen(szBuf);

	switch(EditOptions[OptnIndex].OptionType)
	{
		case OT_STRINGZ :
		case OT_STRING :
			
		break;

		case OT_IP_ADDRESS:
			IPAdr = szBuf;
			if (!IPAdr.IsValid())
			{
				msg = 1;
				goto ErrorExit;
			}
			strcpy(szBuf, IPAdr);	// normalize it
		break;

		case OT_U32:
			if ((vlen > 10) || (
					(vlen == 10) && (strcmpi(szBuf, "4294967295") > 0)))
			{
				msg = 2;
				goto ErrorExit;
			}
			if (!sscanf(szBuf, "%lu", &lvalue))
			{
				msg = 2;
				goto ErrorExit;
			}
			//additional checks for limits can be imposed here
			if ((EditOptions[OptnIndex].OptionMaxVal < lvalue) ||
					(EditOptions[OptnIndex].OptionMinVal > lvalue))
			{
RangeError:
				sprintf(ErMsg, "Value out of range for option.\n\
Minimum=%lu, Maximum=%lu.", EditOptions[OptnIndex].OptionMinVal,
				EditOptions[OptnIndex].OptionMaxVal);
				::MessageBox (GetSafeHwnd(), (LPCSTR)ErMsg,
					(LPCSTR) "DHCP Option values", MB_OK | MB_ICONEXCLAMATION) ;
				*szBuf = 0;
				m_EdtWnd.SetFocus();
				return FALSE;
			}
		break;

		case OT_U16:
			if ((vlen > 5) || (
					(vlen == 5) && (strcmpi(szBuf, "65535") > 0)))
			{
				msg = 3;
				goto ErrorExit;
			}
			if (!sscanf(szBuf, "%u", &value))
			{
				msg = 3;
				goto ErrorExit;
			}
			//additional checks for limits can be imposed here
			if ((EditOptions[OptnIndex].OptionMaxVal < value) ||
					(EditOptions[OptnIndex].OptionMinVal > value))
			{
				goto RangeError;
			}
		break;

		case OT_U8:
			if ((vlen > 3) || (
					(vlen == 3) && (strcmpi(szBuf, "255") > 0)))
			{
				msg = 4;
				goto ErrorExit;
			}
			if (!sscanf(szBuf, "%u", &value))
			{
				msg = 4;
				goto ErrorExit;
			}
			//additional checks for limits can be imposed here
			if ((EditOptions[OptnIndex].OptionMaxVal < value) ||
					(EditOptions[OptnIndex].OptionMinVal > value))
			{
				goto RangeError;
			}

		break;
	}
	return TRUE;
}

void CDHCPOPTN::OnOK()
{
	// TODO: Add extra validation here
	//check if options value is OK
	char szBuf[80];

	UpdateData(TRUE);

	//if yes add it to the list
	if (!IsValidEditFields(szBuf))
	{
		return;
	}
	int index;

	index = m_LstWnd.GetCurSel();
	//if we are editing and option, we need to deletestring and insert string
	if (m_EditedOptionValueIndex != LB_ERR)
		((CDHCP *)GetParent())->m_OptnEdtWnd.DeleteString(index);

	index =	((CDHCP *)GetParent())->m_OptnEdtWnd.InsertString(index,(LPCSTR)szBuf);
	//Set the cursor this entry
	((CDHCP *)GetParent())->m_OptnEdtWnd.SetCurSel(index);
	
	CDialog::OnOK();
}

void CDHCPOPTN::OnHelp()
{
	// TODO: Add your control notification handler code here
	AfxGetApp()->WinHelp (0x20000 + IDD_DIALOG_DHCP_ADD_OPTN, HELP_CONTEXT) ;
	
}
